/*
 * Decompiled with CFR 0.152.
 */
package org.java.plugin.standard;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.java.plugin.Plugin;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginLifecycleException;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.standard.PluginLifecycleHandler;
import org.java.plugin.standard.StandardPluginClassLoader;
import org.java.plugin.util.ExtendedProperties;

public class StandardPluginLifecycleHandler
extends PluginLifecycleHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private boolean probeParentLoaderLast;

    protected PluginClassLoader createPluginClassLoader(final PluginDescriptor descr) {
        StandardPluginClassLoader result = AccessController.doPrivileged(new PrivilegedAction<StandardPluginClassLoader>(){

            @Override
            public StandardPluginClassLoader run() {
                return new StandardPluginClassLoader(StandardPluginLifecycleHandler.this.getPluginManager(), descr, StandardPluginLifecycleHandler.this.getClass().getClassLoader());
            }
        });
        result.setProbeParentLoaderLast(this.probeParentLoaderLast);
        return result;
    }

    protected Plugin createPluginInstance(PluginDescriptor descr) throws PluginLifecycleException {
        Class<?> pluginClass;
        String className = descr.getPluginClassName();
        try {
            pluginClass = this.getPluginManager().getPluginClassLoader(descr).loadClass(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassNotFound", className, cnfe);
        }
        try {
            return (Plugin)pluginClass.newInstance();
        }
        catch (InstantiationException ie) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", descr.getId(), ie);
        }
        catch (IllegalAccessException iae) {
            throw new PluginLifecycleException("org.java.plugin.standard", "pluginClassInstantiationFailed", descr.getId(), iae);
        }
    }

    protected void beforePluginStart(Plugin plugin) {
    }

    protected void afterPluginStop(Plugin plugin) {
    }

    protected void dispose() {
    }

    public void configure(ExtendedProperties config) {
        this.probeParentLoaderLast = "true".equalsIgnoreCase(config.getProperty("probeParentLoaderLast", "false"));
        this.log.debug((Object)("probeParentLoaderLast parameter value is " + this.probeParentLoaderLast));
    }
}

