# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LayoutItemSelector
                                 A QGIS plugin
 レイアウト印刷を選択してレイアウトマネージャを開くプラグイン
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2025-07-13
        copyright            : (C) 2025 by yamamoto-ryuzo
        email                : ryu@yamakun.net
        git sha              : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""



# QGIS標準の翻訳システム対応
import os
from qgis.PyQt.QtCore import QCoreApplication, QTranslator, QLocale
from qgis.core import QgsApplication

_translator = None

def _load_translator():
    global _translator
    plugin_dir = os.path.dirname(__file__)
    i18n_dir = os.path.join(plugin_dir, 'i18n')
    from qgis.PyQt.QtCore import QSettings
    # QGISの設定からユーザー言語を取得（なければOS言語）
    locale_setting = QSettings().value("locale/userLocale", QLocale.system().name())
    locale = str(locale_setting)[:2] if locale_setting else QLocale.system().name()[:2]
    candidates = [locale, QLocale.system().name()[:2], 'en']
    for lang in candidates:
        qm_path = os.path.join(i18n_dir, f"layout_item_selector_{lang}.qm")
        if os.path.exists(qm_path):
            _translator = QTranslator()
            if _translator.load(qm_path):
                # 既存のトランスレータを削除してから追加（競合防止）
                QCoreApplication.removeTranslator(_translator)
                QCoreApplication.installTranslator(_translator)
                break

_load_translator()

# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load LayoutItemSelector class from file LayoutItemSelector.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    from .layout_item_selector import LayoutItemSelector
    return LayoutItemSelector(iface)
