import sys #FIXME: useless
import time
from pysimplesoap.client import SoapClient
from pysimplesoap.simplexml import SimpleXMLElement, TYPE_MAP

ETRI_BM_URL = 'http://webservices.decision-deck.org/soap/ElectreTriBMInference-PyXMCDA.py'

def submit_problem(url, params):
    p = SimpleXMLElement("<submitProblem></submitProblem>")
    for k, v in params.items():
        child = p.add_child(k, v)
        child.add_attribute("xsi:type", "xsd:string")

    client = SoapClient(
        location = url,
        action = '',
        soap_ns = 'soapenv',
        namespace = 'http://www.decision-deck.org/2009/XMCDA-2.0.0',
        trace = False)

    sp = client.call('submitProblem', p)
    reply = sp.submitProblemResponse
    return str(reply.ticket)

def request_solution(url, ticket_id, timeout=0):
    client = SoapClient(
        location = url,
        action = '',
        soap_ns = 'soapenv',
        namespace = 'http://www.decision-deck.org/2009/XMCDA-2.0.0',
        trace = False)

    start = time.time()
    while True:
        rs = client.call('requestSolution', ticket=ticket_id)
        reply = rs.requestSolutionResponse

        if getattr(reply,'service-status') != 1:
            break

        time.sleep(0.5)
        if timeout and time.time()>start+timeout:
            return None

    return reply

def save_file(filename, xmcda_data):
    file = open(filename, "w")
    file.write(add_xmcda_tags(xmcda_data))
    file.close()
