# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Flight Planner - Horizontal Flight Merge
                                 A QGIS plugin

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2025-11-24
        copyright            : (C) 2025 by Prof Cazaroli e Leandro França
        email                : contato@geoone.com.br
***************************************************************************/
"""

__author__ = 'Prof Cazaroli e Leandro França - Participação Ilton Freitas'
__date__ = '2025-11-24'
__copyright__ = '(C) 2025 by Prof Cazaroli e Leandro França - Participação Ilton Freitas'
__revision__ = '$Format:%H$'

from qgis.core import *
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtCore import QCoreApplication, QVariant
from qgis.PyQt.QtWidgets import QAction, QMessageBox
from .Funcs import loadParametros, saveParametros
from ..images.Imgs import *
import csv
import os

class CSV_Merge(QgsProcessingAlgorithm):
    def initAlgorithm(self, config=None):
        csv1Merge, csv2Merge, addCsvMerge, addPointsMerge = loadParametros("H_Merge")
       
        self.addParameter(QgsProcessingParameterFile(
            'csv1', 
            'Enter the first CSV file', 
            behavior=QgsProcessingParameterFile.File, 
            fileFilter='CSV Files (*.csv)', 
            defaultValue=csv1Merge
        ))
        self.addParameter(QgsProcessingParameterFile(
            'csv2', 
            'Enter the second CSV file', 
            behavior=QgsProcessingParameterFile.File, 
            fileFilter='CSV Files (*.csv)', 
            defaultValue=csv2Merge
        ))
        self.addParameter(QgsProcessingParameterFileDestination(
            'csvS', 
            'Simplified CSV', 
            fileFilter='CSV Files (*.csv)', 
            defaultValue=addCsvMerge 
        ))
        self.addParameter(QgsProcessingParameterBoolean(
            'ver_Points_merge', 
            'Add merged points layer to project', 
            defaultValue=addPointsMerge
        ))

    def processAlgorithm(self, parameters, context, feedback):
        arquivo_csv1 = self.parameterAsFile(parameters, 'csv1', context)
        arquivo_csv2 = self.parameterAsFile(parameters, 'csv2', context)
        arquivo_csvS = self.parameterAsFile(parameters, 'csvS', context)

        # Verificações
        if arquivo_csvS:
            if not os.path.exists(os.path.dirname(arquivo_csvS)):
                raise QgsProcessingException("❌ Path to Generated CSV file does not exist!")

        # Grava Parâmetros
        saveParametros("H_Merge",
                        csvI=arquivo_csv1,
                        csv=arquivo_csv2,
                        add1=arquivo_csvS,
                        add2=parameters['ver_Points_merge']
                        )
                                
        # =========================================================================
        # Processo: juntar os dois CSV em um terceiro
        # ========================================================================
        # Abrir os dois arquivos de entrada
        with open(arquivo_csv1, 'r', encoding='utf-8') as f1, \
                open(arquivo_csv2, 'r', encoding='utf-8') as f2:

            reader1 = csv.reader(f1)
            reader2 = csv.reader(f2)

            # Ler cabeçalhos
            header1 = next(reader1)
            header2 = next(reader2)

            # Definir cabeçalho de saída (pode ser união ou apenas de um dos arquivos)
            header_out = header1 if header1 == header2 else header1 + [h for h in header2 if h not in header1]

            # Abrir arquivo de saída
            with open(arquivo_csvS, 'w', newline='', encoding='utf-8') as fout:
                writer = csv.writer(fout)
                writer.writerow(header_out)

                # Escrever linhas do primeiro CSV
                for row in reader1:
                    writer.writerow(row)

                # Escrever linhas do segundo CSV
                for row in reader2:
                    writer.writerow(row)

        if parameters['ver_Points_merge']:
            csv_path = self.parameterAsString(parameters, 'csvS', context)
            csv_name = os.path.splitext(os.path.basename(csv_path))[0]

            # Criar camada a partir do CSV
            uri = f"file:///{csv_path}?delimiter=,&xField=longitude&yField=latitude&crs=EPSG:4326"
            merged_layer = QgsVectorLayer(uri, f"Merged Points - {csv_name}", "delimitedtext")

            if not merged_layer.isValid():
                feedback.reportError("❌ Não foi possível carregar o CSV como camada de pontos.")
            else:
                QgsProject.instance().addMapLayer(merged_layer)
                feedback.pushInfo("✓ Merged points layer added to project")

        feedback.pushInfo("")
        feedback.pushInfo("✅ CSV executed successfully.")
        feedback.pushInfo("")

        return {}

    def name(self):
        return 'MergeCSV'.lower()

    def displayName(self):
        return self.tr('2. Merge CSV files')

    def group(self):
        return 'CSV Tools'

    def groupId(self):
        return 'CSVTools'.lower()

    def tr(self, string):
        return QCoreApplication.translate('Processing', string)

    def createInstance(self):
        return CSV_Merge()

    def tags(self):
        return self.tr('Flight Plan,Measure,Topography,Plano voo,Plano de voo,voo,drones,GeoOne,simplify,simplificar,generalize,merge').split(',')

    def icon(self):
        return QIcon(os.path.join(os.path.dirname(os.path.dirname(__file__)), 'images/CSV.png'))
    
    figura2 = 'images/csv_merge.jpg'

    def shortHelpString(self):
        texto = f"""This tool allows you to <b>merge two flight plan CSV files into a single mission</b>,
    enabling them to be executed <b>sequentially in one continuous flight</b>.
    <p>
    It is especially useful for <b>mapping missions</b>, where one area is flown first
    and the drone continues directly to the next area <b>without returning to the takeoff point</b>.
    </p>
    <p>
    By combining multiple flight plans into a single CSV, you can <b>optimize flight time</b>,
    <b>reduce unnecessary maneuvers</b>, and <b>save battery</b>, making large surveys more efficient.
    </p>
    <p>
    The merged CSV also can be loaded into QGIS as a <b>point layer</b> for quick visual validation.
    </p>
        """

        corpo = '''<div align="center">
                      <img src="'''+ os.path.join(os.path.dirname(os.path.dirname(__file__)), self.figura2) +'''">
                      </div>
                      <div align="right">
                       <p><b>Learn more:</b></p>
                        <ul>
                            <li><a href="https://geoone.com.br/pvplanodevoo">Sign up for GeoFlight Planner course</a></li>
                            <li><a href="https://portal.geoone.com.br/m/lessons/planodevoo?classId=6027">Click here to access the class with all the details about this tool!</a></li>
                        </ul>
                      <p align="right">
                      <b>Autores: Prof Cazaroli, Leandro França and Ilton Freitas</b>
                      </p>
                      <a target="_blank" rel="noopener noreferrer" href="https://geoone.com.br/"><img title="GeoOne" src="data:image/png;base64,'''+ GeoOne +'''"></a>
					  <p><i>"Automated, easy and straight to the point mapping is at GeoOne!"</i></p>
                      </div>
                    </div>'''

        return self.tr(texto) + corpo