# -*- coding: utf-8 -*-

"""
/***************************************************************************
 Flight Planner - A QGIS plugin

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2024-11-05
        copyright            : (C) 2024 by Prof Cazaroli e Leandro França
        email                : contato@geoone.com.br
****************************************************************************/
"""

__author__ = 'Prof Cazaroli e Leandro França'
__date__ = '2024-11-05'
__copyright__ = '(C) 2024 by Prof Cazaroli e Leandro França'

import os

from qgis.PyQt.QtWidgets import QAction, QMenu, QMessageBox
from qgis.PyQt.QtGui import QIcon
from qgis.core import QgsApplication
from qgis.utils import iface

from .PlanoVoo_provider import PlanoVooProvider

class GeoFlightPlanner:
    def __init__(self, iface):
        self.iface = iface
        self.plugin_dir = os.path.dirname(__file__)
        self.menu = None
        self.actions = []
        self.provider = None

    def initGui(self):
        # Register the processing provider
        self.provider = PlanoVooProvider()
        QgsApplication.processingRegistry().addProvider(self.provider)

        icon_dir = os.path.join(self.plugin_dir, "images")

        # Create the main plugin menu
        self.menu = QMenu("GeoFlight Planner", self.iface.mainWindow())
        self.menu.setObjectName("GeoFlight Planner")
        standard_menu = self.iface.firstRightStandardMenu()
        self.iface.mainWindow().menuBar().insertMenu(standard_menu.menuAction(), self.menu)

        # Clear previous actions if plugin was reloaded
        self.menu.clear()

        # Create submenus
        horizontal_menu = QMenu("Horizontal Flight Plan", self.menu)
        vertical_menu = QMenu("Vertical Flight Plan", self.menu)
        csv_menu = QMenu("CSV Tools", self.menu)

        # Add Calculator action directly to main menu
        self._add_action("GSD and Overlap - Mission Calculator...", self._open_calculator, icon_path=os.path.join(icon_dir, "calculator.png"))

        # Add Horizontal submenu actions
        self._add_action("Sensor", lambda: self._run_algorithm("Flight_Plan_H_Sensor"), horizontal_menu, os.path.join(icon_dir, "Horizontal.png"))
        self._add_action("RC2 Controller", lambda: self._run_algorithm("Flight_Plan_H_RC2"), horizontal_menu, os.path.join(icon_dir, "Horizontal.png"))
        self._add_action("Manual", lambda: self._run_algorithm("Flight_Plan_H_Manual"), horizontal_menu, os.path.join(icon_dir, "Horizontal.png"))

        # Add Vertical submenu actions
        self._add_action("Circular", lambda: self._run_algorithm("Flight_Plan_V_C"), vertical_menu, os.path.join(icon_dir, "Vertical.png"))
        self._add_action("Facade", lambda: self._run_algorithm("Flight_Plan_V_F"), vertical_menu, os.path.join(icon_dir, "Vertical.png"))

         # Add Simplified submenu actions
        self._add_action("Simplify Waypoints", lambda: self._run_algorithm('SimplifyWaypoints'.lower()), csv_menu, os.path.join(icon_dir, "CSV.png"))

        # Add submenus to main menu
        self.menu.addMenu(horizontal_menu)
        self.menu.addMenu(vertical_menu)
        self.menu.addMenu(csv_menu)

    def unload(self):
        for action in self.actions:
            self.iface.removeToolBarIcon(action)
        self.actions = []

        if self.menu:
            try:
                self.iface.mainWindow().menuBar().removeAction(self.menu.menuAction())
            except RuntimeError:
                pass  # menu já foi removido
            self.menu = None

        try:
            QgsApplication.processingRegistry().removeProvider(self.provider)
        except RuntimeError:
            pass
        self.provider = None

    def _add_action(self, label, callback, parent_menu=None, icon_path=None):
        if icon_path and os.path.exists(icon_path):
            icon = QIcon(icon_path)
            action = QAction(icon, label, self.iface.mainWindow())
        else:
            action = QAction(label, self.iface.mainWindow())

        action.triggered.connect(callback)
        self.actions.append(action)

        if parent_menu:
            parent_menu.addAction(action)
        elif self.menu:
            self.menu.addAction(action)

    def _open_calculator(self):
        try:
            from .calculator.calculators import Calculator_Dialog
            dlg = Calculator_Dialog(self.iface)
            try:
                dlg.exec()     # PyQt6
            except AttributeError:
                dlg.exec_()    # PyQt5
        except Exception as e:
            QMessageBox.critical(None, "Error", f"Error opening calculator:\n{str(e)}")

    def _run_algorithm(self, algorithm_name):
        try:
            from qgis import processing
            algorithm_id = f"GeoFlightPlanner:{algorithm_name}"
            processing.execAlgorithmDialog(algorithm_id)
        except Exception as e:
            QMessageBox.critical(None, "Error", f"Error executing algorithm:\n{str(e)}")
