# -*- coding: utf-8 -*-
"""
/***************************************************************************
 AdjustStyleDockWidget
                                 A QGIS plugin
 Adjust color, line thickness, font size etc. of all symbols/labels.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-05-05
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Florian Neukirchen
        email                : mail@riannek.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os

from qgis.PyQt import QtGui, QtWidgets, uic
from qgis.PyQt.QtCore import pyqtSignal, Qt
from qgis.PyQt.QtWidgets import QAction, QLabel, QCheckBox
from qgis.PyQt.QtGui import QColor, QPalette
from qgis.core import (
    QgsLayoutItemLegend, 
    QgsLayoutItemScaleBar, 
    QgsLayoutItemLabel, 
    QgsLayoutItemShape, 
    QgsLegendStyle,
    QgsLayoutFrame,
    QgsLayoutMeasurement,
    QgsLayoutTable,
    QgsLayoutItemMarker,
    QgsLayoutItemPolygon,
    QgsLayoutItemPolyline,
    QgsLayoutItemPicture,
    QgsLayoutItemPage
    )

FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'adjust_style_dockwidget_base.ui'))


class AdjustStyleDockWidget(QtWidgets.QDockWidget, FORM_CLASS):

    closingPlugin = pyqtSignal()

    def __init__(self, parent=None):
        """Constructor."""
        super(AdjustStyleDockWidget, self).__init__(parent)
        # Set up the user interface from Designer.
        # After setupUI you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://doc.qt.io/qt-5/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Init slider and spinbox widgets
        self.horizontalSlider.setValue(30) 
        self.spinBox.setValue(30) 
        self.horizontalSlider.valueChanged[int].connect(self.sliderChangeValue)
        self.spinBox.valueChanged[int].connect(self.spinboxChangeValue)

        self.changeSlider.setValue(20)
        self.changeSpinBox.setValue(20)
        self.changeSlider.valueChanged.connect(self.changeSliderChangeValue)
        self.changeSpinBox.valueChanged.connect(self.changeSpinboxChangeValue)

        # Create color grid
        self.wheel = range(0, 360, 30)


        tooltip = self.tr('Preview of rotating color hue (color wheel)')

        for column, hue in enumerate(self.wheel):
            for row in range(2):
                color = QColor()
                color.setHsv(hue, 250, 250, 250)
                widget = QLabel(' ')
                widget.setAutoFillBackground(True) 
                palette = QPalette()
                palette.setColor(QPalette.Window, color)
                widget.setPalette(palette)
                widget.setToolTip(tooltip)
                self.colorGrid.addWidget(widget, row, column)

        self.update_preview_colors()



    #--------------------------------------------------------------------------

    # Update preview colors

    def update_preview_colors(self):
        for column, hue in enumerate(self.wheel):
            h = hue + self.spinBox.value()
            if h >= 360:
                h = h - 360
            color = QColor()
            color.setHsv(h, 250, 250, 250)
            widget = self.colorGrid.itemAtPosition(1, column).widget()
            palette = QPalette()
            palette.setColor(QPalette.Window, color)
            widget.setPalette(palette)


    # Connect slider and spinbox
    def spinboxChangeValue(self):
        self.horizontalSlider.setValue(self.spinBox.value())
        self.update_preview_colors()

    def sliderChangeValue(self):
        self.spinBox.setValue(self.horizontalSlider.value())
        self.update_preview_colors()

    def changeSpinboxChangeValue(self):
        self.changeSlider.setValue(int(self.changeSpinBox.value()))

    def changeSliderChangeValue(self):
        self.changeSpinBox.setValue(int(self.changeSlider.value()))



    def closeEvent(self, event):
        self.closingPlugin.emit()
        event.accept()



class AdjustStyleLayoutDockWidget(AdjustStyleDockWidget):
    def __init__(self, parent=None):
        super(AdjustStyleLayoutDockWidget, self).__init__(parent)

        self.radioActiveLayer.setParent(None)
        self.radioAllLayers.setParent(None)
        self.radioSelectedLayers.setParent(None)
        self.radioVisibleLayers.setParent(None)
        self.label_6.setParent(None)
        self.checkAnnotation.setParent(None)
        self.checkCanvas.setParent(None)
        self.loadStylesButton.setParent(None)
        self.saveStylesButton.setParent(None)
        self.line_2.setParent(None)

        container = self.verticalLayout_2

        self.checkTextLabels = QCheckBox(self.tr('Text'))
        self.checkLegend = QCheckBox(self.tr('Legend'))
        self.checkScalebar = QCheckBox(self.tr('Scalebar'))
        self.checkSVG = QCheckBox(self.tr('North arrow, parameterized SVG'))
        self.checkShapes = QCheckBox(self.tr('Shapes'))
        self.checkMarker = QCheckBox(self.tr('Marker'))
        self.checkLinesPolygons = QCheckBox(self.tr('Lines, Polygons, Arrows'))
        self.checkTable = QCheckBox(self.tr('Tables'))
        self.checkPage = QCheckBox(self.tr('Page Background'))

        self.checkLegend.setChecked(True)
        self.checkScalebar.setChecked(True)
        self.checkSVG.setChecked(True)
        self.checkTextLabels.setChecked(True)
        self.checkShapes.setChecked(True)
        self.checkMarker.setChecked(True)
        self.checkLinesPolygons.setChecked(True)
        self.checkTable.setChecked(True)
        self.checkPage.setChecked(True)

        container.insertWidget(0, self.checkTextLabels)
        container.insertWidget(1, self.checkLegend)
        container.insertWidget(2, self.checkScalebar)
        container.insertWidget(3, self.checkSVG)
        container.insertWidget(4, self.checkShapes)
        container.insertWidget(5, self.checkMarker)
        container.insertWidget(6, self.checkLinesPolygons)
        container.insertWidget(7, self.checkTable)
        container.insertWidget(8, self.checkPage)
        



class AdjustStyleLayoutHandler():
    def __init__(self, plugin_instance, designer):
        self.plugin_instance = plugin_instance
        self.designer = designer
        self.dockwidget = None

        self.action = QAction(plugin_instance.icon, plugin_instance.menu, designer)
        self.action.triggered.connect(self.openDesignerDockWidget)
        self.action.setEnabled(True)

        toolbar = designer.actionsToolbar()
        toolbar.addAction(self.action)

        editmenu = designer.editMenu()
        editmenu.addAction(self.action)

        self.legend_components = [
            QgsLegendStyle.Title,
            QgsLegendStyle.Subgroup,
            QgsLegendStyle.Group,
            QgsLegendStyle.SymbolLabel
        ]
        

    def openDesignerDockWidget(self):
        if self.dockwidget is None:
            self.dockwidget = AdjustStyleLayoutDockWidget(self.designer.window())
            self.designer.addDockWidget(Qt.LeftDockWidgetArea, self.dockwidget)

            self.dockwidget.hueButton.clicked.connect(self.hueBtn)
            self.dockwidget.plusSatButton.clicked.connect(self.saturationPlusBtn)
            self.dockwidget.minusSatButton.clicked.connect(self.saturationMinusBtn)
            self.dockwidget.plusValueButton.clicked.connect(self.hsvValuePlusBtn)
            self.dockwidget.minusValueButton.clicked.connect(self.hsvValueMinusBtn)
            self.dockwidget.plusStrokeWidthButton.clicked.connect(self.strokeWidthPlusBtn)
            self.dockwidget.minusStrokeWidthButton.clicked.connect(self.strokeWidthMinusBtn)
            self.dockwidget.plusFontSizeButton.clicked.connect(self.fontSizePlusBtn)
            self.dockwidget.minusFontSizeButton.clicked.connect(self.fontSizeMinusBtn)
            self.dockwidget.replaceFontButton.clicked.connect(self.replace_font_dlg)

        self.dockwidget.show()

    def unload(self):
        toolbar = self.designer.actionsToolbar()
        toolbar.removeAction(self.action)
        editmenu = self.designer.editMenu()
        editmenu.removeAction(self.action)
        self.dockwidget = None


    def hueBtn(self):
        self.plugin_instance.value = self.dockwidget.spinBox.value()
        self.plugin_instance.change_color = self.plugin_instance.rotate_hue
        self.mapToLayout(self.layout_change_color)

    def saturationPlusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value()
        self.plugin_instance.change_color = self.plugin_instance.change_saturation
        self.mapToLayout(self.layout_change_color)       

    def saturationMinusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() * -1
        self.plugin_instance.change_color = self.plugin_instance.change_saturation
        self.mapToLayout(self.layout_change_color)  

    def hsvValuePlusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value()
        self.plugin_instance.change_color = self.plugin_instance.change_hsv_value
        self.mapToLayout(self.layout_change_color)  

    def hsvValueMinusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() * -1
        self.plugin_instance.change_color = self.plugin_instance.change_hsv_value
        self.mapToLayout(self.layout_change_color)  

    def strokeWidthPlusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() / 100
        self.mapToLayout(self.layout_change_stroke)  

    def strokeWidthMinusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() * -1 / 100
        self.mapToLayout(self.layout_change_stroke)  

    def fontSizePlusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() / 100
        self.mapToLayout(self.layout_font_size)

    def fontSizeMinusBtn(self):
        self.plugin_instance.value = self.dockwidget.changeSpinBox.value() * -1 / 100
        self.mapToLayout(self.layout_font_size)

    def replace_font_dlg(self):
        self.plugin_instance.replace_font_dlg(self)

    def mapToLayout(self, func):
        layout = self.designer.layout()

        for item in layout.items():
            func(item)

                

    def layout_change_color(self, item):

        if isinstance(item, QgsLayoutItemLegend) and self.dockwidget.checkLegend.isChecked():
            for component in self.legend_components:
                try:
                    style = item.style(component)
                    format = style.textFormat()
                    format = self.plugin_instance.change_font_color(format)
                    style.setTextFormat(format)
                    item.setStyle(component, style)

                except AttributeError:
                    print('Style change of legend requires QGIS >= 3.30')
                    break

            if item.hasBackground():
                background = item.backgroundColor()
                background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                item.setBackgroundColor(background)

            if item.frameEnabled():
                frame = item.frameStrokeColor()
                frame = self.plugin_instance.change_color(frame, self.plugin_instance.value)
                item.setFrameStrokeColor(frame)

            item.refresh()

        elif isinstance(item, QgsLayoutItemScaleBar) and self.dockwidget.checkScalebar.isChecked():
            format = item.textFormat()
            format = self.plugin_instance.change_font_color(format)
            item.setTextFormat(format)

            symbol = item.fillSymbol()
            self.plugin_instance.change_symbol_color(symbol)

            symbol = item.alternateFillSymbol()
            self.plugin_instance.change_symbol_color(symbol)

            symbol = item.lineSymbol()
            self.plugin_instance.change_symbol_color(symbol)

            symbol = item.divisionLineSymbol()
            self.plugin_instance.change_symbol_color(symbol)

            symbol = item.subdivisionLineSymbol()
            self.plugin_instance.change_symbol_color(symbol)

            if item.hasBackground():
                background = item.backgroundColor()
                background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                item.setBackgroundColor(background)

            if item.frameEnabled():
                frame = item.frameStrokeColor()
                frame = self.plugin_instance.change_color(frame, self.plugin_instance.value)
                item.setFrameStrokeColor(frame)

            item.refresh()

        elif isinstance(item, QgsLayoutItemLabel) and self.dockwidget.checkTextLabels.isChecked():
            format = item.textFormat()
            format = self.plugin_instance.change_font_color(format)
            item.setTextFormat(format)

            if item.hasBackground():
                background = item.backgroundColor()
                background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                item.setBackgroundColor(background)

            if item.frameEnabled():
                frame = item.frameStrokeColor()
                frame = self.plugin_instance.change_color(frame, self.plugin_instance.value)
                item.setFrameStrokeColor(frame)

            item.refresh()

        elif isinstance(item, QgsLayoutItemShape) and self.dockwidget.checkShapes.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_color(symbol)
            item.refresh()

        elif isinstance(item, QgsLayoutItemMarker) and self.dockwidget.checkMarker.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_color(symbol)

            if item.hasBackground():
                background = item.backgroundColor()
                background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                item.setBackgroundColor(background)

            item.refresh()

        elif isinstance(item, QgsLayoutItemPolygon) and self.dockwidget.checkLinesPolygons.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_color(symbol)
            item.refresh()

        elif isinstance(item, QgsLayoutItemPolyline) and self.dockwidget.checkLinesPolygons.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_color(symbol)
            # Arrows
            if item.endMarker() == 1:
                color = item.arrowHeadFillColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                item.setArrowHeadFillColor(color)

                color = item.arrowHeadStrokeColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                item.setArrowHeadStrokeColor(color)

            item.refresh()

        elif isinstance(item, QgsLayoutItemPicture) and self.dockwidget.checkSVG.isChecked():
            color = item.svgFillColor()
            color = self.plugin_instance.change_color(color, self.plugin_instance.value)
            item.setSvgFillColor(color)

            color = item.svgStrokeColor()
            color = self.plugin_instance.change_color(color, self.plugin_instance.value)
            item.setSvgStrokeColor(color)

            if item.hasBackground():
                background = item.backgroundColor()
                background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                item.setBackgroundColor(background)
            
            if item.frameEnabled():
                frame = item.frameStrokeColor()
                frame = self.plugin_instance.change_color(frame, self.plugin_instance.value)
                item.setFrameStrokeColor(frame)
            
            item.refresh()

        elif isinstance(item, QgsLayoutItemPage) and self.dockwidget.checkPage.isChecked():
            symbol = item.pageStyleSymbol()
            self.plugin_instance.change_symbol_color(symbol)
            item.refresh()

        # Tables
        elif isinstance(item, QgsLayoutFrame) and self.dockwidget.checkTable.isChecked():
            table = item.multiFrame()
            print(table)
            # Make shure it is really a table
            if isinstance(table, QgsLayoutTable):
                color = table.backgroundColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                table.setBackgroundColor(color)

                color = table.contentFontColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                table.setContentFontColor(color)

                color = table.headerFontColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                table.setHeaderFontColor(color)

                color = table.gridColor()
                color = self.plugin_instance.change_color(color, self.plugin_instance.value)
                table.setGridColor(color)

                # Advanced style settings
                for i in range(9):
                    cellstyle = table.cellStyle(i)
                    if cellstyle.enabled:
                        color = cellstyle.cellBackgroundColor
                        cellstyle.cellBackgroundColor = self.plugin_instance.change_color(color, self.plugin_instance.value)

                # On attribute tables, there could also be conditonal styles, but we ignore them for now

                if item.hasBackground():
                    background = item.backgroundColor()
                    background = self.plugin_instance.change_color(background, self.plugin_instance.value)
                    item.setBackgroundColor(background)

                if item.frameEnabled():
                    frame = item.frameStrokeColor()
                    frame = self.plugin_instance.change_color(frame, self.plugin_instance.value)
                    item.setFrameStrokeColor(frame)

                item.refresh()



    def layout_change_stroke(self, item):

        if isinstance(item, QgsLayoutItemLegend) and self.dockwidget.checkLegend.isChecked():
            self.frame_change_stroke(item)
            item.refresh()

        elif isinstance(item, QgsLayoutItemScaleBar) and self.dockwidget.checkScalebar.isChecked():
            symbol = item.fillSymbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            symbol = item.alternateFillSymbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            symbol = item.lineSymbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            symbol = item.divisionLineSymbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            symbol = item.subdivisionLineSymbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            self.frame_change_stroke(item)

            item.refresh()

        elif isinstance(item, QgsLayoutItemLabel) and self.dockwidget.checkTextLabels.isChecked():
            self.frame_change_stroke(item)
            item.refresh()

        elif isinstance(item, QgsLayoutItemShape) and self.dockwidget.checkShapes.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_stroke(symbol)
            item.refresh()

        elif isinstance(item, QgsLayoutItemMarker) and self.dockwidget.checkMarker.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_stroke(symbol)
            item.refresh()

        elif isinstance(item, QgsLayoutItemPolygon) and self.dockwidget.checkLinesPolygons.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_stroke(symbol)
            item.refresh()

        elif isinstance(item, QgsLayoutItemPolyline) and self.dockwidget.checkLinesPolygons.isChecked():
            symbol = item.symbol()
            self.plugin_instance.change_symbol_stroke(symbol)

            # Arrows
            if item.endMarker() == 1:
                width = item.arrowHeadStrokeWidth()
                width = width + width * self.plugin_instance.value
                item.setArrowHeadStrokeWidth(width)
            item.refresh()

        elif isinstance(item, QgsLayoutItemPicture) and self.dockwidget.checkSVG.isChecked():
            width = item.svgStrokeWidth()
            width = width + width * self.plugin_instance.value
            item.setSvgStrokeWidth(width)
            item.refresh()

        # Tables
        elif isinstance(item, QgsLayoutFrame) and self.dockwidget.checkTable.isChecked():
            table = item.multiFrame()
            # Make shure it is really a layout table
            if isinstance(table, QgsLayoutTable):
                width = table.gridStrokeWidth()
                width = width + width * self.plugin_instance.value
                table.setGridStrokeWidth(width)


    def frame_change_stroke(self, item):
        if item.frameEnabled():
            measure = item.frameStrokeWidth() # Returns QgsLayoutMeasurement
            width = measure.length() + measure.length() * self.plugin_instance.value
            measure.setLength(width)
            item.setFrameStrokeWidth(measure)

    def layout_font_size(self, item):

        if isinstance(item, QgsLayoutItemLegend) and self.dockwidget.checkLegend.isChecked():

            for component in self.legend_components:
                try:
                    style = item.style(component)
                    format = style.textFormat()
                    format = self.plugin_instance.change_font_size(format)
                    style.setTextFormat(format)
                    item.setStyle(component, style)

                except AttributeError:
                    print('Style change of legend requires QGIS >= 3.30')
                    break

            item.refresh()

        elif isinstance(item, QgsLayoutItemScaleBar) and self.dockwidget.checkScalebar.isChecked():
            format = item.textFormat()
            format = self.plugin_instance.change_font_size(format)
            item.setTextFormat(format)
            item.refresh()

        elif isinstance(item, QgsLayoutItemLabel) and self.dockwidget.checkTextLabels.isChecked():
            format = item.textFormat()
            format = self.plugin_instance.change_font_size(format)
            item.setTextFormat(format)
            item.refresh()

        elif isinstance(item, QgsLayoutFrame) and self.dockwidget.checkTable.isChecked():
            table = item.multiFrame()
            # Make shure it is really a layout table
            if isinstance(table, QgsLayoutTable):
                format = table.headerTextFormat()
                format = self.plugin_instance.change_font_size(format)
                table.setHeaderTextFormat(format)

                format = table.contentTextFormat()
                format = self.plugin_instance.change_font_size(format)
                table.setContentTextFormat(format)

                item.refresh()


    def collect_fonts(self):
        layout = self.designer.layout()
        self.fonts = set()

        for item in layout.items():
            if isinstance(item, QgsLayoutItemLabel) and self.dockwidget.checkTextLabels.isChecked():
                self.extract_font(item)


            elif isinstance(item, QgsLayoutItemScaleBar) and self.dockwidget.checkScalebar.isChecked():
                self.extract_font(item)

            elif isinstance(item, QgsLayoutItemLegend) and self.dockwidget.checkLegend.isChecked():
                for component in self.legend_components:
                    self.extract_font(item.style(component))

            elif isinstance(item, QgsLayoutFrame) and self.dockwidget.checkTable.isChecked():
                table = item.multiFrame()
                if isinstance(table, QgsLayoutTable):
                    try:
                        self.fonts.add(table.headerTextFormat().font().family())
                        self.fonts.add(table.contentTextFormat().font().family())
                    except AttributeError:
                        pass

        return self.fonts
    
    def extract_font(self, item):
        format = item.textFormat()
        try:
            self.fonts.add(format.font().family())
        except AttributeError:
            pass

    def replace_font(self):
        layout = self.designer.layout()

        for item in layout.items():
            if isinstance(item, QgsLayoutItemLabel) and self.dockwidget.checkTextLabels.isChecked():
                self.replace_font_item(item)

            elif isinstance(item, QgsLayoutItemScaleBar) and self.dockwidget.checkScalebar.isChecked():
                self.replace_font_item(item)

            elif isinstance(item, QgsLayoutItemLegend) and self.dockwidget.checkLegend.isChecked():
                for component in self.legend_components:
                    style = item.style(component)
                    style = self.replace_font_item(style)
                    item.setStyle(component, style)

            elif isinstance(item, QgsLayoutFrame) and self.dockwidget.checkTable.isChecked():
                table = item.multiFrame()
                if isinstance(table, QgsLayoutTable):
                    format = table.headerTextFormat()
                    if format.font().family() == self.plugin_instance.oldfont:
                        format.setFont(self.plugin_instance.newfont)
                        table.setHeaderTextFormat(format)

                    format = table.contentTextFormat()
                    if format.font().family() == self.plugin_instance.oldfont:
                        format.setFont(self.plugin_instance.newfont)
                        table.setContentTextFormat(format)

    def replace_font_item(self, item):
        format = item.textFormat()
        if format.font().family() == self.plugin_instance.oldfont:
            format.setFont(self.plugin_instance.newfont)
            item.setTextFormat(format)
        return item