# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Qgis2rasterliteDialog
                                 A QGIS plugin
 import raster into spatialite5  database
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2021-07-30
        git sha              : $Format:%H$
        copyright            : (C) 2021 by adArte srl
        email                : enzo.ccc@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import subprocess
import platform
from qgis.PyQt import uic
from qgis.PyQt.QtGui import QDesktopServices
from qgis.PyQt.QtCore import  pyqtSlot, pyqtSignal,QThread,QUrl,QSettings,Qt
from qgis.PyQt.QtWidgets import QApplication, QDialog, QMessageBox, QFileDialog,QLineEdit,QWidget,QCheckBox
from qgis.PyQt.QtSql import *
from qgis.PyQt.uic import loadUiType
from qgis.PyQt import  QtWidgets 
from qgis.core import  *
from qgis.gui import  *
from qgis.utils import iface
# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'qgis2raster_dialog_base.ui'))


class Qgis2rasterliteDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        """Constructor."""
        super(Qgis2rasterliteDialog, self).__init__(parent)
        
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)
        # self.toolButton_raster.clicked.connect(self.setPathraster)
        # self.toolButton_database.clicked.connect(self.setPathDB)
        self.comboBox_raster.setFilters(QgsMapLayerProxyModel.RasterLayer)
        self.test()
        #self.comboBox_database.activated[str].connect(self.test)
    def test(self):    
        
        p = QgsProviderRegistry.instance().providerMetadata('spatialite')
        
        a=self.comboBox_database.addItems(p.connections())
        
        index = self.comboBox_database.findText(a, Qt.MatchFixedString)
        if index >= 0:
            self.comboBox_database.setCurrentIndex(index)
        con = p.connections()[self.comboBox_database.currentText()]
        if platform.system() == "Windows":
            conn=con.uri().replace("dbname=",'').replace("'","").replace("/","\\")
        else:
            conn=con.uri().replace("dbname=",'').replace("'","")
        return conn
        
    
    # def setPathraster(self):
        
        # s = QgsSettings()
        # dbpath = QFileDialog.getOpenFileName(
            # self,
            # "Set file name",
            # '',
            # "image (*.*)"
        # )[0]
        # #filename=dbpath.split("/")[-1]
        # if dbpath:

            # self.comboBox_raster.setEditText(dbpath)
            # s.setValue('',dbpath)
    
    # def setPathDB(self):
        # s = QgsSettings()
        # filename = QFileDialog.getOpenFileName(
            # self,
            # "Set file name",
            # '',
            # " db sqlite (*.sqlite)"
        # )[0]
        # #filename=dbpath.split("/")[-1]
        # if filename:

            # self.comboBox_database.setEditText(filename)
            # s.setValue('',filename)
    
    
    
    
    def on_pushButton_import_pressed(self):
        self.comboBox_raster.update()
        try:
            raster = self.comboBox_raster.currentLayer()
            database=self.test()
            table_n= str(self.lineEdit_table_name.text())
            driver= str(self.comboBox_driver.currentText())
            
            self.list.addItem(str("gdal_translate -of Rasterlite " +str(raster.source()) +  "\n RASTERLITE:" + database  + "\n,table="+str(table_n) + " -co DRIVER=" + str(driver)))
            params=os.system("gdal_translate -of Rasterlite " + '"'+str(raster.source()) + '"'+  " RASTERLITE:" + database + ",table="+str(table_n) + " -co DRIVER=" + str(driver))
            self.list.addItem("...........................\n\n")
            
            if params==0:
                self.list.addItem("Raster imported\n\n")
            else:
                self.list.addItem("Error!!\n\n")
        except Exception as e:
            QMessageBox.warning(self, "Attenzione",
                                     str(e),
                                     QMessageBox.Ok)
    
    
    def on_pushButton_vacuum_pressed(self):
        
        database=self.test()
        self.list.addItem(str("ogrinfo "+ database + " -sql 'VACUUM'"))
        params=os.system("ogrinfo "+ database + " -sql 'VACUUM'")  
        if params==0:
                self.list.addItem("VACUUM OK\n\n")
        else:
            self.list.addItem("Error!!\n\n")
            
        
    def on_pushButton_load_pressed(self):    
        
        uri=self.test()
        table_n= str(self.lineEdit_table_name.text())
        rlayer = iface.addRasterLayer(uri, table_n, 'gdal')
        if not rlayer.isValid():
            self.list.addItem(str("Layer failed to load!"))
        else:
            QgsProject.instance().addMapLayer(rlayer)
             
           