# -*- coding: utf-8 -*-
"""
/***************************************************************************
 QGIS2APICNIGDialog
                                 A QGIS plugin
 Complemento que crea un visualizador cartográfico con el contenido del lienzo de QGIS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2023-12-16
        git sha              : $Format:%H$
        copyright            : (C) 2023 by IngenieroGeomatico
        email                : aurearagon@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
from pathlib import Path
import shutil
import webbrowser

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets

from qgis.core import (
                        QgsProject, QgsMapLayer, QgsWkbTypes, QgsCoordinateTransform, 
                        QgsCoordinateReferenceSystem, QgsVectorFileWriter, QgsCoordinateTransformContext,
                        QgsMessageLog
                       )
from qgis.gui import QgsMapCanvas
from qgis.utils import iface, Qgis

from PyQt5 import QtGui, QtWidgets, QtCore



# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), 'QGIS2APICNIG_dialog_base.ui'))


class QGIS2APICNIGDialog(QtWidgets.QDialog, FORM_CLASS):
    
    def __init__(self, parent=None):
        """Constructor."""
        super(QGIS2APICNIGDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # Ventana de aviso de obsolescencia
        msg = QtWidgets.QMessageBox(self)
        msg.setIcon(QtWidgets.QMessageBox.Information)
        msg.setWindowTitle("Aviso: Plugin obsoleto")
        msg.setTextFormat(QtCore.Qt.RichText)
        msg.setText(
            "<b>Este plugin está obsoleto, debido a la evolución de API-CNIG a API-IDEE</b><br><br>"
            "Por favor, utiliza el nuevo plugin QGIS2API-IDEE:<br>"
            "<br>"
            "<a href='https://plugins.qgis.org/plugins/qgis2apiidee/'>QGIS2API-IDEE</a>"
        )
        msg.setStandardButtons(QtWidgets.QMessageBox.Ok)
        msg.exec_()


    def selectFolder(self):
        dialog = QtWidgets.QFileDialog()
        if self.lineEdit_Folder.text().replace(" ","").replace("—","_") == '':
            folder_path = dialog.getExistingDirectory(None, "Selecciona carpeta de salida")
        else:
            folder_path = dialog.getExistingDirectory(self.lineEdit_Folder, "Selecciona carpeta de salida")  

        if folder_path == None or folder_path == "":
            folder_path = self.lineEdit_Folder.text()

        self.lineEdit_Folder.setText(folder_path)
        return folder_path

    def exportMap(self):
        projectSource = "/QGIS2APICNIG"
        sourceFolder = "/Sources"
        JSFolder = "/JS"
        CSSFolder = "/CSS"
        pluginQGIS2APICNIG = "/pluginQGIS2APICNIG"

        exportFolder = self.lineEdit_Folder.text() + projectSource
        exportFolderSources = self.lineEdit_Folder.text() + projectSource + sourceFolder
        exportJSFolder = self.lineEdit_Folder.text() + projectSource + JSFolder
        exportCSSFolder= self.lineEdit_Folder.text() + projectSource + CSSFolder

        exportPluginQGIS2APICNIG = self.lineEdit_Folder.text() + projectSource + pluginQGIS2APICNIG 

        if Path(exportFolder).exists() == True:
            shutil.rmtree(exportFolder)

        Path(exportFolder).mkdir(parents=True, exist_ok=True)
        Path(exportFolderSources).mkdir(parents=True, exist_ok=True)
        Path(exportJSFolder).mkdir(parents=True, exist_ok=True)
        Path(exportCSSFolder).mkdir(parents=True, exist_ok=True)

        # Obtención de extensiones personalizadas QGIS2APICNIG
        checkBox_ComparacionMapas = self.checkBox_ComparacionMapas.isChecked()
        if checkBox_ComparacionMapas:
            # print('File name :    ', os.path.basename(__file__))
            # print('Directory Name:     ', os.path.dirname(__file__))
            Path(exportPluginQGIS2APICNIG).mkdir(parents=True, exist_ok=True)
            
            shutil.copytree(os.path.dirname(__file__)+'/customPlugins/comparadorMapas', exportPluginQGIS2APICNIG+'/comparadorMapas', dirs_exist_ok=True) 
            shutil.copytree(os.path.dirname(__file__)+'/customPlugins/viglino', exportPluginQGIS2APICNIG+'/viglino', dirs_exist_ok=True) 

        fileMap = exportFolder + '/index.html'
        fileJS = exportJSFolder + '/QGIS2APICNIG.js'
        fileCSS = exportCSSFolder + '/QGIS2APICNIG.css'

        tableOfSources = self.tableWidget_capas
        # print("tableOfSources.columnCount(): ", tableOfSources.columnCount())
        # print("tableOfSources.rowCount(): ", tableOfSources.rowCount())

        layers = []
        controls = []
        plugins = []
        pluginImports = []

        # Contenido de la tabla:
        # [ 0-> capa superpuesta, 1-> visible, 2-> tipo de capa, 3-> fuente de la capa, 4-> nombre]
        initialZIndexLayer = 100
        initialZIndexLayerMax = initialZIndexLayer + tableOfSources.rowCount()
        for r in range(tableOfSources.rowCount()):
            layer={
                'layerSourceType':'',
                'url_path':'',
                'format':'',
                'style':'',
                'nameLayer':'',
                'nameLegend':'',
                'visible':0,
                'isLocal':0,
                'dataSourceUri':'',
                'source':'',
                'QGISlayer':'',
                'sourceFolder':sourceFolder,
                'exportFolderSources':exportFolderSources,
                'zIndex': initialZIndexLayer - r
            }
            
            
            for c in range(tableOfSources.columnCount()):
                item = tableOfSources.item(r, c)
                if item == None:
                    cell_widget = tableOfSources.cellWidget(r, c)
                    if cell_widget is not None:
                        chk_box = cell_widget.findChild(QtWidgets.QCheckBox).isChecked()
                        # c = 0 --> capa supuerpuesta
                        if c == 0:
                            # print('check capa superpuesta:  ',chk_box)
                            if chk_box == False:
                                break
                        # c = 1 --> capa visible
                        elif c == 1:
                            # print('check visible:  ',chk_box)
                            layer['visible'] = chk_box
                            continue
                
                else:
                    text = str(item.text())

                    # c = 2 --> tipo de capa
                    if c == 2:
                        # print('tipo de la capa: ',text)
                        pass
                    
                    # c = 3 --> fuente de la capa
                    elif c == 3:
                        # print('fuente de la capa: ',text)
                        layer['layerSourceType'] = text
                    
                    # c = 4 --> nombre
                    elif c == 4:
                        QGISlayer = QgsProject.instance().mapLayersByName(text)[0]
                        layer['QGISlayer'] = QGISlayer
                        # print('nombre de la capa: ',QGISlayer.name())
                        layer['nameLegend'] = QGISlayer.name()
                        layer['dataSourceUri'] = QGISlayer.dataProvider().dataSourceUri()
                        layer['source'] = QGISlayer.source()

                        if layer['dataSourceUri'] == '':
                            layer['dataSourceUri'] = layer['source'] 
                    
                if c == tableOfSources.columnCount() -1 :
                    layers.append( self.JSONLayer2StringLayer(layer) )      
        
        layers = list(filter( lambda k: '' != k, layers ))        
        layers = list(reversed(layers))    

        # Obtención de controles y plugins
        # ["scale","scaleline","panzoombar","panzoom","location","getfeatureinfo","rotate","backgroundlayers"]
        checkBox_checkBox_SelectorCapas = self.checkBox_SelectorCapas.isChecked()
        checkBox_CapasBase = self.checkBox_CapasBase.isChecked()
        checkBox_Rotacion = self.checkBox_Rotacion.isChecked()
        checkBox_Localizacion = self.checkBox_Localizacion.isChecked()
        checkBox_EscalaZoom = self.checkBox_EscalaZoom.isChecked()
        checkBox_ZoomBotones = self.checkBox_ZoomBotones.isChecked()
        checkBox_ZoomBarrita = self.checkBox_ZoomBarrita.isChecked()
        checkBox_EscalaGrafica = self.checkBox_EscalaGrafica.isChecked()

        


        # Comprobación controles
        if checkBox_CapasBase:
            controls.append('backgroundlayers')
        if checkBox_Rotacion:
            controls.append('rotate')
        if checkBox_Localizacion:
            controls.append('location')
        if checkBox_EscalaZoom:
            controls.append('scale')
        if checkBox_ZoomBotones:
            controls.append('panzoom')
        if checkBox_ZoomBarrita:
            controls.append('panzoombar')
        if checkBox_EscalaGrafica:
            controls.append('scaleline')

        # Comprobación plugins
        if checkBox_checkBox_SelectorCapas:
            headerImports = """
                            <link href="https://componentes.cnig.es/api-core/plugins/layerswitcher/layerswitcher-2.0.0.ol.min.css" rel="stylesheet" />
                            <script type="text/javascript" src="https://componentes.cnig.es/api-core/plugins/layerswitcher/layerswitcher-2.0.0.ol.min.js"></script>
            """
            stringplugin = """
                            const mp_selectorCapa = new M.plugin.Layerswitcher({
                                    position: 'TR',
                                    collapsed: false,
                                    collapsible: true,
                                    https: true,
                                    http: true,
                                    showCatalog: true,
                                    displayLabel: false,
                                    addLayers: true,
                                    statusLayers: true,
                                    modeSelectLayers: 'eyes', // opciones: 'eyes', 'radio'
                                    isMoveLayers: true,
                                    tools: ['transparency', 'legend', 'zoom', 'information', 'style', 'delete']
                                });

                            mapajs.addPlugin(mp_selectorCapa);
                           """
            pluginImports.append(headerImports)
            plugins.append(stringplugin)

        
        extentQGIS = iface.mapCanvas().extent()
        CRSQGIS = QgsProject.instance().crs()
        ct = QgsCoordinateTransform(CRSQGIS, QgsCoordinateReferenceSystem('EPSG:3857'), QgsProject.instance())
        bounds_crs = ct.transformBoundingBox(extentQGIS)
        bbox = [ bounds_crs.xMinimum() , bounds_crs.yMinimum() , bounds_crs.xMaximum() , bounds_crs.yMaximum() ]
        
        with open(fileJS, 'w') as filetowrite:
            filetowrite.write( self.CreateJS(bbox, layers, controls, plugins) )

        with open(fileCSS, 'w') as filetowrite:
            filetowrite.write( self.CreateCSS() )

        with open(fileMap, 'w') as filetowrite:
            filetowrite.write( self.CreateHTML(pluginImports, checkBox_ComparacionMapas) )

        webbrowser.open(fileMap,new=2)
        self.close ()
        return

    def JSONLayer2StringLayer(self, layer):

        def removeSpaces(txt):
            return '"'.join(it if i % 2 else ''.join(it.split())
                            for i, it in enumerate(txt.split('"')))
        
        def toLocalGeoJSON(layer, layerGJSON, APICNIGStyle):
            if type(APICNIGStyle) != list:
                stringLayer="""
                                var js_{name} = document.createElement("script");
                                js_{name}.type = "text/javascript";
                                js_{name}.async = false;
                                js_{name}.src = ".{sourceFolder}/{file}";
                                document.head.appendChild(js_{name});
                                js_{name}.addEventListener('load', () => {{
                                
                                    mapajs.addLayers(
                                        new M.layer.GeoJSON({{
                                                source: {source}, 
                                                name: '{name}',
                                                legend: "{name}",
                                                extract: true,
                                            }}, {{
                                            // aplica un estilo a la capa
                                                style: {APICNIGStyle},
                                                visibility: {visible} // capa no visible en el mapa
                                            }}, {{
                                                opacity: 1 // aplica opacidad a la capa
                                            }})
                                    );

                                    mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})

                                }});
                                """.format(
                                    sourceFolder = layer['sourceFolder'],
                                    file = layer['nameLegend'].replace(" ","").replace("—","_")+'.js',
                                    source = layer['nameLegend'].replace(" ","").replace("—","_"),
                                    name = layer['nameLegend'].replace(" ","").replace("—","_"),
                                    visible = str(layer['visible']).lower(),
                                    layerGJSON=layerGJSON,
                                    APICNIGStyle=APICNIGStyle,
                                    zindex = layer['zIndex'],
                                )
            
            else:
                stringLayer="""
                                var js_{name} = document.createElement("script");
                                js_{name}.type = "text/javascript";
                                js_{name}.async = false;
                                js_{name}.src = ".{sourceFolder}/{file}";
                                document.head.appendChild(js_{name});
                                js_{name}.addEventListener('load', () => {{
                                    
                                    {stylesList}

                                    mapajs.addLayers(
                                        new M.layer.GeoJSON({{
                                                source: {source}, 
                                                name: '{name}',
                                                legend: "{name}",
                                                extract: true,
                                            }}, {{
                                            // aplica un estilo a la capa
                                                style: {APICNIGStyle},
                                                visibility: {visible} // capa no visible en el mapa
                                            }}, {{
                                                opacity: 1 // aplica opacidad a la capa
                                            }})
                                    );

                                    mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})

                                }});
                                """.format(
                                    stylesList= APICNIGStyle[1],
                                    sourceFolder = layer['sourceFolder'],
                                    file = layer['nameLegend'].replace(" ","").replace("—","_")+'.js',
                                    source = layer['nameLegend'].replace(" ","").replace("—","_"),
                                    name = layer['nameLegend'].replace(" ","").replace("—","_"),
                                    visible = str(layer['visible']).lower(),
                                    layerGJSON=layerGJSON,
                                    APICNIGStyle=APICNIGStyle[0],
                                    zindex = layer['zIndex'],
                                )
            

            
            return stringLayer
        
        stringLayer = ''

        if layer['layerSourceType'] == 'XYZ':
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0]

            if urlURI:
                url = urlURI.split('=')[1]
                url = url.replace('%7B','{')
                url = url.replace('%7D','}')

            stringLayer="""
                                mapajs.addXYZ(
                                    new M.layer.XYZ({{
                                        url: '{url}',
                                        name: '{name}',
                                        visibility: {visible},
                                        legend: '{name}',
                                    }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    zindex = layer['zIndex'],

                                )

        elif layer['layerSourceType'] == 'TMS':
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0]

            if urlURI:
                url = urlURI.split('=')[1]
                url = url.replace('%7B','{')
                url = url.replace('%7D','}')

            stringLayer="""
                                mapajs.addTMS(
                                    new M.layer.TMS({{
                                        url: '{url}',
                                        name: '{name}',
                                        visibility: {visible},
                                        legend: '{name}',
                                    }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    zindex = layer['zIndex'],

                                )

        elif layer['layerSourceType'] == 'GeoTIFF':
            urlURI = layer['dataSourceUri']

            if urlURI:
                url = urlURI.replace("/vsicurl/","")

            stringLayer="""
                                mapajs.addLayers(
                                    new M.layer.GeoTIFF({{
                                        url: '{url}',
                                        name: '{name}',
                                        visibility: {visible},
                                        legend: '{name}',
                                    }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    zindex = layer['zIndex'],

                                )


        elif layer['layerSourceType'] == 'WMTS':
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0]
            formatURI = list(filter( lambda k: 'format=' in k, layer['dataSourceUri'].split('&') ))[0]
            layerURI = list(filter( lambda k: 'layers=' in k, layer['dataSourceUri'].split('&') ))[0]
            stylesURI = list(filter( lambda k: 'styles=' in k, layer['dataSourceUri'].split('&') ))[0]

            if urlURI:
                url = urlURI.split('=')[1]
            if formatURI:
                formatWMTS = formatURI.split('=')[1]
            if layerURI:
                layerWMTS = layerURI.split('=')[1]
            if stylesURI:
                styleWMTS = stylesURI.split('=')[1]

            stringLayer="""
                                mapajs.addWMTS(
                                    new M.layer.WMTS({{
                                        url: '{url}',
                                        name: "{layerWMTS}",
                                        legend: "{name}",
                                        matrixSet: 'GoogleMapsCompatible',
                                        visibility: {visible},
                                        }},
                                        {{
                                            format: '{formatWMTS}'
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    formatWMTS=formatWMTS,
                                    layerWMTS=layerWMTS,
                                    zindex = layer['zIndex'],
                                )

        elif layer['layerSourceType'] == 'WMS':
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0]
            formatURI = list(filter( lambda k: 'format=' in k, layer['dataSourceUri'].split('&') ))[0]
            layerURI = list(filter( lambda k: 'layers=' in k, layer['dataSourceUri'].split('&') ))[0]
            if 'styles=' in layer['dataSourceUri']:
                stylesURI = list(filter( lambda k: 'styles=' in k, layer['dataSourceUri'].split('&') ))[0]
            else:
                stylesURI = None

            if urlURI:
                url = urlURI.split('=')[1]
            if formatURI:
                formatWMS = formatURI.split('=')[1]
            if layerURI:
                layerWMS = layerURI.split('=')[1]
            if stylesURI:
                styleWMS = stylesURI.split('=')[1]

            stringLayer="""
                                mapajs.addWMS(
                                     new M.layer.WMS({{
                                            url: '{url}',
                                            name: "{layerWMS}",
                                            legend: "{name}",
                                            tiled: false,
                                            visibility: {visible},
                                        }}, 
                                        {{
                                            format: '{formatWMS}'
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    formatWMS=formatWMS,
                                    layerWMS=layerWMS,
                                    zindex = layer['zIndex'],
                                )
        
        elif layer['layerSourceType'] == 'OGC WFS (Web Feature Service)':

            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split(' ') ))[0]
            layerURI = list(filter( lambda k: 'typename=' in k, layer['dataSourceUri'].split(' ') ))[0]

            if urlURI:
                url = urlURI.split('=')[1]
            if layerURI:
                layerWFS = layerURI.split('=')[1]

            APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

            if type(APICNIGStyle) != list:
                stringLayer="""
                                mapajs.addWFS(
                                     new M.layer.WFS({{
                                            url: {url}, 
                                            name: {layerWFS},
                                            legend: "{name}",
                                            extract: true,
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerWFS=layerWFS,
                                    APICNIGStyle=APICNIGStyle,
                                    zindex = layer['zIndex'],
                                )
        
            else:
                stringLayer="""
                                {stylesList}

                                mapajs.addWFS(
                                     new M.layer.WFS({{
                                            url: {url}, 
                                            name: {layerWFS},
                                            legend: "{name}",
                                            extract: true,
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerWFS=layerWFS,
                                    stylesList= APICNIGStyle[1],
                                    APICNIGStyle=APICNIGStyle[0],
                                    zindex = layer['zIndex'],
                                )
        
        elif layer['layerSourceType'] == 'GeoJSON':

            if 'http' in layer['dataSourceUri']:
                urlURI = layer['dataSourceUri'].split('|')[0]
                layerURI = list(filter( lambda k: 'layername=' in k, layer['dataSourceUri'].split('|') ))[0]

                if urlURI:
                    url = urlURI.replace('/vsicurl/','')
                if layerURI:
                    layerGJSON = layerURI.split('=')[1]
                
                APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

                if type(APICNIGStyle) != list:
                    stringLayer="""

                                mapajs.addLayers(
                                     new M.layer.GeoJSON({{
                                            url: '{url}', 
                                            name: '{name}',
                                            legend: "{name}",
                                            extract: true,
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerGJSON=layerGJSON,
                                    APICNIGStyle=APICNIGStyle,
                                    zindex = layer['zIndex'],
                                    
                                )

                else:
                    stringLayer="""

                                {stylesList}

                                mapajs.addLayers(
                                     new M.layer.GeoJSON({{
                                            url: '{url}', 
                                            name: '{name}',
                                            legend: "{name}",
                                            extract: true,
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerGJSON=layerGJSON,
                                    stylesList= APICNIGStyle[1],
                                    APICNIGStyle=APICNIGStyle[0],
                                    zindex = layer['zIndex'],
                                )
            
            else:
                # Guardar la capa vectorial como geojson en local y hacerle el trapis para que pueda leerlo en local como objeto JS
                pathh = layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js'   
                options = []
                options.append("COORDINATE_PRECISION=" + str(6))
                e, err = QgsVectorFileWriter.writeAsVectorFormat(layer['QGISlayer'], 
                                                                 pathh + '_tmp',
                                                                 "utf-8", 
                                                                 QgsCoordinateReferenceSystem("EPSG:4326"), 
                                                                 'GeoJson',
                                                                 0, 
                                                                 layerOptions=options)
                if e == QgsVectorFileWriter.NoError:
                    with open(pathh, mode="w", encoding="utf8") as f:
                        f.write("var %s = " % (layer['nameLegend'].replace(" ","").replace("—","_")))
                        with open(pathh+ '_tmp', encoding="utf8") as tmpFile:
                            for line in tmpFile:
                                line = line.strip("\n\t ")
                                line = removeSpaces(line)
                                f.write(line)

                    os.remove(pathh + '_tmp')
                
                else:
                    QgsMessageLog.logMessage(
                        "Could not write json file {}: {}".format(layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js', err),
                        "qgis2APICNIG",
                        level=Qgis.Critical)
                    return
                
                if 'layername=' in layer['dataSourceUri']:
                    layerURI = list(filter( lambda k: 'layername=' in k, layer['dataSourceUri'].split('|') ))[0]
                else:
                    layerURI = False

                if layerURI:
                    layerGJSON = layerURI.split('=')[1]
                else:
                    layerGJSON=layer['nameLegend'].replace(" ","").replace("—","_")

                APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

                stringLayer = toLocalGeoJSON(layer, layerGJSON, APICNIGStyle)
                            
        elif layer['layerSourceType'] == 'Memory storage':
            # Guardar la capa vectorial como geojson en local y hacerle el trapis para que pueda leerlo en local como objeto JS
                pathh = layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js'
                options = []
                options.append("COORDINATE_PRECISION=" + str(6))
                e, err = QgsVectorFileWriter.writeAsVectorFormat(layer['QGISlayer'], 
                                                                 pathh + '_tmp',
                                                                 "utf-8", 
                                                                 QgsCoordinateReferenceSystem("EPSG:4326"), 
                                                                 'GeoJson',
                                                                 0, 
                                                                 layerOptions=options)
                if e == QgsVectorFileWriter.NoError:
                    with open(pathh, mode="w", encoding="utf8") as f:
                        f.write("var %s = " % (layer['nameLegend'].replace(" ","").replace("—","_")))
                        with open(pathh+ '_tmp', encoding="utf8") as tmpFile:
                            for line in tmpFile:
                                line = line.strip("\n\t ")
                                line = removeSpaces(line)
                                f.write(line)

                    os.remove(pathh + '_tmp')
                else:
                    QgsMessageLog.logMessage(
                        "Could not write json file {}: {}".format(layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js', err),
                        "qgis2APICNIG",
                        level=Qgis.Critical)
                    return
                
                APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])
                layerGJSON=layer['nameLegend'].replace(" ","").replace("—","_")
                stringLayer = toLocalGeoJSON(layer, layerGJSON, APICNIGStyle)

        elif layer['layerSourceType'] == 'OGC API - Features':
            
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split(' ') ))[0]
            layerURI = list(filter( lambda k: 'typename=' in k, layer['dataSourceUri'].split(' ') ))[0]

            if urlURI:
                url = urlURI.split('=')[1][:-1]+"collections/'"
            if layerURI:
                layerOGCAPI_Features = layerURI.split('=')[1]

            APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

            if type(APICNIGStyle) != list:
                stringLayer="""
                                mapajs.addOGCAPIFeatures(
                                     new M.layer.OGCAPIFeatures({{
                                            url: {url}, 
                                            name: {layerOGCAPI_Features},
                                            legend: "{name}",
                                            extract: true,
                                            limit: 100
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerOGCAPI_Features=layerOGCAPI_Features,
                                    APICNIGStyle=APICNIGStyle,
                                    zindex = layer['zIndex'],
            )
            else:
                stringLayer="""
                                {stylesList}

                                mapajs.addOGCAPIFeatures(
                                     new M.layer.OGCAPIFeatures({{
                                            url: {url}, 
                                            name: {layerOGCAPI_Features},
                                            legend: "{name}",
                                            extract: true,
                                            limit: 100
                                        }}, {{
                                        // aplica un estilo a la capa
                                            style: {APICNIGStyle},
                                            visibility: {visible} // capa no visible en el mapa
                                        }}, {{
                                            opacity: 1 // aplica opacidad a la capa
                                        }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    layerOGCAPI_Features=layerOGCAPI_Features,
                                    stylesList= APICNIGStyle[1],
                                    APICNIGStyle=APICNIGStyle[0],
                                    zindex = layer['zIndex'],
            )
            
        elif layer['layerSourceType'] == 'LIBKML':

            if 'http' in layer['dataSourceUri']:

                if 'http' in layer['dataSourceUri']:
                    urlURI = layer['dataSourceUri'].split('|')[0]
                    layerURI = list(filter( lambda k: 'layername=' in k, layer['dataSourceUri'].split('|') ))[0]

                    if urlURI:
                        url = urlURI.replace('/vsicurl/','')
                    if layerURI:
                        layerGJSON = layerURI.split('=')[1]

                    stringLayer="""
                                    mapajs.addKML(
                                        new M.layer.KML({{
                                                url: '{url}', 
                                                name: "{name}",
                                                legend: "{name}",
                                                // layers: "{layerGJSON}",
                                                extract: true,
                                            }}, {{
                                                visibility: {visible} // capa no visible en el mapa
                                            }}, {{
                                                opacity: 1 // aplica opacidad a la capa
                                            }})
                                    );

                                    mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                    """.format(
                                        url = url,
                                        name = layer['nameLegend'],
                                        visible = str(layer['visible']).lower(),
                                        layerGJSON=layerGJSON,
                                        zindex = layer['zIndex'],
                                    )
            
            else:
                # Guardar la capa vectorial como geojson en local y hacerle el trapis para que pueda leerlo en local como objeto JS
                pathh = layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js'
                options = []
                options.append("COORDINATE_PRECISION=" + str(6))
                e, err = QgsVectorFileWriter.writeAsVectorFormat(layer['QGISlayer'], 
                                                                 pathh + '_tmp',
                                                                 "utf-8", 
                                                                 QgsCoordinateReferenceSystem("EPSG:4326"), 
                                                                 'GeoJson',
                                                                 0, 
                                                                 layerOptions=options)
                if e == QgsVectorFileWriter.NoError:
                    with open(pathh, mode="w", encoding="utf8") as f:
                        f.write("var %s = " % ( layer['nameLegend'].replace(" ","").replace("—","_") ))
                        with open(pathh+ '_tmp', encoding="utf8") as tmpFile:
                            for line in tmpFile:
                                line = line.strip("\n\t ")
                                line = removeSpaces(line)
                                f.write(line)

                    os.remove(pathh + '_tmp')
                else:
                    QgsMessageLog.logMessage(
                        "Could not write json file {}: {}".format(layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js', err),
                        "qgis2APICNIG",
                        level=Qgis.Critical)
                    return
                
                if 'layername=' in layer['dataSourceUri']:
                    layerURI = list(filter( lambda k: 'layername=' in k, layer['dataSourceUri'].split('|') ))[0]
                else:
                    layerURI = False

                if layerURI:
                    layerGJSON = layerURI.split('=')[1]
                else:
                    layerGJSON=layer['nameLegend'].replace(" ","").replace("—","_")
                
                APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])
               
                stringLayer = toLocalGeoJSON(layer, layerGJSON, APICNIGStyle)
                
        elif layer['layerSourceType'] == 'MVT':
            # print(layer['dataSourceUri'])
            # print(layer['dataSourceUri'].split('&') )
            # print(list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0])
            urlURI = list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0]

            if urlURI:
                url = urlURI.split('=')[1]
                url = url.replace('%7B','{')
                url = url.replace('%7D','}')

            
            APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

            stringLayer="""
                                mapajs.addLayers(
                                    new M.layer.MVT({{
                                        url: '{url}',
                                        name: '{name}',
                                        extract: true,
                                        visibility: {visible},
                                        legend: "{name}",
                                    }},{{
                                        // aplica un estilo a la capa
                                        style: {APICNIGStyle},
                                    }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = url,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    APICNIGStyle=APICNIGStyle,
                                    zindex = layer['zIndex'],
                                    )

        elif layer['layerSourceType'] == 'MapLibre':
            # print(layer['dataSourceUri'])
            # print(layer['dataSourceUri'].split('&') )
            # print(list(filter( lambda k: 'url=' in k, layer['dataSourceUri'].split('&') ))[0])
            urlJSONURI = list(filter( lambda k: 'styleUrl=' in k, layer['dataSourceUri'].split('&') ))[0]

            jsonURL = urlJSONURI.split('=')[1]
            stringLayer="""
                                mapajs.addLayers(
                                    new M.layer.MapLibre({{
                                        url: '{url}',
                                        name: '{name}',
                                        extract: true,
                                        visibility: {visible},
                                        legend: "{name}",
                                    }})
                                );

                                mapajs.getLayers().filter( (layer) => layer.legend == "{name}" )[0].setZIndex({zindex})
                                """.format(
                                    url = jsonURL,
                                    name = layer['nameLegend'],
                                    visible = str(layer['visible']).lower(),
                                    zindex = layer['zIndex'],
                                )


        elif layer['QGISlayer'].type() == QgsMapLayer.VectorLayer:
            # Guardar la capa vectorial como geojson en local y hacerle el trapis para que pueda leerlo en local como objeto JS
                pathh = layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js'
                options = []
                options.append("COORDINATE_PRECISION=" + str(6))
                e, err = QgsVectorFileWriter.writeAsVectorFormat(layer['QGISlayer'], 
                                                                 pathh + '_tmp',
                                                                 "utf-8", 
                                                                 QgsCoordinateReferenceSystem("EPSG:4326"), 
                                                                 'GeoJson',
                                                                 0, 
                                                                 layerOptions=options)
                if e == QgsVectorFileWriter.NoError:
                    with open(pathh, mode="w", encoding="utf8") as f:
                        f.write("var %s = " % ( layer['nameLegend'].replace(" ","").replace("—","_") ))
                        with open(pathh+ '_tmp', encoding="utf8") as tmpFile:
                            for line in tmpFile:
                                line = line.strip("\n\t ")
                                line = removeSpaces(line)
                                f.write(line)

                    os.remove(pathh + '_tmp')
                else:
                    QgsMessageLog.logMessage(
                        "Could not write json file {}: {}".format(layer['exportFolderSources']+'/'+layer['nameLegend'].replace(" ","").replace("—","_")+'.js', err),
                        "qgis2APICNIG",
                        level=Qgis.Critical)
                    return
     
                layerGJSON=layer['nameLegend'].replace(" ","").replace("—","_")

                APICNIGStyle = self.QGISStyle2APICNIGStyle(layer['nameLegend'])

                stringLayer = toLocalGeoJSON(layer, layerGJSON, APICNIGStyle)

        return stringLayer

    def QGISStyle2APICNIGStyle(self, qgisLayerLegend):

        qgisLayer= QgsProject.instance().mapLayersByName(qgisLayerLegend)[0]

        typeStyle = qgisLayer.renderer().type()

        try:
            legendClassificationAttribute = qgisLayer.renderer().legendClassificationAttribute()
        except Exception as e:
            legendClassificationAttribute = "- - -"

        # Una capa puede tener más de une stilo, por lo que cuando en apicnig se permita un array de estilos, 
        # se podrá añadir cada estilo de qgis como un array desde un bucle.
        # De momento se coge el elemento 0
        
        try:
            propertiesStyle = qgisLayer.renderer().symbol().symbolLayer(0).properties()
        except Exception as e:
            propertiesStyle = "- - -"
        try:
            CategorizedSymbolStyle = qgisLayer.renderer().symbol().symbolLayer(0).properties()
        except Exception as e:
            propertiesStyle = "- - -"

        # print('_____________________________')
        # print('typeStyle  :',typeStyle)
        # print('legendClassificationAttribute  :',legendClassificationAttribute)
        # print('propertiesStyle :',propertiesStyle)
        # print('_____________________________')

        returnStyleDefault = True

        if typeStyle == 'singleSymbol':
            # print('/////////////')
            # print(typeStyle)
            # print(qgisLayer.renderer())
            # print('/////////////')

            
            if 'color' in propertiesStyle:
                fillColorRGBA_list= propertiesStyle['color'].split(',')
            else:
                fillColorRGBA_list= [255, 153, 0, 255/2]

            fillColorRGB = '''rgb({r}, {g}, {b})'''.format(
                r = int(fillColorRGBA_list[0]),
                g = int(fillColorRGBA_list[1]),
                b = int(fillColorRGBA_list[2]),
            )
            
            fillOpacity = int(fillColorRGBA_list[3]) / 255 

            if 'outline_color' in propertiesStyle:
                strokeColorRGBA_list= propertiesStyle['outline_color'].split(',')
            else:
                strokeColorRGBA_list= [255, 102, 0, 255]

            strokeColorRGB = '''rgb({r}, {g}, {b})'''.format(
                r = int(strokeColorRGBA_list[0]),
                g = int(strokeColorRGBA_list[1]),
                b = int(strokeColorRGBA_list[2]),
            )
            strokeOpacity = int(strokeColorRGBA_list[3]) / 255 

            if 'outline_color' in propertiesStyle:
                strokeWidth = float(propertiesStyle['outline_width'])
            else:
                strokeWidth = float(2)

            APICNIGStyle = '''new M.style.Generic({{
                                            point: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }},
                                            polygon: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }},
                                            line: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }}
                                        }})'''.format(
                                                fillColorRGB = fillColorRGB,
                                                fillOpacity=fillOpacity,
                                                strokeColorRGB=strokeColorRGB,
                                                strokeOpacity=strokeOpacity,
                                                strokeWidth =strokeWidth,
                                        )
            
            returnStyleDefault = False
        
        elif typeStyle == 'basic':
            # print('/////////////')
            # qgisLayer= QgsProject.instance().mapLayersByName('UA_VT')[0]
            # qgisLayer.renderer().styles()[0].symbol().symbolLayers()
            # print(qgisLayer.renderer())

            lineStyle = 'line:{}'
            polygonStyle = 'polygon:{}'
            pointStyle = 'point:{}'
            for style in qgisLayer.renderer().styles():
                # print(style.symbol())
                # print(style.symbol().type(), str(style.symbol().type()))
                # print(style.symbol().symbolLayer(0).properties())

                propertiesStyle = style.symbol().symbolLayer(0).properties()
                

                if 'color' in propertiesStyle:
                    fillColorRGBA_list= propertiesStyle['color'].split(',')
                else:
                    fillColorRGBA_list= [255, 153, 0, 255/2]

                fillColorRGB = '''rgb({r}, {g}, {b})'''.format(
                    r = int(fillColorRGBA_list[0]),
                    g = int(fillColorRGBA_list[1]),
                    b = int(fillColorRGBA_list[2]),
                )
                
                fillOpacity = int(fillColorRGBA_list[3]) / 255 

                if 'outline_color' in propertiesStyle:
                    strokeColorRGBA_list= propertiesStyle['outline_color'].split(',')
                else:
                    strokeColorRGBA_list= [255, 102, 0, 255]

                strokeColorRGB = '''rgb({r}, {g}, {b})'''.format(
                    r = int(strokeColorRGBA_list[0]),
                    g = int(strokeColorRGBA_list[1]),
                    b = int(strokeColorRGBA_list[2]),
                )
                strokeOpacity = int(strokeColorRGBA_list[3]) / 255 

                if 'outline_color' in propertiesStyle:
                    strokeWidth = float(propertiesStyle['outline_width'])
                else:
                    strokeWidth = float(2)

                if str(style.symbol().type()) == 'SymbolType.Fill':
                    polygonStyle = '''
                        polygon: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }}
                    '''.format(
                                    fillColorRGB = fillColorRGB,
                                    fillOpacity=fillOpacity,
                                    strokeColorRGB=strokeColorRGB,
                                    strokeOpacity=strokeOpacity,
                                    strokeWidth =strokeWidth,
                            )
                    returnStyleDefault = False
                
                elif str(style.symbol().type()) == 'SymbolType.Line':
                    lineStyle = '''
                        line: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }}
                    '''.format(
                                    fillColorRGB = fillColorRGB,
                                    fillOpacity=fillOpacity,
                                    strokeColorRGB=strokeColorRGB,
                                    strokeOpacity=strokeOpacity,
                                    strokeWidth =strokeWidth,
                            )
                    returnStyleDefault = False
                
                elif str(style.symbol().type()) == 'SymbolType.Marker':
                    pointStyle = '''
                        point: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }}
                    '''.format(
                                    fillColorRGB = fillColorRGB,
                                    fillOpacity=fillOpacity,
                                    strokeColorRGB=strokeColorRGB,
                                    strokeOpacity=strokeOpacity,
                                    strokeWidth =strokeWidth,
                            )
                    returnStyleDefault = False
                
                else:
                    continue
           
            APICNIGStyle = '''new M.style.Generic({{
                                        {point},
                                        {polygon},
                                        {line}
                            }})'''.format(
                                    point = pointStyle,
                                    polygon = polygonStyle,
                                    line = lineStyle
                            )
                      
           
            # print('/////////////')

        elif typeStyle == 'categorizedSymbol':
            print('/////////////')
            APICNIGStyleCategoric = ""
            categoricList = {}
            i = 0
            for categoria in qgisLayer.renderer().categories():
                i += 1
                valueAtribute = categoria.value()
                propertiesStyle = categoria.symbol().symbolLayer(0).properties()
                print(valueAtribute , '///', propertiesStyle)

                if 'color' in propertiesStyle:
                    fillColorRGBA_list= propertiesStyle['color'].split(',')
                elif 'line_color' in propertiesStyle:
                    fillColorRGBA_list= propertiesStyle['line_color'].split(',')
                else:
                    fillColorRGBA_list= [255, 153, 0, 255/2]

                fillColorRGB = '''rgb({r}, {g}, {b})'''.format(
                    r = int(fillColorRGBA_list[0]),
                    g = int(fillColorRGBA_list[1]),
                    b = int(fillColorRGBA_list[2]),
                )
                
                fillOpacity = int(fillColorRGBA_list[3]) / 255 

                if 'outline_color' in propertiesStyle:
                    strokeColorRGBA_list= propertiesStyle['outline_color'].split(',')
                elif 'line_color' in propertiesStyle:
                    strokeColorRGBA_list= propertiesStyle['line_color'].split(',')
                else:
                    strokeColorRGBA_list= [255, 102, 0, 255]

                strokeColorRGB = '''rgb({r}, {g}, {b})'''.format(
                    r = int(strokeColorRGBA_list[0]),
                    g = int(strokeColorRGBA_list[1]),
                    b = int(strokeColorRGBA_list[2]),
                )
                strokeOpacity = int(strokeColorRGBA_list[3]) / 255 

                if 'outline_color' in propertiesStyle:
                    strokeWidth = float(propertiesStyle['outline_width'])
                else:
                    strokeWidth = float(2)
                

                categoricList[valueAtribute] = "__{}_{}__".format(legendClassificationAttribute,i)
                APICNIGStyle_category = ''' 
                                        var {legendClassificationAttribute}_{i} = new M.style.Generic({{
                                            point: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }},
                                            polygon: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }},
                                            line: {{
                                                fill: {{
                                                    color: '{fillColorRGB}',
                                                    opacity: {fillOpacity},
                                                }},
                                                stroke: {{
                                                    color: '{strokeColorRGB}',
                                                    opacity: {strokeOpacity},
                                                    width: {strokeWidth}, 
                                                }}
                                            }}
                                        }}) \n'''.format(
                                                legendClassificationAttribute=legendClassificationAttribute,
                                                i=i,
                                                fillColorRGB = fillColorRGB,
                                                fillOpacity=fillOpacity,
                                                strokeColorRGB=strokeColorRGB,
                                                strokeOpacity=strokeOpacity,
                                                strokeWidth =strokeWidth,
                                        )

                APICNIGStyleCategoric += APICNIGStyle_category

            APICNIGStyle = """new M.style.Category("{name}", {list})""".format(name=legendClassificationAttribute, list=categoricList)
            APICNIGStyle = APICNIGStyle.replace("'__","").replace("__'","")
            APICNIGStyle = [APICNIGStyle, APICNIGStyleCategoric]
            returnStyleDefault = False
            print('/////////////')

        else:
            returnStyleDefault = True

        if returnStyleDefault:
            APICNIGStyle = '''new M.style.Generic({{
                                point: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }},
                                polygon: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }},
                                line: {{
                                    fill: {{
                                        color: '{fillColorRGB}',
                                        opacity: {fillOpacity},
                                    }},
                                    stroke: {{
                                        color: '{strokeColorRGB}',
                                        opacity: {strokeOpacity},
                                        width: {strokeWidth}, 
                                    }}
                                }}
                            }})'''.format(
                                    fillColorRGB = 'orange',
                                    fillOpacity=0.6,
                                    strokeColorRGB='red',
                                    strokeOpacity=0.8,
                                    strokeWidth = 2,
                            )
        

        return APICNIGStyle

    def CreateHTML(self, headerImports, checkBox_ComparacionMapas):

        headerImportsString = ''
        for l in headerImports:
            headerImportsString = headerImportsString + l

        body="""
        <!-- Contenedor principal del mapa -->
        <div id="mapaJS_div" class="m-container"></div>

        <!-- Importación de JS del visualizador-->
        <script type="text/javascript" src="./JS/QGIS2APICNIG.js"></script>
        """
        CSS_MapasComparacion = ''
        JS_MapasComparacion = ''
        if checkBox_ComparacionMapas:
            CSS_MapasComparacion = """
            <!-- extensiones OL - viglino -->
            <link type="text/css" rel="stylesheet" href="./pluginQGIS2APICNIG/viglino/CSS/ol-ext.css">
            <link type="text/css" rel="stylesheet" href="./pluginQGIS2APICNIG/viglino/CSS/font-gis.css">
            <script type="text/javascript" src="./pluginQGIS2APICNIG/viglino/JS/ol-ext.js"></script>

            <!-- extensiones propias de QGIS2APICNIG (CSS) -->
            <link type="text/css" rel="stylesheet" href="./pluginQGIS2APICNIG/comparadorMapas/CSS/comparadorMapas.css">
            """

            JS_MapasComparacion = """
            <!-- Importación de JS del visualizador-->
            <script type="text/javascript" src="./pluginQGIS2APICNIG/comparadorMapas/JS/comparadorMapas.js"></script>
            """

            body="""
            <!-- The Modal -->
            <div id="myModal" class="modal">

                <!-- Modal content -->
                <div class="modal-content">
                    <span class="close">&times;</span>
                    <h3>Configuración de comparación</h3>

                    <table id="tablaModal">
                        <tr>
                            <th>Botón</th>
                            <th>Información</th>
                        </tr>
                        <tr>
                            <td><i class="fg-map-add"></i></td>
                            <td>Al hacer clic, abre una ventana modal para crear una nueva vista al visualizador</td>
                        </tr>
                        <tr>
                            <td><i class="fg-map-o"></i></td>
                            <td>
                                Al hacer clic, visualiza el mapa seleccionado
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fg-screen-dub-o"></i></td>
                            <td>
                                Permite la comparación en espejo.
                                Se divide el visualizador en dos partes donde se puede comparar de forma síncrona dos mapas
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fg-screen-split-h"></i></td>
                            <td>
                                Permite al comparación en cortina horizontal.
                                Se divide el visualizador superponiendo los dos mapas entre si, pudiendo ver la misma extensión
                                en los dos mapas
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fg-screen-split-v"></i></td>
                            <td>
                                Permite al comparación en cortina vertical.
                                Se divide el visualizador superponiendo los dos mapas entre si, pudiendo ver la misma extensión
                                en los dos mapas
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fg-screen-mag"></i></td>
                            <td>
                                Permite la comparación zonal.
                                Habilita un círculo que permite comparar los dos mapas según se mueve el ratón.
                            </td>
                        </tr>
                        <tr>
                            <td><i class="fg-map-options-alt"></i></td>
                            <td>
                                Permite configurar los mapas a visualizar en cada sección de comparación.
                            </td>
                        </tr>
                    </table>
                </div>

            </div>

            <!-- The Sidenav -->
            <div id="mySidenav" class="sidenav">

                <div class="grid-container">
                    <h3 style="padding-left: 10px;">Configuración comparación</h3>
                    <a href="javascript:void(0)" class="closebtn">&times;</a>
                </div>


                <table id="tablaConfig">
                    <tr>
                        <th>Botón</th>
                        <th>Configuración</th>
                    </tr>
                    <tr id="table_view1" class="activeTable">
                        <td><i class="fg-map-o"></i></td>
                        <td>
                            <div class="grid-container">
                                <p>Mapa:</p>
                                <select id="selectorMapasUnico" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr id="table_compare">
                        <td><i class="fg-screen-dub-o"></i></td>
                        <td>
                            <div class="grid-container">
                                <p>Mapa derecho:</p>
                                <select id="selectorMapasEspejoDer" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                                <p>Mapa izquierdo:</p>
                                <select id="selectorMapasEspejoIzq" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr id="table_swipev">
                        <td><i class="fg-screen-split-h"></i></td>
                        <td>
                            <div class="grid-container">
                                <p>Mapa derecho:</p>
                                <select id="selectorMapasHCortinillaDer" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                                <p>Mapa izquierdo:</p>
                                <select id="selectorMapasHCortinillaIzq" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr id="table_swipeh">
                        <td><i class="fg-screen-split-v"></i></td>
                        <td>
                            <div class="grid-container">
                                <p>Mapa arriba:</p>
                                <select id="selectorMapasVCortinillaIzq" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                                <p>Mapa abajo:</p>
                                <select id="selectorMapasVCortninillaDer" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                            </div>
                        </td>
                    </tr>
                    <tr id="table_clip">
                        <td><i class="fg-screen-mag"></i></td>
                        <td>
                            <div class="grid-container">
                                <p>Mapa fondo:</p>
                                <select id="selectorMapasCirculoFondo" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                                <p>Mapa círculo:</p>
                                <select id="selectorMapasCirculoCir" class="selectorMapasClase" name="Selector de mapa">

                                </select>
                            </div>
                        </td>
                    </tr>
                </table>

                <div class="grid-container">
                    <p></p>
                    <button id="idAceptar" class="aceptar">aceptar</button>
                </div>
            </div>



            <!-- div comparación -->
            <div class="tools">
                <i id="addMap" class="fg-map-add" onclick="setMode('addMap')" title="Añadir mapa"></i>
                <i id="view1" class="fg-map-o activeSVG" onclick="setMode('view1')" title="Mapa único"></i>
                <i id="compare" class="fg-screen-dub-o" onclick="setMode('compare')" title="Compare"></i>
                <i id="swipev" class="fg-screen-split-h" onclick="setMode('swipev')" title="Swipe V"></i>
                <i id="swipeh" class="fg-screen-split-v" onclick="setMode('swipeh')" title="Swipe V"></i>
                <i id="clip" class="fg-screen-mag" onclick="setMode('clip')" title="Clip"></i>
                <i id="settings" class="fg-map-options-alt" onclick="setMode('settings')" title="configuración"></i>
                <i id="info" class="fg-poi-info-o" onclick="setMode('info')" title="info"></i>
            </div>

            <!-- Contenedor principal del mapa -->
            <div id="compareMaps">

                <div id="mapaJS_div" class="m-container m-mapea-container compareMaps" 
                    style="z-index: 1;"
                    >
                </div>
                <div id="mapaJS_div_2" class="m-container m-mapea-container compareMaps" 
                    style="z-index: 0;"
                    >
                </div>
                <div id="mapaJS_div_n" class="m-container m-mapea-container compareMaps" 
                    style="z-index: -1;"
                    >
                </div>

            </div>

            <!-- Importación de JS del visualizador-->
            <script type="text/javascript" src="./JS/QGIS2APICNIG.js"></script>
            """


        html = """<!DOCTYPE html>
                    <html>
                        <head>
                            <meta charset="UTF-8">
                            <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
                            <meta http-equiv="X-UA-Compatible" content="IE=edge" />
                            <meta name="cnig" content="yes">
                            <title>Visualizador API-CNIG</title>
                            
                            <!--          -->
                            <!-- API-CNIG -->
                            <!--          -->

                            <!-- CSS API-CNIG -->
                            <link type="text/css" rel="stylesheet" href="https://componentes.cnig.es/api-core/assets/css/apiign-5.0.0.ol.min.css">
                            
                            <!-- JS API-CNIG  -->
                            <script type="text/javascript" src="https://componentes.cnig.es/api-core/vendor/browser-polyfill.js"></script>
                            <script type="text/javascript" src="https://componentes.cnig.es/api-core/js/apiign-5.0.0.ol.min.js"></script>
                            <script type="text/javascript" src="https://componentes.cnig.es/api-core/js/configuration-5.0.0.js"></script>

                            <!-- extensiones API-CNIG -->
                            {headerImports}

                            {CSS_MapasComparacion}


                            <!-- Estilo personalizado del HTML-->
                            <link type="text/css" rel="stylesheet" href="./CSS/QGIS2APICNIG.css">
                            
                        </head>
                        
                        <body>
                            {body}

                            {JS_MapasComparacion}

                        </body>
                    </html>""".format(
                                    headerImports=headerImportsString,
                                    CSS_MapasComparacion=CSS_MapasComparacion,
                                    JS_MapasComparacion=JS_MapasComparacion,
                                    body=body
                                )
        return html

    def CreateJS(self, bbox, layers, controls, plugins):

        layersString = ''
        for l in layers:
            layersString = layersString + l

        pluginString = ''
        for l in plugins:
            pluginString = pluginString + l
        
        JS = """
                                
            // Configuración del mapa
            let zoomInicial = 5
            let longLatInicial = [-3, 40]
            const zoom_p = M.config.MAP_VIEWER_ZOOM || zoomInicial;
            const center_p = M.config.MAP_VIEWER_CENTER || ol.proj.fromLonLat(longLatInicial);
            
            M.proxy(false) // Necesario para ejecutar el visualizador en local.
            const mapajs = M.map({{
                container: 'mapaJS_div',
                controls: {controls},
                bbox: {bbox}
            }});
            
            const layers_p = M.config.MAP_VIEWER_LAYERS || [];
            mapajs.addLayers(layers_p)

            {layers}

            {plugins}
                                        
        """.format(
                    bbox = bbox,
                    controls=controls,
                    layers = layersString,
                    plugins = pluginString                
                    )
        return JS
    
    def CreateCSS(self):

        CSS = """
                html,
                body {
                    margin: 0;
                    padding: 0;
                    height: 100%;
                    overflow: hidden;
                }

                .m-panel button, 
                .m-panel.m-plugin-layerswitcher.opened button.m-panel-btn, 
                .m-areas>div.m-area>div.m-panel.collapsed>button.m-panel-btn,
                .ol-zoomslider>button.ol-zoomslider-thumb,
                .m-areas>div.m-area>div.m-panel.no-collapsible>div.m-panel-controls>div.m-control.m-container.m-background>button,
                .m-scale-container {
                    background-color: orange !important;
                }

                .m-areas>div.m-area>div.m-panel.no-collapsible>div.m-panel-controls>div.m-control.m-container.m-background>button.m-background-group-btn.activeBaseLayerButton{
                    background-color: #cd7d00 !important;
                }

                .ol-scale-line .ol-scale-line-inner {
                    border-color: orange;
                    color: orange;
                    font-weight: 700;
                }

                .ol-scale-line.ol-unselectable {
                    background: white !important;
                }
  

                .m-panel section button {
                    background-color: transparent !important;
                }
        """
        return CSS