# -*- coding: utf-8 -*-
"""
/***************************************************************************
 Stereonet
                                 A QGIS plugin
 Displays a geologic stereonet of selected data
                             -------------------
        begin               : 2016-11-29
        copyright           : (C) 2016 by Daniel Childs
        email               : daniel@childsgeo.com
        git sha             : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 *                                                                          *
 *   This program is free software; you can redistribute it and/or modify   *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or      *
 *   (at your option) any later version.                                    *
 *                                                                          *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

from PyQt5.QtGui import *
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
import numpy as np
import matplotlib.pyplot as plt
from matplotlib import cm
from .mplstereonet import *
from qgis.core import *
from qgis.gui import *
import os

def classFactory(iface):
    return Stereonet(iface)

class Stereonet:
    def __init__(self, iface):
        self.iface = iface

    def initGui(self):
        dir_path = os.path.dirname(os.path.realpath(__file__))
        self.contourAction = QAction(QIcon(str(dir_path)+"/icon.png"), u'Stereonet', self.iface.mainWindow())
        self.contourAction.triggered.connect(self.contourPlot)
        self.iface.addToolBarIcon(self.contourAction)

    def unload(self):
        self.iface.removeToolBarIcon(self.contourAction)
        del self.contourAction
    def contourPlot(self):
        strikes = list()
        dips = list()
 #       layers = self.iface.legendInterface().layers()
        layers = list(QgsProject.instance().mapLayers().values())
        for layer in layers:
            if layer.type() == QgsMapLayer.VectorLayer:
                iter = layer.selectedFeatures()
                strikeExists = layer.fields().lookupField('strike')
                ddrExists = layer.fields().lookupField('ddr')
                dipExists = layer.fields().lookupField('dip')
                for feature in iter:
                    if strikeExists != -1 and dipExists != -1:
                        strikes.append(feature['strike'])
                        dips.append(feature['dip'])
                    elif ddrExists != -1 and dipExists != -1:
                        strikes.append(feature['ddr']-90)
                        dips.append(feature['dip'])
            else:
                continue
        if len(strikes) != 0:
            fig, ax = mplstereonet.subplots()
            ax.density_contourf(strikes, dips, measurement='poles',cmap=cm.coolwarm,method='schmidt')
            ax.pole(strikes, dips, 'k+', markersize=7)
            ax.set_azimuth_ticks([0,30,60,90,120,150,180,210,240,270,300,330])
            ax.set_azimuth_ticklabels(['180\u00b0','210\u00b0','240\u00b0','270\u00b0','300\u00b0','330\u00b0','0\u00b0','30\u00b0','60\u00b0','90\u00b0','120\u00b0','150\u00b0'])
            ax.grid(kind='polar')
            plt.show()