# -*- coding: utf-8 -*-
"""
/***************************************************************************
 SmartSDI
                                 A QGIS plugin
 Description
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2023-07-19
        git sha              : $Format:%H$
        copyright            : (C) 2023 by Geo-System
        email                : geo-system@geo-system.com.pl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
from qgis.PyQt.QtCore import QSettings, QTranslator, QCoreApplication, QUrl, QByteArray
from qgis.PyQt.QtGui import QIcon
from qgis.PyQt.QtWidgets import QAction
from qgis.PyQt.QtNetwork import QNetworkRequest

from qgis.core import QgsProject, QgsMessageLog, Qgis, QgsNetworkAccessManager, QgsVectorLayer, QgsWkbTypes, QgsProcessingParameterFileDestination, QgsMapLayerProxyModel
from qgis.gui import QgsMessageBar

# Initialize Qt resources from file resources.py
from .resources import *
# Import the code for the dialog
from .smartsdi_dialog import SmartSDIDialog
import os.path
import tempfile
import csv


class SmartSDI:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        """Constructor.

        :param iface: An interface instance that will be passed to this class
            which provides the hook by which you can manipulate the QGIS
            application at run time.
        :type iface: QgsInterface
        """
        # Save reference to the QGIS interface
        self.iface = iface
        # initialize plugin directory
        self.plugin_dir = os.path.dirname(__file__)
        # initialize locale
        locale = QSettings().value('locale/userLocale')[0:2]
        self.token = QSettings().value('smartsdi/token') or ''
        locale_path = os.path.join(
            self.plugin_dir,
            'i18n',
            'SmartSDI_{}.qm'.format(locale))

        if os.path.exists(locale_path):
            self.translator = QTranslator()
            self.translator.load(locale_path)
            QCoreApplication.installTranslator(self.translator)

        # Declare instance attributes
        self.actions = []
        self.menu = self.tr(u'&SmartSDI')

        # Check if plugin was started the first time in current QGIS session
        # Must be set in initGui() to survive plugin reloads
        self.first_start = None

    # noinspection PyMethodMayBeStatic
    def tr(self, message):
        """Get the translation for a string using Qt translation API.

        We implement this ourselves since we do not inherit QObject.

        :param message: String for translation.
        :type message: str, QString

        :returns: Translated version of message.
        :rtype: QString
        """
        # noinspection PyTypeChecker,PyArgumentList,PyCallByClass
        return QCoreApplication.translate('SmartSDI', message)

    def add_action(
        self,
        icon_path,
        text,
        callback,
        enabled_flag=True,
        add_to_menu=True,
        add_to_toolbar=True,
        status_tip=None,
        whats_this=None,
        parent=None):
        """Add a toolbar icon to the toolbar.

        :param icon_path: Path to the icon for this action. Can be a resource
            path (e.g. ':/plugins/foo/bar.png') or a normal file system path.
        :type icon_path: str

        :param text: Text that should be shown in menu items for this action.
        :type text: str

        :param callback: Function to be called when the action is triggered.
        :type callback: function

        :param enabled_flag: A flag indicating if the action should be enabled
            by default. Defaults to True.
        :type enabled_flag: bool

        :param add_to_menu: Flag indicating whether the action should also
            be added to the menu. Defaults to True.
        :type add_to_menu: bool

        :param add_to_toolbar: Flag indicating whether the action should also
            be added to the toolbar. Defaults to True.
        :type add_to_toolbar: bool

        :param status_tip: Optional text to show in a popup when mouse pointer
            hovers over the action.
        :type status_tip: str

        :param parent: Parent widget for the new action. Defaults None.
        :type parent: QWidget

        :param whats_this: Optional text to show in the status bar when the
            mouse pointer hovers over the action.

        :returns: The action that was created. Note that the action is also
            added to self.actions list.
        :rtype: QAction
        """

        icon = QIcon(icon_path)
        action = QAction(icon, text, parent)
        action.triggered.connect(callback)
        action.setEnabled(enabled_flag)

        if status_tip is not None:
            action.setStatusTip(status_tip)

        if whats_this is not None:
            action.setWhatsThis(whats_this)

        if add_to_toolbar:
            # Adds plugin icon to Plugins toolbar
            self.iface.addToolBarIcon(action)

        if add_to_menu:
            self.iface.addPluginToMenu(
                self.menu,
                action)

        self.actions.append(action)

        return action

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""

        icon_path = self.plugin_dir +'/icon.png'
        self.add_action(
            icon_path,
            text=self.tr(u'Znajdź i pobierz dane'),
            callback=self.run,
            parent=self.iface.mainWindow())

        # will be set False in run()
        self.first_start = True

    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        for action in self.actions:
            self.iface.removePluginMenu(
                self.tr(u'&SmartSDI'),
                action)
            self.iface.removeToolBarIcon(action)
    
    def bbox(self):
        """Sets the BBOX and SRS fields from the current map extent"""
        
        bbox=self.iface.mapCanvas().extent()
        epsg=self.iface.mapCanvas().mapSettings().destinationCrs().authid()
        self.dlg.BBtop.setText(str(bbox.yMaximum()))
        self.dlg.BBbottom.setText(str(bbox.yMinimum()))
        self.dlg.BBright.setText(str(bbox.xMaximum()))
        self.dlg.BBleft.setText(str(bbox.xMinimum()))
        self.dlg.BBepsg.setText(epsg)
        
    def save_token(self):
        self.token=self.dlg.tokenEdit.text()
        QSettings().setValue('smartsdi/token', self.token)

 
    def read_data_from_file(self,file):
        """
        Reads key-label pairs from a CSV file.
        """
        filepath = self.plugin_dir+"/"+file+".list"
        data = {}
        try:
            with open(filepath, 'r', encoding='utf-8') as f:
                reader = csv.DictReader(f, fieldnames=['key','value'])
                for row in reader:
                    data[row['key']]=row['value']
        except FileNotFoundError:
            QgsMessageLog.logMessage(f"Nie znaleziono pliku {filepath}", 'SmartSDI', Qgis.Critical)
        except Exception as e:
            QgsMessageLog.logMessage(f"Bład czytania pliku {e}", 'SmartSDI', Qgis.Critical)
        return data
        
    def populate_combobox_woj(self):
            if(not self.woj): woj = self.read_data_from_file("woj")
            self.dlg.comboBoxWoj.addItem('wybierz')
            for key, value in woj.items():
                display_text = f"{value} ({key})"
                self.dlg.comboBoxWoj.addItem(display_text, key)
                
    def populate_combobox_pow(self):
            idx=self.dlg.comboBoxWoj.currentIndex()
            ter2 = self.dlg.comboBoxWoj.itemData(idx)
            self.dlg.comboBoxPow.clear()
            if(not self.pow): pow = self.read_data_from_file("pow")
            if(not self.sa_grupy): self.sa_grupy = self.read_data_from_file("sa_grupy")
            if(not self.sa_uzytki): self.sa_uzytki = self.read_data_from_file("sa_uzytki")
            self.dlg.comboBoxPow.addItem('wybierz')
            for key, value in pow.items():
                if(ter2 and key.startswith(ter2)):
                    display_text = f"{value} ({key})"
                    self.dlg.comboBoxPow.addItem(display_text, key)
                    
    def populate_combobox_gmi(self):
            idx=self.dlg.comboBoxPow.currentIndex()
            ter4 = self.dlg.comboBoxPow.itemData(idx)
            self.dlg.comboBoxGmi.clear()
            
            if(ter4 in self.sa_grupy): self.dlg.comboBoxGr.setEnabled(1)
            else:
                self.dlg.comboBoxGr.setEnabled(0)
                self.dlg.comboBoxGr.setCurrentIndex(0)
            
            if(ter4 in self.sa_uzytki): self.dlg.comboBoxKl.setEnabled(1)
            else:
                self.dlg.comboBoxKl.setEnabled(0)
                self.dlg.comboBoxKl.setCurrentIndex(0)
            
            if(not self.gmi): gmi = self.read_data_from_file("gmi")
            self.dlg.comboBoxGmi.addItem('wybierz')
            for key, value in gmi.items():
                if(ter4 and key.startswith(ter4)):
                    display_text = f"{value} ({key})"
                    self.dlg.comboBoxGmi.addItem(display_text, key)
                    
    def populate_combobox_obr(self):
            idx=self.dlg.comboBoxGmi.currentIndex()
            ter = self.dlg.comboBoxGmi.itemData(idx)
            if(ter):
                if(int(ter[2])>=6):
                    ter=ter[0:4]
                else:
                    ter=ter[0:6]
            self.dlg.comboBoxObr.clear()
            if(not self.obr): obr = self.read_data_from_file("obr")
            self.dlg.comboBoxObr.addItem('wybierz')
            for key, value in obr.items():
                if(ter and key.startswith(ter)):
                    display_text = f"{value} ({key})"
                    self.dlg.comboBoxObr.addItem(display_text, key)
                    
    def populate_combobox_adv(self):
            if(not self.gr): gr = self.read_data_from_file("gr")
            self.dlg.comboBoxGr.addItem('wybierz grupę rejestrową')
            for key, value in gr.items():
                display_text = f"{value} ({key})"
                self.dlg.comboBoxGr.addItem(display_text, key)
            if(not self.kl): kl = self.read_data_from_file("kl")
            self.dlg.comboBoxKl.addItem('wybierz klasoużytek')
            for key, value in kl.items():
                display_text = f"{value} ({key})"
                self.dlg.comboBoxKl.addItem(display_text, key)

    def load(self,path,layer,srid=2180):
        """Loads the downloaded data as a new layer"""
        
        self.download_count+=1
        name='SmartSDI '+layer+str(self.download_count)
        vlayer = QgsVectorLayer(path, "SmartSDI "+layer,  "ogr")
        if not vlayer.isValid():
            QgsMessageLog.logMessage('Błąd wczytywania warstwy '+layer, 'SmartSDI', Qgis.Warning)
        elif vlayer.featureCount()==0:
            self.iface.messageBar().pushMessage("Uwaga", "Brak wyników", level=Qgis.Warning)
            QgsMessageLog.logMessage('Brak wyników '+layer, 'SmartSDI', Qgis.Warning)
        else:
            QgsProject.instance().addMapLayer(vlayer)
            #load the associated style
            style=os.path.join(self.plugin_dir,layer+'.qml')
            vlayer.loadNamedStyle(style)
            
            crs = vlayer.crs()
            crs.createFromId(srid)
            vlayer.setCrs(crs,True)
            
            canvas = self.iface.mapCanvas()
            extent = vlayer.extent()
            canvas.setExtent(extent)
            canvas.refresh()
            
            # Show Feature Count
            root = QgsProject.instance().layerTreeRoot()
            newLayerNode = root.findLayer(vlayer.id())
            newLayerNode.setCustomProperty("showFeatureCount", True)
            
            QgsMessageLog.logMessage('Wczytano warstwę '+name, 'SmartSDI', Qgis.Success)
            
    def szukaj(self):
        idx = self.dlg.comboBoxGmi.currentIndex()
        gmina = self.dlg.comboBoxGmi.itemData(idx)
        idx = self.dlg.comboBoxObr.currentIndex()
        obreb = self.dlg.comboBoxObr.itemData(idx)
        dzialka = self.dlg.lineEditDz.text()
        idx = self.dlg.comboBoxGr.currentIndex()
        grupa = self.dlg.comboBoxGr.itemData(idx)
        idx = self.dlg.comboBoxKl.currentIndex()
        klasa = self.dlg.comboBoxKl.itemData(idx)
        params={}
        adv = 0;

        if(obreb and dzialka):
            params['teryt']=obreb
            params['dzialka']=dzialka
        elif(obreb):
            params['teryt']=obreb
        elif(gmina and dzialka):
            params['teryt']=gmina
            params['dzialka']=dzialka
        elif(gmina):
            params['teryt']=gmina
        if(self.dlg.groupBoxPow.isChecked()):
            adv = 1
            pow_od = self.dlg.spinBoxPowOd.value()
            pow_do = self.dlg.spinBoxPowDo.value()
            params['pow_od']=str(pow_od)
            params['pow_do']=str(pow_do)
            if(self.dlg.checkBoxShape.isChecked()):
               foremnosc = self.dlg.horizontalSliderShape.value()
               params['foremnosc']=str(foremnosc)               
        if(self.dlg.groupBoxZab.isChecked()):
            adv = 1
            if(self.dlg.radioButtonZab.isChecked()):
                params['zabudowa']='1'
                pow_zab_od = self.dlg.spinBoxPowZabOd.value()
                pow_zab_do = self.dlg.spinBoxPowZabDo.value()
                params['pow_zab_od']=str(pow_zab_od)
                params['pow_zab_do']=str(pow_zab_do)
            else:
                params['zabudowa']='-1'
                odl_zab = self.dlg.spinBoxOdlZab.value()
                params['odl_zab']=str(odl_zab)
        if(grupa): params['grupa']=grupa
        if(klasa): params['klasa']=klasa
        if('teryt' in params):
            if(dzialka or grupa or klasa or adv):
                url='https://smartsdi.pl/qgis/search.php?request=dzialka&token='+self.token
                for p in params: url+='&'+p+'='+params[p]
                #QgsMessageLog.logMessage(url, 'SmartSDI', Qgis.Success)
                self.searchRequest(url)
            else:
                self.iface.messageBar().pushMessage("Uwaga", "Wpisz numer działki lub ustaw zaawansowane parametry szukania", level=Qgis.Warning)
        else:
            self.iface.messageBar().pushMessage("Uwaga", "Wybierz gminę", level=Qgis.Warning)
        
    def searchRequest(self,url):
        workingUrl = QUrl(url)
        request = QNetworkRequest(workingUrl)
        networkAccessManager = QgsNetworkAccessManager()
        response = networkAccessManager.blockingGet(request)
        status_code = response.attribute(QNetworkRequest.HttpStatusCodeAttribute)
        #all OK
        if status_code == 200:
            #save data to temp file
            dest = QgsProcessingParameterFileDestination(name='wyniki')
            path = dest.generateTemporaryDestination()
            print(path)
            f = open(path, "wb")
            f.write(response.content())
            f.close()
            #load temp file as new layer
            self.load(path,'wyniki')
        #HTTP status not OK - show the message
        elif status_code == 403:
            info=str(response.content(), 'utf-8')
            self.iface.messageBar().pushMessage("Błąd", info, level=Qgis.Critical)
        else:
            QgsMessageLog.logMessage(response.errorString(), 'SmartSDI', Qgis.Warning)
            
        
    def pobierz(self):
        selectedLayer=self.dlg.layerList.currentLayer()
        #use the BBOX
        if selectedLayer is None:
            epsg=self.dlg.BBepsg.text().replace('EPSG:','')
            bbox=self.dlg.BBleft.text()
            bbox+=','+self.dlg.BBbottom.text()
            bbox+=','+self.dlg.BBright.text()
            bbox+=','+self.dlg.BBtop.text()
        #layer was selected - use it as a boundary for downloading
        else:
            epsg=selectedLayer.crs().authid().replace('EPSG:','')
            features=selectedLayer.getFeatures()
            for f in features:
                bbox=f.geometry().asWkt()
                break
        #which data to download (parcels, buildings, addresses)
        if(self.dlg.checkDz.isChecked()):
            self.download(epsg,bbox,'dzialki')
        if(self.dlg.checkBud.isChecked()):
            self.download(epsg,bbox,'budynki')
        if(self.dlg.checkAdr.isChecked()):
            self.download(epsg,bbox,'adresy')
    
    def download(self,epsg,bbox,layer):
        """Downloads the data from the web service"""
        
        #use POST request for long bboxes (large polygons/lines)
        if len(bbox)>512:
            url='https://smartsdi.pl/qgis/download.php'
            postData = QByteArray()
            postData.append("layer").append('=').append(layer).append("&")
            postData.append("epsg").append('=').append(epsg).append("&")
            postData.append("bbox").append('=').append(bbox).append("&")
            post=1
        else:
            url='https://smartsdi.pl/qgis/download.php?layer='+layer+'&epsg='+epsg+'&bbox='+bbox
            post=0
        
        workingUrl = QUrl(url)
        request = QNetworkRequest(workingUrl)
        networkAccessManager = QgsNetworkAccessManager()
        #POST
        if post:
            response = networkAccessManager.blockingPost(request,postData)
        #GET for short requests
        else:
            response = networkAccessManager.blockingGet(request)
        status_code = response.attribute(QNetworkRequest.HttpStatusCodeAttribute)
        #all OK
        if status_code == 200:
            #save data to temp file
            dest = QgsProcessingParameterFileDestination(name=layer)
            path = dest.generateTemporaryDestination()
            print(path)
            f = open(path, "wb")
            f.write(response.content())
            f.close()
            #load temp file as new layer
            self.load(path,layer,int(epsg))
        #HTTP status not OK - show the message
        elif status_code == 403:
            info=str(response.content(), 'utf-8')
            self.iface.messageBar().pushMessage("Błąd", info, level=Qgis.Critical)
        else:
            QgsMessageLog.logMessage(response.errorString(), 'SmartSDI', Qgis.Warning)

    def run(self):
        """Run method that performs all the real work"""

        # Create the dialog with elements (after translation) and keep reference
        # Only create GUI ONCE in callback, so that it will only load when the plugin is started
        if self.first_start == True:
            self.first_start = False
            self.download_count = 0;
            #slowniki do comboboxow
            self.woj = {}
            self.pow = {}
            self.gmi = {}
            self.obr = {}
            self.kl = {}
            self.gr = {}
            self.sa_grupy = {}
            self.sa_uzytki = {} 
            self.dlg = SmartSDIDialog()
            self.populate_combobox_woj()
            self.populate_combobox_adv()
            self.dlg.tokenEdit.setText(self.token)
            #sygnaly przy zmianie/kliknieciu
            self.dlg.comboBoxWoj.currentIndexChanged.connect(self.populate_combobox_pow)
            self.dlg.comboBoxPow.currentIndexChanged.connect(self.populate_combobox_gmi)
            self.dlg.comboBoxGmi.currentIndexChanged.connect(self.populate_combobox_obr)
            self.dlg.button_box.clicked.connect(self.pobierz)
            self.dlg.buttonBox2.clicked.connect(self.szukaj)
            self.dlg.BBget.clicked.connect(self.bbox)
            self.dlg.saveTokenButton.clicked.connect(self.save_token)
            #filter the layer list - only lines and polygons
            self.dlg.layerList.setFilters(QgsMapLayerProxyModel.PolygonLayer|QgsMapLayerProxyModel.LineLayer)

        # show the dialog
        self.dlg.show()
        self.bbox()   
        
        
        


