# -*- coding: utf-8 -*-
"""
/***************************************************************************
 LoginDialog
                                 A QGIS plugin
 Merupakan plugin qgis untuk keperluan opd di provide dari JDS
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2022-10-28
        git sha              : $Format:%H$
        copyright            : (C) 2022 by Misdan Wijaya
        email                : jds.dataengineer@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

import os
import requests

from qgis.PyQt import uic
from qgis.PyQt import QtWidgets
from PyQt5.QtCore import pyqtSignal

from ..utils.config import storeSetting

# This loads your .ui file so that PyQt can populate your plugin with the elements from Qt Designer
FORM_CLASS, _ = uic.loadUiType(os.path.join(
    os.path.dirname(__file__), '../ui/login.ui'))


class LoginDialog(QtWidgets.QDialog, FORM_CLASS):
    
    userMasuk = pyqtSignal()
    
    def __init__(self, parent=None):
        """Constructor."""
        super(LoginDialog, self).__init__(parent)
        # Set up the user interface from Designer through FORM_CLASS.
        # After self.setupUi() you can access any designer object by doing
        # self.<objectname>, and you can use autoconnect slots - see
        # http://qt-project.org/doc/qt-4.8/designer-using-a-ui-file.html
        # #widgets-and-dialogs-with-auto-connect
        self.setupUi(self)

        # hide label notif
        self.label_status.setHidden(True)

        display_opd = self.get_opd_list()
        self.cb_list_opd.addItems(display_opd)

        self.pbLogin.clicked.connect(self.onpbLoginClicked)


    def get_opd_list(self):
        url_list_opd = 'https://api.coredatajds.id/gis/list_opd_code'
        opd_list = requests.get(url_list_opd)
        display = []
        if opd_list.status_code == 200:
            opd_list = opd_list.json()
            opd_list = opd_list.get("result")
            #display = []
            for data in opd_list:
                display.append(data['opd_code'])
            #print(display)
            #return display
        else:
            display = ["Reconnecting..."]
            #print(display)
            #return display
        return display
        # url_list_opd = 'https://api.coredatajds.id/gis/list_opd_code'
        # opd_list = requests.get(url_list_opd)
        # opd_list = opd_list.json()
        # opd_list = opd_list.get("result")

        # display = []
        # for data in opd_list:
        #     display.append(data['opd_code'])
        
        # return display

    def onpbLoginClicked(self):

        user = self.input_username.text()
        password = self.input_password.text()
        opd_code = self.cb_list_opd.currentText()

        headers = {
            'content-type': 'application/json',
            'user':user,
            'password':password,
            'opdcode':opd_code
        }

        url_login = 'https://api.coredatajds.id/gis/login'

        result = requests.get(url_login,headers=headers)

        if result.status_code == 200:
            self.label_status.setHidden(True)

            #extract data
            result_data = result.json()

            #store setting to local cache
            storeSetting("username",result_data.get('username'))
            storeSetting("password",password)
            storeSetting("opdcode",result_data.get('opd_code'))
            storeSetting("opdname",result_data.get('opd_name'))
            storeSetting("roles",result_data.get('roles'))

            self.userMasuk.emit()

        else:
            err_msg = result.json().get('detail').get('message')
            self.label_status.setHidden(False)
            self.label_status.setStyleSheet("color: white; background-color: #C4392A; border-radius: 4px;")
            self.label_status.setText(err_msg)