# -*- coding: utf-8 -*-
"""
/***************************************************************************
 FindReplace
                                 A QGIS plugin
 Simple screen to quickly perform find/replace on text in columns.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                              -------------------
        begin                : 2020-10-31
        git sha              : $Format:%H$
        copyright            : (C) 2020 by Sem Riemens
        email                : semriemens@posteo.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.gui import QgsGui, QgsMapLayerAction

# Import the code for the dialog
from .findreplace_dialog import FindReplaceDialog
import os.path


class FindReplace:
    """QGIS Plugin Implementation."""

    def __init__(self, iface):
        self.plugin_dir = os.path.dirname(__file__)

    def initGui(self):
        """Create the menu entries and toolbar icons inside the QGIS GUI."""
        
        # Note: this is using a QgsMapLayerAction which will show in the right click menu on an attribute table.
        # It's not exactly what I wanted, as there is no way to get the selected field when using a QgsMapLayerAction
        # and also it will show up under the 'Actions' button in the main QGIS screen.
        # Another possibility would be to use a QgsAction with Field scope and the QgsActionManager, then add this action
        # to all layers. I decided against this as the action would then be saved and visible in people's project files.
        # I guess the ideal thing would be a QgsAttributeTableMapLayerAction, but I don't understand how to use that.
        # For now people will have to manually select the field to use.
        self.findReplaceAction = QgsMapLayerAction( "Find/Replace",None, targets=QgsMapLayerAction.Target.SingleFeature )
        QgsGui.mapLayerActionRegistry().addMapLayerAction(self.findReplaceAction)
        
        self.findReplaceAction.triggeredForLayer.connect(self.run)
        self.findReplaceAction.triggeredForFeature.connect(self.run)
        
    def unload(self):
        """Removes the plugin menu item and icon from QGIS GUI."""
        QgsGui.mapLayerActionRegistry().removeMapLayerAction(self.findReplaceAction)
        del self.findReplaceAction

    def run(self, layer=None,feature=None):
        frd = FindReplaceDialog(layer)
        
        frd.show()
        if frd.exec_():
            pass
        frd.deleteLater()
        del frd

