# QGIS Fast Grid Inspection (FGI)

## Introduction

## Overview

The "QGIS Fast Grid Inspection" plugin is a versatile tool designed for use in QGIS, aimed at innovating the way users generate and classify samples. Originally developed to assist in creating a comprehensive global map of pastures, its functionality extends far beyond just that application. Whether you're mapping pastures or undertaking any other geospatial analysis, this plugin offers a range of features to enhance your workflow in QGIS.

![QGIS Fast Grid Inspection (FGI)](./img/fgi.gif)

### Primary Features:

1. **Sample Generation**: Easily generate samples from predefined regions, streamlining the process and making it efficient.
2. **Flexible Classification**: While it has been optimized for pasture mapping, the plugin's classification capability is adaptable. Users can set their criteria and classify samples according to their unique needs.
3. **Integration with Major Image Providers**: To ensure comprehensive coverage and high-resolution imagery, the plugin is integrated with Bing and Google Images. This provides users with a rich visual dataset to work from.
4. **Customizable Inspection**: Beyond pastures, the tool can be tailored to generate samples for any other classifications users might want to inspect. This makes it a versatile choice for a myriad of applications.

### Applications:

While its primary application revolves around assisting in the creation of a global pasture map, the adaptability of the QGIS Fast Grid Inspection plugin means it can be applied across a multitude of scenarios. Whether you're an environmental scientist tracking specific terrains, a researcher studying different land use patterns, or simply someone curious about exploring diverse geographic regions through samples, this plugin is your go-to tool.

### Features & Benefits

The QGIS Fast Grid Inspection plugin provides an array of features designed to streamline and enhance the generation and classification of samples. Below are some of the key features and their associated benefits.

#### Sample Generation for Pastures (v1)

- **Feature**: Easily generate samples for pastures.
- **Benefit**: Speeds up the mapping process and improves the accuracy of pasture classifications.

#### Bing Image Support (v2)

- **Feature**: Integrated support for Bing images.
- **Benefit**: Expands the available data sources for your mapping project, offering more versatility.

#### Customizable Inspection Settings (v3)

- **Feature**: Ability to customize inspection settings.
- **Benefit**: Allows for a more tailored inspection process, fitting specific project needs and requirements.


### User Guide

For a more detailed understanding, including step-by-step instructions and advanced functionalities, please refer to our [QGIS Fast Grid Inspection (FGI) - User Guide](https://github.com/lapig-ufg/qgis-fgi-plugin/wiki).

### Reporting Issues

If you've found a bug or would like to suggest a new feature, please open an issue on GitHub. When reporting bugs, make sure to provide detailed information so that the issue can be replicated. Use the following link to open an issue: [GitHub Issues](https://github.com/lapig-ufg/inspection-tiles/issues).

### Feedback

Your thoughts and suggestions about the "QGIS Fast Grid Inspection" plugin are invaluable to us. Whether it's new ideas, improvements, or other types of feedback, we're eager to hear what you have to say and excited about the contributions you may bring to the project!

For any questions or to start a discussion, please feel free to reach out at [irtharles@gmail.com](mailto:irtharles@gmail.com).

### Acknowledgements & Funding

This work is supported by [WRI](https://wri.org), [LAPIG/UFG](http://lapig.iesa.ufg.br), [OpenGeoHub Foundation](https://opengeohub.org/) and [IIASA](https://iiasa.ac.at/) and has received funding from [Land and Carbon Lab](https://www.landcarbonlab.org/) through the [Global Pasture Watch](https://www.wri.org/events/2023/4/global-pasture-watch-mapping-monitoring-global-grasslands-livestock).

