# -*- coding: utf-8 -*-
"""
/***************************************************************************
 easydem
                                A QGIS plugin
 Get Digital Elevation Model (DEM) data from Google Earth Engine and plot as raster layer it contour lines, make elevation maps.
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                               -------------------
        begin                 : 2024-11-13
        copyright             : (C) 2024 by Caio Arantes
        email                 : caiosimplicioarantes@gmail.com
        git sha               : $Format:%H$
 ***************************************************************************/

/***************************************************************************
 * *
 * This program is free software; you can redistribute it and/or modify  *
 * it under the terms of the GNU General Public License as published by  *
 * the Free Software Foundation; either version 2 of the License, or     *
 * (at your option) any later version.                                   *
 * *
 ***************************************************************************/
 This script initializes the plugin, making it known to QGIS.
"""

import os
import sys
# Import QMessageBox for user feedback if a dependency is missing (optional but recommended)
from qgis.PyQt.QtWidgets import QMessageBox

# --- START: Dependency Loading Code ---
# Get the path to the current plugin directory
plugin_dir = os.path.dirname(__file__)

# Define the path to the 'extlibs' directory
extlibs_path = os.path.join(plugin_dir, 'extlibs')

# Add the 'extlibs' directory to sys.path if it exists and is not already there
# This ensures that Python can find the modules installed by 'paver setup'
if os.path.isdir(extlibs_path) and extlibs_path not in sys.path:
    sys.path.insert(0, extlibs_path)
    print(f"EasyDEM Plugin: Added '{extlibs_path}' to sys.path.")
elif not os.path.isdir(extlibs_path):
    print(f"EasyDEM Plugin Warning: 'extlibs' directory not found at '{extlibs_path}'. "
          "External dependencies might be missing. Please run 'paver setup'.")
    # Optional: Display a warning message to the user
    # QMessageBox.warning(None, "EasyDEM Plugin Warning",
    #                     "External dependencies directory 'extlibs' not found. "
    #                     "Please ensure you have run 'paver setup' for the plugin.")

# --- END: Dependency Loading Code ---


# noinspection PyPep8Naming
def classFactory(iface):  # pylint: disable=invalid-name
    """Load easydem class from file easy.

    :param iface: A QGIS interface instance.
    :type iface: QgsInterface
    """
    #
    # Ensure your easydem class (in easy.py) can now import its dependencies
    from .easy import easydem
    return easydem(iface)