# (c) Didier  LECLERC 2024 CHARGE D'ETUDES GEOMATIQUES MTE-MCTRCT/SG/DNUM/MSP/DS/GSG/PMIRG Site de Rouen
# créé sept 2024 

from qgis.PyQt import QtWidgets
from qgis.PyQt.QtCore import ( QSettings, QLocale, QFileInfo, QCoreApplication, QTranslator )

from qgis.PyQt.QtWidgets import (QAction, QMenu, QWidget)
from qgis.PyQt.QtGui import QIcon

import os

from qgireferentiels.bibli_qgireferentiels import (returnVersion) 


#===================================================
# Generation de la traduction selon la langue choisie   
overrideLocale = QSettings().value("locale/overrideFlag", False)
localeFullName = QLocale.system().name() if not overrideLocale else QSettings().value("locale/userLocale", "")
if localeFullName == None :
  localePath = os.path.dirname(__file__) + "/i18n/qgireferentiels_fr.qm"
else :
  localePath = os.path.dirname(__file__) + "/i18n/qgireferentiels_" + localeFullName[0:2] + ".qm"
if QFileInfo(localePath).exists():
  translator = QTranslator()
  translator.load(localePath)
  QCoreApplication.installTranslator(translator)
# Generation de la traduction selon la langue choisie
#===================================================

from qgireferentiels import doqgireferentiels_ui

class MainPlugin(object):
  def __init__(self, iface):
     self.name = "qgireferentiels"
     self.iface = iface
      
  def initGui(self):
     #Construction du menu
     self.menu=QMenu("qgireferentiels")
     self.menu.setTitle(QtWidgets.QApplication.translate("qgidistribution_main", "PLUGIN QGIREFERENTIELS") + "  (" + str(returnVersion()) + ")")
     _pathIcons = os.path.dirname(__file__) + "/icons/logo"
     menuIcon          = _pathIcons + "/qgireferentiels.png"
     self.menuIcon = menuIcon
     #For Menu in Extensions
     self.qgidistribution = QAction(QIcon(menuIcon),"PLUGIN QGIREFERENTIELS (Interface for the GeoIde Warehouse API)" + "  (" + str(returnVersion()) + ")",self.iface.mainWindow())
     self.qgidistribution.setText(QtWidgets.QApplication.translate("qgidistribution_main", "open QGIReferentiels"))
     self.qgidistribution.triggered.connect(self.clickIHMqgidistribution)
     #For icon in ToolBar
     self.qgidistributionToolBar = QAction(QIcon(menuIcon),"PLUGIN QGIREFERENTIELS (Interface for the GeoIde Warehouse API)" + "  (" + str(returnVersion()) + ")",self.iface.mainWindow())
     self.qgidistributionToolBar.setText(QtWidgets.QApplication.translate("qgidistribution_main", "open QGIReferentiels"))
     self.qgidistributionToolBar.triggered.connect(self.clickIHMqgidistributionToolBar)

     #Construction du menu
     self.menu.setIcon(QIcon(menuIcon))
     self.menu.addAction(self.qgidistribution)
     #=========================
     #-- Ajout du menu
     menuBar = self.iface.mainWindow().menuBar()    
     zMenu = menuBar
     for child in menuBar.children():
         if child.objectName()== "mPluginMenu" :
            zMenu = child
            break
     zMenu.addMenu(self.menu)

     #Ajouter une barre d'outils'
     self.toolBarName = QtWidgets.QApplication.translate("qgidistribution_main", "My tool bar QGIReferentiels")
     self.toolbar = self.iface.addToolBar(self.toolBarName)
     # Pour faire une action
     self.toolbar.addAction(self.qgidistributionToolBar)
     #-
             
  # Pour la géoplateforme
  def create_gpf_plugins_actions(self, parent: QWidget) -> list[QAction]:
      """Create action to be inserted a Geoplateforme plugin

      :param parent: parent widget
      :type parent: QWidget
      :return: list of action to add in Geoplateforme plugin
      :rtype: list[QAction]
       """
      available_actions = []
      self.qgidistributionForGpf = QAction(QIcon(self.menuIcon),"PLUGIN QGIREFERENTIELS (Interface for the GeoIde Warehouse API)" + "  (" + str(returnVersion()) + ")",self.iface.mainWindow())
      self.qgidistributionForGpf.setText(QtWidgets.QApplication.translate("qgidistribution_main", "PLUGIN QGIREFERENTIELS") + "  (" + str(returnVersion()) + ")")
      self.qgidistributionForGpf.triggered.connect(self.clickIHMqgidistribution)
      available_actions.append(self.qgidistributionForGpf)
      return available_actions
  # Pour la géoplateforme
    
  def clickIHMqgidistribution(self):
      d = doqgireferentiels_ui.Dialog(self.qgidistribution, self.qgidistributionToolBar)
      d.exec()

  def clickIHMqgidistributionToolBar(self):
      d = doqgireferentiels_ui.Dialog(self.qgidistribution, self.qgidistributionToolBar)
      d.exec()

  def unload(self):
      self.menu.deleteLater() 
      self.toolbar.deleteLater()
      pass  

