from .model_abwasser import get_abwasser_model
from .model_qgep import get_qgep_model


def get_qgep_mapping():
    QGEP = get_qgep_model()
    ABWASSER = get_abwasser_model()

    return {
        # VSA-DSS 2015
        QGEP.re_maintenance_event_wastewater_structure: [
            ABWASSER.erhaltungsereignis_abwasserbauwerk,
            ABWASSER.metaattribute,
        ],
        QGEP.mutation: [ABWASSER.mutation, ABWASSER.metaattribute],
        QGEP.aquifier: [ABWASSER.grundwasserleiter, ABWASSER.metaattribute],
        QGEP.river: [ABWASSER.fliessgewaesser, ABWASSER.metaattribute],
        QGEP.lake: [ABWASSER.see, ABWASSER.metaattribute],
        QGEP.water_course_segment: [ABWASSER.gewaesserabschnitt, ABWASSER.metaattribute],
        QGEP.water_catchment: [ABWASSER.wasserfassung, ABWASSER.metaattribute],
        QGEP.river_bank: [ABWASSER.ufer, ABWASSER.metaattribute],
        QGEP.river_bed: [ABWASSER.gewaessersohle, ABWASSER.metaattribute],
        QGEP.sector_water_body: [ABWASSER.gewaessersektor, ABWASSER.metaattribute],
        QGEP.administrative_office: [ABWASSER.amt, ABWASSER.metaattribute],
        QGEP.cooperative: [ABWASSER.genossenschaft_korporation, ABWASSER.metaattribute],
        QGEP.canton: [ABWASSER.kanton, ABWASSER.metaattribute],
        QGEP.waste_water_association: [ABWASSER.abwasserverband, ABWASSER.metaattribute],
        QGEP.municipality: [ABWASSER.gemeinde, ABWASSER.metaattribute],
        QGEP.waste_water_treatment_plant: [
            ABWASSER.abwasserreinigungsanlage,
            ABWASSER.metaattribute,
        ],
        QGEP.private: [ABWASSER.privat, ABWASSER.metaattribute],
        QGEP.channel: [ABWASSER.kanal, ABWASSER.metaattribute],
        QGEP.manhole: [ABWASSER.normschacht, ABWASSER.metaattribute],
        QGEP.discharge_point: [ABWASSER.einleitstelle, ABWASSER.metaattribute],
        QGEP.special_structure: [ABWASSER.spezialbauwerk, ABWASSER.metaattribute],
        QGEP.infiltration_installation: [ABWASSER.versickerungsanlage, ABWASSER.metaattribute],
        QGEP.wwtp_structure: [ABWASSER.arabauwerk, ABWASSER.metaattribute],
        QGEP.planning_zone: [ABWASSER.planungszone, ABWASSER.metaattribute],
        QGEP.infiltration_zone: [ABWASSER.versickerungsbereich, ABWASSER.metaattribute],
        QGEP.drainage_system: [ABWASSER.entwaesserungssystem, ABWASSER.metaattribute],
        QGEP.water_body_protection_sector: [
            ABWASSER.gewaesserschutzbereich,
            ABWASSER.metaattribute,
        ],
        QGEP.ground_water_protection_perimeter: [
            ABWASSER.grundwasserschutzareal,
            ABWASSER.metaattribute,
        ],
        QGEP.groundwater_protection_zone: [ABWASSER.grundwasserschutzzone, ABWASSER.metaattribute],
        QGEP.pipe_profile: [ABWASSER.rohrprofil, ABWASSER.metaattribute],
        QGEP.wwtp_energy_use: [ABWASSER.araenergienutzung, ABWASSER.metaattribute],
        QGEP.waste_water_treatment: [ABWASSER.abwasserbehandlung, ABWASSER.metaattribute],
        QGEP.sludge_treatment: [ABWASSER.schlammbehandlung, ABWASSER.metaattribute],
        QGEP.control_center: [ABWASSER.steuerungszentrale, ABWASSER.metaattribute],
        QGEP.ford: [ABWASSER.furt, ABWASSER.metaattribute],
        QGEP.chute: [ABWASSER.gewaesserabsturz, ABWASSER.metaattribute],
        QGEP.lock: [ABWASSER.schleuse, ABWASSER.metaattribute],
        QGEP.passage: [ABWASSER.durchlass, ABWASSER.metaattribute],
        QGEP.blocking_debris: [ABWASSER.geschiebesperre, ABWASSER.metaattribute],
        QGEP.dam: [ABWASSER.gewaesserwehr, ABWASSER.metaattribute],
        QGEP.rock_ramp: [ABWASSER.sohlrampe, ABWASSER.metaattribute],
        QGEP.fish_pass: [ABWASSER.fischpass, ABWASSER.metaattribute],
        QGEP.bathing_area: [ABWASSER.badestelle, ABWASSER.metaattribute],
        QGEP.hydr_geometry: [ABWASSER.hydr_geometrie, ABWASSER.metaattribute],
        QGEP.reach_point: [ABWASSER.haltungspunkt, ABWASSER.metaattribute],
        QGEP.wastewater_node: [ABWASSER.abwasserknoten, ABWASSER.metaattribute],
        QGEP.reach: [ABWASSER.haltung, ABWASSER.metaattribute],
        QGEP.profile_geometry: [ABWASSER.rohrprofil_geometrie, ABWASSER.metaattribute],
        QGEP.hydr_geom_relation: [ABWASSER.hydr_geomrelation, ABWASSER.metaattribute],
        QGEP.mechanical_pretreatment: [ABWASSER.mechanischevorreinigung, ABWASSER.metaattribute],
        QGEP.retention_body: [ABWASSER.retentionskoerper, ABWASSER.metaattribute],
        QGEP.overflow_char: [ABWASSER.ueberlaufcharakteristik, ABWASSER.metaattribute],
        QGEP.hq_relation: [ABWASSER.hq_relation, ABWASSER.metaattribute],
        QGEP.dryweather_downspout: [ABWASSER.trockenwetterfallrohr, ABWASSER.metaattribute],
        QGEP.access_aid: [ABWASSER.einstiegshilfe, ABWASSER.metaattribute],
        QGEP.dryweather_flume: [ABWASSER.trockenwetterrinne, ABWASSER.metaattribute],
        QGEP.cover: [ABWASSER.deckel, ABWASSER.metaattribute],
        QGEP.electric_equipment: [ABWASSER.elektrischeeinrichtung, ABWASSER.metaattribute],
        QGEP.electromechanical_equipment: [
            ABWASSER.elektromechanischeausruestung,
            ABWASSER.metaattribute,
        ],
        QGEP.benching: [ABWASSER.bankett, ABWASSER.metaattribute],
        QGEP.building: [ABWASSER.gebaeude, ABWASSER.metaattribute],
        QGEP.reservoir: [ABWASSER.reservoir, ABWASSER.metaattribute],
        QGEP.individual_surface: [ABWASSER.einzelflaeche, ABWASSER.metaattribute],
        QGEP.fountain: [ABWASSER.brunnen, ABWASSER.metaattribute],
        QGEP.hazard_source: [ABWASSER.gefahrenquelle, ABWASSER.metaattribute],
        QGEP.accident: [ABWASSER.unfall, ABWASSER.metaattribute],
        QGEP.substance: [ABWASSER.stoff, ABWASSER.metaattribute],
        QGEP.catchment_area: [ABWASSER.einzugsgebiet, ABWASSER.metaattribute],
        QGEP.measuring_point: [ABWASSER.messstelle, ABWASSER.metaattribute],
        QGEP.measuring_device: [ABWASSER.messgeraet, ABWASSER.metaattribute],
        QGEP.measurement_series: [ABWASSER.messreihe, ABWASSER.metaattribute],
        QGEP.measurement_result: [ABWASSER.messresultat, ABWASSER.metaattribute],
        QGEP.throttle_shut_off_unit: [ABWASSER.absperr_drosselorgan, ABWASSER.metaattribute],
        QGEP.prank_weir: [ABWASSER.streichwehr, ABWASSER.metaattribute],
        QGEP.pump: [ABWASSER.foerderaggregat, ABWASSER.metaattribute],
        QGEP.leapingweir: [ABWASSER.leapingwehr, ABWASSER.metaattribute],
        QGEP.hydraulic_char_data: [ABWASSER.hydr_kennwerte, ABWASSER.metaattribute],
        QGEP.backflow_prevention: [ABWASSER.rueckstausicherung, ABWASSER.metaattribute],
        QGEP.solids_retention: [ABWASSER.feststoffrueckhalt, ABWASSER.metaattribute],
        QGEP.tank_cleaning: [ABWASSER.beckenreinigung, ABWASSER.metaattribute],
        QGEP.tank_emptying: [ABWASSER.beckenentleerung, ABWASSER.metaattribute],
        QGEP.param_ca_general: [ABWASSER.ezg_parameter_allg, ABWASSER.metaattribute],
        QGEP.param_ca_mouse1: [ABWASSER.ezg_parameter_mouse1, ABWASSER.metaattribute],
    }
