/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.generator;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.Cardinality;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumValType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.MetaobjectType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.StructuredUnitType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Uml21Generator {
    public static String umlNs = "http://www.eclipse.org/uml2/3.0.0/UML";
    public static String umlPfx = "uml:";
    public static String xmiNs = "http://schema.omg.org/spec/XMI/2.1";
    public static String xsiNs = "http://www.w3.org/2001/XMLSchema-instance";
    public static String iliNs = "http://www.interlis.ch/INTERLIS2.3/UML2";
    public static String ecoreIliProfileLocation = "INTERLIS.profile.uml#ch.interlis.ili23.ecore.uml2";
    public static String idTextType = "C16095C6-1D80-49ab-9A0B-5847A355489B";
    public static String idEnumerationType = "279A049B-2BCC-4fb5-9C8F-3B22EF3EE0ED";
    public static String idEnumTreeValueType = "064231DE-6F7D-43bb-A0B9-B4C37906E012";
    public static String idAlignmentType = "B5F4B6BC-41B7-400b-84DF-64474E7B3F07";
    public static String idBooleanType = "D2A6D48C-97F0-44d0-910A-7C55943BECA7";
    public static String idNumericType = "39FDCDA0-DAE3-4c14-B2DC-C4F0F4DAAAF8";
    public static String idFormattedType = "36B2DF93-856E-4997-B610-61C456A6BD1B";
    public static String idTimeType = "FBAA3B46-D164-4ecf-96C5-31D69315FDDF";
    public static String idDateType = "259523F4-AAC6-4fe2-8B34-B9113604AB8C";
    public static String idDateTimeType = "5904195D-E562-4262-9F6B-7104FA1AB70D";
    public static String idOIDType = "19ACF3BB-5A8B-4b73-9C38-D37C3DC8B207";
    public static String idBlackboxType = "93ADB54A-B82F-421c-8C50-8881FFD61F42";
    public static String idClassType = "F1B17749-EACA-4ed1-A9EC-40B63C2A94B0";
    public static String idAttributePathType = "5AD53796-0781-4f5d-AEFA-B11FD46DD5AB";
    public static String idCoordinateType = "45397FCA-66E2-4ac8-A8A7-89D3A573E44B";
    public static String idPolylineType = "F466480C-C0A2-47de-A0FC-D9D3932DB96E";
    public static String idSurfaceType = "D874C9DB-F082-4bd4-B4F1-DACD75BBFDD6";
    public static String idAreaType = "E06837E3-F58C-49bb-8F82-22F666FB4CCF";
    private XMLStreamWriter xout = null;
    private TransferDescription td = null;
    private ArrayList applies = new ArrayList();

    private Uml21Generator() {
    }

    public static void generate(File outFile, TransferDescription td) {
        try {
            new Uml21Generator().doit(outFile, td);
        }
        catch (IOException e) {
            EhiLogger.logError((Throwable)e);
        }
        catch (XMLStreamException e) {
            EhiLogger.logError((Throwable)e);
        }
    }

    private void doit(File outFile, TransferDescription td) throws IOException, XMLStreamException {
        this.td = td;
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        XMLOutputFactory output = XMLOutputFactory.newInstance();
        this.xout = output.createXMLStreamWriter(out);
        this.xout.writeStartDocument("UTF-8", "1.0");
        this.xout.setPrefix("xmi", xmiNs);
        this.xout.setPrefix("uml", umlNs);
        this.xout.setPrefix("ili", iliNs);
        this.xout.setPrefix("xsi", xsiNs);
        this.xout.writeStartElement(xmiNs, "XMI");
        this.xout.writeNamespace("xsi", xsiNs);
        this.xout.writeNamespace("xmi", xmiNs);
        this.xout.writeNamespace("uml", umlNs);
        this.xout.writeNamespace("ili", iliNs);
        this.xout.writeAttribute(xmiNs, "version", "2.1");
        this.xout.writeAttribute(xsiNs, "schemaLocation", iliNs + " " + ecoreIliProfileLocation);
        this.xout.writeStartElement(xmiNs, "Documentation");
        this.xout.writeAttribute("exporter", "ili2c");
        this.xout.writeAttribute("exporterVersion", TransferDescription.getVersion());
        this.xout.writeEndElement();
        this.xout.writeStartElement(umlNs, "Model");
        this.xout.writeAttribute("name", "INTERLIS_Model");
        this.xout.writeAttribute("visibility", "public");
        this.xout.writeStartElement("packagedElement");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "Package");
        this.xout.writeAttribute(xmiNs, "id", "1");
        this.xout.writeAttribute("name", "import");
        this.xout.writeAttribute("visibility", "public");
        Iterator modeli = td.iterator();
        while (modeli.hasNext()) {
            Object modelo = modeli.next();
            if (!(modelo instanceof Model)) continue;
            Model model = (Model)modelo;
            this.visitModelDef(model);
        }
        this.xout.writeEndElement();
        this.xout.writeEndElement();
        this.writeStereotypes();
        this.xout.writeEndElement();
        this.xout.flush();
    }

    private void writePrimitiveType(String id, String name) throws XMLStreamException {
        this.xout.writeStartElement("packagedElement");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "PrimitiveType");
        this.xout.writeAttribute(xmiNs, "id", id);
        this.xout.writeAttribute("name", name);
        this.xout.writeAttribute("visibility", "public");
        this.xout.writeEndElement();
    }

    private void visitModelDef(Model model) throws XMLStreamException {
        this.xout.writeStartElement("packagedElement");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "Package");
        this.xout.writeAttribute(xmiNs, "id", model.getName());
        this.xout.writeAttribute("name", model.getName());
        this.xout.writeAttribute("visibility", "public");
        this.xout.writeStartElement("profileApplication");
        this.xout.writeStartElement("eAnnotations");
        this.xout.writeAttribute("source", "http://www.eclipse.org/uml2/2.0.0/UML");
        this.xout.writeStartElement("references");
        this.xout.writeAttribute("href", ecoreIliProfileLocation);
        this.xout.writeEndElement();
        this.xout.writeEndElement();
        this.xout.writeStartElement("appliedProfile");
        this.xout.writeAttribute("href", "INTERLIS.profile.uml#ch.interlis.ili23.uml2");
        this.xout.writeEndElement();
        this.applyStereotype(model);
        this.xout.writeEndElement();
        if (model == this.td.INTERLIS) {
            this.writePrimitiveType(idTextType, "TextType");
            this.writePrimitiveType(idEnumerationType, "EnumerationType");
            this.writePrimitiveType(idEnumTreeValueType, "EnumTreeValueType");
            this.writePrimitiveType(idAlignmentType, "AlignmentType");
            this.writePrimitiveType(idBooleanType, "BooleanType");
            this.writePrimitiveType(idNumericType, "NumericType");
            this.writePrimitiveType(idFormattedType, "FormattedType");
            this.writePrimitiveType(idTimeType, "TimeType");
            this.writePrimitiveType(idDateType, "DateType");
            this.writePrimitiveType(idDateTimeType, "DateTimeType");
            this.writePrimitiveType(idOIDType, "OIDType");
            this.writePrimitiveType(idBlackboxType, "BlackboxType");
            this.writePrimitiveType(idClassType, "ClassType");
            this.writePrimitiveType(idAttributePathType, "AttributePathType");
            this.writePrimitiveType(idCoordinateType, "CoordinateType");
            this.writePrimitiveType(idPolylineType, "PolylineType");
            this.writePrimitiveType(idSurfaceType, "SurfaceType");
            this.writePrimitiveType(idAreaType, "AreaType");
        }
        Iterator elei = model.iterator();
        while (elei.hasNext()) {
            Object ele = elei.next();
            if (ele instanceof Topic) {
                Topic topic = (Topic)ele;
                this.visitTopicDef(topic);
                continue;
            }
            if (ele instanceof Domain) {
                Domain domain = (Domain)ele;
                this.visitDomainDef(domain);
                continue;
            }
            if (ele instanceof Unit) {
                this.visitUnitDef((Unit)ele);
                continue;
            }
            if (!(ele instanceof Table)) continue;
            this.visitAbstractClassDef((Table)ele);
        }
        this.xout.writeEndElement();
    }

    private void visitTopicDef(Topic topic) throws XMLStreamException {
        this.xout.writeStartElement("packagedElement");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "Package");
        this.xout.writeAttribute(xmiNs, "id", topic.getScopedName(null));
        this.xout.writeAttribute("name", topic.getName());
        this.xout.writeAttribute("visibility", "public");
        this.applyStereotype(topic);
        Iterator elei = topic.iterator();
        while (elei.hasNext()) {
            Object ele = elei.next();
            if (ele instanceof Table) {
                Table aclass = (Table)ele;
                this.visitAbstractClassDef(aclass);
                continue;
            }
            if (ele instanceof AssociationDef) {
                AssociationDef assoc = (AssociationDef)ele;
                this.visitAbstractClassDef(assoc);
                continue;
            }
            if (ele instanceof Unit) {
                this.visitUnitDef((Unit)ele);
                continue;
            }
            if (!(ele instanceof Domain)) continue;
            Domain domain = (Domain)ele;
            this.visitDomainDef(domain);
        }
        this.xout.writeEndElement();
    }

    private void visitUnitDef(Unit def) throws XMLStreamException {
        this.xout.writeStartElement("packagedElement");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "Class");
        this.xout.writeAttribute(xmiNs, "id", def.getScopedName(null));
        this.xout.writeAttribute("name", def.getName());
        this.xout.writeAttribute("visibility", "public");
        if (def.isAbstract()) {
            this.xout.writeAttribute("isAbstract", "true");
        }
        this.applyStereotype(def);
        if (def.getExtending() != null) {
            this.xout.writeStartElement("generalization");
            this.xout.writeAttribute("general", def.getExtending().getScopedName(null));
            this.xout.writeEndElement();
        }
        this.xout.writeEndElement();
    }

    private void visitDomainDef(Domain def) throws XMLStreamException {
        if (def.getType() instanceof EnumerationType) {
            EnumerationType enumType = (EnumerationType)def.getType();
            this.xout.writeStartElement("packagedElement");
            this.xout.writeAttribute(xmiNs, "type", umlPfx + "Enumeration");
            this.xout.writeAttribute(xmiNs, "id", def.getScopedName(null));
            this.xout.writeAttribute("name", def.getName());
            this.xout.writeAttribute("visibility", "public");
            ArrayList ev = new ArrayList();
            XSDGenerator.buildEnumList(ev, "", enumType.getConsolidatedEnumeration());
            for (String value : ev) {
                this.xout.writeStartElement("ownedLiteral");
                this.xout.writeAttribute("name", value);
                this.xout.writeEndElement();
            }
            this.xout.writeEndElement();
        } else {
            this.xout.writeStartElement("packagedElement");
            this.xout.writeAttribute(xmiNs, "type", umlPfx + "PrimitiveType");
            this.xout.writeAttribute(xmiNs, "id", def.getScopedName(null));
            this.xout.writeAttribute("name", def.getName());
            this.xout.writeAttribute("visibility", "public");
            if (def.getExtending() == null) {
                Type type = def.getType();
                String typeId = null;
                if (type instanceof AttributePathType) {
                    typeId = idAttributePathType;
                } else if (type instanceof BlackboxType) {
                    typeId = idBlackboxType;
                } else if (type instanceof CoordType) {
                    typeId = idCoordinateType;
                } else if (type instanceof EnumerationType) {
                    typeId = idEnumerationType;
                } else if (type instanceof EnumTreeValueType) {
                    typeId = idEnumTreeValueType;
                } else if (type instanceof FormattedType) {
                    typeId = idFormattedType;
                } else if (type instanceof NumericType) {
                    typeId = idNumericType;
                } else if (type instanceof StructuredUnitType) {
                    typeId = idFormattedType;
                } else if (type instanceof TextType) {
                    typeId = idTextType;
                } else if (type instanceof BasketType) {
                    typeId = idTextType;
                } else if (type instanceof ClassType) {
                    typeId = idClassType;
                } else {
                    if (type instanceof EnumValType) {
                        throw new IllegalStateException();
                    }
                    if (type instanceof PolylineType) {
                        typeId = idPolylineType;
                    } else if (type instanceof SurfaceType) {
                        typeId = idSurfaceType;
                    } else if (type instanceof AreaType) {
                        typeId = idAreaType;
                    } else {
                        if (type instanceof MetaobjectType) {
                            throw new IllegalStateException();
                        }
                        if (type instanceof ObjectType) {
                            throw new IllegalStateException();
                        }
                        if (type instanceof OIDType) {
                            typeId = idOIDType;
                        } else {
                            if (type instanceof ReferenceType) {
                                throw new IllegalStateException();
                            }
                            throw new IllegalStateException();
                        }
                    }
                }
                this.xout.writeStartElement("generalization");
                this.xout.writeAttribute("general", typeId);
                this.xout.writeEndElement();
            } else {
                this.xout.writeStartElement("generalization");
                this.xout.writeAttribute("general", def.getExtending().getScopedName(null));
                this.xout.writeEndElement();
            }
            this.xout.writeEndElement();
        }
    }

    private void visitAbstractClassDef(AbstractClassDef def) throws XMLStreamException {
        Iterator<ViewableTransferElement> iter;
        String memberEnds = "";
        boolean isAssocClass = false;
        if (def instanceof AssociationDef) {
            iter = def.getAttributesAndRoles2();
            String sep = "";
            while (iter.hasNext()) {
                ViewableTransferElement obj = iter.next();
                if (obj.obj instanceof AttributeDef) {
                    AttributeDef attr = (AttributeDef)obj.obj;
                    isAssocClass = true;
                }
                if (!(obj.obj instanceof RoleDef) || obj.embedded) continue;
                RoleDef role = (RoleDef)obj.obj;
                memberEnds = memberEnds + sep + this.getRoleDefXmiId((AssociationDef)def, role);
                sep = " ";
            }
        }
        this.xout.writeStartElement("packagedElement");
        if (def instanceof AssociationDef) {
            if (isAssocClass) {
                this.xout.writeAttribute(xmiNs, "type", umlPfx + "AssociationClass");
            } else {
                this.xout.writeAttribute(xmiNs, "type", umlPfx + "Association");
            }
        } else if (def instanceof Table) {
            if (((Table)def).isIdentifiable()) {
                this.xout.writeAttribute(xmiNs, "type", umlPfx + "Class");
            } else {
                this.xout.writeAttribute(xmiNs, "type", umlPfx + "DataType");
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.xout.writeAttribute(xmiNs, "id", def.getScopedName((Container)null));
        this.xout.writeAttribute("name", def.getName());
        this.xout.writeAttribute("visibility", "public");
        if (def.isAbstract()) {
            this.xout.writeAttribute("isAbstract", "true");
        }
        if (def instanceof AssociationDef) {
            this.xout.writeAttribute("memberEnd", memberEnds);
        }
        if (def.getExtending() != null) {
            this.xout.writeStartElement("generalization");
            this.xout.writeAttribute("general", def.getExtending().getScopedName(null));
            this.xout.writeEndElement();
        }
        iter = def.getAttributesAndRoles2();
        while (iter.hasNext()) {
            AttributeDef attr;
            ViewableTransferElement obj = iter.next();
            if (obj.obj instanceof AttributeDef && (attr = (AttributeDef)obj.obj).getContainer() == def) {
                this.visitAttributeDef(attr);
            }
            if (!(obj.obj instanceof RoleDef) || obj.embedded) continue;
            RoleDef role = (RoleDef)obj.obj;
            this.xout.writeStartElement("ownedEnd");
            this.xout.writeAttribute("name", role.getName());
            this.xout.writeAttribute("visibility", "public");
            this.xout.writeAttribute(xmiNs, "id", this.getRoleDefXmiId((AssociationDef)def, role));
            String aggregation = "none";
            if (role.hasOneOppEnd()) {
                RoleDef oppend = role.getOppEnd();
                if (oppend.getKind() == 2) {
                    aggregation = "shared";
                } else if (oppend.getKind() == 3) {
                    aggregation = "composite";
                }
            }
            this.xout.writeAttribute("aggregation", aggregation);
            this.xout.writeAttribute("type", role.getDestination().getScopedName((Container)null));
            if (role.getContainer() != def) {
                this.xout.writeAttribute("redefinedProperty", this.getRoleDefXmiId((AssociationDef)def.getExtending(), role));
            }
            Cardinality card = role.getCardinality();
            this.writeCardinality(card);
            this.xout.writeEndElement();
        }
        this.xout.writeEndElement();
    }

    private String getRoleDefXmiId(AssociationDef assoc, RoleDef role) {
        return assoc.getScopedName((Container)null) + "." + role.getName();
    }

    private String getAttributeDefXmiId(AttributeDef attr) {
        return attr.getContainer().getScopedName(null) + "." + attr.getName();
    }

    private void visitAttributeDef(AttributeDef def) throws XMLStreamException {
        this.xout.writeStartElement("ownedAttribute");
        this.xout.writeAttribute("name", def.getName());
        this.xout.writeAttribute(xmiNs, "id", this.getAttributeDefXmiId(def));
        Type type = def.getDomain();
        if (type instanceof CompositionType) {
            CompositionType composition = (CompositionType)type;
            Table part = composition.getComponentType();
            this.xout.writeAttribute("type", part.getScopedName((Container)null));
            if (def.getExtending() != null) {
                this.xout.writeAttribute("redefinedProperty", this.getAttributeDefXmiId((AttributeDef)def.getExtending()));
            }
        } else {
            String typeId = null;
            if (type instanceof TypeAlias) {
                typeId = ((TypeAlias)type).getAliasing().getScopedName(null);
            } else if (type instanceof AttributePathType) {
                typeId = idAttributePathType;
            } else if (type instanceof BlackboxType) {
                typeId = idBlackboxType;
            } else if (type instanceof CoordType) {
                typeId = idCoordinateType;
            } else if (type instanceof EnumerationType) {
                typeId = idEnumerationType;
            } else if (type instanceof EnumTreeValueType) {
                typeId = idEnumTreeValueType;
            } else if (type instanceof FormattedType) {
                typeId = idFormattedType;
            } else if (type instanceof NumericType) {
                typeId = idNumericType;
            } else if (type instanceof StructuredUnitType) {
                typeId = idFormattedType;
            } else if (type instanceof TextType) {
                typeId = idTextType;
            } else if (type instanceof BasketType) {
                typeId = idTextType;
            } else if (type instanceof ClassType) {
                typeId = idClassType;
            } else {
                if (type instanceof EnumValType) {
                    throw new IllegalStateException();
                }
                if (type instanceof PolylineType) {
                    typeId = idPolylineType;
                } else if (type instanceof SurfaceType) {
                    typeId = idSurfaceType;
                } else if (type instanceof AreaType) {
                    typeId = idAreaType;
                } else {
                    if (type instanceof MetaobjectType) {
                        throw new IllegalStateException();
                    }
                    if (type instanceof ObjectType) {
                        throw new IllegalStateException();
                    }
                    if (type instanceof OIDType) {
                        typeId = idOIDType;
                    } else {
                        if (type instanceof ReferenceType) {
                            throw new IllegalStateException("ReferenceType not yet implemented");
                        }
                        throw new IllegalStateException();
                    }
                }
            }
            this.xout.writeAttribute("type", typeId);
            if (def.getExtending() != null) {
                this.xout.writeAttribute("redefinedProperty", this.getAttributeDefXmiId((AttributeDef)def.getExtending()));
            }
        }
        Cardinality card = type.getCardinality();
        this.writeCardinality(card);
        this.xout.writeEndElement();
    }

    private void writeCardinality(Cardinality card) throws XMLStreamException {
        this.xout.writeStartElement("upperValue");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "LiteralUnlimitedNatural");
        if (card.getMaximum() == Long.MAX_VALUE) {
            this.xout.writeAttribute("value", "*");
        } else {
            this.xout.writeAttribute("value", Long.toString(card.getMaximum()));
        }
        this.xout.writeEndElement();
        this.xout.writeStartElement("lowerValue");
        this.xout.writeAttribute(xmiNs, "type", umlPfx + "LiteralInteger");
        this.xout.writeAttribute("value", Long.toString(card.getMinimum()));
        this.xout.writeEndElement();
    }

    private void applyStereotype(Element ele) {
        this.applies.add(ele);
    }

    private void writeStereotypes() throws XMLStreamException {
        String idPrefix = "ili";
        Iterator elei = this.applies.iterator();
        int id = 1;
        while (elei.hasNext()) {
            Element ele = (Element)elei.next();
            if (ele instanceof Model) {
                this.xout.writeStartElement(iliNs, "ModelDef");
                this.xout.writeAttribute(xmiNs, "id", idPrefix + UUID.randomUUID().toString());
                this.xout.writeAttribute("base_Package", ele.getScopedName(null));
                this.xout.writeEndElement();
                ++id;
                continue;
            }
            if (ele instanceof Topic) {
                this.xout.writeStartElement(iliNs, "TopicDef");
                this.xout.writeAttribute(xmiNs, "id", idPrefix + UUID.randomUUID().toString());
                this.xout.writeAttribute("base_Package", ele.getScopedName(null));
                this.xout.writeEndElement();
                ++id;
                continue;
            }
            if (!(ele instanceof Unit)) continue;
            this.xout.writeStartElement(iliNs, "UnitDef");
            this.xout.writeAttribute(xmiNs, "id", idPrefix + UUID.randomUUID().toString());
            this.xout.writeAttribute("base_Class", ele.getScopedName(null));
            this.xout.writeEndElement();
            ++id;
        }
    }
}

