/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.iligml;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.ehi.iox.objpool.impl.IomObjectSerializer;
import ch.interlis.ili2c.generator.Gml32Generator;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.ViewableProperties;
import ch.interlis.iom_j.ViewableProperty;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iom_j.itf.impl.ItfAreaPolygon2Linetable;
import ch.interlis.iom_j.xtf.Ili2cUtility;
import ch.interlis.iom_j.xtf.XtfModel;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxWriter;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.jts.Iox2jtsext;
import ch.interlis.iox_j.jts.Jtsext2iox;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Polygon;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Iligml10Writer
implements IoxWriter {
    private XMLStreamWriter xout = null;
    private ObjectPoolManager recman = null;
    private ViewableProperties mapping = null;
    private XtfModel[] xtfModels = null;
    private HashMap nameMapping = null;
    private HashSet unkClsv = new HashSet();
    private long maxOid = 0L;
    private String currentTopic = null;
    private TransferDescription td = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private String defaultCrs = "EPSG:21781";
    public static final String INTERNAL_T_ID = "_t_id";
    public static final String iligmlBase = "http://www.interlis.ch/INTERLIS2.3/GML32";
    public static final String xmlns_ili = "http://www.interlis.ch/INTERLIS2.3/GML32/INTERLIS";
    public static final String xmlns_gml = "http://www.opengis.net/gml/3.2";
    public static final String xmlns_xlink = "http://www.w3.org/1999/xlink";
    public static final String xmlns_xsi = "http://www.w3.org/2001/XMLSchema-instance";
    private static String nl = null;
    private String lastBasketNs = null;
    private int tid = 1;
    HashMap<String, Map<String, IomObject>> pools = null;

    public Iligml10Writer(OutputStreamWriter buffer, TransferDescription td) throws IoxException {
        this.td = td;
        this.init(buffer);
    }

    public Iligml10Writer(File buffer, TransferDescription td) throws IoxException {
        this.td = td;
        String encoding = "UTF-8";
        try {
            this.init(new OutputStreamWriter((OutputStream)new FileOutputStream(buffer), encoding));
        }
        catch (UnsupportedEncodingException ex) {
            throw new IoxException((Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void init(OutputStreamWriter buffer) throws IoxException {
        this.mapping = this.createMapping(this.td);
        this.nameMapping = Gml32Generator.createName2NameMapping((TransferDescription)this.td);
        this.xtfModels = Ili2cUtility.buildModelList(this.td);
        this.recman = new ObjectPoolManager();
        XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
        try {
            this.xout = outputFactory.createXMLStreamWriter(new BufferedWriter(buffer));
            String encoding = Charset.forName(buffer.getEncoding()).name();
            this.xout.writeStartDocument(encoding, "1.0");
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private ViewableProperties createMapping(TransferDescription td) {
        ViewableProperties mapping = new ViewableProperties();
        HashMap tagv = Gml32Generator.createDef2NameMapping((TransferDescription)td);
        for (Element ili2cEle : tagv.keySet()) {
            String tag = null;
            ArrayList propv = null;
            if (ili2cEle instanceof AttributeDef) {
                AttributeDef attr = (AttributeDef)ili2cEle;
                tag = ili2cEle.getContainer().getScopedName(null) + "." + ili2cEle.getName();
                propv = Ili2cUtility.mapLinetable(attr);
            } else if (ili2cEle instanceof Viewable) {
                propv = new ArrayList();
                Viewable v = (Viewable)ili2cEle;
                tag = v.getScopedName(null);
                Iterator iter = v.getAttributesAndRoles2();
                while (iter.hasNext()) {
                    ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                    ViewableProperty prop = Ili2cUtility.mapViewableTransferElement(v, obj);
                    propv.add(prop);
                }
            }
            if (tag == null) continue;
            mapping.defineClass(tag, propv.toArray(new ViewableProperty[propv.size()]));
        }
        return mapping;
    }

    public XMLStreamWriter getXout() {
        return this.xout;
    }

    public void close() throws IoxException {
        this.flush();
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.xout = null;
        }
        if (this.pools != null) {
            this.pools.clear();
            this.pools = null;
        }
        if (this.recman != null) {
            this.recman.close();
        }
        this.recman = null;
    }

    public void flush() throws IoxException {
        if (this.xout != null) {
            try {
                this.xout.flush();
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
        }
    }

    public void newline() throws IoxException {
        if (nl == null) {
            nl = System.getProperty("line.separator");
        }
        try {
            this.xout.writeCharacters(nl);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeStartTransfer(String sender, String comment, XtfModel[] models) throws IoxException {
        try {
            this.xout.setPrefix("ili", xmlns_ili);
            this.xout.writeStartElement(xmlns_ili, "TRANSFER");
            this.xout.writeNamespace("ili", xmlns_ili);
            this.xout.writeNamespace("gml", xmlns_gml);
            this.xout.setPrefix("gml", xmlns_gml);
            this.xout.writeNamespace("xlink", xmlns_xlink);
            this.xout.setPrefix("xlink", xmlns_xlink);
            this.xout.writeNamespace("xsi", xmlns_xsi);
            this.xout.setPrefix("xsi", xmlns_xsi);
            for (int i = 0; i < models.length; ++i) {
                XtfModel model = models[i];
                if (i + 1 == models.length) {
                    this.xout.writeDefaultNamespace("http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                    this.xout.setDefaultNamespace("http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                    continue;
                }
                this.xout.writeNamespace(model.getName(), "http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
                this.xout.setPrefix(model.getName(), "http://www.interlis.ch/INTERLIS2.3/GML32/" + model.getName());
            }
            this.xout.writeAttribute(xmlns_gml, "id", this.getNewTid());
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeEndTransfer() throws IoxException {
        try {
            this.xout.writeEndElement();
            this.xout.writeEndDocument();
            this.xout.flush();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        this.xout = null;
    }

    private void writeStartBasket(String type, String bid) throws IoxException {
        this.writeStartBasket(type, bid, 0, 0, null, null, null);
    }

    private void writeStartBasket(String type, String bid, int consistency, int kind, String startstate, String endstate, String[] topicv) throws IoxException {
        this.pools = new HashMap();
        this.currentTopic = type;
        try {
            this.xout.writeStartElement(xmlns_ili, "baskets");
            this.newline();
            this.lastBasketNs = this.getXmlNs(type);
            this.xout.writeStartElement(this.lastBasketNs, this.getXmlName(type));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(bid));
            if (kind != 0 && kind != 2) {
                throw new IllegalArgumentException();
            }
            if (consistency != 0) {
                throw new IllegalArgumentException();
            }
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeEndBasket() throws IoxException {
        String modelName = null;
        String topicName = null;
        int mdlNameSep = this.currentTopic.indexOf(46);
        modelName = this.currentTopic.substring(0, mdlNameSep);
        topicName = this.currentTopic.substring(mdlNameSep + 1);
        this.flushBasket(modelName, topicName);
        for (Map<String, IomObject> m : this.pools.values()) {
            m.clear();
        }
        this.pools = null;
        try {
            this.xout.writeEndElement();
            this.newline();
            this.xout.writeEndElement();
            this.newline();
            this.lastBasketNs = null;
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void flushBasket(String modelName, String topicName) throws IoxException {
        ArrayList itftablev = ModelUtilities.getItfTables(this.td, modelName, topicName);
        for (Object tableo : itftablev) {
            IomObject iomObj;
            Map<String, IomObject> pool;
            if (!(tableo instanceof Viewable)) continue;
            Viewable table = (Viewable)tableo;
            String tableQName = table.getScopedName(null);
            ArrayList<AttributeDef> areaAttrs = new ArrayList<AttributeDef>();
            this.getPolygonAttrs(table, areaAttrs);
            if (areaAttrs.size() == 0) {
                pool = this.getObjectPool(tableQName);
                for (String objId : pool.keySet()) {
                    iomObj = pool.get(objId);
                    this.writeInternalObject(iomObj);
                }
                continue;
            }
            for (AttributeDef attr : areaAttrs) {
                String attrName = attr.getName();
                String lineTableName = tableQName + "." + attrName;
                EhiLogger.logState((String)("build linetable " + lineTableName + "..."));
                ItfAreaPolygon2Linetable allLines = new ItfAreaPolygon2Linetable(tableQName, this.recman);
                Map<String, IomObject> pool2 = this.getObjectPool(tableQName);
                for (String poolId : pool2.keySet()) {
                    IomObject iomObj2 = pool2.get(poolId);
                    String mainObjTid = iomObj2.getobjectoid();
                    IomObject iomPolygon = iomObj2.getattrobj(attrName, 0);
                    if (iomPolygon == null) continue;
                    String internalTid = iomObj2.getattrvalue(INTERNAL_T_ID);
                    ArrayList<IomObject> lines = ItfAreaPolygon2Linetable.getLinesFromPolygon(iomPolygon);
                    allLines.addLines(mainObjTid, internalTid, lines);
                }
                for (IomObject line : allLines.getLines()) {
                    Iom_jObject lineTableObj = new Iom_jObject(lineTableName, Long.toString(++this.maxOid));
                    String iomAttrName = ModelUtilities.getHelperTableGeomAttrName(attr);
                    lineTableObj.addattrobj(iomAttrName, line);
                    this.writeInternalObject(lineTableObj);
                }
            }
            pool = this.getObjectPool(tableQName);
            for (String poolId : pool.keySet()) {
                iomObj = pool.get(poolId);
                for (AttributeDef attr : areaAttrs) {
                    String attrName = attr.getName();
                    IomObject iomPolygon = iomObj.getattrobj(attrName, 0);
                    if (iomPolygon == null) continue;
                    Polygon polygon = Iox2jtsext.surface2JTS(iomPolygon, 0.0);
                    Coordinate geoRef = polygon.getInteriorPoint().getCoordinate();
                    iomObj.changeattrobj(attrName, 0, Jtsext2iox.JTS2coord(geoRef));
                }
                this.writeInternalObject(iomObj);
            }
        }
    }

    private void writeObject(IomObject iomObj) throws IoxException {
        String currentTid = iomObj.getobjectoid();
        String iliQName = iomObj.getobjecttag();
        Map<String, IomObject> pool = this.getObjectPool(iliQName);
        if (pool.containsKey(currentTid)) {
            throw new IoxException("duplicate tid " + currentTid + " in " + iliQName);
        }
        pool.put(currentTid, iomObj);
        try {
            int tidInt = Integer.parseInt(currentTid);
            if ((long)tidInt > this.maxOid) {
                this.maxOid = tidInt;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void writeInternalObject(IomObject iomObj) throws IoxException {
        String currentTid = iomObj.getobjectoid();
        String iliQName = iomObj.getobjecttag();
        try {
            this.xout.writeStartElement(this.lastBasketNs, "member");
            this.xout.writeStartElement(this.getXmlNs(iliQName), this.getXmlName(iliQName));
            this.xout.writeAttribute(xmlns_gml, "id", this.makeOid(currentTid));
            this.writeObjAttrs(iomObj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
            this.newline();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeObjAttrs(IomObject obj) throws IoxException {
        String tag = obj.getobjecttag();
        if (this.mapping != null && this.mapping.existsClass(tag)) {
            ViewableProperty[] attrv = this.mapping.getClassVProperties(tag);
            for (int i = 0; i < attrv.length; ++i) {
                this.writeObjAttr(obj, attrv[i]);
            }
        } else {
            if (!this.unkClsv.contains(tag)) {
                EhiLogger.logError((String)("unknown class " + tag));
                this.unkClsv.add(tag);
            }
            for (int i = 0; i < obj.getattrcount(); ++i) {
                this.writeObjAttr(obj, new ViewableProperty(obj.getattrname(i)));
            }
        }
    }

    private void writeObjAttr(IomObject obj, ViewableProperty attr) throws IoxException {
        block29: {
            String xmlns_attr = this.getXmlNs(obj.getobjecttag());
            String baseAttrInClass = attr.getBaseDefInClass();
            if (baseAttrInClass != null) {
                xmlns_attr = this.getXmlNs(baseAttrInClass);
            }
            String attrName = attr.getName();
            try {
                int valueCount = obj.getattrvaluecount(attrName);
                if (valueCount <= 0) break block29;
                String val = obj.getattrprim(attrName, 0);
                if (val == null) {
                    boolean isRef;
                    IomObject child = obj.getattrobj(attrName, 0);
                    if (child == null) break block29;
                    if (child.getobjecttag().equals("COORD")) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        this.writeCoord(child, this.getDefaultCrs());
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one COORD value allowed (" + attrName + ")");
                        }
                        break block29;
                    }
                    if (child.getobjecttag().equals("POLYLINE")) {
                        if (attrName.startsWith("_itf_geom_")) {
                            this.xout.writeStartElement(xmlns_attr, "geometry");
                        } else {
                            this.xout.writeStartElement(xmlns_attr, attrName);
                        }
                        this.writePolyline(child, false, this.getDefaultCrs());
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one POLYLINE value allowed (" + attrName + ")");
                        }
                        break block29;
                    }
                    if (child.getobjecttag().equals("MULTISURFACE")) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        this.writeSurface(child, this.getDefaultCrs());
                        this.xout.writeEndElement();
                        if (valueCount > 1) {
                            throw new IoxException("max one MULTISURFACE value allowed (" + attrName + ")");
                        }
                        break block29;
                    }
                    String aref = child.getobjectrefoid();
                    boolean bl = isRef = aref != null;
                    if (isRef) {
                        String orderpos = null;
                        if (child.getobjectreforderpos() > 0L) {
                            orderpos = Long.toString(child.getobjectreforderpos());
                        }
                        String extref = null;
                        String bid = child.getobjectrefbid();
                        if (bid != null) {
                            extref = aref;
                            aref = null;
                        }
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        if (aref != null) {
                            this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(aref));
                        } else {
                            this.xout.writeAttribute(xmlns_xlink, "href", "#" + this.makeOid(extref));
                        }
                        this.writeAttributeStringOptional(xmlns_ili, "ORDER_POS", orderpos);
                        this.xout.writeEndElement();
                        if (child.getattrcount() > 0) {
                            this.xout.writeStartElement(xmlns_attr, attrName + "." + "LINK_DATA");
                            String structType = child.getobjecttag();
                            String structTid = child.getobjectoid();
                            if (structTid == null) {
                                structTid = this.getNewTid();
                            }
                            this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                            this.xout.writeAttribute(xmlns_gml, "id", structTid);
                            this.writeObjAttrs(child);
                            this.xout.writeEndElement();
                            this.xout.writeEndElement();
                        }
                        if (valueCount > 1) {
                            throw new IoxException("max one reference value allowed (" + attrName + ")");
                        }
                        break block29;
                    }
                    int valuei = 0;
                    while (true) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        String structType = child.getobjecttag();
                        String structTid = child.getobjectoid();
                        if (structTid == null) {
                            structTid = this.getNewTid();
                        }
                        this.xout.writeStartElement(this.getXmlNs(structType), this.getXmlName(structType));
                        this.xout.writeAttribute(xmlns_gml, "id", structTid);
                        this.writeObjAttrs(child);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        if (++valuei < valueCount) {
                            child = obj.getattrobj(attrName, valuei);
                            continue;
                        }
                        break block29;
                        break;
                    }
                }
                if (attr.getEnumType() != null && !attr.isTypeFinal()) {
                    if ((val = StringUtility.purge((String)val)) != null) {
                        this.xout.writeStartElement(xmlns_attr, attrName);
                        String type = attr.getEnumType();
                        String codeSpace = null;
                        int pos = type.lastIndexOf(58);
                        if (pos > 0) {
                            String enumAttrDef = type.substring(pos + 1);
                            type = type.substring(0, pos);
                            codeSpace = this.getXmlNs(type) + "/" + this.getXmlName(type) + "/" + enumAttrDef;
                        } else {
                            codeSpace = this.getXmlNs(type) + "/" + this.getXmlName(type);
                        }
                        this.xout.writeAttribute("codeSpace", codeSpace);
                        this.xout.writeCharacters(val);
                        this.xout.writeEndElement();
                    }
                } else {
                    this.writeElementStringOptional(xmlns_attr, attrName, val);
                }
                if (valueCount > 1) {
                    throw new IoxException("max one primitive-type value allowed (" + attrName + ")");
                }
            }
            catch (XMLStreamException ex) {
                throw new IoxException((Throwable)ex);
            }
        }
    }

    private void writeCoord(IomObject obj, String srs) throws IoxException {
        try {
            this.xout.writeStartElement(xmlns_gml, "Point");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "pos");
            this.writePosContent(obj);
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writePosContent(IomObject obj) throws XMLStreamException {
        String c1 = obj.getattrprim("C1", 0);
        this.xout.writeCharacters(c1);
        String c2 = obj.getattrprim("C2", 0);
        if (c2 != null) {
            this.xout.writeCharacters(" ");
            this.xout.writeCharacters(c2);
            String c3 = obj.getattrprim("C3", 0);
            if (c3 != null) {
                this.xout.writeCharacters(" ");
                this.xout.writeCharacters(c3);
            }
        }
    }

    private void writePolyline(IomObject obj, boolean hasLineAttr, String srs) throws IoxException {
        try {
            boolean clipped;
            IomObject lineattr;
            this.xout.writeStartElement(xmlns_gml, "Curve");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            this.xout.writeStartElement(xmlns_gml, "segments");
            if (hasLineAttr && (lineattr = obj.getattrobj("lineattr", 0)) != null) {
                this.xout.writeStartElement(xmlns_ili, "LINEATTR");
                this.xout.writeStartElement(xmlns_ili, lineattr.getobjecttag());
                this.writeObjAttrs(lineattr);
                this.xout.writeEndElement();
                this.xout.writeEndElement();
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped polyline not supported");
            }
            for (int sequencei = 0; sequencei < obj.getattrvaluecount("sequence"); ++sequencei) {
                if (!clipped && sequencei > 0) {
                    throw new IllegalArgumentException("unclipped polyline with multi 'sequence' elements");
                }
                IomObject sequence = obj.getattrobj("sequence", sequencei);
                int segmentc = sequence.getattrvaluecount("segment");
                for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                    IomObject lastSegment;
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    if (segment.getobjecttag().equals("COORD")) {
                        if (segmenti == 0 && !sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) continue;
                        if (segmenti == 0 || !sequence.getattrobj("segment", segmenti - 1).getobjecttag().equals("COORD")) {
                            this.xout.writeStartElement(xmlns_gml, "LineStringSegment");
                            this.xout.writeAttribute("interpolation", "linear");
                            this.xout.writeStartElement(xmlns_gml, "posList");
                            if (segmenti > 0) {
                                lastSegment = sequence.getattrobj("segment", segmenti - 1);
                                this.writePosContent(lastSegment);
                                this.xout.writeCharacters(" ");
                            }
                        } else {
                            this.xout.writeCharacters(" ");
                        }
                        this.writePosContent(segment);
                        if (segmenti + 1 != segmentc && sequence.getattrobj("segment", segmenti + 1).getobjecttag().equals("COORD")) continue;
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        continue;
                    }
                    if (segment.getobjecttag().equals("ARC")) {
                        this.xout.writeStartElement(xmlns_gml, "Arc");
                        this.xout.writeAttribute("numArc", "1");
                        this.xout.writeAttribute("interpolation", "circularArc3Points");
                        this.xout.writeStartElement(xmlns_gml, "posList");
                        lastSegment = sequence.getattrobj("segment", segmenti - 1);
                        this.writePosContent(lastSegment);
                        this.xout.writeCharacters(" ");
                        String a1 = segment.getattrprim("A1", 0);
                        String a2 = segment.getattrprim("A2", 0);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a1);
                        this.xout.writeCharacters(" ");
                        this.xout.writeCharacters(a2);
                        this.xout.writeCharacters(" ");
                        this.writePosContent(segment);
                        this.xout.writeEndElement();
                        this.xout.writeEndElement();
                        continue;
                    }
                    throw new IoxException("custum line form not supported (" + segment.getobjecttag() + ")");
                }
            }
            this.xout.writeEndElement();
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeSurface(IomObject obj, String srs) throws IoxException {
        try {
            boolean clipped;
            this.xout.writeStartElement(xmlns_gml, "Polygon");
            String structTid = obj.getobjectoid();
            if (structTid == null) {
                structTid = this.getNewTid();
            }
            this.xout.writeAttribute(xmlns_gml, "id", structTid);
            if (srs != null) {
                this.xout.writeAttribute("srsName", srs);
            }
            boolean bl = clipped = obj.getobjectconsistency() == 1;
            if (clipped) {
                throw new IoxException("clipped surface not supported");
            }
            for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
                if (!clipped && surfacei > 0) {
                    throw new IllegalArgumentException("unclipped surface with multi 'surface' elements");
                }
                IomObject surface = obj.getattrobj("surface", surfacei);
                for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                    IomObject boundary = surface.getattrobj("boundary", boundaryi);
                    if (boundaryi == 0) {
                        this.xout.writeStartElement(xmlns_gml, "exterior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    } else {
                        this.xout.writeStartElement(xmlns_gml, "interior");
                        this.xout.writeStartElement(xmlns_gml, "Ring");
                    }
                    for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                        IomObject polyline = boundary.getattrobj("polyline", polylinei);
                        this.xout.writeStartElement(xmlns_gml, "curveMember");
                        this.writePolyline(polyline, true, null);
                        this.xout.writeEndElement();
                    }
                    this.xout.writeEndElement();
                    this.xout.writeEndElement();
                }
            }
            this.xout.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeElementStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeStartElement(nsuri, name);
                this.xout.writeCharacters(v);
                this.xout.writeEndElement();
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void writeAttributeStringOptional(String nsuri, String name, String value) throws IoxException {
        try {
            String v;
            if (value != null && (v = value.trim()).length() > 0) {
                this.xout.writeAttribute(nsuri, name, v);
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private String getXmlNs(String type) {
        int pos = type.indexOf(46);
        String ret = "http://www.interlis.ch/INTERLIS2.3/GML32/" + type.substring(0, pos);
        return ret;
    }

    private String getXmlName(String type) {
        if (!this.nameMapping.containsKey(type)) {
            throw new IllegalArgumentException();
        }
        String ret = (String)this.nameMapping.get(type);
        return ret;
    }

    private String makeOid(String value) {
        String v;
        if (value != null && (v = value.trim()).length() > 0) {
            if (Character.isDigit(v.charAt(0))) {
                return "x" + v;
            }
            return v;
        }
        return null;
    }

    private String getNewTid() {
        return "iox" + Integer.toString(this.tid++);
    }

    private Map<String, IomObject> getObjectPool(String classQName) throws IoxException {
        Map<String, IomObject> m = null;
        m = this.pools.get(classQName);
        if (m == null) {
            m = this.recman.newObjectPool(this.getClass().getSimpleName(), new IomObjectSerializer());
            this.pools.put(classQName, m);
        }
        return m;
    }

    private void getPolygonAttrs(Viewable aclass, ArrayList<AttributeDef> attrs_areaAttrs) {
        Iterator attri = aclass.getAttributes();
        while (attri.hasNext()) {
            AttributeDef attr;
            Type type;
            Object attrObj = attri.next();
            if (!(attrObj instanceof AttributeDef) || !((type = Type.findReal((Type)(attr = (AttributeDef)attrObj).getDomain())) instanceof AreaType)) continue;
            attrs_areaAttrs.add(attr);
        }
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection arg0) throws IoxException {
        this.factory = this.factory;
    }

    public void write(IoxEvent event) throws IoxException {
        if (event instanceof StartTransferEvent) {
            StartTransferEvent e = (StartTransferEvent)event;
            this.writeStartTransfer(e.getSender(), e.getComment(), this.xtfModels);
        } else if (event instanceof StartBasketEvent) {
            StartBasketEvent e = (StartBasketEvent)event;
            this.writeStartBasket(e.getType(), e.getBid(), e.getConsistency(), e.getKind(), e.getStartstate(), e.getEndstate(), e.getTopicv());
        } else if (event instanceof ObjectEvent) {
            ObjectEvent e = (ObjectEvent)event;
            this.writeObject(e.getIomObject());
        } else if (event instanceof EndBasketEvent) {
            this.writeEndBasket();
        } else if (event instanceof EndTransferEvent) {
            this.writeEndTransfer();
        } else {
            throw new IoxException("unknown event type " + event.getClass().getName());
        }
    }

    public void setDefaultCrs(String defaultCrs) {
        this.defaultCrs = defaultCrs;
    }

    public String getDefaultCrs() {
        return this.defaultCrs;
    }
}

