/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator;

import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Value {
    private boolean booleanIsDefined = false;
    private boolean booleanValue;
    private double numeric = 0.0;
    private boolean numericIsDefined = false;
    private Type type = null;
    private String value = null;
    private String[] values = null;
    private String refTypeName;
    private List<IomObject> complexObjects;
    private RoleDef role = null;
    private String oid = null;
    private Viewable viewable = null;
    private boolean notYetImplemented = false;
    private boolean error = false;

    public Value(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.booleanIsDefined = true;
    }

    public Value(double numeric) {
        this.numeric = numeric;
        this.numericIsDefined = true;
    }

    public Value(Viewable viewable) {
        this.viewable = viewable;
    }

    public static Value createOidValue(String oid) {
        Value ret = new Value();
        ret.oid = oid;
        return ret;
    }

    public Value(Type type, String valueStr) {
        this.value = valueStr;
        this.type = type;
    }

    public Value(Type type, String[] valueStr) {
        if (valueStr.length == 1) {
            this.value = valueStr[0];
        } else {
            this.values = valueStr;
        }
        this.type = type;
    }

    public Value(List<IomObject> complexObjects) {
        this.complexObjects = complexObjects;
    }

    public Value(RoleDef role) {
        this.role = role;
    }

    private Value() {
    }

    public Value(Type type, String valueStr, String refTypeName) {
        this.value = valueStr;
        this.type = type;
        this.refTypeName = refTypeName;
    }

    public boolean isTrue() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.booleanValue;
    }

    public String getRefTypeName() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.refTypeName;
    }

    public Viewable getViewable() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.viewable;
    }

    public Type getType() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.type;
    }

    public String getOid() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.oid;
    }

    public String getValue() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        if (this.numericIsDefined) {
            return Double.toString(this.numeric);
        }
        if (this.oid != null) {
            return this.oid;
        }
        if (this.booleanIsDefined) {
            return this.booleanValue ? "true" : "false";
        }
        return this.value;
    }

    public String[] getValues() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.values;
    }

    public double getNumeric() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        if (this.isUndefined()) {
            throw new IllegalArgumentException();
        }
        if (this.numericIsDefined) {
            return this.numeric;
        }
        String val = this.getValue();
        if (val == null) {
            throw new IllegalArgumentException();
        }
        return Double.parseDouble(val);
    }

    public RoleDef getRole() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.role;
    }

    public Collection<IomObject> getComplexObjects() {
        if (this.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        return this.complexObjects;
    }

    public static Value createUndefined() {
        return new Value((List<IomObject>)null);
    }

    public boolean isUndefined() {
        return this.getValue() == null && this.getComplexObjects() == null && !this.booleanIsDefined && this.getRole() == null && this.oid == null && !this.numericIsDefined && this.getViewable() == null && this.getValues() == null;
    }

    public static Value createSkipEvaluation() {
        Value ret = new Value();
        ret.error = true;
        return ret;
    }

    public boolean isNotYetImplemented() {
        return this.notYetImplemented;
    }

    public static Value createNotYetImplemented() {
        Value ret = new Value();
        ret.notYetImplemented = true;
        return ret;
    }

    public boolean skipEvaluation() {
        if (this.notYetImplemented) {
            return this.notYetImplemented;
        }
        return this.error;
    }

    public double compareTo(Value other) {
        if (this.skipEvaluation() || other.skipEvaluation()) {
            throw new IllegalArgumentException();
        }
        if (this.complexObjects != null && other.complexObjects != null) {
            for (IomObject iomObj : this.complexObjects) {
                Iterator<IomObject> iterator = other.complexObjects.iterator();
                if (!iterator.hasNext()) continue;
                IomObject iomObjOther = iterator.next();
                if (iomObj.getobjecttag().equals("COORD") && iomObjOther.getobjecttag().equals("COORD") || iomObj.getobjecttag().equals("ARC") && iomObjOther.getobjecttag().equals("ARC")) {
                    return this.compareCoordsTo(iomObj, iomObjOther);
                }
                if (iomObj.getobjecttag().equals("POLYLINE") && iomObjOther.getobjecttag().equals("POLYLINE")) {
                    return this.comparePolylineTo(iomObj, iomObjOther);
                }
                if (iomObj.getobjecttag().equals("MULTISURFACE") && iomObjOther.getobjecttag().equals("MULTISURFACE")) {
                    return this.compareSurfaceOrAreaTo(iomObj, iomObjOther);
                }
                return this.compareIomObjTo(iomObj, iomObjOther);
            }
        }
        if (this.values != null && other.values != null) {
            if (this.values.length != other.values.length) {
                return -1.0;
            }
            for (int i = 0; i < this.values.length; ++i) {
                int result = this.compareSimpleValue(this.values[i], other.values[i]);
                if (result == 0) continue;
                return result;
            }
            return 0.0;
        }
        if (this.value != null && other.value != null) {
            if (this.type instanceof NumericType) {
                return Double.valueOf(this.value).compareTo(Double.valueOf(other.value));
            }
            if (this.type instanceof TextType) {
                return this.value.compareTo(other.value);
            }
            if (this.type instanceof FormattedType) {
                return this.value.compareTo(other.value);
            }
            if (this.type instanceof EnumerationType) {
                EnumerationType enumeration = (EnumerationType)this.type;
                if (enumeration.isOrdered() && !enumeration.isCircular()) {
                    int thisIndex = enumeration.getValues().indexOf(this.value);
                    int otherIndex = enumeration.getValues().indexOf(other.value);
                    return this.compareDouble(thisIndex, otherIndex);
                }
                return this.value.compareTo(other.value);
            }
            if (this.type instanceof EnumTreeValueType) {
                EnumTreeValueType enumerationTree = (EnumTreeValueType)this.type;
                EnumerationType enumeration = (EnumerationType)enumerationTree.getEnumType().getType();
                if (enumeration.isOrdered() && !enumeration.isCircular()) {
                    int thisIndex = enumeration.getValues().indexOf(this.value);
                    int otherIndex = enumeration.getValues().indexOf(other.value);
                    return this.compareDouble(thisIndex, otherIndex);
                }
                return this.value.compareTo(other.value);
            }
        } else {
            if (this.numericIsDefined && other.numericIsDefined) {
                return this.compareDouble(this.numeric, other.numeric);
            }
            if (this.numericIsDefined && other.value != null) {
                return this.compareDouble(this.numeric, Double.valueOf(other.value));
            }
            if (this.value != null && other.numericIsDefined) {
                return this.compareDouble(Double.valueOf(this.value), other.numeric);
            }
            if (this.oid != null && other.oid != null) {
                return this.compareOid(this.oid, other.oid);
            }
            if (this.viewable != null && other.viewable != null) {
                return this.compareViewable(this.viewable, other.viewable);
            }
            if (this.value == null && other.value == null) {
                return this.compareBoolean(this.booleanValue, other.booleanValue);
            }
        }
        throw new IllegalArgumentException("incompatible values");
    }

    private double compareIomObjTo(IomObject iomObj, IomObject iomObjOther) {
        if (iomObj.getattrcount() != iomObjOther.getattrcount()) {
            return -1.0;
        }
        if (iomObj.getobjectrefbid() != null && iomObjOther.getobjectrefbid() != null) {
            if (!iomObj.getobjectrefbid().equals(iomObjOther.getobjectrefbid())) {
                return -1.0;
            }
        } else {
            if (iomObj.getobjectrefbid() != null && iomObjOther.getobjectrefbid() == null) {
                return 1.0;
            }
            if (iomObj.getobjectrefbid() == null && iomObjOther.getobjectrefbid() != null) {
                return -1.0;
            }
        }
        if (iomObj.getobjectoid() != null && iomObjOther.getobjectoid() != null) {
            if (!iomObj.getobjectoid().equals(iomObjOther.getobjectoid())) {
                return -1.0;
            }
        } else {
            if (iomObj.getobjectoid() != null && iomObjOther.getobjectoid() == null) {
                return 1.0;
            }
            if (iomObj.getobjectoid() == null && iomObjOther.getobjectoid() != null) {
                return -1.0;
            }
        }
        if (iomObj.getobjecttag() != null && iomObjOther.getobjecttag() != null) {
            if (!iomObj.getobjecttag().equals(iomObjOther.getobjecttag())) {
                return -1.0;
            }
        } else {
            if (iomObj.getobjecttag() != null && iomObjOther.getobjecttag() == null) {
                return 1.0;
            }
            if (iomObj.getobjecttag() == null && iomObjOther.getobjecttag() != null) {
                return -1.0;
            }
        }
        for (int i = 0; i < iomObj.getattrcount(); ++i) {
            int otherCount;
            String attrNameIomObj = iomObj.getattrname(i);
            int actualCount = iomObj.getattrvaluecount(attrNameIomObj);
            if (actualCount != (otherCount = iomObjOther.getattrvaluecount(attrNameIomObj))) {
                return -1.0;
            }
            for (int j = 0; j < actualCount; ++j) {
                IomObject iomStructActual = iomObj.getattrobj(attrNameIomObj, j);
                IomObject iomStructOther = iomObjOther.getattrobj(attrNameIomObj, j);
                if (iomStructActual == null && iomStructOther == null) {
                    String attrNameValueOther;
                    String attrNameValue = iomObj.getattrvalue(attrNameIomObj);
                    if (attrNameValue.equals(attrNameValueOther = iomObjOther.getattrvalue(attrNameIomObj))) continue;
                    return -1.0;
                }
                double returnValue = this.compareIomObjTo(iomStructActual, iomStructOther);
                if (returnValue == 0.0) continue;
                return returnValue;
            }
        }
        return 0.0;
    }

    private int compareSimpleValue(String thisValue, String otherValue) {
        if (thisValue != null && otherValue != null || !thisValue.isEmpty() && !otherValue.isEmpty()) {
            if (!thisValue.equals(otherValue)) {
                return -1;
            }
        } else {
            if (thisValue != null && otherValue == null || !thisValue.isEmpty() && otherValue.isEmpty()) {
                return 1;
            }
            if (thisValue == null && otherValue != null || thisValue.isEmpty() && !otherValue.isEmpty()) {
                return -1;
            }
        }
        return 0;
    }

    private int compareViewable(Viewable viewable2, Viewable viewable3) {
        return viewable3.equals(viewable2) ? 0 : (!viewable3.equals(viewable2) ? 1 : -1);
    }

    private int compareBoolean(boolean thisValue, boolean otherValue) {
        return otherValue == thisValue ? 0 : (thisValue ? 1 : -1);
    }

    private double compareDouble(double thisVal, double anotherVal) {
        return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
    }

    private int compareOid(String oid1, String oid2) {
        return oid1.equals(oid2) ? 0 : -1;
    }

    private int compareSurfaceOrAreaTo(IomObject complexValue2, IomObject iomObjOther2) {
        for (int l = 0; l < complexValue2.getattrvaluecount("surface"); ++l) {
            IomObject thisSurfaceValue = complexValue2.getattrobj("surface", l);
            IomObject otherSurfaceValue = iomObjOther2.getattrobj("surface", l);
            for (int m = 0; m < thisSurfaceValue.getattrvaluecount("boundary"); ++m) {
                IomObject thisBoundaryValue = thisSurfaceValue.getattrobj("boundary", m);
                IomObject otherBoundaryValue = otherSurfaceValue.getattrobj("boundary", m);
                for (int n = 0; n < thisBoundaryValue.getattrvaluecount("polyline"); ++n) {
                    IomObject otherPolylineValue;
                    IomObject thisPolylineValue = thisBoundaryValue.getattrobj("polyline", n);
                    if (this.comparePolylineTo(thisPolylineValue, otherPolylineValue = otherBoundaryValue.getattrobj("polyline", n)) == 0) continue;
                    return this.comparePolylineTo(thisPolylineValue, otherPolylineValue);
                }
            }
        }
        return 0;
    }

    private int comparePolylineTo(IomObject iomObj, IomObject iomObjOther) {
        for (int l = 0; l < iomObj.getattrvaluecount("sequence"); ++l) {
            IomObject thisSegmentsValue = iomObj.getattrobj("sequence", l);
            IomObject otherSegmentsValue = iomObjOther.getattrobj("sequence", l);
            for (int m = 0; m < thisSegmentsValue.getattrvaluecount("segment"); ++m) {
                IomObject otherCoord;
                IomObject thisCoord = thisSegmentsValue.getattrobj("segment", m);
                if (this.compareCoordsTo(thisCoord, otherCoord = otherSegmentsValue.getattrobj("segment", m)) == 0) continue;
                return this.compareCoordsTo(thisCoord, otherCoord);
            }
        }
        return 0;
    }

    private int compareCoordsTo(IomObject complexValue, IomObject iomObjOther) {
        if (complexValue.getattrvalue("C1") != null && iomObjOther.getattrvalue("C1") != null && complexValue.getattrvalue("C1").compareTo(iomObjOther.getattrvalue("C1")) != 0) {
            return complexValue.getattrvalue("C1").compareTo(iomObjOther.getattrvalue("C1"));
        }
        if (complexValue.getattrvalue("C2") != null && iomObjOther.getattrvalue("C2") != null && complexValue.getattrvalue("C2").compareTo(iomObjOther.getattrvalue("C2")) != 0) {
            return complexValue.getattrvalue("C2").compareTo(iomObjOther.getattrvalue("C2"));
        }
        if (complexValue.getattrvalue("C3") != null && iomObjOther.getattrvalue("C3") != null && complexValue.getattrvalue("C3").compareTo(iomObjOther.getattrvalue("C3")) != 0) {
            return complexValue.getattrvalue("C3").compareTo(iomObjOther.getattrvalue("C3"));
        }
        if (complexValue.getattrvalue("A1") != null && iomObjOther.getattrvalue("A1") != null && complexValue.getattrvalue("A1").compareTo(iomObjOther.getattrvalue("A1")) != 0) {
            return complexValue.getattrvalue("A1").compareTo(iomObjOther.getattrvalue("A1"));
        }
        if (complexValue.getattrvalue("A2") != null && iomObjOther.getattrvalue("A2") != null && complexValue.getattrvalue("A2").compareTo(iomObjOther.getattrvalue("A2")) != 0) {
            return complexValue.getattrvalue("A2").compareTo(iomObjOther.getattrvalue("A2"));
        }
        return 0;
    }
}

