/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen.generator_impl.jdbc;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.sqlgen.DbUtility;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import java.io.IOException;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

public class GeneratorGeoPackage
extends GeneratorJdbc {
    private boolean createGeomIdx = false;
    private String today = "";
    private ArrayList<DbColumn> indexColumns = null;
    private ArrayList<DbColGeometry> geomColumns = null;
    private ArrayList<DbColJson> jsonColumns = null;
    private ArrayList<DbColumn> arrayColumns = null;
    private DbColumn primaryKeyColumn = null;
    private StringWriter totalScript = null;

    @Override
    public void visitSchemaBegin(Settings config, DbSchema schema) throws IOException {
        super.visitSchemaBegin(config, schema);
        this.today = new SimpleDateFormat("yyy-MM-dd'T'HH:mm:ss.S'Z'").format(new Date());
        if ("True".equals(config.getValue("ch.ehi.sqlgen.createGeomIndex"))) {
            this.createGeomIdx = true;
        }
        this.totalScript = new StringWriter();
    }

    @Override
    public void visitColumn(DbTable dbTab, DbColumn column) throws IOException {
        String constraintName;
        String constraintAction;
        String type = "";
        String createConstraintStmt = "";
        if (column instanceof DbColBoolean) {
            type = "BOOLEAN";
        } else if (column instanceof DbColDateTime) {
            type = "DATETIME";
        } else if (column instanceof DbColDate) {
            type = "DATE";
        } else if (column instanceof DbColTime) {
            type = "TIME";
        } else if (column instanceof DbColDecimal) {
            DbColDecimal col = (DbColDecimal)column;
            type = "DOUBLE";
            constraintAction = null;
            if (col.getMaxValue() != null || col.getMinValue() != null) {
                constraintAction = col.getMaxValue() == null ? ">=" + col.getMinValue() : (col.getMinValue() == null ? "<=" + col.getMaxValue() : "BETWEEN " + col.getMinValue() + " AND " + col.getMaxValue());
            }
            if (constraintAction != null) {
                constraintName = this.createConstraintName(dbTab, "check", col.getName());
                createConstraintStmt = " CONSTRAINT " + constraintName + " CHECK( " + col.getName() + " " + constraintAction + ")";
            }
        } else if (column instanceof DbColGeometry) {
            if (column.getArraySize() != 0) {
                throw new UnsupportedOperationException();
            }
            this.geomColumns.add((DbColGeometry)column);
            type = GeneratorGeoPackage.getGpkgGeometryTypename(((DbColGeometry)column).getType());
        } else if (column instanceof DbColId) {
            type = "INTEGER";
        } else if (column instanceof DbColUuid) {
            type = "TEXT(36)";
        } else if (column instanceof DbColNumber) {
            DbColNumber col = (DbColNumber)column;
            type = "INTEGER";
            constraintAction = null;
            if (col.getMaxValue() != null || col.getMinValue() != null) {
                constraintAction = col.getMaxValue() == null ? ">=" + col.getMinValue() : (col.getMinValue() == null ? "<=" + col.getMaxValue() : "BETWEEN " + col.getMinValue() + " AND " + col.getMaxValue());
            }
            if (constraintAction != null) {
                constraintName = this.createConstraintName(dbTab, "check", col.getName());
                createConstraintStmt = " CONSTRAINT " + constraintName + " CHECK( " + col.getName() + " " + constraintAction + ")";
            }
        } else if (column instanceof DbColVarchar) {
            int colsize = ((DbColVarchar)column).getSize();
            type = colsize == -1 ? "TEXT" : "TEXT(" + Integer.toString(colsize) + ")";
            if (((DbColVarchar)column).getValueRestriction() != null) {
                DbColVarchar dbColTxt = (DbColVarchar)column;
                StringBuffer action = new StringBuffer("IN (");
                String sep = "";
                for (String restrictedValue : dbColTxt.getValueRestriction()) {
                    action.append(sep);
                    action.append("'");
                    action.append(GeneratorGeoPackage.escapeString(restrictedValue));
                    action.append("'");
                    sep = ",";
                }
                action.append(")");
                String constraintName2 = this.createConstraintName(dbTab, "check", column.getName());
                createConstraintStmt = " CONSTRAINT " + constraintName2 + " CHECK( " + column.getName() + " " + action.toString() + ")";
            }
        } else if (column instanceof DbColBlob) {
            type = "BLOB";
        } else if (column instanceof DbColXml) {
            type = "TEXT";
        } else if (column instanceof DbColJson) {
            type = "TEXT";
            this.jsonColumns.add((DbColJson)column);
        } else {
            type = "TEXT";
        }
        if (column.isIndex() || this.createGeomIdx && column instanceof DbColGeometry) {
            this.indexColumns.add(column);
        }
        if (column.getArraySize() != 0 && !(column instanceof DbColJson)) {
            String isNull = column.isNotNull() ? "NOT NULL" : "NULL";
            type = "TEXT";
            String name = column.getName();
            this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + isNull + this.newline());
            this.colSep = ",";
            this.arrayColumns.add(column);
        } else {
            String isNull;
            String string = isNull = column.isNotNull() ? "NOT NULL" : "NULL";
            if (column.isPrimaryKey()) {
                isNull = "NOT NULL PRIMARY KEY";
                this.primaryKeyColumn = column;
            }
            String sep = " ";
            String defaultValue = "";
            if (column.getDefaultValue() != null) {
                defaultValue = sep + "DEFAULT " + column.getDefaultValue();
                sep = " ";
            }
            String fkConstraint = "";
            if (column.getReferencedTable() != null) {
                String action = "";
                if (column.getOnUpdateAction() != null) {
                    action = action + " ON UPDATE " + column.getOnUpdateAction();
                }
                if (column.getOnDeleteAction() != null) {
                    action = action + " ON DELETE " + column.getOnDeleteAction();
                }
                String constraintName3 = this.createConstraintName(dbTab, "fkey", column.getName());
                fkConstraint = " CONSTRAINT " + constraintName3 + " REFERENCES " + column.getReferencedTable().getQName() + action + " DEFERRABLE INITIALLY DEFERRED";
            }
            String name = column.getName();
            this.out.write(this.getIndent() + this.colSep + name + " " + type + " " + isNull + defaultValue + fkConstraint + createConstraintStmt + this.newline());
            this.colSep = ",";
        }
    }

    @Override
    public void visit1TableBegin(DbTable tab) throws IOException {
        super.visit1TableBegin(tab);
        this.geomColumns = new ArrayList();
        this.jsonColumns = new ArrayList();
        this.arrayColumns = new ArrayList();
        this.indexColumns = new ArrayList();
    }

    @Override
    public void visitTableEndColumn(DbTable tab) throws IOException {
        Iterator<DbIndex> idxi = tab.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = idxi.next();
            if (!idx.isUnique()) continue;
            String constraintName = idx.getName();
            if (constraintName == null) {
                String[] colNames = new String[idx.sizeAttr()];
                int i = 0;
                Iterator attri = idx.iteratorAttr();
                while (attri.hasNext()) {
                    DbColumn attr = (DbColumn)attri.next();
                    colNames[i++] = attr.getName();
                }
                constraintName = this.createConstraintName(tab, "key", colNames);
            }
            this.out.write(this.getIndent() + this.colSep + "CONSTRAINT " + constraintName + " UNIQUE (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                this.out.write(sep + attr.getName());
                sep = ",";
            }
            this.out.write(")" + this.newline());
            this.colSep = ",";
        }
    }

    public void finishTable(DbTable tab) throws IOException {
        Iterator<DbIndex> idxi = tab.iteratorIndex();
        while (idxi.hasNext()) {
            DbIndex idx = idxi.next();
            if (!idx.isPrimary()) continue;
            this.out.write(this.getIndent() + this.colSep + "PRIMARY KEY (");
            String sep = "";
            Iterator attri = idx.iteratorAttr();
            while (attri.hasNext()) {
                DbColumn attr = (DbColumn)attri.next();
                this.out.write(sep + attr.getName());
                sep = ",";
            }
            this.out.write(")" + this.newline());
            this.colSep = ",";
        }
        this.dec_ind();
        String cmt = this.getTableEndOptions(tab);
        if (cmt != null) {
            this.out.write(this.getIndent() + ") " + cmt + this.newline());
        } else {
            this.out.write(this.getIndent() + ")" + this.newline());
        }
        String stmt = this.out.toString();
        this.addCreateLine(new GeneratorJdbc.Stmt(stmt));
        this.addDropLine(new GeneratorJdbc.Stmt("DROP TABLE " + tab.getName()));
        this.out = null;
        if (this.conn != null) {
            if (DbUtility.tableExists(this.conn, tab.getName())) {
                if (tab.isDeleteDataIfTableExists()) {
                    String delStmt = "DELETE FROM " + tab.getName();
                    EhiLogger.traceBackendCmd((String)delStmt);
                    this.totalScript.write(delStmt + ";" + this.newline());
                }
            } else {
                Object dbstmt = null;
                EhiLogger.traceBackendCmd((String)stmt);
                this.createdTables.add(tab.getName());
                this.totalScript.write(stmt + ";" + this.newline());
            }
        }
    }

    @Override
    public void visit1TableEnd(DbTable tab) throws IOException {
        String sqlTabName = tab.getName().getName();
        if (tab.getName().getSchema() != null) {
            sqlTabName = tab.getName().getSchema() + "." + sqlTabName;
        }
        boolean tableExists = DbUtility.tableExists(this.conn, tab.getName());
        this.finishTable(tab);
        for (int colIdx = 0; colIdx < this.geomColumns.size(); ++colIdx) {
            DbColGeometry geo = this.geomColumns.get(colIdx);
            String srsId = "(SELECT srs_id FROM gpkg_spatial_ref_sys WHERE organization='" + geo.getSrsAuth() + "' AND organization_coordsys_id=" + geo.getSrsId() + ")";
            String cmt = tab.getComment() == null ? "null" : "'" + tab.getComment() + "'";
            String stmtGeomContents = null;
            if (colIdx == 0) {
                stmtGeomContents = "INSERT INTO gpkg_contents (table_name,data_type,identifier,description,last_change,min_x,min_y,max_x,max_y,srs_id)VALUES ('" + tab.getName().getName() + "','features','" + tab.getName().getName() + "'," + cmt + ",'" + this.today + "'," + geo.getMin1() + "," + geo.getMin2() + "," + geo.getMax1() + "," + geo.getMax2() + "," + srsId + ")";
            }
            String stmtGeomCols = "INSERT INTO gpkg_geometry_columns (table_name,column_name,geometry_type_name,srs_id,z,m)VALUES ('" + tab.getName().getName() + "','" + geo.getName() + "' ,'" + GeneratorGeoPackage.getGpkgGeometryTypename(geo.getType()) + "'," + srsId + "," + (geo.getDimension() == 2 ? "0" : "1") + ",0)";
            if (colIdx == 0) {
                this.addCreateLine(new GeneratorJdbc.Stmt(stmtGeomContents));
            }
            this.addCreateLine(new GeneratorJdbc.Stmt(stmtGeomCols));
            String dropstmtGeomContents = null;
            if (colIdx == 0) {
                dropstmtGeomContents = "DELETE FROM gpkg_contents WHERE table_name='" + tab.getName().getName() + "'";
            }
            String dropstmtGeomCols = "DELETE FROM gpkg_geometry_columns WHERE table_name='" + tab.getName().getName() + "' AND column_name='" + geo.getName() + "'";
            this.addDropLine(new GeneratorJdbc.Stmt(dropstmtGeomCols));
            if (colIdx == 0) {
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmtGeomContents));
            }
            if (this.conn == null || tableExists) continue;
            if (colIdx == 0) {
                EhiLogger.traceBackendCmd((String)stmtGeomContents);
                this.totalScript.write(stmtGeomContents + ";" + this.newline());
            }
            EhiLogger.traceBackendCmd((String)stmtGeomCols);
            this.totalScript.write(stmtGeomCols + ";" + this.newline());
        }
        this.geomColumns = null;
        for (DbColJson jsonCol : this.jsonColumns) {
            this.addJsonColumn(tab, tableExists, jsonCol);
        }
        this.jsonColumns = null;
        for (DbColumn arrayCol : this.arrayColumns) {
            this.addJsonColumn(tab, tableExists, arrayCol);
        }
        this.arrayColumns = null;
        for (DbColumn idxcol : this.indexColumns) {
            if (idxcol instanceof DbColGeometry) {
                DbColGeometry geo = (DbColGeometry)idxcol;
                String primaryKey = this.primaryKeyColumn.getName();
                String stmt = "INSERT INTO gpkg_extensions (table_name,column_name,extension_name,definition,scope)VALUES ('" + tab.getName().getName() + "','" + geo.getName() + "','gpkg_rtree_index','http://www.geopackage.org/spec120/#extension_rtree','write-only')";
                this.addCreateLine(new GeneratorJdbc.Stmt(stmt));
                String dropstmt1 = "DELETE FROM gpkg_extensions WHERE table_name='" + tab.getName().getName() + "' AND column_name='" + geo.getName() + "'";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt1));
                if (this.conn != null && !tableExists) {
                    EhiLogger.traceBackendCmd((String)stmt);
                    this.totalScript.write(stmt + ";" + this.newline());
                }
                String createStmt = "CREATE VIRTUAL TABLE \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" USING rtree(id,minx,maxx,miny,maxy)";
                this.addCreateLine(new GeneratorJdbc.Stmt(createStmt));
                String dropstmt2 = "DROP TABLE \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt2));
                String populateStmt = "INSERT INTO rtree_" + tab.getName().getName() + "_" + geo.getName() + " SELECT " + primaryKey + ",ST_MinX(" + geo.getName() + "),ST_MaxX(" + geo.getName() + "),ST_MinY(" + geo.getName() + "),ST_MaxY(" + geo.getName() + ") FROM " + tab.getName().getName() + " WHERE " + geo.getName() + " NOT NULL AND NOT ST_IsEmpty(" + geo.getName() + ")";
                this.addCreateLine(new GeneratorJdbc.Stmt(populateStmt));
                String triggerStmt1 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_insert\" AFTER INSERT ON \"" + tab.getName().getName() + "\" WHEN (NEW.\"" + geo.getName() + "\" NOT NULL AND NOT ST_IsEmpty(NEW.\"" + geo.getName() + "\")) BEGIN INSERT OR REPLACE INTO \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" VALUES (NEW.\"" + primaryKey + "\",ST_MinX(NEW.\"" + geo.getName() + "\"),ST_MaxX(NEW.\"" + geo.getName() + "\"),ST_MinY(NEW.\"" + geo.getName() + "\"),ST_MaxY(NEW.\"" + geo.getName() + "\")); END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt1));
                String dropstmt3 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_insert\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt3));
                String triggerStmt2 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update1\" AFTER UPDATE OF \"" + geo.getName() + "\" ON \"" + tab.getName().getName() + "\" WHEN OLD.\"" + primaryKey + "\" = NEW.\"" + primaryKey + "\" AND (NEW.\"" + geo.getName() + "\" NOTNULL AND NOT ST_IsEmpty(NEW.\"" + geo.getName() + "\")) BEGIN INSERT OR REPLACE INTO \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" VALUES (NEW.\"" + primaryKey + "\",ST_MinX(NEW.\"" + geo.getName() + "\"),ST_MaxX(NEW.\"" + geo.getName() + "\"),ST_MinY(NEW.\"" + geo.getName() + "\"),ST_MaxY(NEW.\"" + geo.getName() + "\")); END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt2));
                String dropstmt4 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update1\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt4));
                String triggerStmt3 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update2\" AFTER UPDATE OF \"" + geo.getName() + "\" ON \"" + tab.getName().getName() + "\" WHEN OLD.\"" + primaryKey + "\" = NEW.\"" + primaryKey + "\" AND (NEW.\"" + geo.getName() + "\" ISNULL OR ST_IsEmpty(NEW.\"" + geo.getName() + "\")) BEGIN DELETE FROM \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" WHERE id = OLD.\"" + primaryKey + "\"; END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt3));
                String dropstmt5 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update2\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt5));
                String triggerStmt4 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update3\" AFTER UPDATE ON \"" + tab.getName().getName() + "\" WHEN OLD.\"" + primaryKey + "\" != NEW.\"" + primaryKey + "\" AND (NEW.\"" + geo.getName() + "\" NOTNULL AND NOT ST_IsEmpty(NEW.\"" + geo.getName() + "\")) BEGIN DELETE FROM \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" WHERE id = OLD.\"" + primaryKey + "\"; INSERT OR REPLACE INTO \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" VALUES (NEW.\"" + primaryKey + "\",ST_MinX(NEW.\"" + geo.getName() + "\"),ST_MaxX(NEW.\"" + geo.getName() + "\"),ST_MinY(NEW.\"" + geo.getName() + "\"),ST_MaxY(NEW.\"" + geo.getName() + "\")); END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt4));
                String dropstmt6 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update3\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt6));
                String triggerStmt5 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update4\" AFTER UPDATE ON \"" + tab.getName().getName() + "\" WHEN OLD.\"" + primaryKey + "\" != NEW.\"" + primaryKey + "\" AND (NEW.\"" + geo.getName() + "\" ISNULL OR ST_IsEmpty(NEW.\"" + geo.getName() + "\")) BEGIN DELETE FROM \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" WHERE id IN (OLD.\"" + primaryKey + "\",NEW.\"" + primaryKey + "\"); END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt5));
                String dropstmt7 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_update4\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt7));
                String triggerStmt6 = "CREATE TRIGGER \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_delete\" AFTER DELETE ON \"" + tab.getName().getName() + "\" WHEN OLD.\"" + geo.getName() + "\" NOT NULL BEGIN DELETE FROM \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "\" WHERE id = OLD.\"" + primaryKey + "\"; END";
                this.addCreateLine(new GeneratorJdbc.Stmt(triggerStmt6));
                String dropstmt8 = "DROP TRIGGER IF EXISTS \"rtree_" + tab.getName().getName() + "_" + geo.getName() + "_delete\"";
                this.addDropLine(new GeneratorJdbc.Stmt(dropstmt8));
                String[] triggerStmts = new String[]{triggerStmt1, triggerStmt2, triggerStmt3, triggerStmt4, triggerStmt5, triggerStmt6};
                if (this.conn == null || tableExists) continue;
                EhiLogger.traceBackendCmd((String)createStmt);
                this.totalScript.write(createStmt + ";" + this.newline());
                EhiLogger.traceBackendCmd((String)populateStmt);
                this.totalScript.write(populateStmt + ";" + this.newline());
                for (String triggerStmt : triggerStmts) {
                    EhiLogger.traceBackendCmd((String)triggerStmt);
                    this.totalScript.write(triggerStmt + ";" + this.newline());
                }
                continue;
            }
            String idxName = this.createConstraintName(tab, "idx", idxcol.getName().toLowerCase());
            String idxstmt = "CREATE INDEX " + idxName + " ON " + sqlTabName.toLowerCase() + " ( " + idxcol.getName().toLowerCase() + " )";
            this.addCreateLine(new GeneratorJdbc.Stmt(idxstmt));
            if (this.conn == null || tableExists) continue;
            EhiLogger.traceBackendCmd((String)idxstmt);
            this.totalScript.write(idxstmt + ";" + this.newline());
        }
        this.indexColumns = null;
        this.primaryKeyColumn = null;
    }

    protected void addJsonColumn(DbTable tab, boolean tableExists, DbColumn col) throws IOException {
        String stmt2 = "INSERT INTO gpkg_data_columns (table_name,column_name,name,title,description,mime_type,constraint_name)VALUES ('" + tab.getName().getName() + "','" + col.getName() + "' ,NULL,NULL,NULL,'application/json',NULL)";
        this.addCreateLine(new GeneratorJdbc.Stmt(stmt2));
        String dropstmt2 = "DELETE FROM gpkg_data_columns WHERE table_name='" + tab.getName().getName() + "' AND column_name='" + col.getName() + "''";
        this.addDropLine(new GeneratorJdbc.Stmt(dropstmt2));
        if (this.conn != null && !tableExists) {
            EhiLogger.traceBackendCmd((String)stmt2);
            this.totalScript.write(stmt2 + ";" + this.newline());
        }
    }

    @Override
    public void visitIndex(DbIndex idx) throws IOException {
    }

    public static String escapeString(String cmt) {
        StringBuilder ret = new StringBuilder(cmt.length());
        for (int i = 0; i < cmt.length(); ++i) {
            char c = cmt.charAt(i);
            ret.append(c);
            if (c != '\'') continue;
            ret.append(c);
        }
        return ret.toString();
    }

    public static String getGpkgGeometryTypename(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void visit1End() throws IOException {
        String stmt = this.totalScript.toString();
        if (this.conn != null) {
            try {
                Statement dbstmt = this.conn.createStatement();
                try {
                    dbstmt = this.conn.createStatement();
                    dbstmt.executeUpdate(stmt);
                }
                finally {
                    dbstmt.close();
                }
            }
            catch (SQLException ex) {
                IOException iox = new IOException("failed schema import: " + ex.getMessage());
                iox.initCause(ex);
                throw iox;
            }
        }
    }
}

