/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.fromili;

import ch.ehi.basics.types.OutParam;
import ch.ehi.ili2db.base.DbIdGen;
import ch.ehi.ili2db.base.DbNames;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.converter.AbstractRecordConverter;
import ch.ehi.ili2db.dbmetainfo.DbExtMetaInfo;
import ch.ehi.ili2db.fromili.CustomMapping;
import ch.ehi.ili2db.gui.Config;
import ch.ehi.ili2db.mapping.ArrayMapping;
import ch.ehi.ili2db.mapping.ColumnWrapper;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.ili2db.mapping.TrafoConfig;
import ch.ehi.ili2db.mapping.Viewable2TableMapping;
import ch.ehi.ili2db.mapping.ViewableWrapper;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColBoolean;
import ch.ehi.sqlgen.repository.DbColDate;
import ch.ehi.sqlgen.repository.DbColDateTime;
import ch.ehi.sqlgen.repository.DbColDecimal;
import ch.ehi.sqlgen.repository.DbColGeometry;
import ch.ehi.sqlgen.repository.DbColId;
import ch.ehi.sqlgen.repository.DbColJson;
import ch.ehi.sqlgen.repository.DbColNumber;
import ch.ehi.sqlgen.repository.DbColTime;
import ch.ehi.sqlgen.repository.DbColUuid;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColXml;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbIndex;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AbstractCoordType;
import ch.interlis.ili2c.metamodel.AbstractEnumerationType;
import ch.interlis.ili2c.metamodel.AbstractSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.AreaType;
import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.AttributePathType;
import ch.interlis.ili2c.metamodel.AttributeRef;
import ch.interlis.ili2c.metamodel.BasketType;
import ch.interlis.ili2c.metamodel.BlackboxType;
import ch.interlis.ili2c.metamodel.ClassType;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.FormattedType;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.LocalAttribute;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.MultiAreaType;
import ch.interlis.ili2c.metamodel.MultiCoordType;
import ch.interlis.ili2c.metamodel.MultiPolylineType;
import ch.interlis.ili2c.metamodel.MultiSurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.MultiSurfaceType;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.OIDType;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.PathElAssocRole;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.ReferenceType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.TypeAlias;
import ch.interlis.ili2c.metamodel.UniqueEl;
import ch.interlis.ili2c.metamodel.UniquenessConstraint;
import ch.interlis.ili2c.metamodel.Unit;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class FromIliRecordConverter
extends AbstractRecordConverter {
    private DbSchema schema = null;
    private CustomMapping customMapping = null;
    private Set<Element> visitedEnumsAttrs = null;
    private String nl = System.getProperty("line.separator");
    private boolean coalesceCatalogueRef = true;
    private boolean coalesceMultiSurface = true;
    private boolean coalesceMultiLine = true;
    private boolean coalesceMultiPoint = true;
    private boolean coalesceArray = true;
    private boolean coalesceJson = true;
    private boolean expandMultilingual = true;
    private boolean expandLocalised = true;
    private boolean createUnique = true;
    private boolean createNumCheck = false;
    private boolean createTextCheck = false;
    private boolean createDateTimeCheck = false;
    private boolean createMandatoryCheck = false;
    private DbExtMetaInfo metaInfo = null;
    private boolean createTypeConstraint = false;
    private boolean createIliTidCol = false;

    public FromIliRecordConverter(TransferDescription td1, NameMapping ili2sqlName, Config config, DbSchema schema1, CustomMapping customMapping1, DbIdGen idGen1, Set<Element> visitedEnumsAttrs1, TrafoConfig trafoConfig, Viewable2TableMapping class2wrapper1, DbExtMetaInfo metaInfo) {
        super(td1, ili2sqlName, config, idGen1, trafoConfig, class2wrapper1);
        this.visitedEnumsAttrs = visitedEnumsAttrs1;
        this.customMapping = customMapping1;
        this.schema = schema1;
        this.coalesceCatalogueRef = "coalesce".equals(config.getCatalogueRefTrafo());
        this.coalesceMultiSurface = "coalesce".equals(config.getMultiSurfaceTrafo());
        this.coalesceMultiLine = "coalesce".equals(config.getMultiLineTrafo());
        this.coalesceMultiPoint = "coalesce".equals(config.getMultiPointTrafo());
        this.coalesceArray = "coalesce".equals(config.getArrayTrafo());
        this.coalesceJson = "coalesce".equals(config.getJsonTrafo());
        this.expandMultilingual = "expand".equals(config.getMultilingualTrafo());
        this.expandLocalised = "expand".equals(config.getLocalisedTrafo());
        this.createUnique = config.isCreateUniqueConstraints();
        this.createNumCheck = config.isCreateCreateNumChecks();
        this.createTextCheck = config.isCreateCreateTextChecks();
        this.createDateTimeCheck = config.isCreateCreateDateTimeChecks();
        this.createMandatoryCheck = config.isCreateMandatoryChecks() && !this.sqlEnableNull;
        this.metaInfo = metaInfo;
        this.createTypeConstraint = config.getCreateTypeConstraint();
        this.createIliTidCol = "property".equals(config.getTidHandling());
    }

    public void generateTable(ViewableWrapper def, int pass) throws Ili2dbException {
        AttributeDef attr;
        if (pass == 1) {
            DbTableName sqlName = new DbTableName(this.schema.getName(), def.getSqlTablename());
            DbTable dbTable = new DbTable();
            dbTable.setName(sqlName);
            this.schema.addTable(dbTable);
            return;
        }
        DbTableName sqlName = new DbTableName(this.schema.getName(), def.getSqlTablename());
        DbTable dbTable = this.schema.findTable(sqlName);
        ViewableWrapper base = def.getExtending();
        StringBuffer cmt = new StringBuffer();
        String cmtSep = "";
        if (!def.isSecondaryTable()) {
            dbTable.setIliName(def.getViewable().getScopedName(null));
            if (def.getViewable().getDocumentation() != null) {
                cmt.append(cmtSep + def.getViewable().getDocumentation());
                cmtSep = this.nl;
            }
        }
        if (cmt.length() > 0) {
            dbTable.setComment(cmt.toString());
        }
        if (base == null && !def.isSecondaryTable()) {
            dbTable.setRequiresSequence(true);
        }
        DbColId dbColId = this.addKeyCol(dbTable);
        if (base != null) {
            dbColId.setScriptComment("REFERENCES " + base.getViewable().getScopedName(null));
            if (this.createFk) {
                dbColId.setReferencedTable(this.getSqlType(base.getViewable()));
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", this.getSqlType(base.getViewable()).getName());
        } else if (def.isSecondaryTable()) {
            if (this.createFk && def.getPrimitiveCollectionAttr() == null) {
                dbColId.setReferencedTable(new DbTableName(this.schema.getName(), def.getMainTable().getSqlTablename()));
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColId.getName(), "ch.ehi.ili2db.foreignKey", def.getMainTable().getSqlTablename());
        }
        if (this.createBasketCol) {
            DbColId t_basket = new DbColId();
            t_basket.setName("T_basket");
            t_basket.setNotNull(true);
            t_basket.setScriptComment("REFERENCES T_ILI2DB_BASKET");
            if (this.createFk) {
                t_basket.setReferencedTable(new DbTableName(this.schema.getName(), "T_ILI2DB_BASKET"));
            }
            if (this.createFkIdx) {
                t_basket.setIndex(true);
            }
            dbTable.addColumn((DbColumn)t_basket);
        }
        if (this.createDatasetCol) {
            DbColVarchar t_dsName = new DbColVarchar();
            t_dsName.setName("T_datasetname");
            t_dsName.setSize(200);
            t_dsName.setNotNull(true);
            t_dsName.setIndex(true);
            dbTable.addColumn((DbColumn)t_dsName);
        }
        DbColumn dbTypeCol = null;
        if (base == null && !def.isSecondaryTable()) {
            if (this.createTypeDiscriminator || def.includesMultipleTypes()) {
                dbTypeCol = this.createSqlTypeCol("T_Type");
                ArrayList<String> extensions = new ArrayList<String>();
                for (Object o : def.getViewable().getExtensions()) {
                    Viewable v = (Viewable)o;
                    if (v.isAbstract()) continue;
                    extensions.add(this.ili2sqlName.mapIliClassDef(v));
                }
                Collections.sort(extensions);
                String jsonExtensions = "";
                JsonFactory factory = new JsonFactory();
                StringWriter out = new StringWriter();
                try {
                    JsonGenerator generator = factory.createGenerator((Writer)out);
                    generator.writeStartArray();
                    for (String e : extensions) {
                        generator.writeString(e);
                    }
                    generator.writeEndArray();
                    generator.flush();
                    jsonExtensions = out.toString();
                    generator.close();
                }
                catch (IOException e) {
                    throw new Ili2dbException(e);
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), "T_Type", "ch.ehi.ili2db.types", jsonExtensions);
                if (this.createTypeConstraint) {
                    String[] possibleValues = new String[extensions.size()];
                    ((DbColVarchar)dbTypeCol).setValueRestriction(extensions.toArray(possibleValues));
                }
                dbTable.addColumn(dbTypeCol);
            }
            if (!(def.getViewable() instanceof AssociationDef && ((AssociationDef)def.getViewable()).isLightweight() || (!this.createIliTidCol || def.getViewable() instanceof AssociationDef) && !def.hasOid())) {
                this.addIliTidCol(dbTable, def.getOid());
                if (def.getOid() != null) {
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), "T_Ili_Tid", "ch.ehi.ili2db.oidDomain", def.getOid().getScopedName());
                }
            }
            if (def.isStructure()) {
                DbColId dbSeq = new DbColId();
                dbSeq.setName("T_Seq");
                dbSeq.setPrimaryKey(false);
                dbTable.addColumn((DbColumn)dbSeq);
            }
        }
        if (def.isSecondaryTable() && (attr = def.getPrimitiveCollectionAttr()) != null) {
            DbColId dbSeq = new DbColId();
            dbSeq.setName("T_Seq");
            dbTable.addColumn((DbColumn)dbSeq);
            ViewableWrapper parent = def.getMainTable();
            String refAttrSqlName = this.ili2sqlName.mapIliAttributeDefReverse(attr, def.getSqlTablename(), parent.getSqlTablename());
            DbColId dbParentId = new DbColId();
            dbParentId.setName(refAttrSqlName);
            dbParentId.setNotNull(true);
            if (this.createFk) {
                dbParentId.setReferencedTable(parent.getSqlTable());
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbParentId.getName(), "ch.ehi.ili2db.foreignKey", parent.getSqlTablename());
            if (this.createFkIdx) {
                dbParentId.setIndex(true);
            }
            dbTable.addColumn((DbColumn)dbParentId);
        }
        Iterator<ColumnWrapper> iter = def.getAttrIterator();
        while (iter.hasNext()) {
            boolean isExtRef;
            ColumnWrapper columnWrapper = iter.next();
            if (columnWrapper.getViewableTransferElement().obj instanceof AttributeDef) {
                AttributeDef attr2 = (AttributeDef)columnWrapper.getViewableTransferElement().obj;
                try {
                    Type proxyType;
                    if (!(attr2.isTransient() || (proxyType = attr2.getDomain()) != null && proxyType instanceof ObjectType)) {
                        Integer epsgCode = columnWrapper.getEpsgCode();
                        this.generateAttr(dbTable, dbTypeCol, def.getViewable(), attr2, epsgCode);
                    }
                }
                catch (Exception ex) {
                    throw new Ili2dbException(attr2.getContainer().getScopedName(null) + "." + attr2.getName(), ex);
                }
            }
            if (!(columnWrapper.getViewableTransferElement().obj instanceof RoleDef)) continue;
            RoleDef role = (RoleDef)columnWrapper.getViewableTransferElement().obj;
            if (columnWrapper.getViewableTransferElement().embedded) {
                Object cmt2;
                boolean isExtRef2;
                AssociationDef roleOwner = (AssociationDef)role.getContainer();
                if (roleOwner.getDerivedFrom() != null) continue;
                boolean bl = isExtRef2 = this.createExtRef && role.isExternal();
                if (isExtRef2) {
                    DbColVarchar dbColRef = null;
                    dbColRef = new DbColVarchar();
                    dbColRef.setSize(255);
                    String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), this.getSqlType((Viewable)role.getDestination()).getName(), false);
                    dbColRef.setName(roleSqlName);
                    boolean notNull = false;
                    if (!this.sqlEnableNull) {
                        notNull = role.getOppEnd().getDestination() != def.getViewable() ? false : role.getCardinality().getMinimum() != 0L;
                    }
                    dbColRef.setNotNull(notNull);
                    dbColRef.setPrimaryKey(false);
                    if (this.createFkIdx) {
                        dbColRef.setIndex(true);
                    }
                    if ((cmt2 = role.getDocumentation()) != null && ((String)cmt2).length() > 0) {
                        dbColRef.setComment((String)cmt2);
                    }
                    dbTable.addColumn((DbColumn)dbColRef);
                    if (!role.getOppEnd().isOrdered()) continue;
                    DbColId dbSeq = new DbColId();
                    dbSeq.setName(roleSqlName + "_" + "T_Seq");
                    dbSeq.setNotNull(notNull);
                    dbSeq.setPrimaryKey(false);
                    dbTable.addColumn((DbColumn)dbSeq);
                    continue;
                }
                ArrayList<String> fkColNames = new ArrayList<String>();
                boolean notNull = false;
                ArrayList<ViewableWrapper> targetTables = this.getTargetTables((Viewable)role.getDestination());
                cmt2 = targetTables.iterator();
                while (cmt2.hasNext()) {
                    String cmt3;
                    ViewableWrapper targetTable = cmt2.next();
                    DbColId dbColRef = null;
                    dbColRef = new DbColId();
                    DbTableName targetSqlTableName = targetTable.getSqlTable();
                    String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), targetSqlTableName.getName(), targetTables.size() > 1);
                    dbColRef.setName(roleSqlName);
                    fkColNames.add(roleSqlName);
                    notNull = false;
                    if (!this.sqlEnableNull) {
                        notNull = targetTables.size() > 1 ? false : (role.getOppEnd().getDestination() != def.getViewable() ? false : role.getCardinality().getMinimum() != 0L);
                    }
                    dbColRef.setNotNull(notNull);
                    dbColRef.setPrimaryKey(false);
                    if (this.createFk) {
                        dbColRef.setReferencedTable(targetSqlTableName);
                    }
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColRef.getName(), "ch.ehi.ili2db.foreignKey", targetSqlTableName.getName());
                    if (this.createFkIdx) {
                        dbColRef.setIndex(true);
                    }
                    if ((cmt3 = role.getDocumentation()) != null && cmt3.length() > 0) {
                        dbColRef.setComment(cmt3);
                    }
                    this.customMapping.fixupEmbeddedLink(dbTable, (DbColumn)dbColRef, roleOwner, role, targetSqlTableName, this.colT_ID);
                    dbTable.addColumn((DbColumn)dbColRef);
                    if (!role.getOppEnd().isOrdered()) continue;
                    DbColId dbSeq = new DbColId();
                    dbSeq.setName(roleSqlName + "_" + "T_Seq");
                    dbSeq.setNotNull(notNull);
                    dbSeq.setPrimaryKey(false);
                    dbTable.addColumn((DbColumn)dbSeq);
                }
                if (!this.createMandatoryCheck || notNull) continue;
                AbstractClassDef sourceClass = role.getOppEnd().getDestination();
                List<Viewable> exts = this.getPotentialClassTypes((Viewable)sourceClass);
                String cnstrName = "ili_" + this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), this.getSqlType((Viewable)role.getDestination()).getName());
                String cnstr = this.createReferenceAttrCheck(dbTypeCol != null ? exts : null, fkColNames);
                dbTable.setNativeConstraint(cnstrName, cnstr);
                continue;
            }
            boolean bl = isExtRef = this.createExtRef && role.isExternal();
            if (isExtRef) {
                String cmt4;
                DbColVarchar dbColRef = null;
                dbColRef = new DbColVarchar();
                dbColRef.setSize(255);
                String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), this.getSqlType((Viewable)role.getDestination()).getName(), false);
                dbColRef.setName(roleSqlName);
                boolean notNull = false;
                if (!this.sqlEnableNull) {
                    notNull = true;
                }
                dbColRef.setNotNull(notNull);
                dbColRef.setPrimaryKey(false);
                if (this.createFkIdx) {
                    dbColRef.setIndex(true);
                }
                if ((cmt4 = role.getDocumentation()) != null && cmt4.length() > 0) {
                    dbColRef.setComment(cmt4);
                }
                dbTable.addColumn((DbColumn)dbColRef);
                if (this.createFk && def.getViewable() instanceof AssociationDef && ((AssociationDef)def.getViewable()).isLightweight() && role.getCardinality().getMaximum() > 1L) {
                    DbIndex dbIndex = new DbIndex();
                    dbIndex.setPrimary(false);
                    dbIndex.setUnique(true);
                    dbIndex.addAttr((DbColumn)dbColRef);
                    dbTable.addIndex(dbIndex);
                }
                if (!role.isOrdered()) continue;
                DbColId dbSeq = new DbColId();
                dbSeq.setName(roleSqlName + "_" + "T_Seq");
                dbSeq.setNotNull(notNull);
                dbSeq.setPrimaryKey(false);
                dbTable.addColumn((DbColumn)dbSeq);
                continue;
            }
            ArrayList<String> fkColNames = new ArrayList<String>();
            boolean notNull = false;
            ArrayList<ViewableWrapper> targetTables = null;
            targetTables = this.getTargetTables((Viewable)role.getDestination());
            for (ViewableWrapper targetTable : targetTables) {
                String cmt5;
                DbColId dbColRef = null;
                dbColRef = new DbColId();
                DbTableName targetSqlTableName = targetTable.getSqlTable();
                String roleSqlName = this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), targetSqlTableName.getName(), targetTables.size() > 1);
                dbColRef.setName(roleSqlName);
                fkColNames.add(roleSqlName);
                notNull = false;
                if (!this.sqlEnableNull) {
                    notNull = targetTables.size() <= 1;
                }
                dbColRef.setNotNull(notNull);
                dbColRef.setPrimaryKey(false);
                if (this.createFk) {
                    dbColRef.setReferencedTable(targetSqlTableName);
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbColRef.getName(), "ch.ehi.ili2db.foreignKey", targetSqlTableName.getName());
                if (this.createFkIdx) {
                    dbColRef.setIndex(true);
                }
                if ((cmt5 = role.getDocumentation()) != null && cmt5.length() > 0) {
                    dbColRef.setComment(cmt5);
                }
                dbTable.addColumn((DbColumn)dbColRef);
                if (this.createFk && def.getViewable() instanceof AssociationDef && ((AssociationDef)def.getViewable()).isLightweight() && role.getCardinality().getMaximum() > 1L) {
                    DbIndex dbIndex = new DbIndex();
                    dbIndex.setPrimary(false);
                    dbIndex.setUnique(true);
                    dbIndex.addAttr((DbColumn)dbColRef);
                    dbTable.addIndex(dbIndex);
                }
                if (!role.isOrdered()) continue;
                DbColId dbSeq = new DbColId();
                dbSeq.setName(roleSqlName + "_" + "T_Seq");
                dbSeq.setNotNull(notNull);
                dbSeq.setPrimaryKey(false);
                dbTable.addColumn((DbColumn)dbSeq);
            }
            if (!this.createMandatoryCheck || notNull) continue;
            String cnstrName = "ili_" + this.ili2sqlName.mapIliRoleDef(role, sqlName.getName(), this.getSqlType((Viewable)role.getDestination()).getName());
            String cnstr = this.createReferenceAttrCheck(null, fkColNames);
            dbTable.setNativeConstraint(cnstrName, cnstr);
        }
        if (this.createStdCols) {
            FromIliRecordConverter.addStdCol(dbTable);
        }
        if (this.createUnique && !def.isStructure()) {
            Viewable aclass = def.getViewable();
            for (Object cnstro : aclass) {
                if (!(cnstro instanceof UniquenessConstraint)) continue;
                UniquenessConstraint cnstr = (UniquenessConstraint)cnstro;
                Integer[] epsgCodes = this.getEpsgCodes(cnstr, def.getAttrv());
                if (epsgCodes.length == 0) {
                    epsgCodes = new Integer[]{null};
                }
                for (Integer epsgCode : epsgCodes) {
                    Set<Element> attrs = this.getUniqueAttrs(cnstr, def.getAttrv(), epsgCode);
                    if (attrs == null) continue;
                    DbIndex dbIndex = new DbIndex();
                    dbIndex.setPrimary(false);
                    dbIndex.setUnique(true);
                    for (Element attro : attrs) {
                        String attrSqlName = null;
                        if (attro instanceof AttributeDef) {
                            Type attrType = ((AttributeDef)attro).getDomainResolvingAliases();
                            attrSqlName = attrType instanceof CoordType || attrType instanceof LineType ? this.ili2sqlName.mapIliAttributeDef((AttributeDef)attro, epsgCode, def.getSqlTablename(), null) : this.ili2sqlName.mapIliAttributeDef((AttributeDef)attro, null, def.getSqlTablename(), null);
                        } else if (attro instanceof RoleDef) {
                            RoleDef role = (RoleDef)attro;
                            DbTableName targetSqlTableName = this.getSqlType((Viewable)role.getDestination());
                            attrSqlName = this.ili2sqlName.mapIliRoleDef(role, def.getSqlTablename(), targetSqlTableName.getName());
                        } else {
                            throw new IllegalStateException("unexpected attr " + attro);
                        }
                        DbColumn idxCol = dbTable.getColumn(attrSqlName);
                        dbIndex.addAttr(idxCol);
                    }
                    if (cnstr.perBasket() && this.createBasketCol) {
                        dbIndex.addAttr("T_basket");
                        dbTable.addIndex(dbIndex);
                        continue;
                    }
                    if (cnstr.perBasket()) continue;
                    dbTable.addIndex(dbIndex);
                }
            }
        }
        if (!def.isSecondaryTable()) {
            this.customMapping.fixupViewable(dbTable, def.getViewable());
        }
    }

    private List<Viewable> getPotentialClassTypes(Viewable def) {
        ArrayList<Viewable> extensions = new ArrayList<Viewable>();
        this.getExtensions_recursiveHelper(def, extensions);
        return extensions;
    }

    private final void getExtensions_recursiveHelper(Viewable def, List<Viewable> s) {
        if (!def.isAbstract()) {
            s.add(def);
        }
        for (Viewable ext : def.getDirectExtensions()) {
            String trafo;
            if (ext.isAbstract() || (trafo = this.trafoConfig.getViewableConfig(ext, "ch.ehi.ili2db.inheritance")) != null && trafo.equals("newAndSubClass")) continue;
            this.getExtensions_recursiveHelper(ext, s);
        }
    }

    private Integer[] getEpsgCodes(List<ColumnWrapper> colv) {
        HashSet<Integer> epsgCodes = new HashSet<Integer>();
        for (ColumnWrapper col : colv) {
            if (col.getEpsgCode() == null) continue;
            epsgCodes.add(col.getEpsgCode());
        }
        return epsgCodes.toArray(new Integer[epsgCodes.size()]);
    }

    private Integer[] getEpsgCodes(UniquenessConstraint cnstr, List<ColumnWrapper> colv) {
        HashSet<Integer> epsgCodes = new HashSet<Integer>();
        for (ColumnWrapper col : colv) {
            if (col.getEpsgCode() == null || !this.isUniqueAttr(cnstr, (Element)col.getViewableTransferElement().obj)) continue;
            epsgCodes.add(col.getEpsgCode());
        }
        return epsgCodes.toArray(new Integer[epsgCodes.size()]);
    }

    private boolean isUniqueAttr(UniquenessConstraint cnstr, Element col) {
        UniqueEl attribs = cnstr.getElements();
        Iterator attri = attribs.iteratorAttribute();
        while (attri.hasNext()) {
            ObjectPath path = (ObjectPath)attri.next();
            PathEl[] pathEles = path.getPathElements();
            if (pathEles.length != 1) {
                return false;
            }
            PathEl pathEle = pathEles[0];
            if (pathEle instanceof AttributeRef) {
                AttributeDef attr = ((AttributeRef)pathEle).getAttr();
                while (attr.getExtending() != null) {
                    attr = (AttributeDef)attr.getExtending();
                }
                if (col != attr) continue;
                return true;
            }
            if (!(pathEle instanceof PathElAssocRole)) continue;
            RoleDef role = ((PathElAssocRole)pathEle).getRole();
            while (role.getExtending() != null) {
                role = (RoleDef)role.getExtending();
            }
            if (col != role) continue;
            return true;
        }
        return false;
    }

    private Set<Element> getUniqueAttrs(UniquenessConstraint cnstr, List<ColumnWrapper> colv, Integer epsgCode) {
        if (cnstr.getLocal()) {
            return null;
        }
        HashSet<Element> wrapperCols = new HashSet<Element>();
        for (ColumnWrapper col : colv) {
            if (col.getEpsgCode() != null) {
                if (!col.getEpsgCode().equals(epsgCode)) continue;
                wrapperCols.add((Element)col.getViewableTransferElement().obj);
                continue;
            }
            wrapperCols.add((Element)col.getViewableTransferElement().obj);
        }
        HashSet<Element> ret = new HashSet<Element>();
        UniqueEl attribs = cnstr.getElements();
        Iterator attri = attribs.iteratorAttribute();
        while (attri.hasNext()) {
            ObjectPath path = (ObjectPath)attri.next();
            PathEl[] pathEles = path.getPathElements();
            if (pathEles.length != 1) {
                return null;
            }
            PathEl pathEle = pathEles[0];
            if (pathEle instanceof AttributeRef) {
                AttributeDef attr = ((AttributeRef)pathEle).getAttr();
                while (attr.getExtending() != null) {
                    attr = (AttributeDef)attr.getExtending();
                }
                if (!wrapperCols.contains(attr)) {
                    return null;
                }
                ret.add((Element)attr);
                continue;
            }
            if (pathEle instanceof PathElAssocRole) {
                RoleDef role = ((PathElAssocRole)pathEle).getRole();
                while (role.getExtending() != null) {
                    role = (RoleDef)role.getExtending();
                }
                if (!wrapperCols.contains(role)) {
                    return null;
                }
                ret.add((Element)role);
                continue;
            }
            return null;
        }
        return ret;
    }

    public void generateAttr(DbTable dbTable, DbColumn dbTypeCol, Viewable aclass, AttributeDef attr, Integer epsgCode) throws Ili2dbException {
        String sqlColName;
        DbColId ret;
        ArrayList<ViewableWrapper> targetTables;
        String attrName;
        DbColVarchar ret2;
        boolean result;
        OutParam dbCol = new OutParam();
        dbCol.value = null;
        OutParam unitDef = new OutParam();
        unitDef.value = null;
        OutParam mText = new OutParam();
        mText.value = false;
        OutParam simpleTypeKind = new OutParam();
        simpleTypeKind.value = null;
        Model model = (Model)attr.getContainer(Model.class);
        ArrayList<DbColumn> dbColExts = new ArrayList<DbColumn>();
        Type type = attr.getDomainResolvingAll();
        String typeKind = null;
        boolean bl = result = this.mapAsTextCol(attr) ? this.createSimpleDbColTXT(dbTable, aclass, attr, type, (OutParam<DbColumn>)dbCol, (OutParam<Unit>)unitDef, (OutParam<Boolean>)mText, dbColExts) : this.createSimpleDbCol(dbTable, aclass, attr, type, (OutParam<DbColumn>)dbCol, (OutParam<String>)simpleTypeKind, (OutParam<Unit>)unitDef, (OutParam<Boolean>)mText, dbColExts);
        if (result) {
            typeKind = (String)simpleTypeKind.value;
        } else if (type instanceof AbstractSurfaceOrAreaType) {
            Object coord;
            Domain coordDomain;
            boolean curvePolygon;
            if (this.createItfLineTables) {
                dbCol.value = null;
            } else if (this.createXtfLineTables) {
                ret2 = new DbColGeometry();
                curvePolygon = false;
                if (!this.strokeArcs) {
                    curvePolygon = true;
                }
                ret2.setType(curvePolygon ? 11 : 5);
                this.setCrs((DbColGeometry)ret2, epsgCode);
                CoordType coord2 = (CoordType)((AbstractSurfaceOrAreaType)type).getControlPointDomain().getType();
                ret2.setDimension(coord2.getDimensions().length);
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord2, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret2;
            } else {
                ret2 = new DbColGeometry();
                curvePolygon = false;
                if (!this.strokeArcs) {
                    curvePolygon = true;
                }
                if (type instanceof SurfaceOrAreaType) {
                    ret2.setType(curvePolygon ? 10 : 3);
                    if (type instanceof SurfaceType) {
                        typeKind = "SURFACE";
                    } else if (type instanceof AreaType) {
                        typeKind = "AREA";
                    }
                } else if (type instanceof MultiSurfaceOrAreaType) {
                    ret2.setType(curvePolygon ? 12 : 6);
                    if (type instanceof MultiSurfaceType) {
                        typeKind = "MULTISURFACE";
                    } else if (type instanceof MultiAreaType) {
                        typeKind = "MULTIAREA";
                    }
                }
                this.setCrs((DbColGeometry)ret2, epsgCode);
                coordDomain = ((AbstractSurfaceOrAreaType)type).getControlPointDomain();
                coord = (CoordType)coordDomain.getType();
                if (coord.isGeneric()) {
                    coord = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, epsgCode).getType();
                }
                ret2.setDimension(coord.getDimensions().length);
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret2;
            }
            if (this.createItfAreaRef && type instanceof AreaType) {
                ret2 = new DbColGeometry();
                String sqlName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null) + "_ref";
                ret2.setName(sqlName);
                ret2.setType(0);
                this.setNullable(aclass, attr, (DbColumn)ret2);
                this.setCrs((DbColGeometry)ret2, epsgCode);
                ret2.setDimension(2);
                coordDomain = ((AbstractSurfaceOrAreaType)type).getControlPointDomain();
                coord = (CoordType)coordDomain.getType();
                if (coord.isGeneric()) {
                    coord = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, epsgCode).getType();
                }
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbColExts.add((DbColumn)ret2);
            }
        } else if (type instanceof PolylineType) {
            attrName = attr.getContainer().getScopedName(null) + "." + attr.getName();
            DbColGeometry ret3 = this.generatePolylineType(model, (LineType)((PolylineType)type), attrName, epsgCode);
            this.setCrs(ret3, epsgCode);
            dbCol.value = ret3;
            typeKind = "POLYLINE";
        } else if (type instanceof MultiPolylineType) {
            attrName = attr.getContainer().getScopedName(null) + "." + attr.getName();
            DbColGeometry ret4 = this.generateMultiPolylineType(model, (LineType)((MultiPolylineType)type), attrName, epsgCode);
            this.setCrs(ret4, epsgCode);
            dbCol.value = ret4;
            typeKind = "MULTIPOLYLINE";
        } else if (type instanceof CoordType) {
            ret2 = new DbColGeometry();
            ret2.setType(0);
            this.setCrs((DbColGeometry)ret2, epsgCode);
            CoordType coord = (CoordType)type;
            if (coord.isGeneric()) {
                coord = (CoordType)Ili2cUtility.resolveGenericCoordDomain(attr, epsgCode).getType();
            }
            ret2.setDimension(coord.getDimensions().length);
            this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
            dbCol.value = ret2;
            typeKind = "COORD";
        } else if (type instanceof MultiCoordType) {
            ret2 = new DbColGeometry();
            ret2.setType(4);
            this.setCrs((DbColGeometry)ret2, epsgCode);
            MultiCoordType coord = (MultiCoordType)type;
            if (coord.isGeneric()) {
                coord = (MultiCoordType)Ili2cUtility.resolveGenericCoordDomain(attr, epsgCode).getType();
            }
            ret2.setDimension(coord.getDimensions().length);
            this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
            dbCol.value = ret2;
            typeKind = "MULTICOORD";
        } else if (type instanceof CompositionType) {
            CoordType coord;
            if (this.isChbaseCatalogueRef(this.td, attr) && (this.coalesceCatalogueRef || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.catalogueRefTrafo")))) {
                if (this.createExtRef) {
                    ret2 = new DbColVarchar();
                    ret2.setSize(255);
                    ret2.setName(this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), this.getSqlType((Viewable)FromIliRecordConverter.getCatalogueRefTarget(type)).getName(), false));
                    ret2.setNotNull(false);
                    ret2.setPrimaryKey(false);
                    if (this.createFkIdx) {
                        ret2.setIndex(true);
                    }
                    dbColExts.add((DbColumn)ret2);
                } else {
                    targetTables = this.getTargetTables((Viewable)FromIliRecordConverter.getCatalogueRefTarget(type));
                    ArrayList<String> fkColNames = new ArrayList<String>();
                    boolean catRefMandatory = this.isChbaseCatalogueRefMandatory(this.td, attr);
                    for (ViewableWrapper targetTable : targetTables) {
                        DbColId ret5 = new DbColId();
                        String colName = this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), targetTable.getSqlTablename(), targetTables.size() > 1);
                        ret5.setName(colName);
                        fkColNames.add(colName);
                        ret5.setNotNull(false);
                        ret5.setPrimaryKey(false);
                        if (this.createFk) {
                            ret5.setReferencedTable(targetTable.getSqlTable());
                        }
                        this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, ret5.getName(), "ch.ehi.ili2db.foreignKey", targetTable.getSqlTablename());
                        if (this.createFkIdx) {
                            ret5.setIndex(true);
                        }
                        dbColExts.add((DbColumn)ret5);
                    }
                    if (this.createMandatoryCheck && catRefMandatory) {
                        Viewable sourceClass = (Viewable)attr.getContainer();
                        List<Viewable> exts = this.getPotentialClassTypes(sourceClass);
                        String cnstrName = "ili_" + this.getSqlAttrName(attr, null, dbTable.getName().getName(), null);
                        String cnstr = this.createReferenceAttrCheck(dbTypeCol != null ? exts : null, fkColNames);
                        dbTable.setNativeConstraint(cnstrName, cnstr);
                    }
                }
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.catalogueRefTrafo", "coalesce");
            } else if (Ili2cUtility.isMultiSurfaceAttr(this.td, attr) && (this.coalesceMultiSurface || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo")))) {
                this.multiSurfaceAttrs.addMultiSurfaceAttr(attr);
                ret2 = new DbColGeometry();
                boolean curvePolygon = false;
                if (!this.strokeArcs) {
                    curvePolygon = true;
                }
                ret2.setType(curvePolygon ? 12 : 6);
                AttributeDef surfaceAttr = this.multiSurfaceAttrs.getSurfaceAttr(attr);
                this.setCrs((DbColGeometry)ret2, epsgCode);
                SurfaceType surface = (SurfaceType)surfaceAttr.getDomainResolvingAliases();
                coord = (CoordType)surface.getControlPointDomain().getType();
                ret2.setDimension(coord.getDimensions().length);
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret2;
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiSurfaceTrafo", "coalesce");
                typeKind = "MULTISURFACE";
            } else if (Ili2cUtility.isMultiLineAttr(this.td, attr) && (this.coalesceMultiLine || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo")))) {
                this.multiLineAttrs.addMultiLineAttr(attr);
                ret2 = new DbColGeometry();
                boolean curvePolyline = false;
                if (!this.strokeArcs) {
                    curvePolyline = true;
                }
                ret2.setType(curvePolyline ? 11 : 5);
                AttributeDef polylineAttr = this.multiLineAttrs.getPolylineAttr(attr);
                this.setCrs((DbColGeometry)ret2, epsgCode);
                PolylineType polylineType = (PolylineType)polylineAttr.getDomainResolvingAliases();
                coord = (CoordType)polylineType.getControlPointDomain().getType();
                ret2.setDimension(coord.getDimensions().length);
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret2;
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiLineTrafo", "coalesce");
                typeKind = "MULTIPOLYLINE";
            } else if (Ili2cUtility.isMultiPointAttr(this.td, attr) && (this.coalesceMultiPoint || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo")))) {
                this.multiPointAttrs.addMultiPointAttr(attr);
                ret2 = new DbColGeometry();
                ret2.setType(4);
                AttributeDef coordAttr = this.multiPointAttrs.getCoordAttr(attr);
                this.setCrs((DbColGeometry)ret2, epsgCode);
                CoordType coord3 = (CoordType)coordAttr.getDomainResolvingAliases();
                ret2.setDimension(coord3.getDimensions().length);
                this.setBB((DbColGeometry)ret2, (AbstractCoordType)coord3, attr.getContainer().getScopedName(null) + "." + attr.getName());
                dbCol.value = ret2;
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multiPointTrafo", "coalesce");
                typeKind = "MULTICOORD";
            } else if (Ili2cUtility.isArrayAttr(this.td, attr) && (this.coalesceArray || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo")))) {
                this.arrayAttrs.addArrayAttr(attr);
                ArrayMapping attrMapping = this.arrayAttrs.getMapping(attr);
                AttributeDef localAttr = attrMapping.getValueAttr();
                Type localType = localAttr.getDomainResolvingAll();
                if (!this.createSimpleDbCol(dbTable, aclass, localAttr, localType, (OutParam<DbColumn>)dbCol, (OutParam<String>)simpleTypeKind, (OutParam<Unit>)unitDef, (OutParam<Boolean>)mText, dbColExts)) {
                    throw new IllegalStateException("unexpected attr type " + localAttr.getScopedName());
                }
                ((DbColumn)dbCol.value).setArraySize(-1);
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.arrayTrafo", "coalesce");
            } else if (Ili2cUtility.isJsonAttr(this.td, attr) && (this.coalesceJson || "coalesce".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.jsonTrafo")))) {
                ret2 = new DbColJson();
                dbCol.value = ret2;
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.jsonTrafo", "coalesce");
                typeKind = "STRUCTURE";
            } else if (this.isMultilingualTextAttr(this.td, attr) && (this.expandMultilingual || "expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.multilingualTrafo")))) {
                for (DbColVarchar sfx : DbNames.MULTILINGUAL_TXT_COL_SUFFIXS) {
                    ret = new DbColVarchar();
                    ret.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + (String)sfx);
                    ret.setSize(-1);
                    if (this.createTextCheck) {
                        ret.setMinLength(Integer.valueOf(1));
                    }
                    ret.setNotNull(false);
                    ret.setPrimaryKey(false);
                    dbColExts.add((DbColumn)ret);
                }
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.multilingualTrafo", "expand");
            } else if (this.isLocalisedTextAttr(this.td, attr) && (this.expandLocalised || "expand".equals(this.trafoConfig.getAttrConfig(attr, "ch.ehi.ili2db.localisedTrafo")))) {
                ret2 = new DbColVarchar();
                ret2.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null));
                ret2.setSize(-1);
                ret2.setNotNull(false);
                ret2.setPrimaryKey(false);
                dbCol.value = ret2;
                ret2 = new DbColVarchar();
                ret2.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + "_lang");
                ret2.setSize(2);
                ret2.setNotNull(false);
                ret2.setPrimaryKey(false);
                dbColExts.add((DbColumn)ret2);
                this.trafoConfig.setAttrConfig(attr, "ch.ehi.ili2db.localisedTrafo", "expand");
            } else {
                this.addParentRef(aclass, attr);
                dbCol.value = null;
            }
        } else if (type instanceof ReferenceType) {
            if (this.createExtRef && ((ReferenceType)type).isExternal()) {
                ret2 = new DbColVarchar();
                ret2.setName(this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), this.getSqlType((Viewable)((ReferenceType)type).getReferred()).getName(), false));
                ret2.setSize(255);
                if (this.createFkIdx) {
                    ret2.setIndex(true);
                }
                dbColExts.add((DbColumn)ret2);
                typeKind = "REFERENCE";
            } else {
                targetTables = this.getTargetTables((Viewable)((ReferenceType)type).getReferred());
                ArrayList<String> fkColNames = new ArrayList<String>();
                for (ViewableWrapper targetTable : targetTables) {
                    ret = new DbColId();
                    String colName = this.ili2sqlName.mapIliAttributeDef(attr, dbTable.getName().getName(), targetTable.getSqlTablename(), targetTables.size() > 1);
                    ret.setName(colName);
                    fkColNames.add(colName);
                    ret.setNotNull(false);
                    ret.setPrimaryKey(false);
                    if (this.createFk) {
                        ret.setReferencedTable(targetTable.getSqlTable());
                    }
                    if (this.createFkIdx) {
                        ret.setIndex(true);
                    }
                    dbColExts.add((DbColumn)ret);
                }
                if (this.createMandatoryCheck) {
                    Viewable sourceClass = (Viewable)attr.getContainer();
                    List<Viewable> exts = this.getPotentialClassTypes(sourceClass);
                    String cnstrName = "ili_" + this.getSqlAttrName(attr, null, dbTable.getName().getName(), null);
                    String cnstr = this.createReferenceAttrCheck((List<Viewable>)(dbTypeCol != null ? exts : null), fkColNames);
                    dbTable.setNativeConstraint(cnstrName, cnstr);
                }
            }
        } else {
            ret2 = new DbColVarchar();
            ret2.setSize(255);
            dbCol.value = ret2;
        }
        if (type instanceof EnumerationType) {
            if (this.createEnumTxtCol) {
                ret2 = new DbColVarchar();
                ret2.setSize(255);
                ret2.setName(this.getSqlAttrName(attr, null, dbTable.getName().getName(), null) + "_txt");
                this.setNullable(aclass, attr, (DbColumn)ret2);
                dbColExts.add((DbColumn)ret2);
            }
            sqlColName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null);
            String attrName2 = attr.getName();
            List<Viewable> exts = this.getPotentialClassTypes(aclass);
            for (Viewable extV : exts) {
                Type extType;
                AttributeDef extAttr = null;
                extAttr = (AttributeDef)extV.getElement(AttributeDef.class, attrName2);
                if (extAttr == null || !((extType = extAttr.getDomain()) instanceof TypeAlias)) continue;
                Domain domain = ((TypeAlias)extType).getAliasing();
                String domainSqlName = domain.getScopedName();
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), this.getSqlType(extV).getName(), sqlColName, "ch.ehi.ili2db.enumDomain", domainSqlName);
            }
        }
        if (dbCol.value != null) {
            String dispName;
            sqlColName = this.getSqlAttrName(attr, epsgCode, dbTable.getName().getName(), null);
            this.setAttrDbColProps(aclass, attr, (DbColumn)dbCol.value, sqlColName);
            String subType = null;
            Viewable attrClass = (Viewable)attr.getContainer();
            if (attrClass != aclass && attrClass.isExtending((Element)aclass)) {
                subType = this.getSqlType(attrClass).getName();
            }
            if (typeKind != null) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.typeKind", typeKind);
            }
            if (unitDef.value != null) {
                String unitName = ((Unit)unitDef.value).getName();
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.unit", unitName);
            }
            if (((Boolean)mText.value).booleanValue()) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.textKind", "MTEXT");
            }
            if (((DbColumn)dbCol.value).getReferencedTable() != null) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, ((DbColumn)dbCol.value).getName(), "ch.ehi.ili2db.foreignKey", ((DbColumn)dbCol.value).getReferencedTable().getName());
            }
            if (dbCol.value instanceof DbColGeometry) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c1Min", ((DbColGeometry)dbCol.value).getMin1AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c1Max", ((DbColGeometry)dbCol.value).getMax1AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c2Min", ((DbColGeometry)dbCol.value).getMin2AsString());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c2Max", ((DbColGeometry)dbCol.value).getMax2AsString());
                if (((DbColGeometry)dbCol.value).getDimension() == 3) {
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c3Min", ((DbColGeometry)dbCol.value).getMin3AsString());
                    this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.c3Max", ((DbColGeometry)dbCol.value).getMax3AsString());
                }
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.geomType", FromIliRecordConverter.getIli2DbGeomType(((DbColGeometry)dbCol.value).getType()));
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.srid", ((DbColGeometry)dbCol.value).getSrsId());
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.coordDimension", Integer.toString(((DbColGeometry)dbCol.value).getDimension()));
            }
            if ((dispName = attr.getMetaValues().getValue("ili2db.dispName")) != null) {
                this.metaInfo.setColumnInfo(dbTable.getName().getName(), subType, sqlColName, "ch.ehi.ili2db.dispName", dispName);
            }
            this.customMapping.fixupAttribute(dbTable, (DbColumn)dbCol.value, attr);
            dbTable.addColumn((DbColumn)dbCol.value);
        }
        for (DbColumn dbColExt : dbColExts) {
            this.customMapping.fixupAttribute(dbTable, dbColExt, attr);
            dbTable.addColumn(dbColExt);
        }
        if (dbCol.value == null && dbColExts.size() == 0) {
            this.customMapping.fixupAttribute(dbTable, null, attr);
        }
    }

    private String createReferenceAttrCheck(List<Viewable> exts, List<String> fkColNames) {
        String sep;
        StringBuffer action = new StringBuffer("CHECK(");
        if (exts != null) {
            action.append("T_Type");
            action.append(" NOT IN (");
            sep = "";
            for (Viewable candView : exts) {
                action.append(sep);
                action.append("'");
                action.append(this.ili2sqlName.mapIliClassDef(candView));
                action.append("'");
                sep = ",";
            }
            action.append(") OR ");
        }
        sep = "";
        for (String fkCol : fkColNames) {
            action.append(sep);
            action.append(fkCol);
            action.append(" IS NOT NULL");
            sep = " OR ";
        }
        action.append(")");
        return action.toString();
    }

    private AttributeDef getDefinedAttribute(Viewable aclass, String attrName) {
        Iterator attri = aclass.getDefinedAttributes();
        while (attri.hasNext()) {
            AttributeDef attr = (AttributeDef)attri.next();
            if (!attr.getName().equals(attrName)) continue;
            return attr;
        }
        return null;
    }

    public static String getIli2DbGeomType(int type) {
        switch (type) {
            case 0: {
                return "POINT";
            }
            case 2: {
                return "LINESTRING";
            }
            case 3: {
                return "POLYGON";
            }
            case 4: {
                return "MULTIPOINT";
            }
            case 5: {
                return "MULTILINESTRING";
            }
            case 6: {
                return "MULTIPOLYGON";
            }
            case 7: {
                return "GEOMETRYCOLLECTION";
            }
            case 8: {
                return "CIRCULARSTRING";
            }
            case 9: {
                return "COMPOUNDCURVE";
            }
            case 10: {
                return "CURVEPOLYGON";
            }
            case 11: {
                return "MULTICURVE";
            }
            case 12: {
                return "MULTISURFACE";
            }
            case 15: {
                return "POLYHEDRALSURFACE";
            }
            case 16: {
                return "TIN";
            }
            case 17: {
                return "TRIANGLE";
            }
        }
        throw new IllegalArgumentException();
    }

    private boolean createSimpleDbColTXT(DbTable dbTable, Viewable aclass, AttributeDef attr, Type type, OutParam<DbColumn> dbCol, OutParam<Unit> unitDef, OutParam<Boolean> mText, ArrayList<DbColumn> dbColExts) {
        DbColVarchar ret = new DbColVarchar();
        ret.setSize(-1);
        dbCol.value = ret;
        return true;
    }

    private boolean createSimpleDbCol(DbTable dbTable, Viewable aclass, AttributeDef attr, Type type, OutParam<DbColumn> dbCol, OutParam<String> typeKind, OutParam<Unit> unitDef, OutParam<Boolean> mText, ArrayList<DbColumn> dbColExts) {
        if (attr.isDomainBoolean()) {
            dbCol.value = new DbColBoolean();
            typeKind.value = "BOOLEAN";
        } else if (attr.isDomainIli1Date()) {
            dbCol.value = new DbColDate();
            typeKind.value = "DATE";
        } else if (attr.isDomainIliUuid()) {
            dbCol.value = new DbColUuid();
            typeKind.value = "OID";
        } else if (attr.isDomainIli2Date()) {
            DbColDate ret = new DbColDate();
            dbCol.value = ret;
            typeKind.value = "DATE";
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Date(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Date(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (attr.isDomainIli2DateTime()) {
            DbColDateTime ret = new DbColDateTime();
            dbCol.value = ret;
            typeKind.value = "DATETIME";
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Timestamp(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Timestamp(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (attr.isDomainIli2Time()) {
            DbColTime ret = new DbColTime();
            dbCol.value = ret;
            typeKind.value = "TIMEOFDAY";
            if (this.createDateTimeCheck) {
                SimpleDateFormat dateTimeFormatter = new SimpleDateFormat("HH:mm:ss.SSS");
                FormattedType fmtType = (FormattedType)type;
                try {
                    ret.setMinValue(new Time(dateTimeFormatter.parse(fmtType.getMinimum()).getTime()));
                    ret.setMaxValue(new Time(dateTimeFormatter.parse(fmtType.getMaximum()).getTime()));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        } else if (type instanceof BasketType) {
            dbCol.value = null;
        } else if (type instanceof AbstractEnumerationType) {
            this.visitedEnumsAttrs.add((Element)attr);
            if (this.createEnumColAsItfCode) {
                DbColId ret = new DbColId();
                dbCol.value = ret;
                typeKind.value = type instanceof EnumTreeValueType ? "ENUMTREE" : "ENUM";
            } else if ("multiTableWithId".equals(this.createEnumTable)) {
                DbColId ret = new DbColId();
                dbCol.value = ret;
                typeKind.value = type instanceof EnumTreeValueType ? "ENUMTREE" : "ENUM";
                DbTableName targetTable = this.getEnumTargetTableName(attr, null, this.schema.getName());
                if (this.createFk) {
                    ret.setReferencedTable(targetTable);
                }
                if (this.createFkIdx) {
                    ret.setIndex(true);
                }
            } else {
                DbColVarchar ret = new DbColVarchar();
                ret.setSize(255);
                dbCol.value = ret;
                typeKind.value = type instanceof EnumTreeValueType ? "ENUMTREE" : "ENUM";
            }
        } else if (type instanceof NumericType) {
            if (!type.isAbstract()) {
                PrecisionDecimal min = ((NumericType)type).getMinimum();
                PrecisionDecimal max = ((NumericType)type).getMaximum();
                int minLen = min.toString().length();
                int maxLen = max.toString().length();
                if (min.toString().startsWith("-")) {
                    --minLen;
                }
                if (max.toString().startsWith("-")) {
                    --maxLen;
                }
                if (min.getAccuracy() > 0) {
                    DbColDecimal ret = new DbColDecimal();
                    int size = Math.max(minLen, maxLen) - 1;
                    int precision = min.getAccuracy();
                    ret.setSize(size);
                    ret.setPrecision(precision);
                    if (this.createNumCheck) {
                        ret.setMinValue(Double.valueOf(min.doubleValue()));
                        ret.setMaxValue(Double.valueOf(max.doubleValue()));
                    }
                    dbCol.value = ret;
                    typeKind.value = "NUMERIC";
                } else {
                    DbColNumber ret = new DbColNumber();
                    int size = Math.max(minLen, maxLen);
                    ret.setSize(size);
                    if (this.createNumCheck) {
                        ret.setMinValue(Long.valueOf(min.getUnscaledValue().longValue()));
                        ret.setMaxValue(Long.valueOf(max.getUnscaledValue().longValue()));
                    }
                    dbCol.value = ret;
                    typeKind.value = "NUMERIC";
                }
                unitDef.value = ((NumericType)type).getUnit();
            }
        } else if (type instanceof TextType) {
            DbColVarchar ret = new DbColVarchar();
            if (((TextType)type).getMaxLength() > 0) {
                ret.setSize(((TextType)type).getMaxLength());
            } else {
                ret.setSize(-1);
            }
            if (this.createTextCheck) {
                if (((TextType)type).isNormalized()) {
                    ret.setKind("NORMALIZED");
                }
                ret.setMinLength(Integer.valueOf(1));
            }
            if (!((TextType)type).isNormalized()) {
                mText.value = true;
                typeKind.value = "MTEXT";
            } else {
                typeKind.value = attr.isDomainName() ? "NAME" : (attr.isDomainUri() ? "URI" : "TEXT");
            }
            dbCol.value = ret;
        } else if (type instanceof BlackboxType) {
            if (((BlackboxType)type).getKind() == 1) {
                DbColXml ret = new DbColXml();
                dbCol.value = ret;
                typeKind.value = "XML";
            } else {
                DbColBlob ret = new DbColBlob();
                dbCol.value = ret;
                typeKind.value = "BINARY";
            }
        } else if (type instanceof OIDType) {
            DbColVarchar ret = new DbColVarchar();
            ret.setSize(255);
            dbCol.value = ret;
            typeKind.value = "OID";
        } else if (type instanceof FormattedType) {
            DbColVarchar ret = new DbColVarchar();
            ret.setSize(255);
            dbCol.value = ret;
            typeKind.value = "FORMATTED";
        } else if (type instanceof ClassType) {
            DbColVarchar ret = new DbColVarchar();
            ret.setSize(255);
            dbCol.value = ret;
            typeKind.value = "CLASSQNAME";
        } else if (type instanceof AttributePathType) {
            DbColVarchar ret = new DbColVarchar();
            ret.setSize(255);
            dbCol.value = ret;
            typeKind.value = "ATTRIBUTEQNAME";
        } else {
            return false;
        }
        return true;
    }

    private boolean isMultilingualTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return Ili2cUtility.isMultilingualTextAttr(td, attr) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private boolean isLocalisedTextAttr(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return Ili2cUtility.isLocalisedTextAttr(td, attr) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private boolean isChbaseCatalogueRef(TransferDescription td, AttributeDef attr) {
        CompositionType type;
        return Ili2cUtility.isPureChbaseCatalogueRef(td, attr) && (type = (CompositionType)attr.getDomain()).getCardinality().getMaximum() == 1L;
    }

    private boolean isChbaseCatalogueRefMandatory(TransferDescription td, AttributeDef attr) {
        if (Ili2cUtility.isPureChbaseCatalogueRef(td, attr)) {
            CompositionType type = (CompositionType)attr.getDomain();
            if (type.getCardinality().getMinimum() == 0L) {
                return false;
            }
            AttributeDef refAttr = (AttributeDef)((ViewableTransferElement)type.getComponentType().getAttributesAndRoles2().next()).obj;
            return refAttr.getDomain().isMandatoryConsideringAliases();
        }
        return false;
    }

    private void addParentRef(Viewable parentTable, AttributeDef attr) {
        CompositionType type = (CompositionType)attr.getDomainResolvingAll();
        Table structClass = type.getComponentType();
        for (ViewableWrapper structWrapper : this.getStructWrappers((Viewable)structClass)) {
            DbTableName structClassSqlName = structWrapper.getSqlTable();
            DbTable dbTable = this.schema.findTable(structClassSqlName);
            String refAttrSqlName = this.ili2sqlName.mapIliAttributeDefReverse(attr, structClassSqlName.getName(), this.class2wrapper.get(parentTable).getSqlTablename());
            DbColId dbParentId = new DbColId();
            dbParentId.setName(refAttrSqlName);
            dbParentId.setNotNull(false);
            dbParentId.setPrimaryKey(false);
            StringBuffer cmt = new StringBuffer();
            String cmtSep = "";
            if (attr.getDocumentation() != null) {
                cmt.append(cmtSep + attr.getDocumentation());
                cmtSep = this.nl;
            }
            if (cmt.length() > 0) {
                dbParentId.setComment(cmt.toString());
            }
            if (this.createFk) {
                dbParentId.setReferencedTable(this.class2wrapper.get(parentTable).getSqlTable());
            }
            this.metaInfo.setColumnInfo(dbTable.getName().getName(), null, dbParentId.getName(), "ch.ehi.ili2db.foreignKey", this.class2wrapper.get(parentTable).getSqlTablename());
            if (this.createFkIdx) {
                dbParentId.setIndex(true);
            }
            dbTable.addColumn((DbColumn)dbParentId);
        }
    }

    protected void setAttrDbColProps(Viewable aclass, AttributeDef attr, DbColumn dbCol, String sqlName) {
        dbCol.setName(sqlName);
        StringBuffer cmt = new StringBuffer();
        String cmtSep = "";
        if (attr.getDocumentation() != null) {
            cmt.append(cmtSep + attr.getDocumentation());
            cmtSep = this.nl;
        }
        if (cmt.length() > 0) {
            dbCol.setComment(cmt.toString());
        }
        this.setNullable(aclass, attr, dbCol);
    }

    public void setNullable(Viewable aclass, AttributeDef attr, DbColumn dbCol) {
        if (this.sqlEnableNull) {
            dbCol.setNotNull(false);
        } else {
            Type type = attr.getDomain();
            if (type == null) {
                Evaluable[] ev = ((LocalAttribute)attr).getBasePaths();
                type = ((ObjectPath)ev[0]).getType();
            }
            if (type.isMandatoryConsideringAliases() && (attr.getContainer() == aclass || aclass.isExtending((Element)attr.getContainer()))) {
                dbCol.setNotNull(true);
            }
        }
    }

    private DbColumn createSqlTypeCol(String name) {
        DbColVarchar dbCol = new DbColVarchar();
        dbCol.setName(name);
        dbCol.setNotNull(true);
        dbCol.setSize(this.ili2sqlName.getMaxSqlNameLength());
        return dbCol;
    }
}

