/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.filter;

import ch.ehi.basics.settings.Settings;
import ch.ehi.ili2db.base.Ili2cUtility;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.CoordType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.LineType;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.NumericType;
import ch.interlis.ili2c.metamodel.NumericalType;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.PolylineType;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationDataPool;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox_j.filter.IoxFilter;
import ch.interlis.iox_j.validator.Validator;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;

public class Rounder
implements IoxFilter {
    private IoxLogging loggingHandler = null;
    private TransferDescription td = null;
    private Map<String, String> genericDomains = null;

    public Rounder(TransferDescription td, Settings config) {
        this.td = td;
    }

    public IoxEvent filter(IoxEvent event) throws IoxException {
        if (event instanceof StartBasketEvent) {
            this.genericDomains = ((ch.interlis.iox_j.StartBasketEvent)event).getDomains();
        } else if (event instanceof EndBasketEvent) {
            this.genericDomains = null;
        } else if (event instanceof ObjectEvent) {
            IomObject iomObj = ((ObjectEvent)event).getIomObject();
            this.roundObject(iomObj);
        }
        return event;
    }

    private void roundObject(IomObject iomObj) {
        Element modelElement = this.td.getElement(iomObj.getobjecttag());
        if (modelElement == null) {
            return;
        }
        Viewable aclass = (Viewable)modelElement;
        Iterator iter = aclass.getAttributesAndRoles2();
        while (iter.hasNext()) {
            IomObject ref;
            ViewableTransferElement srcProp = (ViewableTransferElement)iter.next();
            if (srcProp.obj instanceof AttributeDef) {
                Type proxyType;
                AttributeDef attr = (AttributeDef)srcProp.obj;
                if (attr.isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType) continue;
                this.roundAttrValue(iomObj, attr);
                continue;
            }
            if (!srcProp.embedded || !(srcProp.obj instanceof RoleDef) || (ref = iomObj.getattrobj(((RoleDef)srcProp.obj).getName(), 0)) == null || ref.getattrcount() <= 0) continue;
            this.roundObject(ref);
        }
    }

    private void roundAttrValue(IomObject iomObj, AttributeDef srcAttr) {
        String srcAttrName = srcAttr.getName();
        int attrc = iomObj.getattrvaluecount(srcAttrName);
        if (attrc == 0) {
            return;
        }
        Type type = srcAttr.getDomainResolvingAll();
        Model model = (Model)srcAttr.getContainer(Model.class);
        for (int attri = 0; attri < attrc; ++attri) {
            String attrValue;
            if (type instanceof NumericType) {
                attrValue = iomObj.getattrprim(srcAttrName, attri);
                try {
                    BigDecimal value = this.roundNumber(attrValue, (NumericType)type);
                    ((Iom_jObject)iomObj).setattrvalue(srcAttrName, attri, value.toString());
                }
                catch (NumberFormatException value) {}
                continue;
            }
            if (type instanceof CoordType) {
                attrValue = iomObj.getattrobj(srcAttrName, attri);
                CoordType coordType = (CoordType)type;
                if (coordType.isGeneric()) {
                    coordType = (CoordType)Ili2cUtility.resolveGenericCoordDomain(srcAttr, null, this.genericDomains).getType();
                }
                this.roundSegment((IomObject)attrValue, coordType);
                continue;
            }
            if (type instanceof PolylineType) {
                attrValue = iomObj.getattrobj(srcAttrName, attri);
                this.roundLine((IomObject)attrValue, (LineType)((PolylineType)type), model);
                continue;
            }
            if (type instanceof SurfaceOrAreaType) {
                attrValue = iomObj.getattrobj(srcAttrName, attri);
                this.roundPolygon((IomObject)attrValue, (SurfaceOrAreaType)type, model);
                continue;
            }
            if (!(srcAttr.getDomain() instanceof CompositionType)) continue;
            attrValue = iomObj.getattrobj(srcAttrName, attri);
            this.roundObject((IomObject)attrValue);
        }
    }

    private void roundPolygon(IomObject surfaceValue, SurfaceOrAreaType type, Model model) {
        int surfacec = surfaceValue.getattrvaluecount("surface");
        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
            IomObject surface = surfaceValue.getattrobj("surface", surfacei);
            int boundaryc = surface.getattrvaluecount("boundary");
            for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                int polylinec = boundary.getattrvaluecount("polyline");
                for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    this.roundLine(polyline, (LineType)type, model);
                }
            }
        }
    }

    private void roundLine(IomObject polylineValue, LineType type, Model model) {
        Domain coordDomain = type.getControlPointDomain();
        CoordType coordType = (CoordType)coordDomain.getType();
        if (coordType.isGeneric()) {
            coordType = (CoordType)Ili2cUtility.resolveGenericCoordDomain(model, coordDomain, null, this.genericDomains).getType();
        }
        int sequencec = polylineValue.getattrvaluecount("sequence");
        for (int sequencei = 0; sequencei < sequencec; ++sequencei) {
            IomObject sequence = polylineValue.getattrobj("sequence", sequencei);
            int segmentc = sequence.getattrvaluecount("segment");
            for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                this.roundSegment(segment, coordType);
            }
        }
    }

    private void roundSegment(IomObject iomObj, CoordType coordType) {
        NumericalType[] dims = coordType.getDimensions();
        for (int i = 0; i < dims.length; ++i) {
            NumericType dimType = (NumericType)dims[i];
            for (String prop : new String[]{"C", "A"}) {
                String propName = prop + Integer.toString(i + 1);
                String attrValue = iomObj.getattrprim(propName, 0);
                if (attrValue == null) continue;
                try {
                    BigDecimal value = this.roundNumber(attrValue, dimType);
                    iomObj.setattrvalue(propName, value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    private BigDecimal roundNumber(String attrValue, NumericType type) {
        PrecisionDecimal minimum = type.getMinimum();
        int precision = minimum.getAccuracy();
        BigDecimal value = Validator.roundNumeric((int)precision, (String)attrValue);
        return value;
    }

    public void close() {
        this.loggingHandler = null;
    }

    public IoxLogging getLoggingHandler() {
        return this.loggingHandler;
    }

    public void setLoggingHandler(IoxLogging errs) {
        this.loggingHandler = errs;
    }

    public IoxValidationDataPool getDataPool() {
        return null;
    }
}

