/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.Iom_jObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iox_j.wkb.ByteArrayOutputStream;
import ch.interlis.iox_j.wkb.Iox2wkbException;
import ch.interlis.iox_j.wkb.LineSegment;
import ch.interlis.iox_j.wkb.RingCollector;
import com.vividsolutions.jts.geom.Coordinate;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class Iox2wkb {
    private int outputDimension = 2;
    private ByteArrayOutputStream os = null;
    private boolean asEWKB = true;

    public Iox2wkb(int outputDimension) {
        this(outputDimension, ByteOrder.BIG_ENDIAN, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder) {
        this(outputDimension, byteOrder, true);
    }

    public Iox2wkb(int outputDimension, ByteOrder byteOrder, boolean asEWKB) {
        this.outputDimension = outputDimension;
        this.asEWKB = asEWKB;
        this.os = new ByteArrayOutputStream(byteOrder);
        if (outputDimension < 2 || outputDimension > 3) {
            throw new IllegalArgumentException("Output dimension must be 2 or 3");
        }
    }

    public static String bytesToHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            buf.append(Iox2wkb.toHexDigit(b >> 4 & 0xF));
            buf.append(Iox2wkb.toHexDigit(b & 0xF));
        }
        return buf.toString();
    }

    private static char toHexDigit(int n) {
        if (n < 0 || n > 15) {
            throw new IllegalArgumentException("Nibble value out of range: " + n);
        }
        if (n <= 9) {
            return (char)(48 + n);
        }
        return (char)(65 + (n - 10));
    }

    public byte[] coord2wkb(IomObject value) throws Iox2wkbException {
        if (value == null) {
            return null;
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(1);
            this.writeCoord(value);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unexpected IO exception: " + ex.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multicoord2wkb(IomObject obj) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            this.writeGeometryType(4);
            int coordc = obj.getattrvaluecount("coord");
            this.os.writeInt(coordc);
            for (int coordi = 0; coordi < coordc; ++coordi) {
                IomObject coord = obj.getattrobj("coord", coordi);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.coord2wkb(coord));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeCoord(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        double zCoord = 0.0;
        if (this.outputDimension == 3) {
            if (c3 != null) {
                try {
                    zCoord = Double.parseDouble(c3);
                }
                catch (Exception ex) {
                    throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
                }
            } else {
                throw new Iox2wkbException("missing C3");
            }
        }
        this.writeCoord(xCoord, yCoord, zCoord);
    }

    private static Coordinate arcSupportingCoord2JTS(IomObject value) throws Iox2wkbException {
        double arcPt_ho;
        double arcPt_re;
        String a1 = value.getattrvalue("A1");
        String a2 = value.getattrvalue("A2");
        try {
            arcPt_re = Double.parseDouble(a1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A1 <" + a1 + ">", ex);
        }
        try {
            arcPt_ho = Double.parseDouble(a2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read A2 <" + a2 + ">", ex);
        }
        return new Coordinate(arcPt_re, arcPt_ho);
    }

    private static Coordinate coord2JTS(IomObject value) throws Iox2wkbException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C1 <" + c1 + ">", ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new Iox2wkbException("failed to read C2 <" + c2 + ">", ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new Iox2wkbException("failed to read C3 <" + c3 + ">", ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    public byte[] polyline2wkb(IomObject polylineObj, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        if (polylineObj == null) {
            return null;
        }
        IomObject[] polylineObjs = new IomObject[]{polylineObj};
        return this.polyline2wkb(polylineObjs, isSurfaceOrArea, asCompoundCurve, p);
    }

    public byte[] polyline2wkb(IomObject[] polylineObjs, boolean isSurfaceOrArea, boolean asCompoundCurve, double p) throws Iox2wkbException {
        ArrayList<List<LineSegment>> lines = new ArrayList<List<LineSegment>>();
        for (int polylinei = 0; polylinei < polylineObjs.length; ++polylinei) {
            IomObject iomObject = polylineObjs[polylinei];
            lines.addAll(this.collectSegments(new IomObject[]{iomObject}, asCompoundCurve, p, false));
        }
        try {
            this.os.reset();
            for (List list : lines) {
                if (asCompoundCurve) {
                    this.writeCompoundCurve(list);
                    continue;
                }
                if (isSurfaceOrArea) {
                    if (((LineSegment)list.get(0)).size() > 1) {
                        throw new Iox2wkbException("Multiple segments in linearring not supported");
                    }
                    this.writeLinearRing((LineSegment)list.get(0));
                    continue;
                }
                this.writeSegments(list);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private List<List<LineSegment>> collectSegments(IomObject[] polylineObjs, boolean asCompoundCurve, double p, boolean repairTouchingLine) throws Iox2wkbException {
        RingCollector ringCollector = new RingCollector(repairTouchingLine);
        ringCollector.startNewRing();
        Coordinate lastCoordinate = null;
        for (IomObject polylineObj : polylineObjs) {
            if (polylineObj == null) continue;
            for (int sequencei = 0; sequencei < polylineObj.getattrvaluecount("sequence"); ++sequencei) {
                IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
                int segmentc = sequence.getattrvaluecount("segment");
                for (int segmenti = 0; segmenti < segmentc; ++segmenti) {
                    IomObject segment = sequence.getattrobj("segment", segmenti);
                    Coordinate segmentCoordinate = Iox2wkb.coord2JTS(segment);
                    lastCoordinate = ringCollector.getLastCoordinate();
                    if (segment.getobjecttag().equals("COORD")) {
                        if (lastCoordinate != null && lastCoordinate.equals((Object)segmentCoordinate)) continue;
                        ringCollector.addStraight(segmentCoordinate);
                        continue;
                    }
                    if (segment.getobjecttag().equals("ARC")) {
                        Coordinate midPt = Iox2wkb.arcSupportingCoord2JTS(segment);
                        if (lastCoordinate != null && lastCoordinate.equals((Object)midPt)) {
                            if (lastCoordinate.equals((Object)segmentCoordinate)) continue;
                            ringCollector.addStraight(segmentCoordinate);
                            continue;
                        }
                        if (midPt.equals((Object)segmentCoordinate)) {
                            if (lastCoordinate != null && lastCoordinate.equals((Object)segmentCoordinate)) continue;
                            ringCollector.addStraight(segmentCoordinate);
                            continue;
                        }
                        if (asCompoundCurve) {
                            ringCollector.addArc(midPt, segmentCoordinate);
                            continue;
                        }
                        if (p == 0.0) {
                            ringCollector.addStraight(midPt);
                            ringCollector.addStraight(segmentCoordinate);
                            continue;
                        }
                        ArcSegment arc = new ArcSegment(lastCoordinate, midPt, segmentCoordinate, p);
                        for (Coordinate c : arc.getCoordinates()) {
                            if (lastCoordinate == null || lastCoordinate.equals((Object)c)) continue;
                            ringCollector.addStraight(c);
                            lastCoordinate = c;
                        }
                        continue;
                    }
                    throw new Iox2wkbException("custom line form not supported");
                }
            }
        }
        return ringCollector.getRings();
    }

    @Deprecated
    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        return this.surface2wkb(obj, asCurvePolygon, strokeP, true);
    }

    public byte[] surface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLine) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        if (obj.getobjectconsistency() == 1) {
            throw new Iox2wkbException("clipped surface not supported");
        }
        ArrayList<List<LineSegment>> rings = new ArrayList<List<LineSegment>>();
        for (int surfacei = 0; surfacei < obj.getattrvaluecount("surface"); ++surfacei) {
            if (surfacei > 0) {
                throw new Iox2wkbException("unclipped surface with multi 'surface' elements");
            }
            IomObject iomObject = obj.getattrobj("surface", surfacei);
            int boundaryc = iomObject.getattrvaluecount("boundary");
            for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                IomObject boundary = iomObject.getattrobj("boundary", boundaryi);
                int polylinec = boundary.getattrvaluecount("polyline");
                ArrayList<IomObject> polylines = new ArrayList<IomObject>();
                for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    if (polyline.getattrobj("lineattr", 0) != null) {
                        throw new Iox2wkbException("Lineattributes not supported");
                    }
                    if (polyline.getobjectconsistency() == 1) {
                        throw new Iox2wkbException("clipped polyline not supported");
                    }
                    polylines.add(polyline);
                }
                rings.addAll(this.collectSegments(polylines.toArray(new IomObject[polylines.size()]), asCurvePolygon, strokeP, repairTouchingLine));
            }
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(asCurvePolygon ? 10 : 3);
            this.os.writeInt(rings.size());
            for (List list : rings) {
                if (asCurvePolygon) {
                    this.writeCompoundCurve(list);
                    continue;
                }
                if (list.size() > 1) {
                    throw new Iox2wkbException("Multiple polylines in linearring not supported");
                }
                this.writeLinearRing((LineSegment)list.get(0));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    @Deprecated
    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP) throws Iox2wkbException {
        return this.multisurface2wkb(obj, asCurvePolygon, strokeP, true);
    }

    public byte[] multisurface2wkb(IomObject obj, boolean asCurvePolygon, double strokeP, boolean repairTouchingLine) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        try {
            this.writeByteOrder();
            this.writeGeometryType(asCurvePolygon ? 12 : 6);
            int surfacec = obj.getattrvaluecount("surface");
            this.os.writeInt(surfacec);
            for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
                IomObject surface = obj.getattrobj("surface", surfacei);
                Iom_jObject iomSurfaceClone = new Iom_jObject("MULTISURFACE", null);
                iomSurfaceClone.addattrobj("surface", surface);
                Iox2wkb helper = new Iox2wkb(this.outputDimension, this.os.order(), this.asEWKB);
                this.os.write(helper.surface2wkb(iomSurfaceClone, asCurvePolygon, strokeP, repairTouchingLine));
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    public byte[] multiline2wkb(IomObject obj, boolean asCurve, double strokeP) throws Iox2wkbException {
        if (obj == null) {
            return null;
        }
        int polylinec = obj.getattrvaluecount("polyline");
        ArrayList<List<LineSegment>> lines = new ArrayList<List<LineSegment>>();
        for (int polylinei = 0; polylinei < polylinec; ++polylinei) {
            IomObject iomObject = obj.getattrobj("polyline", polylinei);
            if (iomObject.getobjectconsistency() == 1) {
                throw new Iox2wkbException("clipped polyline not supported");
            }
            lines.addAll(this.collectSegments(new IomObject[]{iomObject}, asCurve, strokeP, false));
        }
        try {
            this.os.reset();
            this.writeByteOrder();
            this.writeGeometryType(asCurve ? 11 : 5);
            this.os.writeInt(lines.size());
            for (List list : lines) {
                if (asCurve) {
                    this.writeCompoundCurve(list);
                    continue;
                }
                this.writeSegments(list);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unexpected IO exception: " + e.getMessage());
        }
        return this.os.toByteArray();
    }

    private void writeByteOrder() throws IOException {
        if (this.os.order().equals(ByteOrder.LITTLE_ENDIAN)) {
            this.os.write(1);
        } else {
            this.os.write(0);
        }
    }

    private void writeGeometryType(int geometryType) throws IOException {
        int flagIncludeZ = this.asEWKB ? Integer.MIN_VALUE : 1000;
        int flag3D = this.outputDimension == 3 ? flagIncludeZ : 0;
        int typeInt = geometryType + flag3D;
        this.os.writeInt(typeInt);
    }

    private void writeLinearRing(LineSegment line) throws IOException {
        this.os.writeInt(line.size());
        this.writeCoords(line);
    }

    private void writeCompoundCurve(List<LineSegment> segments) throws IOException {
        this.writeByteOrder();
        this.writeGeometryType(9);
        this.os.writeInt(segments.size());
        this.writeSegments(segments);
    }

    private void writeSegments(Iterable<LineSegment> segments) throws IOException {
        for (LineSegment segment : segments) {
            this.writeByteOrder();
            this.writeGeometryType(segment.getWkbType());
            this.os.writeInt(segment.size());
            this.writeCoords(segment);
        }
    }

    private void writeCoords(Iterable<Coordinate> coordinates) {
        for (Coordinate c : coordinates) {
            this.writeCoord(c);
        }
    }

    private void writeCoord(Coordinate coordinate) {
        this.writeCoord(coordinate.x, coordinate.y, coordinate.z);
    }

    private void writeCoord(double xCoord, double yCoord, double zCoord) {
        this.os.writeDouble(xCoord);
        this.os.writeDouble(yCoord);
        if (this.outputDimension == 3) {
            this.os.writeDouble(zCoord);
        }
    }
}

