/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.sqlgen;

import java.io.IOException;
import java.io.PushbackReader;
import java.util.HashMap;
import java.util.Map;

public class SqlReader {
    private SqlReader() {
    }

    public static String readSqlStmt(PushbackReader reader, Map<String, String> params) throws IOException {
        String ret;
        if (params == null) {
            params = new HashMap<String, String>();
        }
        StringBuffer stmt = new StringBuffer();
        int c = reader.read();
        while (c != -1) {
            if (c == 45) {
                c = reader.read();
                if (c == -1) {
                    stmt.append('-');
                    break;
                }
                if (c == 45) {
                    c = reader.read();
                    SqlReader.readCmt(c, reader);
                } else {
                    stmt.append('-');
                    stmt.append((char)c);
                }
            } else if (c == 39) {
                SqlReader.readQuotedString(c, reader, stmt, '\'');
            } else if (c == 34) {
                SqlReader.readQuotedString(c, reader, stmt, '\"');
            } else if (c == 36) {
                SqlReader.readParam(c, reader, stmt, params);
            } else if (c == 59) {
                c = reader.read();
                if (c == 10) {
                    c = reader.read();
                    if (c != -1 && c != 13) {
                        reader.unread(c);
                    }
                } else if (c == 13) {
                    c = reader.read();
                    if (c != -1 && c != 10) {
                        reader.unread(c);
                    }
                } else if (c != -1) {
                    reader.unread(c);
                }
                if (stmt.toString().trim().length() > 0) {
                    break;
                }
            } else if (c == 10) {
                c = reader.read();
                if (c != -1 && c != 13) {
                    reader.unread(c);
                }
                if (stmt.length() > 0) {
                    stmt.append(' ');
                }
            } else if (c == 13) {
                c = reader.read();
                if (c != -1 && c != 10) {
                    reader.unread(c);
                }
                if (stmt.length() > 0) {
                    stmt.append(' ');
                }
            } else {
                stmt.append((char)c);
            }
            c = reader.read();
        }
        if ((ret = stmt.toString().trim()).length() == 0) {
            return null;
        }
        return ret;
    }

    private static void readQuotedString(int c, PushbackReader reader, StringBuffer stmt, char quote) throws IOException {
        stmt.append((char)c);
        while ((c = reader.read()) != -1) {
            if (c == quote) {
                c = reader.read();
                if (c == -1) break;
                if (c == quote) {
                    stmt.append(quote);
                    stmt.append(quote);
                    continue;
                }
                reader.unread(c);
                break;
            }
            stmt.append((char)c);
        }
        stmt.append(quote);
    }

    private static void readParam(int c, PushbackReader reader, StringBuffer stmt, Map<String, String> params) throws IOException {
        c = reader.read();
        StringBuffer paramName = new StringBuffer();
        if (c == 36) {
            stmt.append('$');
            return;
        }
        if (c != 123) {
            stmt.append('$');
            reader.unread(c);
            return;
        }
        while (true) {
            if ((c = reader.read()) == -1) {
                throw new IOException("unexpected termination of parameter");
            }
            if (c == 125) break;
            paramName.append((char)c);
        }
        String paramValue = params.get(paramName.toString());
        if (paramValue != null) {
            stmt.append(paramValue);
        }
    }

    private static void readCmt(int c, PushbackReader reader) throws IOException {
        while (c != -1) {
            if (c == 10) {
                c = reader.read();
                if (c == -1 || c == 13) break;
                reader.unread(c);
                break;
            }
            if (c == 13) {
                c = reader.read();
                if (c == -1 || c == 10) break;
                reader.unread(c);
                break;
            }
            c = reader.read();
        }
    }
}

