/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.validator.functions;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Evaluable;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.FunctionCall;
import ch.interlis.ili2c.metamodel.ObjectPath;
import ch.interlis.ili2c.metamodel.Objects;
import ch.interlis.ili2c.metamodel.PathEl;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.TextType;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.iom.IomObject;
import ch.interlis.iox.IoxValidationConfig;
import ch.interlis.iox_j.validator.Validator;
import ch.interlis.iox_j.validator.Value;
import java.util.Iterator;
import java.util.Map;

public class Interlis {
    private TransferDescription td = null;
    private IoxValidationConfig validationConfig = null;
    private Validator validator = null;

    public Interlis(Validator validator, TransferDescription td, IoxValidationConfig validationConfig) {
        this.td = td;
        this.validationConfig = validationConfig;
        this.validator = validator;
    }

    public Value evaluateFunction(Function currentFunction, FunctionCall functionCallObj, IomObject parentObject, String validationKind, String usageScope, IomObject iomObj, TextType texttype, Evaluable expression, Map<Evaluable, Value> functions, TransferDescription td, RoleDef firstRole) {
        if (currentFunction.getScopedName(null).equals("INTERLIS.len") || currentFunction.getScopedName(null).equals("INTERLIS.lenM")) {
            Evaluable[] arguments;
            for (Evaluable anArgument : arguments = functionCallObj.getArguments()) {
                Value arg = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, anArgument, firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (arg.getValue() == null) continue;
                int lengthOfArgument = arg.getValue().length();
                return new Value(lengthOfArgument);
            }
            return new Value(false);
        }
        if (currentFunction.getScopedName(null).equals("INTERLIS.trim") || currentFunction.getScopedName(null).equals("INTERLIS.trimM")) {
            int n = 0;
            Evaluable[] arguments = functionCallObj.getArguments();
            Evaluable[] evaluableArray = arguments;
            int n2 = evaluableArray.length;
            if (n < n2) {
                Evaluable anArgument = evaluableArray[n];
                Value arg = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, anArgument, firstRole);
                if (arg.skipEvaluation()) {
                    return arg;
                }
                if (arg.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                return new Value((Type)texttype, arg.getValue().trim());
            }
        } else {
            if (currentFunction.getScopedName(null).equals("INTERLIS.isEnumSubVal")) {
                Evaluable[] arguments = functionCallObj.getArguments();
                Value subEnum = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                if (subEnum.skipEvaluation()) {
                    return subEnum;
                }
                if (subEnum.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                Value nodeEnum = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[1], firstRole);
                if (nodeEnum.skipEvaluation()) {
                    return nodeEnum;
                }
                if (nodeEnum.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (subEnum.getValue().toString().startsWith(nodeEnum.getValue().toString())) {
                    return new Value(true);
                }
                return new Value(false);
            }
            if (currentFunction.getScopedName(null).equals("INTERLIS.inEnumRange")) {
                EnumerationType enumerationType;
                Evaluable[] arguments = functionCallObj.getArguments();
                Value enumToCompare = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                if (enumToCompare.skipEvaluation()) {
                    return enumToCompare;
                }
                if (enumToCompare.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                Value minEnum = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[1], firstRole);
                if (minEnum.skipEvaluation()) {
                    return minEnum;
                }
                if (minEnum.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                Value maxEnum = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[2], firstRole);
                if (maxEnum.skipEvaluation()) {
                    return maxEnum;
                }
                if (maxEnum.isUndefined()) {
                    return Value.createSkipEvaluation();
                }
                if (enumToCompare.getType() instanceof EnumerationType && (enumerationType = (EnumerationType)enumToCompare.getType()).isOrdered() && enumToCompare.getRefTypeName().equals(minEnum.getRefTypeName()) && enumToCompare.getRefTypeName().equals(maxEnum.getRefTypeName())) {
                    int indexOfEnumToCompare = enumerationType.getValues().indexOf(enumToCompare.getValue());
                    int indexOfMinEnumValue = enumerationType.getValues().indexOf(minEnum.getValue());
                    int indexOfMaxEnumValue = enumerationType.getValues().indexOf(maxEnum.getValue());
                    if (indexOfEnumToCompare > indexOfMinEnumValue && indexOfEnumToCompare < indexOfMaxEnumValue) {
                        return new Value(true);
                    }
                }
                return new Value(false);
            }
            if (currentFunction.getScopedName(null).equals("INTERLIS.objectCount")) {
                FunctionCall functionCall = (FunctionCall)expression;
                Evaluable[] arguments = functionCall.getArguments();
                Value value = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                if (value.skipEvaluation()) {
                    return value;
                }
                if (value.isUndefined()) {
                    return new Value(0.0);
                }
                if (value.getComplexObjects() != null) {
                    return new Value(value.getComplexObjects().size());
                }
                if (value.getViewable() != null) {
                    if (functions.containsKey(functionCall)) {
                        return functions.get(functionCall);
                    }
                    Value objectCount = null;
                    objectCount = this.validator.evaluateObjectCount(value);
                    functions.put((Evaluable)functionCall, objectCount);
                    return objectCount;
                }
                if (value.getOid() != null) {
                    return new Value(1.0);
                }
            } else {
                if (currentFunction.getScopedName(null).equals("INTERLIS.elementCount")) {
                    FunctionCall functionCall = (FunctionCall)expression;
                    Evaluable[] arguments = functionCall.getArguments();
                    Evaluable anArgument = arguments[0];
                    Value value = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, anArgument, firstRole);
                    if (value.skipEvaluation()) {
                        return value;
                    }
                    if (value.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    return new Value(value.getComplexObjects().size());
                }
                if (currentFunction.getScopedName(null).equals("INTERLIS.isOfClass")) {
                    FunctionCall functionCall = (FunctionCall)expression;
                    Evaluable[] arguments = functionCall.getArguments();
                    Value paramObject = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                    if (paramObject.skipEvaluation()) {
                        return paramObject;
                    }
                    if (paramObject.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    Value paramClass = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[1], firstRole);
                    if (paramClass.skipEvaluation()) {
                        return paramClass;
                    }
                    if (paramClass.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    Viewable paramObjectViewable = paramObject.getViewable();
                    if (paramObject.getComplexObjects() != null) {
                        paramObjectViewable = (Viewable)td.getElement(paramObject.getComplexObjects().iterator().next().getobjecttag());
                    }
                    if (paramObjectViewable.equals(paramClass.getViewable())) {
                        return new Value(true);
                    }
                    if (paramObjectViewable.isExtending((Element)paramClass.getViewable())) {
                        return new Value(true);
                    }
                    return new Value(false);
                }
                if (currentFunction.getScopedName(null).equals("INTERLIS.isSubClass")) {
                    FunctionCall functionCall = (FunctionCall)expression;
                    Evaluable[] arguments = functionCall.getArguments();
                    Value subViewable = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                    if (subViewable.skipEvaluation()) {
                        return subViewable;
                    }
                    if (subViewable.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    Value superViewable = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[1], firstRole);
                    if (superViewable.skipEvaluation()) {
                        return superViewable;
                    }
                    if (superViewable.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    if (subViewable.getViewable().equals(superViewable.getViewable())) {
                        return new Value(true);
                    }
                    if (superViewable.getViewable().isExtending((Element)subViewable.getViewable())) {
                        return new Value(true);
                    }
                    return new Value(false);
                }
                if (currentFunction.getScopedName(null).equals("INTERLIS.myClass")) {
                    FunctionCall functionCall = (FunctionCall)expression;
                    Evaluable[] arguments = functionCall.getArguments();
                    Value targetViewable = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                    if (targetViewable.skipEvaluation()) {
                        return targetViewable;
                    }
                    if (targetViewable.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    return new Value((Viewable)td.getElement(targetViewable.getComplexObjects().iterator().next().getobjecttag()));
                }
                if (currentFunction.getScopedName(null).equals("INTERLIS.areAreas")) {
                    Value argSurfaceAttr;
                    FunctionCall functionCall = (FunctionCall)expression;
                    Evaluable[] arguments = functionCall.getArguments();
                    Value argObjects = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[0], firstRole);
                    if (argObjects.skipEvaluation()) {
                        return argObjects;
                    }
                    if (argObjects.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    Value argSurfaceBag = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[1], firstRole);
                    if (argSurfaceBag.skipEvaluation()) {
                        return argSurfaceBag;
                    }
                    Viewable currentClass = null;
                    if (iomObj != null) {
                        currentClass = (Viewable)td.getElement(iomObj.getobjecttag());
                    } else if (argObjects.getViewable() != null) {
                        currentClass = argObjects.getViewable();
                    } else if (argObjects.getComplexObjects() != null) {
                        Iterator<IomObject> it = argObjects.getComplexObjects().iterator();
                        if (!it.hasNext()) {
                            return new Value(true);
                        }
                        currentClass = (Viewable)td.getElement(it.next().getobjecttag());
                    } else {
                        throw new IllegalStateException("unkown class in " + usageScope);
                    }
                    ObjectPath surfaceBagObjPath = null;
                    PathEl[] surfaceBagPath = null;
                    Viewable viewable = null;
                    if (!argSurfaceBag.isUndefined()) {
                        try {
                            surfaceBagObjPath = this.validator.parseObjectOrAttributePath(currentClass, argSurfaceBag.getValue());
                            if (surfaceBagObjPath.getPathElements() != null) {
                                PathEl[] surfaceBagPathEl;
                                surfaceBagPath = surfaceBagPathEl = surfaceBagObjPath.getPathElements();
                                viewable = surfaceBagObjPath.getViewable();
                            }
                        }
                        catch (Ili2cException e) {
                            EhiLogger.logError((Throwable)e);
                        }
                    }
                    if ((argSurfaceAttr = this.validator.evaluateExpression(parentObject, validationKind, usageScope, iomObj, arguments[2], firstRole)).skipEvaluation()) {
                        return argSurfaceAttr;
                    }
                    if (argSurfaceAttr.isUndefined()) {
                        return Value.createSkipEvaluation();
                    }
                    Viewable attrObjClass = null;
                    attrObjClass = viewable != null ? viewable : currentClass;
                    PathEl[] surfaceAttrPath = null;
                    ObjectPath surfaceAttrObjPath = null;
                    try {
                        surfaceAttrObjPath = this.validator.parseObjectOrAttributePath(attrObjClass, argSurfaceAttr.getValue());
                        if (surfaceAttrObjPath.getPathElements() != null) {
                            PathEl[] surfaceAttrPathEl;
                            surfaceAttrPath = surfaceAttrPathEl = surfaceAttrObjPath.getPathElements();
                        }
                    }
                    catch (Ili2cException e) {
                        EhiLogger.logError((Throwable)e);
                    }
                    if (functions.containsKey(functionCall) && arguments[0] instanceof Objects) {
                        return functions.get(functionCall);
                    }
                    Value isArea = this.validator.evaluateAreArea(iomObj, argObjects, surfaceBagPath, surfaceAttrPath, currentFunction, validationKind);
                    functions.put((Evaluable)functionCall, isArea);
                    return isArea;
                }
            }
        }
        return null;
    }
}

