/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.settings.Settings;
import ch.ehi.iox.objpool.ObjectPoolManager;
import ch.interlis.ili2c.Ili2c;
import ch.interlis.ili2c.Ili2cException;
import ch.interlis.ili2c.Main;
import ch.interlis.ili2c.config.Configuration;
import ch.interlis.ili2c.config.FileEntry;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.modelscan.IliFile;
import ch.interlis.ili2c.modelscan.IliModel;
import ch.interlis.ilirepository.IliFiles;
import ch.interlis.ilirepository.IliManager;
import ch.interlis.ilirepository.impl.ModelMetadata;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.ValidatorHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CheckReposIlis {
    private boolean validationErrors = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkRepoIlis(Configuration config, Settings settings) {
        Main.setHttpProxySystemProperties(settings);
        HashSet<IliFile> failedFiles = new HashSet<IliFile>();
        ArrayList<MetaEntryProblem> inconsistentMetaEntry = new ArrayList<MetaEntryProblem>();
        File tmpFolder = ObjectPoolManager.getCacheTmpFilename();
        try {
            Iterator reposi = config.iteratorFileEntry();
            while (reposi.hasNext()) {
                String[] modeldirs;
                File ilimodelsXmlFile;
                FileEntry e = (FileEntry)reposi.next();
                if (e.getKind() != 1) continue;
                String repos = e.getFilename();
                RepositoryAccess reposAccess = new RepositoryAccess();
                try {
                    ilimodelsXmlFile = reposAccess.getLocalFileLocation(repos, "ilimodels.xml", 0L, null);
                }
                catch (RepositoryAccessException e2) {
                    EhiLogger.logError((Throwable)e2);
                    continue;
                }
                if (ilimodelsXmlFile == null) {
                    EhiLogger.logAdaption((String)("URL <" + repos + "> contains no " + "ilimodels.xml" + "; ignored"));
                    continue;
                }
                Source[] schemaFiles = null;
                try {
                    Source[] schemaFiles2;
                    schemaFiles = schemaFiles2 = new Source[]{new StreamSource(this.getClass().getResource("/IliRepository.xsd").toString())};
                }
                catch (NullPointerException ex) {
                    EhiLogger.logError((String)"failed to create schema", (Throwable)ex);
                }
                Schema schema = null;
                if (schemaFiles != null) {
                    SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                    try {
                        schema = factory.newSchema(schemaFiles);
                    }
                    catch (SAXException ex) {
                        EhiLogger.logError((String)"failed to read schema", (Throwable)ex);
                    }
                }
                if (schema != null) {
                    ValidatorHandler validator = schema.newValidatorHandler();
                    validator.setErrorHandler(new ErrorHandler(){

                        @Override
                        public void error(SAXParseException ex) throws SAXException {
                            EhiLogger.logError((String)("ilimodels.xml:" + ex.getLineNumber() + ":" + ex.getColumnNumber() + ":" + ex.getMessage()));
                            CheckReposIlis.this.validationErrors = true;
                        }

                        @Override
                        public void fatalError(SAXParseException ex) throws SAXException {
                            EhiLogger.logError((Throwable)ex);
                        }

                        @Override
                        public void warning(SAXParseException ex) throws SAXException {
                            EhiLogger.logError((Throwable)ex);
                        }
                    });
                    XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                    try {
                        XMLReader parser = XMLReaderFactory.createXMLReader();
                        parser.setErrorHandler(validator.getErrorHandler());
                        parser.setContentHandler(validator);
                        parser.parse(ilimodelsXmlFile.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        EhiLogger.logError((String)"failed to validate ilimodels.xml", (Throwable)ex);
                    }
                }
                IliManager manager = new IliManager();
                ArrayList<String> modeldirv = new ArrayList<String>();
                String ilidirs = settings.getValue("ch.interlis.ili2c.ilidirs");
                for (String m : modeldirs = ilidirs.split(";")) {
                    if (m.startsWith("%")) continue;
                    modeldirv.add(m);
                }
                manager.setRepositories(modeldirv.toArray(new String[1]));
                IliFiles ilimodelsFiles = null;
                List<ModelMetadata> ilimodelsEntries = null;
                try {
                    ilimodelsEntries = RepositoryAccess.readIliModelsXml2(ilimodelsXmlFile);
                    ilimodelsEntries = RepositoryAccess.getLatestVersions2(ilimodelsEntries);
                    ilimodelsFiles = RepositoryAccess.createIliFiles2(repos, ilimodelsEntries);
                }
                catch (RepositoryAccessException e2) {
                    EhiLogger.logError((Throwable)e2);
                    continue;
                }
                Iterator<IliFile> filei = ilimodelsFiles.iteratorFile();
                while (filei.hasNext()) {
                    IliFile ilimodelsFile = filei.next();
                    EhiLogger.logState((String)("check file <" + ilimodelsFile.getPath() + "> in <" + ilimodelsFile.getRepositoryUri() + ">"));
                    ArrayList<String> modelsInFile = new ArrayList<String>();
                    ArrayList<String> requiredModels = new ArrayList<String>();
                    double iliversion = 0.0;
                    Iterator modeli = ilimodelsFile.iteratorModel();
                    while (modeli.hasNext()) {
                        IliModel model = (IliModel)modeli.next();
                        iliversion = model.getIliVersion();
                        modelsInFile.add(model.getName());
                        for (String reqModel : model.getDependencies()) {
                            if (reqModel.equals("INTERLIS") || requiredModels.contains(reqModel)) continue;
                            requiredModels.add(reqModel);
                        }
                    }
                    Iterator requiredModelIt = requiredModels.iterator();
                    while (requiredModelIt.hasNext()) {
                        String requiredModel = (String)requiredModelIt.next();
                        if (!modelsInFile.contains(requiredModel)) continue;
                        requiredModelIt.remove();
                    }
                    Configuration fileconfig = new Configuration();
                    try {
                        File localIliFileInIliCache = reposAccess.getLocalFileLocation(ilimodelsFile.getRepositoryUri(), ilimodelsFile.getPath(), 0L, ilimodelsFile.getMd5());
                        if (localIliFileInIliCache == null) {
                            EhiLogger.logError((String)("File <" + ilimodelsFile.getPath() + "> not found"));
                            failedFiles.add(ilimodelsFile);
                            continue;
                        }
                        File localIliFile = new File(tmpFolder, localIliFileInIliCache.getName());
                        try {
                            RepositoryAccess.copyFile(localIliFile, localIliFileInIliCache);
                            fileconfig.setAutoCompleteModelList(false);
                            if (requiredModels.size() > 0) {
                                Configuration fconfig = manager.getConfig(requiredModels, iliversion);
                                Iterator fi = fconfig.iteratorFileEntry();
                                while (fi.hasNext()) {
                                    fileconfig.addFileEntry((FileEntry)fi.next());
                                }
                            }
                            fileconfig.addFileEntry(new FileEntry(localIliFile.getAbsolutePath(), 1));
                            Ili2c.logIliFiles(fileconfig);
                            fileconfig.setGenerateWarnings(false);
                            TransferDescription td = Main.runCompiler(fileconfig, settings);
                            if (td == null) {
                                failedFiles.add(ilimodelsFile);
                                continue;
                            }
                            String md5 = RepositoryAccess.calcMD5(localIliFile);
                            for (Model model : td) {
                                if (model == td.INTERLIS || model.getFileName() == null || !model.getFileName().equals(localIliFile.getAbsolutePath())) continue;
                                EhiLogger.logState((String)("check entry of model " + model.getName()));
                                String csl = null;
                                if (model.getIliVersion().equals("1")) {
                                    csl = "ili1";
                                } else if (model.getIliVersion().equals("2.2")) {
                                    csl = "ili2_2";
                                } else if (model.getIliVersion().equals("2.3")) {
                                    csl = "ili2_3";
                                } else if (model.getIliVersion().equals("2.4")) {
                                    csl = "ili2_4";
                                } else {
                                    throw new IllegalStateException("unexpected ili version");
                                }
                                ModelMetadata modelMetadata = RepositoryAccess.findModelMetadata2(ilimodelsEntries, model.getName(), csl);
                                if (modelMetadata == null) {
                                    inconsistentMetaEntry.add(new MetaEntryProblem(null, model.getName(), "entry missing or wrong model name in ilimodels.xml for " + ilimodelsFile.getPath()));
                                    continue;
                                }
                                if (modelMetadata.getMd5() != null && !modelMetadata.getMd5().equalsIgnoreCase(md5)) {
                                    inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong md5 value; correct would be " + md5));
                                }
                                if (model.getIliVersion().equals("2.3") || model.getIliVersion().equals("2.4")) {
                                    if (modelMetadata.getVersion() != null && !modelMetadata.getVersion().equals(model.getModelVersion())) {
                                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong version value; correct would be " + model.getModelVersion()));
                                    }
                                    if (modelMetadata.getVersionComment() != null && !modelMetadata.getVersionComment().equals(model.getModelVersionExpl())) {
                                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong versionComment value; correct would be " + model.getModelVersionExpl()));
                                    }
                                    if (modelMetadata.getIssuer() != null && !modelMetadata.getIssuer().equals(model.getIssuer())) {
                                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong issuer value; correct would be " + model.getIssuer()));
                                    }
                                }
                                HashSet<String> depsMeta = new HashSet<String>();
                                HashSet<String> depsIli = new HashSet<String>();
                                for (String dep : modelMetadata.getDependsOnModel()) {
                                    if (dep.equals("INTERLIS")) {
                                        inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "INTERLIS must not be listed as dependsOnModel"));
                                        continue;
                                    }
                                    depsMeta.add(dep);
                                }
                                String sep = "";
                                StringBuilder missingDeps = new StringBuilder();
                                for (Model dep : model.getImporting()) {
                                    String depIli = dep.getName();
                                    depsIli.add(depIli);
                                    if (depIli.equals("INTERLIS") || depsMeta.contains(depIli)) continue;
                                    missingDeps.append(sep);
                                    missingDeps.append(depIli);
                                    sep = ",";
                                }
                                if (missingDeps.length() <= 0) continue;
                                inconsistentMetaEntry.add(new MetaEntryProblem(modelMetadata.getOid(), model.getName(), "wrong depends list; misssing models " + missingDeps.toString()));
                            }
                        }
                        catch (Ili2cException e1) {
                            EhiLogger.logError((Throwable)e1);
                            failedFiles.add(ilimodelsFile);
                        }
                        finally {
                            localIliFile.delete();
                        }
                    }
                    catch (RepositoryAccessException e1) {
                        EhiLogger.logError((Throwable)e1);
                        failedFiles.add(ilimodelsFile);
                    }
                }
            }
        }
        finally {
            tmpFolder.delete();
        }
        if (inconsistentMetaEntry.size() > 0) {
            Collections.sort(inconsistentMetaEntry, new Comparator<MetaEntryProblem>(){

                @Override
                public int compare(MetaEntryProblem arg0, MetaEntryProblem arg1) {
                    int c1 = arg0.getModelName().compareTo(arg1.getModelName());
                    if (c1 == 0) {
                        if (arg0.getTid() == null) {
                            if (arg1.getTid() == null) {
                                return 0;
                            }
                            return -1;
                        }
                        if (arg1.getTid() == null) {
                            return 1;
                        }
                        return arg0.getTid().compareTo(arg1.getTid());
                    }
                    return c1;
                }
            });
            for (MetaEntryProblem prb : inconsistentMetaEntry) {
                if (prb.getTid() == null) {
                    EhiLogger.logError((String)(prb.getModelName() + ": " + prb.getMsg()));
                    continue;
                }
                EhiLogger.logError((String)(prb.getModelName() + "(TID=\"" + prb.getTid() + "\"): " + prb.getMsg()));
            }
        }
        if (failedFiles.size() != 0) {
            StringBuilder failed = new StringBuilder();
            String sep = "";
            for (IliFile f : failedFiles) {
                failed.append(sep);
                failed.append(f.getPath());
                sep = ", ";
            }
            EhiLogger.logError((String)("compile failed with files: " + failed));
            if (this.validationErrors) {
                EhiLogger.logError((String)"syntax errors in ilimodels.xml");
            }
        }
        return !failedFiles.isEmpty() || !inconsistentMetaEntry.isEmpty();
    }

    private class MetaEntryProblem {
        private String modelName = null;
        private String tid = null;
        private String msg = null;

        public MetaEntryProblem(String tid1, String modelName1, String msg1) {
            this.modelName = modelName1;
            this.tid = tid1;
            this.msg = msg1;
        }

        public String getModelName() {
            return this.modelName;
        }

        public String getTid() {
            return this.tid;
        }

        public String getMsg() {
            return this.msg;
        }
    }
}

