/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.DerivedUnit;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.PrecisionDecimal;
import java.beans.PropertyVetoException;
import java.util.List;

public class NumericallyDerivedUnit
extends DerivedUnit {
    protected Factor[] conversionFactors = new Factor[0];

    public void setConversionFactors(Factor[] conversionFactors) throws PropertyVetoException {
        Factor[] oldValue = this.conversionFactors;
        Factor[] newValue = conversionFactors;
        if (oldValue == newValue) {
            return;
        }
        this.fireVetoableChange("conversionFactors", oldValue, newValue);
        this.conversionFactors = conversionFactors;
        this.firePropertyChange("conversionFactors", oldValue, newValue);
    }

    public Factor[] getConversionFactors() {
        return this.conversionFactors;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        super.checkTranslationOf(errs, name, baseName);
        NumericallyDerivedUnit baseElement = (NumericallyDerivedUnit)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Object err = null;
        if (this.getConversionFactors().length != baseElement.getConversionFactors().length) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), NumericallyDerivedUnit.formatMessage("err_diff_mismatchUnitDef", this.getScopedName(), baseElement.getScopedName())));
        } else {
            for (int i = 0; i < this.getConversionFactors().length; ++i) {
                if (i > 0 && this.conversionFactors[i].conversionOperator != baseElement.conversionFactors[i].conversionOperator) {
                    errs.add(new Ili2cSemanticException(this.getSourceLine(), NumericallyDerivedUnit.formatMessage("err_diff_mismatchUnitDef", this.getScopedName(), baseElement.getScopedName())));
                }
                if (PrecisionDecimal.equals(this.conversionFactors[i].conversionFactor, baseElement.conversionFactors[i].conversionFactor)) continue;
                errs.add(new Ili2cSemanticException(this.getSourceLine(), NumericallyDerivedUnit.formatMessage("err_diff_mismatchUnitDef", this.getScopedName(), baseElement.getScopedName())));
            }
        }
    }

    public static class Factor {
        protected char conversionOperator;
        protected PrecisionDecimal conversionFactor;

        public Factor(char conversionOperator, PrecisionDecimal conversionFactor) {
            this.conversionOperator = conversionOperator;
            this.conversionFactor = conversionFactor;
            if (conversionOperator == '*') {
                if (conversionFactor.doubleValue() == 0.0) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_zeroUnitConversionFactor"));
                }
            } else if (conversionOperator == '/') {
                if (conversionFactor.doubleValue() == 0.0) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_zeroUnitDivisor"));
                }
            } else {
                throw new IllegalArgumentException(Element.rsrc.getString("err_illegalConversionOperator"));
            }
        }

        public PrecisionDecimal getConversionFactor() {
            return this.conversionFactor;
        }

        public char getConversionOperator() {
            return this.conversionOperator;
        }
    }
}

