/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.ContextDef;
import ch.interlis.ili2c.metamodel.Contract;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Function;
import ch.interlis.ili2c.metamodel.GraphicParameterDef;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Importable;
import ch.interlis.ili2c.metamodel.LineForm;
import ch.interlis.ili2c.metamodel.MetaDataUseDef;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.TranslatedElementNameComparator;
import ch.interlis.ili2c.metamodel.TypeModel;
import ch.interlis.ili2c.metamodel.Unit;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Model
extends Importable<Element> {
    protected List<Element> contents = new LinkedList<Element>();
    protected List<GraphicParameterDef> runtimeParameters = new LinkedList<GraphicParameterDef>();
    protected List<ModelImport> imports = new ArrayList<ModelImport>();
    private final List<Contract> contracts = new LinkedList<Contract>();
    private String language = null;
    private boolean contracted = false;
    private String issuer = null;
    private String modelVersion = null;
    private String modelVersionExpl = null;
    private Boolean noIncrementalTransfer = null;
    private String charSetIANAName = null;
    private String xmlns = null;
    private String iliVersion = "2.3";
    public static final String ILI1 = "1";
    public static final String ILI2_2 = "2.2";
    public static final String ILI2_3 = "2.3";
    public static final String ILI2_4 = "2.4";
    private String filename = null;
    private String translationOf = null;
    private String translationOfVersion = null;

    public void addPreLast(Element o) {
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        o.setContainer(this);
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add((GraphicParameterDef)o);
        }
        this.contents.add(this.contents.size() - 1, o);
    }

    public void addBefore(Element o, Element last) {
        int idx;
        if (!((ElementDelegate)this.elements).checkChildElement(o)) {
            return;
        }
        o.setContainer(this);
        if (o instanceof GraphicParameterDef) {
            this.runtimeParameters.add((GraphicParameterDef)o);
        }
        if ((idx = this.contents.indexOf(last)) > -1) {
            this.contents.add(idx, o);
        } else {
            this.contents.add(o);
        }
    }

    protected Model() {
        this.name = "";
    }

    @Override
    protected Collection<Element> createElements() {
        return new ElementDelegate();
    }

    public Element getImportedElement(Class<?> aclass, String name) {
        Element e = this.getElement(aclass, name);
        if (e != null) {
            return e;
        }
        for (ModelImport mi : this.imports) {
            Model i;
            if (!mi.isUnqualified() || (e = (i = mi.getModel()).getElement(aclass, name)) == null) continue;
            return e;
        }
        return null;
    }

    private Element getElement(String name) {
        if (name != null) {
            for (Element e : this.contents) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
        }
        return null;
    }

    private Element getRuntimeParameter(String name) {
        if (name != null) {
            for (GraphicParameterDef e : this.runtimeParameters) {
                if (!name.equals(e.getName())) continue;
                return e;
            }
        }
        return null;
    }

    @Override
    public boolean isDependentOn(Element e) {
        if (e instanceof Model) {
            return this.isImporting((Model)e);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Model.checkNameSanity(newValue, false);
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public boolean isContracted() {
        return this.contracted || !this.contracts.isEmpty();
    }

    public void setContracted(boolean contracted1) {
        this.contracted = contracted1;
    }

    public void setIssuer(String issuer1) {
        this.issuer = issuer1;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setModelVersion(String modelVersion1) {
        this.modelVersion = modelVersion1;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public void setModelVersionExpl(String modelVersionExpl1) {
        this.modelVersionExpl = modelVersionExpl1;
    }

    public String getModelVersionExpl() {
        return this.modelVersionExpl;
    }

    public void addContract(Contract contract) {
        this.contracts.add(contract);
    }

    public Contract[] getContracts() {
        return this.contracts.toArray(new Contract[this.contracts.size()]);
    }

    public Model[] getImporting() {
        ArrayList<Model> importing = new ArrayList<Model>();
        for (ModelImport mi : this.imports) {
            importing.add(mi.getModel());
        }
        return importing.toArray(new Model[importing.size()]);
    }

    public void addImport(Model importing, boolean unqualified) {
        this.imports.add(new ModelImport(importing, unqualified));
        importing.importedBy.add(importing);
    }

    public boolean isImporting(Model importing) {
        for (ModelImport mi : this.imports) {
            if (mi.getModel() != importing) continue;
            return true;
        }
        return false;
    }

    public boolean isImporting(Model importing, boolean qualifiedImport) {
        for (ModelImport mi : this.imports) {
            if (mi.isUnqualified() != !qualifiedImport || mi.getModel() != importing) continue;
            return true;
        }
        return false;
    }

    public void setLanguage(String v) {
        this.language = v;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setFileName(String filename) {
        this.filename = filename;
    }

    public String getFileName() {
        return this.filename;
    }

    public String getIliVersion() {
        return this.iliVersion;
    }

    public void setIliVersion(String string) {
        this.iliVersion = string;
    }

    public boolean isIli23() {
        return ILI2_3.equals(this.iliVersion);
    }

    public Boolean getNoIncrementalTransfer() {
        return this.noIncrementalTransfer;
    }

    public void setNoIncrementalTransfer(boolean noIncrementalTransfer) {
        this.noIncrementalTransfer = noIncrementalTransfer;
    }

    public String getCharSetIANAName() {
        return this.charSetIANAName;
    }

    public void setCharSetIANAName(String charSetIANAName) {
        this.charSetIANAName = charSetIANAName;
    }

    public String getXmlns() {
        return this.xmlns;
    }

    public void setXmlns(String xmlns) {
        this.xmlns = xmlns;
    }

    public void setTranslationOf(String baseModel, String baseVersion) {
        this.translationOf = baseModel;
        this.translationOfVersion = baseVersion;
    }

    @Override
    public void checkIntegrity(List<Ili2cSemanticException> errs) throws IllegalStateException {
        super.checkIntegrity(errs);
        if (this.translationOf != null) {
            Element baseModel = this.getContainer().getElement(Model.class, this.translationOf);
            if (baseModel == null) {
                throw new IllegalStateException(Model.formatMessage("err_noSuchModel", this.translationOf));
            }
            if (baseModel == this) {
                errs.add(new Ili2cSemanticException(this.getSourceLine(), Model.formatMessage("err_model_differentName", this.getScopedName())));
                return;
            }
            this.linkTranslationOf(baseModel);
            this.checkTranslationOf(errs, this.getName(), baseModel.getName());
        }
    }

    public Domain[] resolveGenericDomain(Domain generic) {
        Domain[] concretes = this.getConcreteDomains(generic);
        if (concretes != null) {
            return concretes;
        }
        HashSet<Model> visitedModels = new HashSet<Model>();
        return Model.resolveGenericDomain_deepFirstSearch(generic, this, visitedModels);
    }

    public Domain[] resolveGenericDomainFromImportedModels(Domain generic) {
        HashSet<Model> visitedModels = new HashSet<Model>();
        return Model.resolveGenericDomain_deepFirstSearch(generic, this, visitedModels);
    }

    private static Domain[] resolveGenericDomain_deepFirstSearch(Domain generic, Model model, Set<Model> visitedModels) {
        Model[] imps = model.getImporting();
        for (int i = imps.length - 1; i >= 0; --i) {
            Model imp = imps[i];
            if (visitedModels.contains(imp)) continue;
            visitedModels.add(imp);
            Domain[] concretes = imp.getConcreteDomains(generic);
            if (concretes != null) {
                return concretes;
            }
            concretes = Model.resolveGenericDomain_deepFirstSearch(generic, imp, visitedModels);
            if (concretes == null) continue;
            return concretes;
        }
        return null;
    }

    public Domain[] getConcreteDomains(Domain generic) {
        Iterator eleIt = this.iterator();
        while (eleIt.hasNext()) {
            ContextDef def;
            Object ele = eleIt.next();
            if (!(ele instanceof ContextDef) || (def = (ContextDef)ele).getGeneric() != generic) continue;
            return def.getConcretes();
        }
        return null;
    }

    public Domain mapGenericDomain(Domain genericCoordDomain, Map<String, String> genericDomains) {
        String genericQname = genericCoordDomain.getScopedName();
        String concreteQname = genericDomains.get(genericQname);
        if (concreteQname == null) {
            throw new IllegalArgumentException("no assignment of a concrete domain for the generic domain " + genericQname);
        }
        Element ele = ((TransferDescription)this.getContainer()).getElement(concreteQname);
        if (ele == null || !(ele instanceof Domain)) {
            throw new IllegalArgumentException("no concrete domain " + concreteQname + " (for the generic domain " + genericQname + ")");
        }
        return (Domain)ele;
    }

    @Override
    public void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) throws IllegalStateException {
        Model[] baseImps;
        super.checkTranslationOf(errs, name, baseName);
        Model baseElement = (Model)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        if (this.isContracted() != baseElement.isContracted()) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Model.formatMessage("err_diff_mismatchInContracted", this.getScopedName(), baseElement.getScopedName())));
        }
        if (!this.getClass().equals(baseElement.getClass())) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Model.formatMessage("err_diff_kindModelMismatch", this.getScopedName(), baseElement.getScopedName())));
        }
        Ili2cSemanticException err = null;
        Model[] imps = this.getImporting();
        if (imps.length != (baseImps = baseElement.getImporting()).length) {
            errs.add(new Ili2cSemanticException(this.getSourceLine(), Model.formatMessage("err_diff_importsMismatch")));
        } else {
            ArrayList impModels = new ArrayList(imps.length);
            Collections.addAll(impModels, imps);
            Collections.sort(impModels, new TranslatedElementNameComparator());
            ArrayList baseimpModels = new ArrayList(baseImps.length);
            Collections.addAll(baseimpModels, baseImps);
            Collections.sort(baseimpModels, new TranslatedElementNameComparator());
            for (int impi = 0; impi < imps.length; ++impi) {
                Model baseImp;
                Model imp = (Model)impModels.get(impi);
                err = Model.checkElementRef(imp, baseImp = (Model)baseimpModels.get(impi), this.getSourceLine(), "err_diff_importsMismatch");
                if (err == null) continue;
                errs.add(err);
            }
        }
    }

    protected class ElementDelegate
    extends AbstractCollection<Element> {
        protected ElementDelegate() {
        }

        @Override
        public Iterator<Element> iterator() {
            return new CombiningIterator<Element>(new Iterator[]{Model.this.runtimeParameters.iterator(), Model.this.contents.iterator()});
        }

        @Override
        public int size() {
            return Model.this.runtimeParameters.size() + Model.this.contents.size();
        }

        @Override
        public boolean add(Element o) {
            if (!this.checkChildElement(o)) {
                return false;
            }
            if (o instanceof GraphicParameterDef) {
                return Model.this.runtimeParameters.add((GraphicParameterDef)o);
            }
            return Model.this.contents.add(o);
        }

        public boolean checkChildElement(Element e) {
            if (e instanceof MetaDataUseDef) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_nonuniqueMetaDataUseDefName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Unit) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_duplicateUnitName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Function) {
                if (Model.this.isIli23() && !Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_model_functionButNoContract", e.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_function_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (e instanceof LineForm) {
                if (!Model.this.isContracted() && !(Model.this instanceof PredefinedModel)) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_lineForm_inUnconctractedModel", Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_lineForm_duplicateName", e.getName(), Model.this.toString(), conflicting.toString()));
                }
                return true;
            }
            if (e instanceof Domain) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_duplicateDomainName", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof GraphicParameterDef) {
                Element conflicting = Model.this.getRuntimeParameter(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_graphicparam_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Topic) {
                if (Model.this instanceof TypeModel) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_typeModel_addTopic", e.toString(), Model.this.toString()));
                }
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_topic_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof Table) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_table_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            if (e instanceof ContextDef) {
                Element conflicting = Model.this.getElement(e.getName());
                if (conflicting != null && conflicting != e) {
                    throw new Ili2cSemanticException(e.getSourceLine(), Element.formatMessage("err_contextdef_nonunique", e.getName(), Model.this.toString()));
                }
                return true;
            }
            throw new ClassCastException(Element.formatMessage("err_container_cannotContain", Model.this.toString(), e.toString()));
        }
    }

    private class ModelImport {
        private Model model;
        private boolean unqualified;

        public ModelImport(Model model1, boolean unqualified1) {
            this.model = model1;
            this.unqualified = unqualified1;
        }

        public Model getModel() {
            return this.model;
        }

        public boolean isUnqualified() {
            return this.unqualified;
        }
    }
}

