/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.nls;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.tools.StringUtility;
import ch.ehi.ili2db.base.Ili2dbException;
import ch.ehi.ili2db.mapping.NameMapping;
import ch.ehi.sqlgen.generator_impl.jdbc.GeneratorJdbc;
import ch.ehi.sqlgen.repository.DbColBlob;
import ch.ehi.sqlgen.repository.DbColVarchar;
import ch.ehi.sqlgen.repository.DbColumn;
import ch.ehi.sqlgen.repository.DbSchema;
import ch.ehi.sqlgen.repository.DbTable;
import ch.ehi.sqlgen.repository.DbTableName;
import ch.interlis.ili2c.generator.nls.Ili2TranslationXml;
import ch.interlis.ili2c.generator.nls.NlsModelElement;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.PredefinedModel;
import ch.interlis.ili2c.metamodel.TransferDescription;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NlsUtility {
    private static final String UIVARIANT_ILI = "ili";

    public static void addNlsTable(DbSchema schema) {
        DbTable tab = new DbTable();
        tab.setName(new DbTableName(schema.getName(), "T_ILI2DB_NLS"));
        DbColVarchar ilielementCol = new DbColVarchar();
        ilielementCol.setName("ilielement");
        ilielementCol.setNotNull(true);
        ilielementCol.setSize(255);
        tab.addColumn((DbColumn)ilielementCol);
        DbColVarchar langCol = new DbColVarchar();
        langCol.setName("lang");
        langCol.setNotNull(false);
        langCol.setSize(20);
        tab.addColumn((DbColumn)langCol);
        DbColVarchar uivariantCol = new DbColVarchar();
        uivariantCol.setName("uivariant");
        uivariantCol.setNotNull(false);
        uivariantCol.setSize(30);
        tab.addColumn((DbColumn)uivariantCol);
        DbColVarchar labelCol = new DbColVarchar();
        labelCol.setName("label");
        labelCol.setNotNull(false);
        labelCol.setSize(70);
        tab.addColumn((DbColumn)labelCol);
        DbColVarchar mnemonicCol = new DbColVarchar();
        mnemonicCol.setName("mnemonic");
        mnemonicCol.setNotNull(false);
        mnemonicCol.setSize(20);
        tab.addColumn((DbColumn)mnemonicCol);
        DbColVarchar tooltipCol = new DbColVarchar();
        tooltipCol.setName("tooltip");
        tooltipCol.setNotNull(false);
        tooltipCol.setSize(200);
        tab.addColumn((DbColumn)tooltipCol);
        DbColVarchar descriptionCol = new DbColVarchar();
        descriptionCol.setName("descr");
        descriptionCol.setNotNull(false);
        descriptionCol.setSize(-1);
        tab.addColumn((DbColumn)descriptionCol);
        DbColBlob symbolCol = new DbColBlob();
        symbolCol.setName("symbol");
        symbolCol.setNotNull(false);
        tab.addColumn((DbColumn)symbolCol);
        schema.addTable(tab);
    }

    public static void updateNlsTable(GeneratorJdbc gen, Connection conn, String schema, TransferDescription td, NameMapping class2wrapper) throws Ili2dbException {
        HashMap<NlsKey, NlsEntry> entries = new HashMap<NlsKey, NlsEntry>();
        Iterator transIter = td.iterator();
        ArrayList<Model> models = new ArrayList<Model>();
        while (transIter.hasNext()) {
            Model transElem = (Model)transIter.next();
            if (transElem instanceof PredefinedModel || !(transElem instanceof Model)) continue;
            models.add(0, transElem);
        }
        Ili2TranslationXml ili2cHelper = new Ili2TranslationXml();
        List modelEles = ili2cHelper.convertModels(models.toArray(new Model[models.size()]));
        for (NlsModelElement modelEle : modelEles) {
            for (String lang : modelEle.getLanguages()) {
                NlsEntry entry = new NlsEntry();
                entry.ilielementCol = modelEle.getScopedName();
                entry.langCol = lang;
                entry.uivariantCol = UIVARIANT_ILI;
                entry.labelCol = modelEle.getName(lang);
                String dispName = NlsUtility.getDispName(modelEle, entry.langCol);
                if (dispName != null) {
                    entry.labelCol = dispName;
                }
                entry.mnemonicCol = null;
                entry.tooltipCol = null;
                entry.descriptionCol = modelEle.getDocumentation(lang);
                entry.symbolCol = null;
                entries.put(new NlsKey(entry.ilielementCol, entry.langCol, entry.uivariantCol), entry);
            }
        }
        NlsUtility.saveTableTab(gen, conn, schema, entries);
    }

    private static String getDispName(NlsModelElement modelEle, String lang) {
        String value = null;
        if ((lang = StringUtility.purge((String)lang)) != null) {
            value = StringUtility.purge((String)modelEle.getMetaAttr("ili2db.dispName_" + lang));
        }
        if (value == null) {
            value = StringUtility.purge((String)modelEle.getMetaAttr("ili2db.dispName"));
        }
        if (value != null) {
            return value;
        }
        return null;
    }

    private static void saveTableTab(GeneratorJdbc gen, Connection conn, String schemaName, Map<NlsKey, NlsEntry> tabInfo) throws Ili2dbException {
        DbTableName tabName = new DbTableName(schemaName, "T_ILI2DB_NLS");
        String sqlName = tabName.getQName();
        if (conn != null) {
            Map<NlsKey, NlsEntry> exstEntries = NlsUtility.readTableTab(conn, sqlName);
            try {
                String insStmt = "INSERT INTO " + sqlName + " (" + "ilielement" + "," + "lang" + "," + "uivariant" + "," + "label" + "," + "mnemonic" + "," + "tooltip" + "," + "descr" + "," + "symbol" + ") VALUES (?,?,?,?,?,?,?,?)";
                EhiLogger.traceBackendCmd((String)insStmt);
                try (PreparedStatement insPrepStmt = conn.prepareStatement(insStmt);){
                    for (Map.Entry<NlsKey, NlsEntry> entry : tabInfo.entrySet()) {
                        if (exstEntries.containsKey(entry.getKey())) continue;
                        insPrepStmt.setString(1, entry.getValue().ilielementCol);
                        insPrepStmt.setString(2, entry.getValue().langCol);
                        insPrepStmt.setString(3, entry.getValue().uivariantCol);
                        insPrepStmt.setString(4, entry.getValue().labelCol);
                        insPrepStmt.setString(5, entry.getValue().mnemonicCol);
                        insPrepStmt.setString(6, entry.getValue().tooltipCol);
                        insPrepStmt.setString(7, entry.getValue().descriptionCol);
                        insPrepStmt.setBytes(8, entry.getValue().symbolCol);
                        insPrepStmt.executeUpdate();
                    }
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to update meta-info table " + sqlName, ex);
            }
        }
        if (gen != null) {
            for (Map.Entry<NlsKey, NlsEntry> entry : tabInfo.entrySet()) {
                String insStmt = "INSERT INTO " + sqlName + " (" + "ilielement" + "," + "lang" + "," + "uivariant" + "," + "label" + "," + "mnemonic" + "," + "tooltip" + "," + "descr" + ") VALUES (" + NlsUtility.quoteSqlValue(entry.getValue().ilielementCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().langCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().uivariantCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().labelCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().mnemonicCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().tooltipCol) + "," + NlsUtility.quoteSqlValue(entry.getValue().descriptionCol) + ")";
                GeneratorJdbc generatorJdbc = gen;
                generatorJdbc.getClass();
                gen.addCreateLine((GeneratorJdbc.AbstractStmt)new GeneratorJdbc.Stmt(generatorJdbc, insStmt));
            }
        }
    }

    private static String quoteSqlValue(String val) {
        return val != null ? "'" + val + "'" : "NULL";
    }

    private static Map<NlsKey, NlsEntry> readTableTab(Connection conn, String sqlName) throws Ili2dbException {
        HashMap<NlsKey, NlsEntry> exstEntries = new HashMap<NlsKey, NlsEntry>();
        try {
            String selStmt = "SELECT ilielement,lang,uivariant,label,mnemonic,tooltip,descr,symbol FROM " + sqlName;
            EhiLogger.traceBackendCmd((String)selStmt);
            PreparedStatement selPrepStmt = null;
            ResultSet rs = null;
            try {
                selPrepStmt = conn.prepareStatement(selStmt);
                rs = selPrepStmt.executeQuery();
                while (rs.next()) {
                    NlsEntry entry = new NlsEntry();
                    entry.ilielementCol = rs.getString(1);
                    entry.langCol = rs.getString(2);
                    entry.uivariantCol = rs.getString(3);
                    entry.labelCol = rs.getString(4);
                    entry.mnemonicCol = rs.getString(5);
                    entry.tooltipCol = rs.getString(6);
                    entry.descriptionCol = rs.getString(7);
                    entry.symbolCol = rs.getBytes(8);
                    NlsKey key = new NlsKey(entry.ilielementCol, entry.langCol, entry.uivariantCol);
                    exstEntries.put(key, entry);
                }
            }
            catch (SQLException ex) {
                throw new Ili2dbException("failed to read nls info values from " + sqlName, ex);
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
                if (selPrepStmt != null) {
                    selPrepStmt.close();
                    selPrepStmt = null;
                }
            }
        }
        catch (SQLException ex) {
            throw new Ili2dbException("failed to read nls-info table " + sqlName, ex);
        }
        return exstEntries;
    }

    public static class NlsEntry {
        public String ilielementCol = null;
        public String langCol = null;
        public String uivariantCol = null;
        public String labelCol = null;
        public String mnemonicCol = null;
        public String tooltipCol = null;
        public String descriptionCol = null;
        public byte[] symbolCol = null;
    }

    public static class NlsKey {
        public String ilielementCol = null;
        public String langCol = null;
        public String uivariantCol = null;

        public NlsKey(String ilielementCol, String langCol, String uivariantCol) {
            this.ilielementCol = ilielementCol;
            this.langCol = langCol;
            this.uivariantCol = uivariantCol;
        }

        public int hashCode() {
            return Objects.hash(this.ilielementCol, this.langCol, this.uivariantCol);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NlsKey other = (NlsKey)obj;
            return Objects.equals(this.ilielementCol, other.ilielementCol) && Objects.equals(this.langCol, other.langCol) && Objects.equals(this.uivariantCol, other.uivariantCol);
        }
    }
}

