/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.CombiningIterator;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.Selection;
import ch.interlis.ili2c.metamodel.SignAttribute;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Viewable;
import java.beans.PropertyVetoException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Graphic
extends ExtendableContainer<Element> {
    protected String name = "";
    protected List<SignAttribute> contents = new LinkedList<SignAttribute>();
    protected List<Selection> selections = new LinkedList<Selection>();
    protected Viewable basedOn = null;

    @Override
    protected Collection<Element> createElements() {
        return new AbstractCollection<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new CombiningIterator<Element>(new Iterator[]{Graphic.this.selections.iterator(), Graphic.this.contents.iterator()});
            }

            @Override
            public int size() {
                return Graphic.this.selections.size() + Graphic.this.contents.size();
            }

            @Override
            public boolean add(Element o) {
                if (o == null) {
                    throw new IllegalArgumentException(Element.rsrc.getString("err_nullNotAcceptable"));
                }
                if (o instanceof SignAttribute) {
                    return Graphic.this.contents.add((SignAttribute)o);
                }
                if (o instanceof Selection) {
                    return Graphic.this.selections.add((Selection)o);
                }
                throw new ClassCastException();
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "GRAPHIC " + this.getScopedName(null);
    }

    public void setName(String name) throws PropertyVetoException {
        String oldValue = this.name;
        String newValue = name;
        Graphic.checkNameSanity(newValue, false);
        this.checkNameUniqueness(newValue, Graphic.class, this.getRealExtending(), "err_graphic_duplicateName");
        this.fireVetoableChange("name", oldValue, newValue);
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    @Override
    public void setAbstract(boolean abst) throws PropertyVetoException {
        if (!abst && this.basedOn != null && this.basedOn.isAbstract()) {
            throw new IllegalArgumentException(Graphic.formatMessage("err_graphic_concreteWhileBasedOnAbstract", this.toString(), this.basedOn.toString()));
        }
        super.setAbstract(abst);
    }

    @Override
    public boolean isDependentOn(Element e) {
        if (this.basedOn != null && this.basedOn.isDependentOn(e)) {
            return true;
        }
        return super.isDependentOn(e);
    }

    public Viewable getBasedOn() {
        return this.basedOn;
    }

    public void setBasedOn(Viewable basedOn) throws PropertyVetoException {
        Viewable oldValue = this.basedOn;
        Viewable newValue = basedOn;
        if (oldValue == newValue) {
            return;
        }
        if (newValue instanceof Table && !((Table)newValue).isIdentifiable()) {
            throw new IllegalArgumentException(Graphic.formatMessage("err_graphic_basedOnStructure", this.toString(), newValue.toString()));
        }
        if (newValue != null && !this.isAbstract() && newValue.isAbstract()) {
            throw new IllegalArgumentException(Graphic.formatMessage("err_graphic_concreteBasedOnAbstract", this.toString(), newValue.toString()));
        }
        Viewable extendingBasedOn = this.extending != null ? ((Graphic)this.extending).basedOn : null;
        if (extendingBasedOn != null && newValue != null && !newValue.isExtending(extendingBasedOn)) {
            throw new IllegalArgumentException(Graphic.formatMessage("err_graphic_basedOnNotExtendingInheritedBasedOn", this.toString(), newValue.toString(), this.extending.toString(), extendingBasedOn.toString()));
        }
        this.fireVetoableChange("basedOn", oldValue, newValue);
        this.basedOn = newValue;
        this.firePropertyChange("basedOn", oldValue, newValue);
    }

    @Override
    public Viewable getRHSNameSpace() {
        return this.basedOn;
    }
}

