/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.logging;

import ch.ehi.basics.logging.LogEvent;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.StdListener;
import ch.ehi.basics.logging.StdLogEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class EhiLogger {
    private static EhiLogger instance = null;
    private Set<LogListener> logListenerv = new HashSet<LogListener>();
    private boolean filterTrace = true;
    private int recursive = 0;
    private Set<LogListener> healthyListeners = null;

    public void addListener(LogListener logListener) {
        if (logListener == null) {
            return;
        }
        EhiLogger.getInstance().logListenerv.add(logListener);
    }

    public void removeListener(LogListener logListener) {
        if (logListener == null || !EhiLogger.getInstance().logListenerv.contains(logListener)) {
            return;
        }
        EhiLogger.getInstance().logListenerv.remove(logListener);
        if (EhiLogger.getInstance().logListenerv.size() == 0) {
            StdListener.getInstance().logEvent(new StdLogEvent(7, "no logging listeners left", null, EhiLogger.getOrigin()));
        }
    }

    public static EhiLogger getInstance() {
        if (instance == null) {
            instance = new EhiLogger();
            instance.addListener(StdListener.getInstance());
        }
        return instance;
    }

    private EhiLogger() {
    }

    public void setTraceFilter(boolean enableFilter) {
        this.filterTrace = enableFilter;
    }

    public boolean getTraceFilter() {
        return this.filterTrace;
    }

    public void logEvent(LogEvent event) {
        this.logInternalEvent(EhiLogger.getInstance().logListenerv, event);
    }

    private void logInternalEvent(Set<LogListener> listeners, LogEvent event) {
        int kind = event.getEventKind();
        if (EhiLogger.getInstance().filterTrace && (kind == 1 || kind == 2 || kind == 3 || kind == 4)) {
            return;
        }
        if (kind < 1 || kind > 7) {
            StdLogEvent internalEvent = new StdLogEvent(7, "illegal kind", null, EhiLogger.getOrigin());
            if (listeners == null) {
                StdListener.getInstance().logEvent(internalEvent);
            } else {
                this.logInternalEvent(listeners, internalEvent);
            }
            return;
        }
        String msg = event.getEventMsg();
        if ((msg == null || msg.trim().length() == 0) && event.getException() == null) {
            StdLogEvent internalEvent = new StdLogEvent(7, "null or empty log-message", null, EhiLogger.getOrigin());
            if (listeners == null) {
                StdListener.getInstance().logEvent(internalEvent);
            } else {
                this.logInternalEvent(listeners, internalEvent);
            }
            return;
        }
        if (listeners == null || listeners.size() == 0) {
            StdListener.getInstance().logEvent(event);
        } else {
            Iterator<LogListener> it = listeners.iterator();
            while (it.hasNext()) {
                LogListener listener = it.next();
                try {
                    listener.logEvent(event);
                }
                catch (Throwable ex) {
                    it.remove();
                    StdLogEvent internalEvent = new StdLogEvent(7, null, ex, EhiLogger.getOrigin());
                    this.logInternalEvent(listeners, internalEvent);
                }
            }
        }
    }

    public void logInternalEventFromListener(LogListener caller, LogEvent event) {
        if (this.recursive == 0) {
            this.healthyListeners = new HashSet<LogListener>(EhiLogger.getInstance().logListenerv);
        }
        if (caller != null) {
            this.healthyListeners.remove(caller);
        }
        try {
            ++this.recursive;
            this.logInternalEvent(this.healthyListeners, event);
        }
        finally {
            --this.recursive;
        }
    }

    public static void debug(String msg) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(1, msg, null, EhiLogger.getOrigin()));
    }

    public static void debug(String msg, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(1, msg, null, EhiLogger.getOrigin(), level));
    }

    public static void debugStackTrace() {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            EhiLogger.debug(stack[i].toString());
        }
    }

    public static void debugStackTrace(int level) {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        for (int i = 1; i < stack.length; ++i) {
            EhiLogger.debug(stack[i].toString(), level);
        }
    }

    public static void traceState(String state) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(2, state, null, EhiLogger.getOrigin()));
    }

    public static void traceState(String state, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(2, state, null, EhiLogger.getOrigin(), level));
    }

    public static void traceUnusualState(String state) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(3, state, null, EhiLogger.getOrigin()));
    }

    public static void traceUnusualState(String state, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(3, state, null, EhiLogger.getOrigin(), level));
    }

    public static void traceBackendCmd(String cmd) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(4, cmd, null, EhiLogger.getOrigin()));
    }

    public static void traceBackendCmd(String cmd, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(4, cmd, null, EhiLogger.getOrigin(), level));
    }

    public static void logState(String state) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(5, state, null, EhiLogger.getOrigin()));
    }

    public static void logState(String state, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(5, state, null, EhiLogger.getOrigin(), level));
    }

    public static void logAdaption(String adaption) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(6, adaption, null, EhiLogger.getOrigin()));
    }

    public static void logAdaption(String adaption, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(6, adaption, null, EhiLogger.getOrigin(), level));
    }

    public static void logError(String errmsg) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, errmsg, null, EhiLogger.getOrigin()));
    }

    public static void logError(String errmsg, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, errmsg, null, EhiLogger.getOrigin(), level));
    }

    public static void logError(String errmsg, Throwable ex) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, errmsg, ex, EhiLogger.getOrigin()));
    }

    public static void logError(String errmsg, Throwable ex, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, errmsg, ex, EhiLogger.getOrigin(), level));
    }

    public static void logError(Throwable ex) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, null, ex, EhiLogger.getOrigin()));
    }

    public static void logError(Throwable ex, int level) {
        EhiLogger.getInstance().logEvent(new StdLogEvent(7, null, ex, EhiLogger.getOrigin(), level));
    }

    private static StackTraceElement getOrigin() {
        Throwable tr = new Throwable();
        StackTraceElement[] stack = tr.getStackTrace();
        if (2 < stack.length) {
            StackTraceElement st = stack[2];
            return st;
        }
        return null;
    }

    public static String kindToString(int eventKind) {
        switch (eventKind) {
            case 1: {
                return "DEBUG_TRACE";
            }
            case 2: {
                return "STATE_TRACE";
            }
            case 3: {
                return "UNUSUAL_STATE_TRACE";
            }
            case 4: {
                return "BACKEND_CMD";
            }
            case 5: {
                return "STATE";
            }
            case 6: {
                return "ADAPTION";
            }
            case 7: {
                return "ERROR";
            }
        }
        throw new IllegalArgumentException("illegal event kind");
    }
}

