/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.iox.objpool.impl;

import ch.ehi.iox.objpool.impl.Serializer;
import java.io.IOException;

public class LongSerializer
implements Serializer<Long> {
    @Override
    public byte[] getBytes(Long value) throws IOException {
        byte[] b = new byte[8];
        LongSerializer.longToBytes(value, b);
        return b;
    }

    @Override
    public Long getObject(byte[] bytes) throws IOException, ClassNotFoundException {
        return LongSerializer.bytesToLong(bytes);
    }

    public static final long bytesToLong(byte[] b) {
        assert (b.length >= 8);
        return (((long)b[0] & 0xFFL) << 56) + (((long)b[1] & 0xFFL) << 48) + (((long)b[2] & 0xFFL) << 40) + (((long)b[3] & 0xFFL) << 32) + (((long)b[4] & 0xFFL) << 24) + (((long)b[5] & 0xFFL) << 16) + (((long)b[6] & 0xFFL) << 8) + (((long)b[7] & 0xFFL) << 0);
    }

    public static final void longToBytes(long v, byte[] b) {
        assert (b.length >= 8);
        b[0] = (byte)(v >>> 56 & 0xFFL);
        b[1] = (byte)(v >>> 48 & 0xFFL);
        b[2] = (byte)(v >>> 40 & 0xFFL);
        b[3] = (byte)(v >>> 32 & 0xFFL);
        b[4] = (byte)(v >>> 24 & 0xFFL);
        b[5] = (byte)(v >>> 16 & 0xFFL);
        b[6] = (byte)(v >>> 8 & 0xFFL);
        b[7] = (byte)(v >>> 0 & 0xFFL);
    }

    public static final int bytesToInteger(byte[] b, int offset) {
        assert (b.length >= offset + 4);
        return ((b[offset + 0] & 0xFF) << 24) + ((b[offset + 1] & 0xFF) << 16) + ((b[offset + 2] & 0xFF) << 8) + ((b[offset + 3] & 0xFF) << 0);
    }

    public static final void integerToBytes(int v, byte[] b, int offset) {
        assert (b.length >= offset + 4);
        b[0 + offset] = (byte)(v >>> 24 & 0xFF);
        b[1 + offset] = (byte)(v >>> 16 & 0xFF);
        b[2 + offset] = (byte)(v >>> 8 & 0xFF);
        b[3 + offset] = (byte)(v >>> 0 & 0xFF);
    }

    public static final void doubleToBytes(double value, byte[] b) {
        long v = Double.doubleToRawLongBits(value);
        LongSerializer.longToBytes(v, b);
    }

    public static final double bytesToDouble(byte[] b) {
        long v = LongSerializer.bytesToLong(b);
        return Double.longBitsToDouble(v);
    }
}

