/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.statistics;

import java.util.concurrent.TimeUnit;

public class Stopwatch {
    private long startTime;
    private long elapsedTime;

    public Stopwatch() {
        this.Reset();
    }

    public void Start() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
    }

    public void Stop() {
        if (this.startTime != -1L) {
            this.elapsedTime += System.currentTimeMillis() - this.startTime;
            this.startTime = -1L;
        }
    }

    public long getElapsedTime() {
        long runningTimeMs = this.startTime == -1L ? 0L : System.currentTimeMillis() - this.startTime;
        return this.elapsedTime + runningTimeMs;
    }

    public void Reset() {
        this.startTime = -1L;
        this.elapsedTime = 0L;
    }

    public String toString() {
        long days = TimeUnit.MILLISECONDS.toDays(this.elapsedTime);
        long hours = TimeUnit.MILLISECONDS.toHours(this.elapsedTime) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(this.elapsedTime));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(this.elapsedTime) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(this.elapsedTime));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(this.elapsedTime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(this.elapsedTime));
        long millis = TimeUnit.MILLISECONDS.toMillis(this.elapsedTime) - TimeUnit.SECONDS.toMillis(TimeUnit.MILLISECONDS.toSeconds(this.elapsedTime));
        if (days == 0L) {
            return String.format("%02dh:%02dm:%02ds.%04dms", hours, minutes, seconds, millis);
        }
        return String.format("%ddd %02dh:%02dm:%02ds.%04dms", days, hours, minutes, seconds, millis);
    }
}

