/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.inifile;

import ch.interlis.iox_j.validator.ValidationConfig;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class IniFileWriter {
    private IniFileWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeIniFile(File metaConfigFile, ValidationConfig metaConfig) throws IOException {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(metaConfigFile), Charset.forName("UTF-8")));
            Set<String> sectionsS = metaConfig.getIliQnames();
            if (sectionsS != null) {
                ArrayList<String> sections = new ArrayList<String>(sectionsS);
                Collections.sort(sections);
                for (String section : sections) {
                    writer.write("[" + section + "]");
                    writer.newLine();
                    Set<String> paramsS = metaConfig.getConfigParams(section);
                    if (paramsS == null) continue;
                    ArrayList<String> params = new ArrayList<String>(paramsS);
                    Collections.sort(params);
                    for (String param : params) {
                        String value = metaConfig.getConfigValue(section, param);
                        if (value == null) continue;
                        writer.write(param + "=");
                        writer.write(IniFileWriter.quoteValue(value));
                        writer.newLine();
                    }
                }
            }
        }
        finally {
            if (writer != null) {
                writer.close();
                writer = null;
            }
        }
    }

    private static String quoteValue(String value) {
        if (value == null) {
            return null;
        }
        for (int idx = 0; idx < value.length(); ++idx) {
            if (Character.isLetterOrDigit(value.charAt(idx))) continue;
            StringBuffer ret = new StringBuffer();
            ret.append("\"");
            for (int j = 0; j < value.length(); ++j) {
                char c = value.charAt(j);
                if (c == '\\' || c == '\"') {
                    ret.append('\\');
                }
                ret.append(c);
            }
            ret.append("\"");
            return ret.toString();
        }
        return value;
    }
}

