/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf;

import ch.interlis.ili2c.metamodel.AssociationDef;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.xtf.OidSpace;
import ch.interlis.iom_j.xtf.XtfStartTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxFactoryCollection;
import ch.interlis.iox.IoxReader;
import ch.interlis.iox_j.DefaultIoxFactoryCollection;
import ch.interlis.iox_j.EndBasketEvent;
import ch.interlis.iox_j.EndTransferEvent;
import ch.interlis.iox_j.IoxIliReader;
import ch.interlis.iox_j.IoxSyntaxException;
import ch.interlis.iox_j.ObjectEvent;
import ch.interlis.iox_j.StartBasketEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class Xtf23Reader
implements IoxReader,
IoxIliReader {
    private XMLEventReader reader = null;
    private IoxFactoryCollection factory = new DefaultIoxFactoryCollection();
    private InputStream inputFile = null;
    private int oidSpaceSize = 0;
    private ArrayList<String> models = null;
    private Set<String> filterTopics = null;
    private int state = 0;
    private static final int START = 0;
    private static final int AFTER_STARTTRANSFER = 1;
    private static final int AFTER_STARTBASKET = 2;
    private static final int AFTER_OBJECT = 3;
    private static final int AFTER_ENDBASKET = 4;
    private static final int AFTER_ENDTRANSFER = 5;
    public static final String NAMESPACE_ILIXMLBASE = "http://www.interlis.ch/INTERLIS2.3";
    private String currentModelName = null;
    private String currentTopicName = null;
    private String currentViewableName = null;
    private static final String INTERLIS_VERSION_23 = "2.3";
    private static final QName QNAME_XML_HEADERSECTION = new QName("http://www.interlis.ch/INTERLIS2.3", "HEADERSECTION");
    private static final QName QNAME_XML_HEADERSECTION_SENDER = new QName("SENDER");
    private static final QName QNAME_XML_HEADERSECTION_VERSION = new QName("VERSION");
    private static final QName QNAME_XML_MODELS = new QName("http://www.interlis.ch/INTERLIS2.3", "MODELS");
    private static final QName QNAME_XML_MODEL = new QName("http://www.interlis.ch/INTERLIS2.3", "MODEL");
    private static final QName QNAME_XML_MODEL_NAME = new QName("NAME");
    private static final QName QNAME_XML_MODEL_VERSION = new QName("VERSION");
    private static final QName QNAME_XML_MODEL_URI = new QName("URI");
    private static final QName QNAME_XML_OIDSPACES = new QName("http://www.interlis.ch/INTERLIS2.3", "OIDSPACES");
    private static final QName QNAME_XML_OIDSPACE = new QName("http://www.interlis.ch/INTERLIS2.3", "OIDSPACE");
    private static final QName QNAME_XML_OIDSPACE_OIDDOMAIN = new QName("OIDDOMAIN");
    private static final QName QNAME_XML_OIDSPACE_NAME = new QName("NAME");
    private static final QName QNAME_XML_ENTRIES = new QName("http://www.interlis.ch/INTERLIS2.3", "ENTRIES");
    private static final QName QNAME_XML_COMMENT = new QName("http://www.interlis.ch/INTERLIS2.3", "COMMENT");
    private static final QName QNAME_XML_ALIAS = new QName("http://www.interlis.ch/INTERLIS2.3", "ALIAS");
    private static final QName QNAME_XML_ENTRIES_TAGENTRY = new QName("http://www.interlis.ch/INTERLIS2.3", "TAGENTRY");
    private static final QName QNAME_XML_ENTRIES_VALENTRY = new QName("http://www.interlis.ch/INTERLIS2.3", "VALENTRY");
    private static final QName QNAME_XML_ENTRIES_DELENTRY = new QName("http://www.interlis.ch/INTERLIS2.3", "DELENTRY");
    private static final QName QNAME_XML_ENTRIES_VALUE_ATTR = new QName("ATTR");
    private static final QName QNAME_XML_ENTRIES_VALUE_FROM = new QName("FROM");
    private static final QName QNAME_XML_ENTRIES_VALUE_TO = new QName("TO");
    private static final QName QNAME_XML_ENTRIES_VALUE_TAG = new QName("TAG");
    private static final QName QNAME_XML_ENTRIES_VALUE_FOR = new QName("FOR");
    private static final QName QNAME_XML_TOPIC_BID = new QName("BID");
    private static final QName QNAME_XML_TOPIC_KIND = new QName("KIND");
    private static final QName QNAME_XML_TOPIC_KIND_FULL = new QName("http://www.interlis.ch/INTERLIS2.3", "FULL");
    private static final QName QNAME_XML_TOPIC_KIND_UPDATE = new QName("http://www.interlis.ch/INTERLIS2.3", "UPDATE");
    private static final QName QNAME_XML_TOPIC_KIND_INITIAL = new QName("http://www.interlis.ch/INTERLIS2.3", "INITIAL");
    private static final QName QNAME_XML_TOPIC_STARTSTATE = new QName("STARTSTATE");
    private static final QName QNAME_XML_TOPIC_ENDSTATE = new QName("ENDSTATE");
    private static final QName QNAME_XML_CONSISTENCY = new QName("CONSISTENCY");
    private static final QName QNAME_XML_TOPIC_CONSISTENCY_COMPLETE = new QName("http://www.interlis.ch/INTERLIS2.3", "COMPLETE");
    private static final QName QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE = new QName("http://www.interlis.ch/INTERLIS2.3", "INCOMPLETE");
    private static final QName QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT = new QName("http://www.interlis.ch/INTERLIS2.3", "INCONSISTENT");
    private static final QName QNAME_XML_TOPIC_CONSISTENCY_ADAPTED = new QName("http://www.interlis.ch/INTERLIS2.3", "ADAPTED");
    private static final QName QNAME_XML_DATASECTION = new QName("http://www.interlis.ch/INTERLIS2.3", "DATASECTION");
    private static final QName QNAME_XML_OID = new QName("OID");
    private static final QName QNAME_XML_OBJECT_TID = new QName("TID");
    private static final QName QNAME_XML_OBJECT_OPERATION = new QName("OPERATION");
    private static final QName QNAME_XML_ORDERPOS = new QName("ORDER_POS");
    private static final QName QNAME_XML_TRANSFER = new QName("http://www.interlis.ch/INTERLIS2.3", "TRANSFER");
    private static final QName QNAME_XML_REF = new QName("REF");
    private static final QName QNAME_XML_DOMAIN = new QName("DOMAINS");
    private static final QName QNAME_XML_INSERT = new QName("http://www.interlis.ch/INTERLIS2.3", "INSERT");
    private static final QName QNAME_XML_DELETE = new QName("http://www.interlis.ch/INTERLIS2.3", "DELETE");
    private static final QName QNAME_XML_BINBLBOX = new QName("http://www.interlis.ch/INTERLIS2.3", "BINBLBOX");
    private static final QName QNAME_XML_XMLBLBOX = new QName("http://www.interlis.ch/INTERLIS2.3", "XMLBLBOX");
    private static final QName QNAME_XML_COORD = new QName("http://www.interlis.ch/INTERLIS2.3", "COORD");
    private static final QName QNAME_XML_ARC = new QName("http://www.interlis.ch/INTERLIS2.3", "ARC");
    private static final QName QNAME_XML_POLYLINE = new QName("http://www.interlis.ch/INTERLIS2.3", "POLYLINE");
    private static final QName QNAME_XML_BOUNDARY = new QName("http://www.interlis.ch/INTERLIS2.3", "BOUNDARY");
    private static final QName QNAME_XML_SURFACE = new QName("http://www.interlis.ch/INTERLIS2.3", "SURFACE");
    private static final QName QNAME_XML_MULTISURFACE = new QName("http://www.interlis.ch/INTERLIS2.3", "MULTISURFACE");
    private static final QName QNAME_XML_SEGMENTS = new QName("http://www.interlis.ch/INTERLIS2.3", "SEGMENTS");
    private static final QName QNAME_XML_SEGMENTS_COORD = new QName("http://www.interlis.ch/INTERLIS2.3", "COORD");
    private static final QName QNAME_XML_SEGMENTS_ARC = new QName("http://www.interlis.ch/INTERLIS2.3", "ARC");
    private static final QName QNAME_XML_SEGMENT_C1 = new QName("http://www.interlis.ch/INTERLIS2.3", "C1");
    private static final QName QNAME_XML_SEGMENT_C2 = new QName("http://www.interlis.ch/INTERLIS2.3", "C2");
    private static final QName QNAME_XML_SEGMENT_C3 = new QName("http://www.interlis.ch/INTERLIS2.3", "C3");
    private static final QName QNAME_XML_SEGMENT_A1 = new QName("http://www.interlis.ch/INTERLIS2.3", "A1");
    private static final QName QNAME_XML_SEGMENT_A2 = new QName("http://www.interlis.ch/INTERLIS2.3", "A2");
    private static final QName QNAME_XML_SEGMENT_R = new QName("http://www.interlis.ch/INTERLIS2.3", "R");
    private int hsOid = 0;

    public Xtf23Reader(InputStream in) throws IoxException {
        this.init(in);
    }

    public Xtf23Reader(InputStreamReader in) throws IoxException {
    }

    public Xtf23Reader(File xtffile) throws IoxException {
        try {
            this.inputFile = new FileInputStream(xtffile);
            this.init(this.inputFile);
        }
        catch (IOException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    private void init(InputStream in) throws IoxException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        try {
            this.reader = inputFactory.createXMLEventReader(in);
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
    }

    public void close() throws IoxException {
        this.reader = null;
        if (this.inputFile != null) {
            try {
                this.inputFile.close();
            }
            catch (IOException ex) {
                throw new IoxException((Throwable)ex);
            }
            this.inputFile = null;
        }
    }

    public IoxEvent read() throws IoxException {
        try {
            XMLEvent event = null;
            if (this.state == 0) {
                event = this.reader.nextEvent();
                if (!event.isStartDocument()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_TRANSFER)) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                XtfStartTransferEvent startTransferEvent = null;
                if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                startTransferEvent = new XtfStartTransferEvent();
                event = this.readHeaderSection(event, startTransferEvent);
                if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_DATASECTION)) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                HashMap<String, IomObject> modelx = new HashMap<String, IomObject>();
                for (String modelName : this.models) {
                    IomObject model = this.createIomObject("iom04.metamodel.ModelEntry", this.hsNextOid());
                    model.setattrvalue("model", modelName);
                    modelx.put(model.getobjectoid(), model);
                }
                startTransferEvent.setHeaderObjects(modelx);
                this.state = 1;
                return startTransferEvent;
            }
            if (this.state == 1) {
                event = this.reader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                    this.state = 2;
                    return this.readStartBasket(event);
                }
                if (event.isEndElement()) {
                    this.state = 4;
                } else {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
            }
            if (this.state == 2) {
                event = this.reader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                    this.state = 3;
                    IomObject iomObj = null;
                    iomObj = this.readObject(event, iomObj);
                    this.setOperation(event.asStartElement(), iomObj);
                    this.setConsistency(event.asStartElement(), iomObj);
                    return new ObjectEvent(iomObj);
                }
                if (event.asEndElement().getName().equals(new QName(NAMESPACE_ILIXMLBASE, this.currentModelName + "." + this.currentTopicName))) {
                    this.state = 4;
                    return new EndBasketEvent();
                }
            }
            if (this.state == 3) {
                event = this.reader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                    IomObject iomObj = null;
                    iomObj = this.readObject(event, iomObj);
                    this.setOperation(event.asStartElement(), iomObj);
                    this.setConsistency(event.asStartElement(), iomObj);
                    return new ObjectEvent(iomObj);
                }
                if (event.asEndElement().getName().equals(new QName(NAMESPACE_ILIXMLBASE, this.currentModelName + "." + this.currentTopicName))) {
                    this.state = 4;
                    return new EndBasketEvent();
                }
            }
            if (this.state == 4) {
                event = this.reader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement()) {
                    this.state = 2;
                    return this.readStartBasket(event);
                }
                if (event.isEndElement()) {
                    if (event.asEndElement().getName().equals(QNAME_XML_DATASECTION)) {
                        event = this.reader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                    }
                    if (event.asEndElement().getName().equals(QNAME_XML_TRANSFER)) {
                        event = this.reader.nextEvent();
                        if ((event = this.skipSpacesAndGetNextEvent(event)).isEndDocument()) {
                            this.state = 5;
                            return new EndTransferEvent();
                        }
                        throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                    }
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
            }
            if (this.state == 5) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        return null;
    }

    private IoxEvent readStartBasket(XMLEvent event) throws IoxException, XMLStreamException {
        StartElement element = (StartElement)event;
        this.currentModelName = this.getModelName(element.asStartElement().getName().getLocalPart());
        if (this.currentModelName == null) {
            throw new IoxException("missing model name");
        }
        this.currentTopicName = this.getTopicNameOfModel(element.asStartElement().getName().getLocalPart());
        if (this.currentTopicName == null) {
            throw new IoxException("missing topic name");
        }
        QName basketId = QNAME_XML_TOPIC_BID;
        Attribute bid = element.getAttributeByName(basketId);
        StartBasketEvent newObj = new StartBasketEvent(this.currentModelName + "." + this.currentTopicName, bid.getValue());
        newObj = this.setState(element, newObj);
        newObj = this.setConsistency(element, newObj);
        newObj = this.setDomain(element, newObj);
        newObj = this.setIncrementalKind(element, newObj);
        return newObj;
    }

    private String getModelName(String scopeName) {
        String[] parts = scopeName.split("\\.");
        String obj1 = parts[0];
        return obj1.toString();
    }

    private String getTopicNameOfModel(String scopeName) {
        String[] parts = scopeName.split("\\.");
        String obj1 = parts[1];
        return obj1.toString();
    }

    private String getViewableFromQName(QName scopeName) {
        String[] parts = scopeName.getLocalPart().split("\\.");
        String obj1 = parts[2];
        return obj1.toString();
    }

    private XMLEvent readHeaderSection(XMLEvent startElementHeaderSection, XtfStartTransferEvent xtfEvent) throws XMLStreamException, IoxException {
        Attribute version = startElementHeaderSection.asStartElement().getAttributeByName(QNAME_XML_HEADERSECTION_VERSION);
        if (version == null || !version.getValue().equals(INTERLIS_VERSION_23)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementHeaderSection));
        }
        xtfEvent.setVersion(version.getValue());
        Attribute sender = startElementHeaderSection.asStartElement().getAttributeByName(QNAME_XML_HEADERSECTION_SENDER);
        if (sender == null) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementHeaderSection));
        }
        xtfEvent.setSender(sender.getValue());
        XMLEvent event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (!event.isStartElement() || !event.asStartElement().getName().equals(QNAME_XML_MODELS)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.readHeaderSectionModels(event);
        if (event.isEndElement()) {
            if (event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                if (this.models.size() == 0) {
                    throw new IoxException("expected at least 1 model.");
                }
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isStartElement()) {
            if (!event.asStartElement().getName().equals(QNAME_XML_ALIAS)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.readHeaderSectionAlias(event);
        if (event.isEndElement()) {
            if (event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isStartElement()) {
            if (!event.asStartElement().getName().equals(QNAME_XML_OIDSPACES)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.readHeaderSectionOidSpaces(event, xtfEvent);
        if (event.isEndElement()) {
            if (event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isStartElement()) {
            if (!event.asStartElement().getName().equals(QNAME_XML_COMMENT)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.readHeaderSectionComment(event, xtfEvent);
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_HEADERSECTION)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionModels(XMLEvent startElementModels) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        if (!startElementModels.isStartElement() || !startElementModels.asStartElement().getName().equals(QNAME_XML_MODELS)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        this.models = new ArrayList();
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_MODEL)) {
            event = this.readModel(event);
        }
        if (event.isEndElement() && event.asEndElement().getName().equals(QNAME_XML_MODELS)) {
            if (this.models.size() == 0) {
                throw new IoxException("expected at least 1 model.");
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readModel(XMLEvent startElementModel) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        Attribute name = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_NAME);
        Attribute version = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_VERSION);
        Attribute uri = startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_URI);
        if (name == null || version == null || uri == null) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementModel));
        }
        this.models.add(startElementModel.asStartElement().getAttributeByName(QNAME_XML_MODEL_NAME).getValue());
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_MODEL)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionAlias(XMLEvent startElementAlias) throws IoxException, XMLStreamException {
        XMLEvent event = null;
        if (!startElementAlias.isStartElement() || !startElementAlias.asStartElement().getName().equals(QNAME_XML_ALIAS)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (event.isEndElement()) {
            if (event.asEndElement().getName().equals(QNAME_XML_ALIAS)) {
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_ENTRIES)) {
            while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_ENTRIES)) {
                event = this.readAliasEntries(event);
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_ALIAS)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readAliasEntries(XMLEvent startElementAliasEntries) throws IoxSyntaxException, XMLStreamException, IoxException {
        XMLEvent event = null;
        Attribute entryFor = startElementAliasEntries.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FOR);
        if (entryFor == null) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementAliasEntries));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (event.isEndElement()) {
            if (event.asEndElement().getName().equals(QNAME_XML_ENTRIES)) {
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                return event;
            }
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        while (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_XML_ENTRIES_TAGENTRY) || event.asStartElement().getName().equals(QNAME_XML_ENTRIES_VALENTRY) || event.asStartElement().getName().equals(QNAME_XML_ENTRIES_DELENTRY))) {
            event = this.readAliasEntry(event);
        }
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_ENTRIES)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readAliasEntry(XMLEvent startElementAliasEntry) throws IoxSyntaxException, IoxException, XMLStreamException {
        XMLEvent event = null;
        if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(QNAME_XML_ENTRIES_TAGENTRY)) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FROM) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TO) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_ENTRIES_TAGENTRY)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        } else if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(QNAME_XML_ENTRIES_VALENTRY)) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TAG) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_ATTR) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_FROM) == null || startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TO) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementAliasEntry));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_ENTRIES_VALENTRY)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        } else if (startElementAliasEntry.isStartElement() && startElementAliasEntry.asStartElement().getName().equals(QNAME_XML_ENTRIES_DELENTRY)) {
            if (startElementAliasEntry.asStartElement().getAttributeByName(QNAME_XML_ENTRIES_VALUE_TAG) == null) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementAliasEntry));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
            if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_ENTRIES_DELENTRY)) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return event;
    }

    private XMLEvent readHeaderSectionOidSpaces(XMLEvent startElementOidSpaces, XtfStartTransferEvent xtfEvent) throws XMLStreamException, IoxException {
        ArrayList<OidSpace> oidSpaces;
        XMLEvent event = this.reader.nextEvent();
        if ((event = this.skipSpacesAndGetNextEvent(event)).isStartElement() && event.asStartElement().getName().equals(QNAME_XML_OIDSPACE)) {
            oidSpaces = new ArrayList<OidSpace>();
            while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_OIDSPACE)) {
                event = this.readOidSpace(event, oidSpaces);
            }
            if (this.oidSpaceSize == 0) {
                throw new IoxException("expected at least 1 oid space");
            }
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        xtfEvent.setOidSpaces(oidSpaces);
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_OIDSPACES)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readOidSpace(XMLEvent startElementOidSpace, List<OidSpace> oidSpaces) throws IoxSyntaxException, IoxException, XMLStreamException {
        XMLEvent event = null;
        if (startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_NAME) != null || startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_OIDDOMAIN) != null) {
            Attribute oidSpace = startElementOidSpace.asStartElement().getAttributeByName(QNAME_XML_OIDSPACE_OIDDOMAIN);
            OidSpace oidSpaceObj = new OidSpace("oidSpace" + this.oidSpaceSize, oidSpace.getValue());
            oidSpaces.add(this.oidSpaceSize, oidSpaceObj);
            ++this.oidSpaceSize;
        } else {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startElementOidSpace));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_OIDSPACE)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent readHeaderSectionComment(XMLEvent startElementComment, XtfStartTransferEvent xtfEvent) throws IoxSyntaxException, XMLStreamException {
        XMLEvent event = this.reader.nextEvent();
        event = this.skipCommentary(event);
        StringBuffer value = new StringBuffer();
        event = this.readSimpleContent(event, value);
        xtfEvent.setComment(value.toString());
        if (!event.isEndElement() || !event.asEndElement().getName().equals(QNAME_XML_COMMENT)) {
            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
        }
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        return event;
    }

    private XMLEvent skipCommentary(XMLEvent event) throws XMLStreamException {
        while (event.getEventType() == 5) {
            event = this.reader.nextEvent();
        }
        return event;
    }

    private IomObject readObject(XMLEvent event, IomObject iomObj) throws IoxException {
        try {
            if (event.isStartElement()) {
                Attribute oid = event.asStartElement().getAttributeByName(QNAME_XML_OBJECT_TID);
                if (event.asStartElement().getAttributeByName(QNAME_XML_TOPIC_BID) != null) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                if (event.asStartElement().getName().equals(QNAME_XML_DELETE)) {
                    iomObj = this.readDelete(event, iomObj);
                    event = this.reader.nextEvent();
                    return iomObj;
                }
                this.currentViewableName = this.getViewableFromQName(event.asStartElement().getName());
                if (this.currentViewableName == null) {
                    throw new IoxException("missing table name");
                }
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                iomObj = oid != null ? this.createIomObject(this.currentModelName + "." + this.currentTopicName + "." + this.currentViewableName, oid.getValue()) : this.createIomObject(this.currentModelName + "." + this.currentTopicName + "." + this.currentViewableName, null);
                while (this.reader.hasNext() && !event.isEndElement()) {
                    iomObj = this.readAttribute(event, iomObj);
                    event = this.reader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                }
            }
            if (event.isEndElement()) {
                return iomObj;
            }
            if (event.isCharacters()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IomObject readDelete(XMLEvent event, IomObject iomObj) throws IoxException, XMLStreamException {
        if (event.asStartElement().getAttributeByName(QNAME_XML_OBJECT_TID) == null) throw new IoxException("delete object needs tid");
        iomObj = this.createIomObject(QNAME_XML_DELETE.getLocalPart(), event.asStartElement().getAttributeByName(QNAME_XML_OBJECT_TID).getValue());
        event = this.reader.nextEvent();
        if (!(event = this.skipSpacesAndGetNextEvent(event)).isEndElement()) throw new IoxException("delete references are not yet implemented.");
        this.state = 2;
        if (event.asEndElement().getName().equals(QNAME_XML_DELETE)) return iomObj;
        throw new IoxException("expected rolename and role reference tid");
    }

    private IomObject setConsistency(StartElement element, IomObject iomObj) throws IoxException {
        Attribute consistency = element.getAttributeByName(QNAME_XML_CONSISTENCY);
        if (consistency != null) {
            String attrValue = consistency.getValue();
            if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_COMPLETE.getLocalPart())) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE.getLocalPart())) {
                iomObj.setobjectoperation(1);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT.getLocalPart())) {
                iomObj.setobjectoperation(2);
            } else if (attrValue.equals(QNAME_XML_TOPIC_CONSISTENCY_ADAPTED.getLocalPart())) {
                iomObj.setobjectoperation(3);
            } else {
                throw new IoxException("unexpected consistency <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private IomObject setOperation(StartElement element, IomObject iomObj) throws IoxException {
        Attribute operation = element.getAttributeByName(QNAME_XML_OBJECT_OPERATION);
        if (operation != null) {
            String attrValue = operation.getValue();
            if (attrValue.equals(QNAME_XML_INSERT.getLocalPart())) {
                iomObj.setobjectoperation(0);
            } else if (attrValue.equals(QNAME_XML_TOPIC_KIND_UPDATE.getLocalPart())) {
                iomObj.setobjectoperation(1);
            } else if (attrValue.equals(QNAME_XML_DELETE.getLocalPart())) {
                iomObj.setobjectoperation(2);
            } else {
                throw new IoxException("unexpected operation <" + attrValue + ">");
            }
        }
        return iomObj;
    }

    private StartBasketEvent setState(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        Object genericAndConcreteDomains = null;
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (codingObj.getName().equals(QNAME_XML_TOPIC_STARTSTATE)) {
                startBasketEvent.setStartstate(codingObj.getValue());
                continue;
            }
            if (!codingObj.getName().equals(QNAME_XML_TOPIC_ENDSTATE)) continue;
            startBasketEvent.setEndstate(codingObj.getValue());
        }
        return startBasketEvent;
    }

    private StartBasketEvent setIncrementalKind(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_TOPIC_KIND)) continue;
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_FULL.getLocalPart())) {
                startBasketEvent.setKind(0);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_UPDATE.getLocalPart())) {
                startBasketEvent.setKind(1);
                continue;
            }
            if (!codingObj.getValue().equals(QNAME_XML_TOPIC_KIND_INITIAL.getLocalPart())) continue;
            startBasketEvent.setKind(2);
        }
        return startBasketEvent;
    }

    private StartBasketEvent setDomain(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        String[] genericAndConcreteDomains = null;
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_DOMAIN)) continue;
            String domainValue = codingObj.getValue();
            for (String singleDomain : genericAndConcreteDomains = domainValue.split("\\,")) {
                startBasketEvent.addDomain(singleDomain, element.getName().getLocalPart());
            }
        }
        return startBasketEvent;
    }

    private StartBasketEvent setConsistency(StartElement element, StartBasketEvent startBasketEvent) throws IoxException {
        Iterator<Attribute> codingObjIter = element.getAttributes();
        while (codingObjIter.hasNext()) {
            Attribute codingObj = codingObjIter.next();
            if (!codingObj.getName().equals(QNAME_XML_CONSISTENCY)) continue;
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_COMPLETE.getLocalPart())) {
                startBasketEvent.setConsistency(0);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_INCOMPLETE.getLocalPart())) {
                startBasketEvent.setConsistency(1);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_INCONSISTENT.getLocalPart())) {
                startBasketEvent.setConsistency(2);
                continue;
            }
            if (codingObj.getValue().equals(QNAME_XML_TOPIC_CONSISTENCY_ADAPTED.getLocalPart())) {
                startBasketEvent.setConsistency(3);
                continue;
            }
            throw new IoxException("unexpected consistency <" + codingObj.getValue() + ">");
        }
        return startBasketEvent;
    }

    private static XMLEvent collectXMLElement(XMLEventReader xmlReader, XMLEvent event, StringWriter strw) throws XMLStreamException {
        XMLOutputFactory xmloutputf = XMLOutputFactory.newInstance();
        xmloutputf.setProperty("javax.xml.stream.isRepairingNamespaces", true);
        XMLEventFactory xmlef = XMLEventFactory.newInstance();
        XMLEventWriter xmlw = xmloutputf.createXMLEventWriter(strw);
        xmlw.add(event);
        int inHeader = 1;
        while (xmlReader.hasNext()) {
            event = xmlReader.nextEvent();
            xmlw.add(event);
            switch (event.getEventType()) {
                case 1: {
                    ++inHeader;
                    break;
                }
                case 2: {
                    --inHeader;
                }
            }
            if (inHeader == 0 && event.getEventType() == 2) break;
            if (inHeader >= 0) continue;
            throw new IllegalStateException("inHeader < 0");
        }
        xmlw.flush();
        xmlw.close();
        return event;
    }

    private XMLEvent readSimpleContent(XMLEvent event, StringBuffer value) throws XMLStreamException, IoxSyntaxException {
        while (event.isCharacters()) {
            Characters characters = (Characters)event;
            value.append(characters.getData());
            event = this.reader.nextEvent();
        }
        return event;
    }

    private XMLEvent skipSpacesAndGetNextEvent(XMLEvent event) throws XMLStreamException, IoxSyntaxException {
        while (event.isCharacters() || event.getEventType() == 5) {
            Characters characters;
            if (event.isCharacters() && !(characters = (Characters)event).isWhiteSpace()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
        }
        return event;
    }

    private String unexpectedXmlEvent2msg(XMLEvent actual) {
        StringBuilder output = new StringBuilder();
        output.append("Unexpected XML event ");
        if (actual instanceof StartElement) {
            output.append(actual.asStartElement().getName().getLocalPart());
        } else if (actual instanceof EndElement) {
            output.append(actual.asEndElement().getName().getLocalPart());
        } else if (actual instanceof Characters) {
            output.append(actual.asCharacters().getData());
        }
        output.append(" found.");
        return output.toString();
    }

    private IomObject readAttribute(XMLEvent startAttributeEvent, IomObject iomObj) throws IoxException {
        try {
            XMLEvent event = null;
            String attrName = null;
            StartElement element = (StartElement)startAttributeEvent;
            if (element.getAttributeByName(QNAME_XML_REF) != null) {
                iomObj = this.readReference(iomObj, startAttributeEvent.asStartElement(), startAttributeEvent.asStartElement().getName().getLocalPart(), null);
                if (!startAttributeEvent.isStartElement()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startAttributeEvent));
                }
                event = this.reader.nextEvent();
                if ((event = this.skipSpacesAndGetNextEvent(event)).isEndElement()) {
                    return iomObj;
                }
            } else if (element.getAttributeByName(QNAME_XML_OID) != null) {
                Attribute oidAttr = element.getAttributeByName(QNAME_XML_OID);
                attrName = element.getName().getLocalPart();
                iomObj.setattrvalue(attrName, oidAttr.getValue());
                event = this.reader.nextEvent();
                event = this.skipCommentary(event);
                if (event.isCharacters()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
            } else {
                StringBuffer value;
                attrName = element.getName().getLocalPart();
                if (attrName == null) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(startAttributeEvent));
                }
                event = this.reader.nextEvent();
                event = this.skipCommentary(event);
                if (event.isCharacters()) {
                    Characters characters = (Characters)event;
                    if (!this.reader.peek().isEndElement() && characters.isWhiteSpace()) {
                        event = this.skipSpacesAndGetNextEvent(event);
                    }
                }
                if (event.isCharacters()) {
                    value = new StringBuffer();
                    event = this.readSimpleContent(event, value);
                    iomObj.setattrvalue(attrName, value.toString());
                } else if (event.isStartElement()) {
                    if (event.isStartElement() && (event.asStartElement().getName().equals(QNAME_XML_COORD) || event.asStartElement().getName().equals(QNAME_XML_ARC))) {
                        String segmentType = null;
                        if (event.asStartElement().getName().equals(QNAME_XML_COORD)) {
                            segmentType = "COORD";
                        } else if (event.asStartElement().getName().equals(QNAME_XML_ARC)) {
                            segmentType = "ARC";
                        }
                        event = this.reader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                        if (!event.isStartElement()) {
                            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                        }
                        IomObject returnedSegment = this.readSegment(event, segmentType);
                        if (returnedSegment.getattrcount() == 0) {
                            throw new IoxException("expected coord. unexpected event: " + event.asStartElement().getName().getLocalPart());
                        }
                        iomObj.addattrobj(attrName, returnedSegment);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_POLYLINE)) {
                        IomObject polyline = this.readPolyline(event);
                        if (polyline.getattrcount() == 0) {
                            throw new IoxException("expected polyline. unexpected event: " + event.asStartElement().getName().getLocalPart());
                        }
                        iomObj.addattrobj(attrName, polyline);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_SURFACE)) {
                        IomObject multiSurface = this.createIomObject("MULTISURFACE", null);
                        IomObject surface = this.readSurface(event);
                        if (surface.getattrcount() == 0) {
                            throw new IoxException("expected surface. unexpected event: " + event.asStartElement().getName().getLocalPart());
                        }
                        multiSurface.addattrobj("surface", surface);
                        if (!event.isStartElement()) {
                            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                        }
                        iomObj.addattrobj(attrName, multiSurface);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_XMLBLBOX)) {
                        event = this.reader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                        StringWriter strw = new StringWriter();
                        event = Xtf23Reader.collectXMLElement(this.reader, event, strw);
                        iomObj.setattrvalue(attrName, strw.toString());
                        if (!event.isEndElement()) {
                            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                        }
                        event = this.reader.nextEvent();
                        event = this.skipSpacesAndGetNextEvent(event);
                    } else if (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_BINBLBOX)) {
                        event = this.reader.nextEvent();
                        value = new StringBuffer();
                        event = this.readSimpleContent(event, value);
                        iomObj.setattrvalue(attrName, value.toString());
                        if (!event.isEndElement()) {
                            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                        }
                    } else {
                        IomObject structObj = this.createIomObject(event.asStartElement().getName().getLocalPart(), null);
                        iomObj.addattrobj(attrName, this.readObject(event, structObj));
                        if (!event.isStartElement()) {
                            throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                        }
                    }
                    event = this.reader.nextEvent();
                    event = this.skipSpacesAndGetNextEvent(event);
                }
            }
            if (event.isEndElement() && attrName != null) {
                attrName = null;
            }
            if (event.isEndElement() && attrName == null) {
                return iomObj;
            }
        }
        catch (XMLStreamException ex) {
            throw new IoxException((Throwable)ex);
        }
        return iomObj;
    }

    private IomObject readReference(IomObject iomObj, StartElement element, String attrName, AssociationDef association) throws IoxException, XMLStreamException {
        String orderPosVal;
        String refOid = null;
        if (element.getAttributeByName(QNAME_XML_REF) != null && (refOid = element.getAttributeByName(QNAME_XML_REF).getValue()).length() == 0) {
            throw new IoxException("unexpected reference value <" + refOid + ">");
        }
        Attribute attrRefBid = element.getAttributeByName(QNAME_XML_TOPIC_BID);
        String refBid = null;
        if (attrRefBid != null && (refBid = attrRefBid.getValue()).length() == 0) {
            throw new IoxException("unexpected reference BID value <" + refBid + ">");
        }
        Long orderPos = null;
        Attribute orderPosAttr = element.getAttributeByName(QNAME_XML_ORDERPOS);
        if (orderPosAttr != null && (orderPosVal = orderPosAttr.getValue()) != null) {
            try {
                orderPos = Long.parseLong(orderPosVal);
            }
            catch (NumberFormatException e) {
                throw new IoxException("unexpected orderPos <" + orderPosVal + ">", (Throwable)e);
            }
        }
        XMLEvent peek = this.reader.peek();
        XMLEvent event = null;
        if (peek.isCharacters()) {
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        } else if (peek.isStartElement()) {
            event = this.reader.nextEvent();
        }
        if (event != null && event.isStartElement()) {
            element = (StartElement)event;
            iomObj.addattrobj(attrName, this.readObject(event, iomObj));
        } else {
            IomObject aObject = iomObj.addattrobj(attrName, QNAME_XML_REF.getLocalPart());
            aObject.setobjectrefoid(refOid);
            if (orderPos != null) {
                aObject.setobjectreforderpos(orderPos.longValue());
            }
            if (refBid != null) {
                aObject.setobjectrefbid(refBid);
            }
        }
        return iomObj;
    }

    private IomObject readSurface(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject surface = this.createIomObject("SURFACE", null);
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_BOUNDARY)) {
            surface.addattrobj("boundary", this.readBoundary(event));
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return surface;
    }

    private IomObject readBoundary(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject boundary = this.createIomObject("BOUNDARY", null);
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        while (event.isStartElement() && event.asStartElement().getName().equals(QNAME_XML_POLYLINE)) {
            boundary.addattrobj("polyline", this.readPolyline(event));
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return boundary;
    }

    private IomObject readPolyline(XMLEvent event) throws IoxException, XMLStreamException {
        IomObject polyline = this.createIomObject("POLYLINE", null);
        event = this.reader.nextEvent();
        event = this.skipSpacesAndGetNextEvent(event);
        polyline.addattrobj("sequence", this.readSequence(event));
        return polyline;
    }

    private IomObject readSequence(XMLEvent event) throws XMLStreamException, IoxException {
        IomObject sequence = this.createIomObject("SEGMENTS", null);
        if (event.isStartElement()) {
            while (event.isStartElement()) {
                String segmentType = null;
                if (event.asStartElement().getName().equals(QNAME_XML_COORD)) {
                    segmentType = "COORD";
                } else if (event.asStartElement().getName().equals(QNAME_XML_ARC)) {
                    segmentType = "ARC";
                }
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
                sequence.addattrobj("segment", this.readSegment(event, segmentType));
                event = this.reader.nextEvent();
                event = this.skipSpacesAndGetNextEvent(event);
            }
        }
        return sequence;
    }

    private IomObject readSegment(XMLEvent event, String segmentType) throws IoxException, XMLStreamException {
        if (segmentType == null) {
            throw new IoxException("expected segment type");
        }
        IomObject segment = this.createIomObject(segmentType, null);
        SegmentType segTypeName = null;
        while (!event.isEndElement()) {
            if (event.isStartElement()) {
                String segmentTypeName = event.asStartElement().getName().getLocalPart();
                event = this.reader.nextEvent();
                if (event.isEndElement()) {
                    throw new IoxException("expected coord");
                }
                if (!event.isCharacters()) {
                    throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                }
                segTypeName = SegmentType.valueOf(segmentTypeName);
                switch (segTypeName) {
                    case C1: {
                        segment.setattrvalue("C1", event.asCharacters().getData());
                        break;
                    }
                    case C2: {
                        segment.setattrvalue("C2", event.asCharacters().getData());
                        break;
                    }
                    case C3: {
                        segment.setattrvalue("C3", event.asCharacters().getData());
                        break;
                    }
                    case A1: {
                        segment.setattrvalue("A1", event.asCharacters().getData());
                        break;
                    }
                    case A2: {
                        segment.setattrvalue("A2", event.asCharacters().getData());
                        break;
                    }
                    case R: {
                        segment.setattrvalue("R", event.asCharacters().getData());
                        break;
                    }
                    default: {
                        throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
                    }
                }
            }
            if ((event = this.reader.nextEvent()).isStartElement()) {
                throw new IoxSyntaxException(this.unexpectedXmlEvent2msg(event));
            }
            event = this.reader.nextEvent();
            event = this.skipSpacesAndGetNextEvent(event);
        }
        return segment;
    }

    private String hsNextOid() {
        ++this.hsOid;
        return Integer.toString(this.hsOid);
    }

    public IomObject createIomObject(String type, String oid) throws IoxException {
        return this.factory.createIomObject(type, oid);
    }

    public IoxFactoryCollection getFactory() throws IoxException {
        return this.factory;
    }

    public void setFactory(IoxFactoryCollection factory) throws IoxException {
        this.factory = factory;
    }

    @Override
    public void setModel(TransferDescription td) {
    }

    @Override
    public void setTopicFilter(String[] topicNames) {
        this.filterTopics = new HashSet<String>();
        for (String topicName : topicNames) {
            this.filterTopics.add(topicName);
        }
    }

    @Override
    public String getMimeType() {
        return "application/interlis+xml;version=2.3";
    }

    private static enum SegmentType {
        C1,
        C2,
        C3,
        A1,
        A2,
        R;

    }
}

