/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ilirepository.impl;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.ilirepository.Dataset;
import ch.interlis.ilirepository.impl.RepositoryAccess;
import ch.interlis.ilirepository.impl.RepositoryAccessException;
import ch.interlis.ilirepository.impl.VisitorAction;
import ch.interlis.models.DatasetIdx16.DataIndex.BasketMetadata;
import ch.interlis.models.DatasetIdx16.DataIndex.DatasetMetadata;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataFinder
implements VisitorAction {
    private List<Dataset> result = new ArrayList<Dataset>();
    private String bid = null;
    private Set<String> topics = null;
    private String topicLogTxt = null;
    private boolean dologging = true;

    @Override
    public boolean processRepository(String uri, RepositoryAccess rep) throws RepositoryAccessException {
        this.logRepositoryScan(uri);
        List<DatasetMetadata> repoResult = this.getIliFileMetadataShallow(uri, rep);
        if (repoResult.size() > 0) {
            for (DatasetMetadata md : repoResult) {
                this.result.add(new Dataset(uri, md));
            }
            if (this.bid != null) {
                return true;
            }
        }
        return false;
    }

    private void logRepositoryScan(String uri) {
        if (this.dologging) {
            if (this.bid != null && this.topicLogTxt != null) {
                EhiLogger.logState((String)("search in repository <" + uri + "> for BID <" + this.bid + "> of " + this.topicLogTxt));
            } else if (this.bid != null) {
                EhiLogger.logState((String)("search in repository <" + uri + "> for BID <" + this.bid + ">"));
            } else if (this.topicLogTxt != null) {
                EhiLogger.logState((String)("search in repository <" + uri + "> for baskets of " + this.topicLogTxt));
            }
        }
    }

    private List<DatasetMetadata> getIliFileMetadataShallow(String uri, RepositoryAccess rep) {
        ArrayList<DatasetMetadata> result = new ArrayList<DatasetMetadata>();
        List<DatasetMetadata> iliFiles = rep.getIliData(uri);
        if (iliFiles != null) {
            block0: for (DatasetMetadata iliFile : iliFiles) {
                if (this.bid == null && this.topics == null) {
                    result.add(iliFile);
                    continue;
                }
                if (this.bid != null && iliFile.getid().equals(this.bid)) {
                    result.add(iliFile);
                    continue;
                }
                for (BasketMetadata basket : iliFile.getbaskets()) {
                    if (this.bid != null && !this.bid.equals(basket.getid()) || this.topics != null && !this.topics.contains(basket.getmodel().getname())) continue;
                    result.add(iliFile);
                    continue block0;
                }
            }
        }
        return result;
    }

    public List<Dataset> getResult() {
        return this.result;
    }

    public void setCriteria(String bid, String[] topics) {
        this.result = new ArrayList<Dataset>();
        this.bid = bid;
        if (topics == null || topics.length == 0) {
            this.topicLogTxt = null;
            this.topics = null;
        } else {
            StringBuffer txt = new StringBuffer();
            String sep = "";
            this.topics = new HashSet<String>();
            for (String topic : topics) {
                if (!this.topics.add(topic)) continue;
                txt.append(sep);
                txt.append(topic);
                sep = ", ";
            }
        }
    }

    public void setDoLogging(boolean logLookup) {
        this.dologging = logLookup;
    }
}

