/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.parser;

import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.Axis;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.CoordinateSystem;
import ch.interlis.ili2c.metamodel.DataContainer;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.ErrorListener;
import ch.interlis.ili2c.metamodel.MetaObject;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ReferenceSystem;
import ch.interlis.ili2c.metamodel.Sign;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Viewable;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.ParserFactory;

public final class MetaObjectParser {
    String fileName;
    TransferDescription td;
    ErrorListener errorListener;
    Parser parser;
    boolean fatalErrorEncountered = false;
    Map transfernameToElement = new HashMap();

    public static boolean parse(TransferDescription td, String fileName) {
        return new MetaObjectParser(td, fileName).parse();
    }

    private MetaObjectParser(TransferDescription td, String fileName) {
        this.fileName = fileName;
        this.td = td;
        for (Viewable viewable : td.INTERLIS.METAOBJECT.getExtensions()) {
            String transferName = XSDGenerator.getTransferName(viewable);
            this.transfernameToElement.put(transferName, viewable);
        }
        MetaObjectParser.findModelsAndTopics(td, this.transfernameToElement);
    }

    private static final void findModelsAndTopics(Container container, Map map) {
        Iterator iter = container.iterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            if (elt instanceof Topic || elt instanceof Model) {
                String transferName = XSDGenerator.getTransferName(elt);
                map.put(transferName, elt);
            }
            if (!(elt instanceof Container)) continue;
            MetaObjectParser.findModelsAndTopics((Container)elt, map);
        }
    }

    void reportException(Exception ex, int lineNumber) {
        ErrorListener.ErrorEvent theEvent = new ErrorListener.ErrorEvent(ex, this.fileName, lineNumber, 5);
        this.errorListener.error(theEvent);
    }

    boolean parse() {
        ErrorListener.ErrorEvent theEvent = null;
        MyHandler myHandler = new MyHandler();
        try {
            String parserClass = "org.apache.xerces.parsers.SAXParser";
            this.parser = ParserFactory.makeParser(parserClass);
            this.parser.setDocumentHandler(myHandler);
            this.parser.setErrorHandler(myHandler);
            this.parser.parse("file:" + new File(this.fileName).getAbsolutePath());
        }
        catch (SAXParseException err) {
            theEvent = new ErrorListener.ErrorEvent(err.getMessage(), err.getSystemId(), err.getLineNumber(), 5);
            this.errorListener.error(theEvent);
            return false;
        }
        catch (SAXException e) {
            Exception x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            this.reportException(x, 0);
            return false;
        }
        catch (Exception t) {
            this.reportException(t, 0);
            return false;
        }
        return !this.fatalErrorEncountered;
    }

    class MyHandler
    extends HandlerBase {
        private int level = 0;
        DataContainer dataContainer = null;
        Table theMetaTable = null;
        private boolean inTransfer = false;
        private int TRANSFER_LEVEL = 1;
        private boolean inDataSection = false;
        private int DATASECTION_LEVEL = 2;
        private boolean inBasket = false;
        private int BASKET_LEVEL = 3;
        private boolean inTable = false;
        private int TABLE_LEVEL = 4;
        private boolean inName = false;
        private int NAME_LEVEL = 5;

        MyHandler() {
        }

        @Override
        public void warning(SAXParseException ex) {
            MetaObjectParser.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 3));
        }

        @Override
        public void error(SAXParseException ex) {
            MetaObjectParser.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 5));
        }

        @Override
        public void fatalError(SAXParseException ex) {
            MetaObjectParser.this.fatalErrorEncountered = true;
            MetaObjectParser.this.errorListener.error(new ErrorListener.ErrorEvent(ex.getMessage(), ex.getSystemId(), ex.getLineNumber(), 5));
        }

        @Override
        public void startElement(String name, AttributeList atts) {
            Element elt;
            ++this.level;
            if (this.level == this.TRANSFER_LEVEL && name.equals("TRANSFER")) {
                this.inTransfer = true;
                return;
            }
            if (this.level == this.DATASECTION_LEVEL && this.inTransfer && name.equals("DATASECTION")) {
                this.inDataSection = true;
                return;
            }
            if (this.level == this.BASKET_LEVEL && this.inDataSection) {
                elt = (Element)MetaObjectParser.this.transfernameToElement.get(name);
                if (elt == null) {
                    throw new IllegalArgumentException("unknown topic " + name);
                }
                if (elt instanceof Topic) {
                    Topic topic = (Topic)elt;
                    String boid = atts.getValue("BID");
                    if (boid == null) {
                        throw new IllegalArgumentException("Attribute BID missing in basket " + name);
                    }
                    if (!boid.startsWith("x")) {
                        throw new IllegalArgumentException("Attribute BID in basket " + name + " requires a leading 'x'");
                    }
                    boid = boid.substring(1);
                    try {
                        this.dataContainer = new DataContainer(boid, topic, MetaObjectParser.this.fileName);
                        MetaObjectParser.this.td.addMetaDataContainer(this.dataContainer);
                        this.inBasket = true;
                    }
                    catch (Exception ex) {
                        MetaObjectParser.this.reportException(ex, 0);
                    }
                    return;
                }
            }
            if (this.level == this.TABLE_LEVEL && this.inBasket && (elt = (Element)MetaObjectParser.this.transfernameToElement.get(name)) != null && elt instanceof Table) {
                String operation = atts.getValue("OPERATION");
                if (operation != null && !"INSERT".equals(operation)) {
                    throw new IllegalArgumentException("The OPERATION attribute for " + elt.toString() + " must be \"INSERT\". The INTERLIS compiler does not support incremental updating of meta objects.");
                }
                this.theMetaTable = (Table)elt;
                this.inTable = true;
            }
            if (this.level == this.NAME_LEVEL && this.inTable && name.equals("Name")) {
                this.inName = true;
            }
        }

        @Override
        public void endElement(String name) {
            if (this.level == this.NAME_LEVEL && this.inName) {
                this.inName = false;
            } else if (this.level == this.TABLE_LEVEL && this.inTable) {
                this.inTable = false;
            } else if (this.level == this.BASKET_LEVEL && this.inBasket) {
                this.inBasket = false;
            } else if (this.level == this.DATASECTION_LEVEL && this.inDataSection) {
                this.inDataSection = false;
            } else if (this.level == this.TRANSFER_LEVEL && this.inTransfer) {
                this.inTransfer = false;
            }
            --this.level;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inName) {
                String theName = new String(ch, start, length);
                MetaObject mo = this.theMetaTable.isExtending(MetaObjectParser.this.td.INTERLIS.REFSYSTEM) ? new ReferenceSystem(theName, this.theMetaTable) : (this.theMetaTable.isExtending(MetaObjectParser.this.td.INTERLIS.COORDSYSTEM) ? new CoordinateSystem(theName, this.theMetaTable) : (this.theMetaTable.isExtending(MetaObjectParser.this.td.INTERLIS.AXIS) ? new Axis(theName, this.theMetaTable) : (this.theMetaTable.isExtending(MetaObjectParser.this.td.INTERLIS.SIGN) ? new Sign(theName, this.theMetaTable) : new MetaObject(theName, this.theMetaTable))));
                this.dataContainer.add(mo);
            }
        }
    }
}

