/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.jts;

import ch.ehi.basics.types.OutParam;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iox.IoxException;
import ch.interlis.iox_j.logging.Log2EhiLogger;
import ch.interlis.iox_j.logging.LogEventFactory;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKBWriter;
import java.util.ArrayList;

public class Iox2jtsext {
    private Iox2jtsext() {
    }

    public static String coord2hexwkb(IomObject value) throws IoxException {
        if (value != null) {
            Point geom = new JtsextGeometryFactory().createPoint(Iox2jtsext.coord2JTS(value));
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String polyline2hexwkb(IomObject value, double p) throws IoxException {
        if (value != null) {
            CompoundCurve geom = Iox2jtsext.polyline2JTS(value, false, p);
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static String surface2hexwkb(IomObject value, double strokeP) throws IoxException {
        if (value != null) {
            Polygon geom = Iox2jtsext.surface2JTS(value, strokeP);
            byte[] bv = new WKBWriter().write((Geometry)geom);
            return WKBWriter.bytesToHex((byte[])bv);
        }
        return null;
    }

    public static Coordinate coord2JTS(IomObject value) throws IoxException {
        double yCoord;
        double xCoord;
        if (value == null) {
            return null;
        }
        String c1 = value.getattrvalue("C1");
        String c2 = value.getattrvalue("C2");
        String c3 = value.getattrvalue("C3");
        try {
            xCoord = Double.parseDouble(c1);
        }
        catch (Exception ex) {
            throw new IoxException("failed to read C1 <" + c1 + ">", (Throwable)ex);
        }
        try {
            yCoord = Double.parseDouble(c2);
        }
        catch (Exception ex) {
            throw new IoxException("failed to read C2 <" + c2 + ">", (Throwable)ex);
        }
        Coordinate coord = null;
        if (c3 == null) {
            coord = new Coordinate(xCoord, yCoord);
        } else {
            double zCoord;
            try {
                zCoord = Double.parseDouble(c3);
            }
            catch (Exception ex) {
                throw new IoxException("failed to read C3 <" + c3 + ">", (Throwable)ex);
            }
            coord = new Coordinate(xCoord, yCoord, zCoord);
        }
        return coord;
    }

    public static Coordinate getArcEndPt(IomObject segment) throws IoxException {
        return Iox2jtsext.coord2JTS(segment);
    }

    public static Coordinate getArcMidPt(IomObject segment) throws IoxException {
        double arcPt_ho;
        double arcPt_re;
        String a1 = segment.getattrvalue("A1");
        String a2 = segment.getattrvalue("A2");
        try {
            arcPt_re = Double.parseDouble(a1);
        }
        catch (Exception ex) {
            throw new IoxException("failed to read A1 <" + a1 + ">", (Throwable)ex);
        }
        try {
            arcPt_ho = Double.parseDouble(a2);
        }
        catch (Exception ex) {
            throw new IoxException("failed to read A2 <" + a2 + ">", (Throwable)ex);
        }
        Coordinate midPt = new Coordinate(arcPt_re, arcPt_ho);
        return midPt;
    }

    public static CompoundCurve polyline2JTS(IomObject polylineObj, boolean isSurfaceOrArea, double p) throws IoxException {
        if (polylineObj == null) {
            return null;
        }
        Log2EhiLogger logger = new Log2EhiLogger();
        LogEventFactory errs = new LogEventFactory();
        errs.setLogger(logger);
        OutParam foundErrs = new OutParam();
        return Iox2jtsext.polyline2JTS(polylineObj, isSurfaceOrArea, p, (OutParam<Boolean>)foundErrs, errs, 0.0, "warning", "warning");
    }

    public static CompoundCurve polyline2JTS(IomObject polylineObj, boolean isSurfaceOrArea, double p, OutParam<Boolean> foundErrs, LogEventFactory errs, double tolerance, String validationType, String degeneratedArcValidationType) throws IoxException {
        boolean clipped;
        IomObject lineattr;
        foundErrs.value = false;
        if (polylineObj == null) {
            return null;
        }
        ArrayList<CurveSegment> ret = new ArrayList<CurveSegment>();
        if (isSurfaceOrArea && (lineattr = polylineObj.getattrobj("lineattr", 0)) != null) {
            throw new IoxException("Lineattributes not supported");
        }
        boolean bl = clipped = polylineObj.getobjectconsistency() == 1;
        if (clipped) {
            throw new IoxException("clipped polyline not supported");
        }
        for (int sequencei = 0; sequencei < polylineObj.getattrvaluecount("sequence"); ++sequencei) {
            if (!clipped && sequencei > 0) {
                throw new IoxException("unclipped polyline with multi 'sequence' elements");
            }
            Coordinate lastSegmentEndpoint = null;
            IomObject sequence = polylineObj.getattrobj("sequence", sequencei);
            for (int segmenti = 0; segmenti < sequence.getattrvaluecount("segment"); ++segmenti) {
                IomObject segment = sequence.getattrobj("segment", segmenti);
                CurveSegment curve = null;
                if (segment.getobjecttag().equals("COORD")) {
                    if (lastSegmentEndpoint == null) {
                        lastSegmentEndpoint = Iox2jtsext.coord2JTS(segment);
                        continue;
                    }
                    Coordinate newSegEndPt = Iox2jtsext.coord2JTS(segment);
                    if (lastSegmentEndpoint.equals2D(newSegEndPt, tolerance)) {
                        foundErrs.value = (Boolean)foundErrs.value != false || Iox2jtsext.logMsg(errs, validationType, "duplicate coord at {0}", newSegEndPt, new String[0]);
                        continue;
                    }
                    curve = new StraightSegment(lastSegmentEndpoint, newSegEndPt);
                    ret.add(curve);
                    lastSegmentEndpoint = curve.getEndPoint();
                    continue;
                }
                if (segment.getobjecttag().equals("ARC")) {
                    Coordinate newSegMidPt = Iox2jtsext.getArcMidPt(segment);
                    Coordinate newSegEndPt = Iox2jtsext.getArcEndPt(segment);
                    if (lastSegmentEndpoint == null) {
                        throw new IoxException("unexpected ARC");
                    }
                    if (lastSegmentEndpoint.equals2D(newSegMidPt, tolerance)) {
                        if (newSegMidPt.equals2D(newSegEndPt, tolerance)) {
                            foundErrs.value = (Boolean)foundErrs.value != false || Iox2jtsext.logMsg(errs, validationType, "duplicate coord at {0}", newSegEndPt, new String[0]);
                            continue;
                        }
                        foundErrs.value = (Boolean)foundErrs.value != false || Iox2jtsext.logMsg(errs, validationType, "duplicate coord at {0}", newSegMidPt, new String[0]);
                        curve = new StraightSegment(lastSegmentEndpoint, newSegEndPt);
                        ret.add(curve);
                        lastSegmentEndpoint = curve.getEndPoint();
                        continue;
                    }
                    if (newSegMidPt.equals2D(newSegEndPt, tolerance)) {
                        foundErrs.value = (Boolean)foundErrs.value != false || Iox2jtsext.logMsg(errs, validationType, "duplicate coord at {0}", newSegMidPt, new String[0]);
                        curve = new StraightSegment(lastSegmentEndpoint, newSegMidPt);
                        ret.add(curve);
                        lastSegmentEndpoint = curve.getEndPoint();
                        continue;
                    }
                    curve = new ArcSegment(lastSegmentEndpoint, newSegMidPt, newSegEndPt);
                    if (((ArcSegment)curve).isStraight()) {
                        foundErrs.value = (Boolean)foundErrs.value != false || Iox2jtsext.logMsg(errs, degeneratedArcValidationType, "arc is straight at {0}", ((ArcSegment)curve).getMidPoint(), new String[0]);
                        curve = new StraightSegment(curve.getStartPoint(), curve.getEndPoint());
                    }
                    ret.add(curve);
                    lastSegmentEndpoint = curve.getEndPoint();
                    continue;
                }
                throw new IoxException("custom line form not supported");
            }
            if (!clipped) continue;
        }
        return new CompoundCurve(ret, new JtsextGeometryFactory());
    }

    private static boolean logMsg(LogEventFactory errs, String validateKind, String msg, String ... args) {
        if ("off".equals(validateKind)) {
            return false;
        }
        if ("warning".equals(validateKind)) {
            errs.addEvent(errs.logWarningMsg(msg, args));
            return false;
        }
        errs.addEvent(errs.logErrorMsg(msg, args));
        return true;
    }

    private static boolean logMsg(LogEventFactory errs, String validateKind, String msg, Coordinate coord, String ... args) {
        if ("off".equals(validateKind)) {
            return false;
        }
        if ("warning".equals(validateKind)) {
            String[] args2 = new String[args.length + 1];
            args2[0] = coord.toString();
            for (int i = 0; i < args.length; ++i) {
                args2[i + 1] = args[i];
            }
            errs.addEvent(errs.logWarningMsg(msg, coord.x, coord.y, coord.z, args2));
            return false;
        }
        String[] args2 = new String[args.length + 1];
        args2[0] = coord.toString();
        for (int i = 0; i < args.length; ++i) {
            args2[i + 1] = args[i];
        }
        errs.addEvent(errs.logErrorMsg(msg, coord.x, coord.y, coord.z, args2));
        return true;
    }

    public static Polygon surface2JTS(IomObject obj, double strokeP) throws IoxException {
        Log2EhiLogger logger = new Log2EhiLogger();
        LogEventFactory errs = new LogEventFactory();
        errs.setLogger(logger);
        OutParam foundErrs = new OutParam();
        return Iox2jtsext.surface2JTS(obj, strokeP, (OutParam<Boolean>)foundErrs, errs, 0.0, "warning");
    }

    public static Polygon surface2JTS(IomObject obj, double strokeP, OutParam<Boolean> foundErrs, LogEventFactory errs, double tolerance, String validationType) throws IoxException {
        return (Polygon)Iox2jtsext.surface2JTS_(obj, strokeP, foundErrs, errs, tolerance, validationType, false);
    }

    public static MultiPolygon multisurface2JTS(IomObject obj, double strokeP, OutParam<Boolean> foundErrs, LogEventFactory errs, double tolerance, String validationType) throws IoxException {
        return (MultiPolygon)Iox2jtsext.surface2JTS_(obj, strokeP, foundErrs, errs, tolerance, validationType, true);
    }

    private static Geometry surface2JTS_(IomObject obj, double strokeP, OutParam<Boolean> foundErrs, LogEventFactory errs, double tolerance, String validationType, boolean isMultiSurface) throws IoxException {
        boolean clipped;
        foundErrs.value = false;
        if (obj == null) {
            return null;
        }
        Polygon ret = null;
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new IoxException("clipped surface not supported");
        }
        String tag = obj.getobjecttag();
        if (!"MULTISURFACE".equals(tag)) {
            throw new IoxException("unexpected Type " + tag + "; MULTISURFACE expected");
        }
        int surfacec = obj.getattrvaluecount("surface");
        if (surfacec == 0) {
            throw new IoxException("at least one element surface expected");
        }
        if (!isMultiSurface && !clipped && surfacec > 1) {
            throw new IoxException("unclipped surface with multi 'surface' elements");
        }
        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
            if (clipped) {
                // empty if block
            }
            IomObject surface = obj.getattrobj("surface", surfacei);
            CompoundCurveRing shell = null;
            LinearRing[] holes = null;
            int boundaryc = surface.getattrvaluecount("boundary");
            if (boundaryc > 1) {
                holes = new CompoundCurveRing[boundaryc - 1];
            }
            for (int boundaryi = 0; boundaryi < boundaryc; ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                ArrayList<CompoundCurve> jtsLines = new ArrayList<CompoundCurve>();
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    OutParam lineErrs = new OutParam();
                    CompoundCurve jtsLine = Iox2jtsext.polyline2JTS(polyline, true, strokeP, (OutParam<Boolean>)lineErrs, errs, tolerance, validationType, "warning");
                    if (((Boolean)lineErrs.value).booleanValue()) {
                        foundErrs.value = (Boolean)foundErrs.value != false || (Boolean)lineErrs.value != false;
                    }
                    jtsLines.add(jtsLine);
                }
                if (boundaryi == 0) {
                    shell = new CompoundCurveRing(jtsLines, (GeometryFactory)new JtsextGeometryFactory());
                    continue;
                }
                holes[boundaryi - 1] = new CompoundCurveRing(jtsLines, (GeometryFactory)new JtsextGeometryFactory());
            }
            ret = new JtsextGeometryFactory().createPolygon(shell, holes);
            if (clipped) {
                // empty if block
            }
            polys.add(ret);
        }
        if (isMultiSurface) {
            return new JtsextGeometryFactory().createMultiPolygon(polys.toArray(new Polygon[polys.size()]));
        }
        return ret;
    }

    public static ArrayList<CompoundCurve> surface2JTSCompoundCurves(IomObject obj, String validationType, double tolerance, LogEventFactory errFact) throws IoxException {
        return Iox2jtsext.surface2JTSCompoundCurves_(obj, validationType, tolerance, errFact, false);
    }

    public static ArrayList<CompoundCurve> multisurface2JTSCompoundCurves(IomObject obj, String validationType, double tolerance, LogEventFactory errFact) throws IoxException {
        return Iox2jtsext.surface2JTSCompoundCurves_(obj, validationType, tolerance, errFact, true);
    }

    private static ArrayList<CompoundCurve> surface2JTSCompoundCurves_(IomObject obj, String validationType, double tolerance, LogEventFactory errFact, boolean isMultiSurface) throws IoxException {
        boolean clipped;
        if (obj == null) {
            return null;
        }
        boolean bl = clipped = obj.getobjectconsistency() == 1;
        if (clipped) {
            throw new IoxException("clipped surface not supported");
        }
        String tag = obj.getobjecttag();
        if (!"MULTISURFACE".equals(tag)) {
            throw new IoxException("unexpected Type " + tag + "; MULTISURFACE expected");
        }
        int surfacec = obj.getattrvaluecount("surface");
        if (surfacec == 0) {
            throw new IoxException("at least one element surface expected");
        }
        if (!isMultiSurface && !clipped && surfacec > 1) {
            throw new IoxException("unclipped surface with multi 'surface' elements");
        }
        ArrayList<CompoundCurve> jtsLines = new ArrayList<CompoundCurve>();
        for (int surfacei = 0; surfacei < surfacec; ++surfacei) {
            IomObject surface = obj.getattrobj("surface", surfacei);
            for (int boundaryi = 0; boundaryi < surface.getattrvaluecount("boundary"); ++boundaryi) {
                IomObject boundary = surface.getattrobj("boundary", boundaryi);
                for (int polylinei = 0; polylinei < boundary.getattrvaluecount("polyline"); ++polylinei) {
                    IomObject polyline = boundary.getattrobj("polyline", polylinei);
                    CompoundCurve jtsLine = Iox2jtsext.polyline2JTS(polyline, false, 0.0, (OutParam<Boolean>)new OutParam(), errFact, tolerance, validationType, "warning");
                    jtsLines.add(jtsLine);
                }
            }
        }
        return jtsLines;
    }
}

