/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.wkb;

import com.vividsolutions.jts.geom.Coordinate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LineSegment
implements Iterable<Coordinate> {
    private int wkbType = 2;
    private final List<Coordinate> coordinates = new ArrayList<Coordinate>();
    private final Map<Coordinate, Integer> coordinatesMap = new HashMap<Coordinate, Integer>();

    public LineSegment() {
    }

    public LineSegment(int wkbType) {
        this();
        this.wkbType = wkbType;
    }

    public int getWkbType() {
        return this.wkbType;
    }

    public boolean trySetWkbType(int wkbType) {
        if (this.coordinates.size() > 1) {
            return this.wkbType == wkbType;
        }
        this.wkbType = wkbType;
        return true;
    }

    public void add(Coordinate coordinate) {
        this.coordinatesMap.put(coordinate, this.coordinates.size());
        this.coordinates.add(coordinate);
    }

    public Coordinate get(int index) {
        return this.coordinates.get(index);
    }

    public Coordinate getLast() {
        return this.get(this.size() - 1);
    }

    public int size() {
        return this.coordinates.size();
    }

    public LineSegment splitTailAt(Coordinate coordinate) {
        int pos = this.coordinatesMap.get(coordinate);
        if (pos == this.coordinates.size() - 1) {
            return null;
        }
        if (pos != 0 && pos % 2 == 0 && this.wkbType == 8) {
            throw new IllegalArgumentException("A mid-point of an ARC can not start a ring " + coordinate.toString());
        }
        List<Coordinate> tail = this.coordinates.subList(pos, this.coordinates.size());
        LineSegment result = new LineSegment(this.wkbType);
        for (Coordinate coord : tail) {
            this.coordinatesMap.remove(coord);
            result.add(coord);
        }
        tail.clear();
        return result;
    }

    @Override
    public Iterator<Coordinate> iterator() {
        return this.coordinates.iterator();
    }

    public boolean contains(Coordinate coordinate) {
        return this.coordinatesMap.containsKey(coordinate);
    }
}

