/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.filter;

import ch.ehi.basics.settings.Settings;
import ch.interlis.ili2c.generator.XSDGenerator;
import ch.interlis.ili2c.metamodel.AbstractClassDef;
import ch.interlis.ili2c.metamodel.AttributeDef;
import ch.interlis.ili2c.metamodel.CompositionType;
import ch.interlis.ili2c.metamodel.Container;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.EnumTreeValueType;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.ExtendableContainer;
import ch.interlis.ili2c.metamodel.Model;
import ch.interlis.ili2c.metamodel.ObjectType;
import ch.interlis.ili2c.metamodel.RoleDef;
import ch.interlis.ili2c.metamodel.SurfaceOrAreaType;
import ch.interlis.ili2c.metamodel.SurfaceType;
import ch.interlis.ili2c.metamodel.Table;
import ch.interlis.ili2c.metamodel.Topic;
import ch.interlis.ili2c.metamodel.TransferDescription;
import ch.interlis.ili2c.metamodel.Type;
import ch.interlis.ili2c.metamodel.Viewable;
import ch.interlis.ili2c.metamodel.ViewableTransferElement;
import ch.interlis.iom.IomObject;
import ch.interlis.iom_j.itf.ModelUtilities;
import ch.interlis.iox.EndBasketEvent;
import ch.interlis.iox.EndTransferEvent;
import ch.interlis.iox.IoxEvent;
import ch.interlis.iox.IoxException;
import ch.interlis.iox.IoxLogging;
import ch.interlis.iox.IoxValidationDataPool;
import ch.interlis.iox.ObjectEvent;
import ch.interlis.iox.StartBasketEvent;
import ch.interlis.iox.StartTransferEvent;
import ch.interlis.iox_j.filter.IoxFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TranslateToTranslation
implements IoxFilter {
    private IoxLogging loggingHandler = null;
    private TransferDescription td = null;
    private boolean doItfLineTables = false;
    private HashMap<String, Object> tag2class = null;
    private HashMap<String, Topic> tag2topic = new HashMap();
    private HashMap<String, Element> srctag2destElement = null;
    Map<Type, Map<String, String>> src2destEles = null;

    public TranslateToTranslation(TransferDescription td, Settings config) {
        this.td = td;
        this.doItfLineTables = "doItfLinetables".equals(config.getValue("ch.interlis.iox_j.validator.doItfLinetables"));
        this.tag2class = this.doItfLineTables ? ModelUtilities.getTagMap(td) : XSDGenerator.getTagMap((TransferDescription)td);
        for (Model model : td) {
            for (Element topic : model) {
                if (!(topic instanceof Topic)) continue;
                this.tag2topic.put(topic.getScopedName(), (Topic)topic);
            }
        }
    }

    private void setupTranslation(Element destEle) {
        Element srcEle = destEle.getTranslationOfOrSame();
        if (this.srctag2destElement.containsKey(srcEle.getScopedName())) {
            return;
        }
        this.srctag2destElement.put(srcEle.getScopedName(), destEle);
        if (destEle instanceof Container) {
            Element extending;
            Iterator it = ((Container)destEle).iterator();
            while (it.hasNext()) {
                this.setupTranslation((Element)it.next());
            }
            if (destEle instanceof ExtendableContainer && (extending = ((ExtendableContainer)destEle).getExtending()) != null) {
                this.setupTranslation(extending);
            }
        }
    }

    private void setupStructMapping(Table destStruct) {
        Element srcEle = destStruct.getTranslationOfOrSame();
        if (this.srctag2destElement.containsKey(srcEle.getScopedName())) {
            return;
        }
        Table destContainer = destStruct;
        destContainer = destContainer.getContainer();
        for (Element destEle : destContainer) {
            if (!(destEle instanceof Table) || ((Table)destEle).isIdentifiable()) continue;
            this.setupTranslation(destEle);
        }
        while (!(destContainer instanceof Model)) {
        }
    }

    @Override
    public IoxEvent filter(IoxEvent event) throws IoxException {
        if (!(event instanceof StartTransferEvent)) {
            if (event instanceof StartBasketEvent) {
                String destTopicName = ((StartBasketEvent)event).getType();
                Topic destTopic = this.tag2topic.get(destTopicName);
                this.resetMapping();
                this.setupTranslation((Element)destTopic);
            } else if (event instanceof ObjectEvent) {
                this.translateObject(((ObjectEvent)event).getIomObject());
            } else if (event instanceof EndBasketEvent || event instanceof EndTransferEvent) {
                // empty if block
            }
        }
        return event;
    }

    private void resetMapping() {
        this.srctag2destElement = new HashMap();
        this.src2destEles = new HashMap<Type, Map<String, String>>();
    }

    private void translateObject(IomObject iomObj) {
        Element modelElement = (Element)this.tag2class.get(iomObj.getobjecttag());
        Element destModelEle = this.getTranslatedElement(modelElement);
        if (destModelEle == modelElement) {
            return;
        }
        if (this.doItfLineTables && modelElement instanceof AttributeDef) {
            Table lineAttrTable;
            IomObject structvalue;
            AttributeDef attr = (AttributeDef)modelElement;
            AttributeDef destAttr = (AttributeDef)destModelEle;
            Container table = destAttr.getContainer();
            String destName = table.getScopedName() + "_" + destAttr.getName();
            iomObj.setobjecttag(destName);
            SurfaceOrAreaType saType = (SurfaceOrAreaType)attr.getDomainResolvingAliases();
            if (saType instanceof SurfaceType) {
                String maintableref = ModelUtilities.getHelperTableMainTableRef(attr);
                String destMaintableref = ModelUtilities.getHelperTableMainTableRef(destAttr);
                if (iomObj.getattrvaluecount(maintableref) > 0) {
                    structvalue = iomObj.getattrobj(maintableref, 0);
                    iomObj.deleteattrobj(maintableref, 0);
                    iomObj.addattrobj(destMaintableref, structvalue);
                }
            }
            String geom = ModelUtilities.getHelperTableGeomAttrName(attr);
            String destGeom = ModelUtilities.getHelperTableGeomAttrName(destAttr);
            if (iomObj.getattrvaluecount(geom) > 0) {
                structvalue = iomObj.getattrobj(geom, 0);
                iomObj.deleteattrobj(geom, 0);
                iomObj.addattrobj(destGeom, structvalue);
            }
            if ((lineAttrTable = saType.getLineAttributeStructure()) != null) {
                ModelUtilities.getIli1AttrList((AbstractClassDef)lineAttrTable);
            }
        } else {
            Viewable aclass = (Viewable)modelElement;
            Viewable destClass = (Viewable)destModelEle;
            String destName = destClass.getScopedName();
            iomObj.setobjecttag(destName);
            Iterator iter = aclass.getAttributesAndRoles2();
            while (iter.hasNext()) {
                Type proxyType;
                AttributeDef attr;
                ViewableTransferElement obj = (ViewableTransferElement)iter.next();
                if (!(!(obj.obj instanceof AttributeDef) || (attr = (AttributeDef)obj.obj).isTransient() || (proxyType = attr.getDomain()) != null && proxyType instanceof ObjectType)) {
                    this.translateAttrValue(iomObj, attr);
                }
                if (!(obj.obj instanceof RoleDef)) continue;
                RoleDef role = (RoleDef)obj.obj;
                RoleDef destRole = (RoleDef)this.getTranslatedElement((Element)role);
                String roleName = role.getName();
                if (iomObj.getattrvaluecount(roleName) <= 0) continue;
                IomObject structvalue = iomObj.getattrobj(roleName, 0);
                iomObj.deleteattrobj(roleName, 0);
                iomObj.addattrobj(destRole.getName(), structvalue);
            }
        }
    }

    private Element getTranslatedElement(Element modelElement) {
        Element destEle = this.srctag2destElement.get(modelElement.getScopedName());
        if (destEle == null) {
            throw new IllegalArgumentException("untranslated element " + modelElement.getScopedName());
        }
        return destEle;
    }

    private void translateAttrValue(IomObject iomObj, AttributeDef attr) {
        IomObject structValue;
        String attrValue;
        int attri;
        String attrName = attr.getName();
        int attrc = iomObj.getattrvaluecount(attrName);
        if (attrc == 0) {
            return;
        }
        boolean isCompType = attr.getDomain() instanceof CompositionType;
        boolean isEnumType = attr.getDomainResolvingAliases() instanceof EnumerationType;
        boolean isEnumAllType = attr.getDomainResolvingAliases() instanceof EnumTreeValueType;
        EnumerationType enumType = null;
        EnumTreeValueType enumAllType = null;
        if (isEnumType) {
            enumType = (EnumerationType)attr.getDomainResolvingAliases();
        }
        if (isEnumAllType) {
            enumAllType = (EnumTreeValueType)attr.getDomainResolvingAliases();
        }
        AttributeDef destAttr = (AttributeDef)this.getTranslatedElement((Element)attr);
        String destAttrName = destAttr.getName();
        ArrayList<String> values = new ArrayList<String>();
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = iomObj.getattrprim(attrName, attri);
            if (attrValue != null) {
                values.add(attrValue);
                continue;
            }
            structValue = iomObj.getattrobj(attrName, attri);
            values.add((String)structValue);
        }
        iomObj.setattrundefined(attrName);
        for (attri = 0; attri < attrc; ++attri) {
            attrValue = values.get(attri);
            if (attrValue == null) continue;
            if (attrValue instanceof String) {
                if (isEnumType) {
                    attrValue = this.translateEnumValue(attrValue, enumType, (EnumerationType)destAttr.getDomainResolvingAliases());
                } else if (isEnumAllType) {
                    attrValue = this.translateEnumAllValue(attrValue, enumAllType, (EnumTreeValueType)destAttr.getDomainResolvingAliases());
                }
                iomObj.setattrvalue(destAttrName, attrValue);
                continue;
            }
            structValue = (IomObject)attrValue;
            if (isCompType) {
                this.setupStructMapping(((CompositionType)destAttr.getDomain()).getComponentType());
                this.translateObject(structValue);
            }
            iomObj.addattrobj(destAttrName, structValue);
        }
    }

    private String translateEnumValue(String attrValue, EnumerationType enumType, EnumerationType destEnumType) {
        Map<String, String> src2dest = this.getEnumMapping(enumType, destEnumType);
        String destValue = src2dest.get(attrValue);
        return destValue;
    }

    private String translateEnumAllValue(String attrValue, EnumTreeValueType enumType, EnumTreeValueType destEnumType) {
        Map<String, String> src2dest = this.getEnumAllMapping(enumType, destEnumType);
        String destValue = src2dest.get(attrValue);
        return destValue;
    }

    private Map<String, String> getEnumMapping(EnumerationType enumType, EnumerationType destEnumType) {
        Map<String, String> src2dest = this.src2destEles.get(enumType);
        if (src2dest == null) {
            Enumeration eles = enumType.getConsolidatedEnumeration();
            src2dest = new HashMap<String, String>();
            List srcVals = enumType.getValues();
            List destVals = destEnumType.getValues();
            for (int i = 0; i < srcVals.size(); ++i) {
                src2dest.put((String)srcVals.get(i), (String)destVals.get(i));
            }
            this.src2destEles.put((Type)enumType, src2dest);
        }
        return src2dest;
    }

    private Map<String, String> getEnumAllMapping(EnumTreeValueType enumType, EnumTreeValueType destEnumType) {
        Map<String, String> src2dest = this.src2destEles.get(enumType);
        if (src2dest == null) {
            Enumeration eles = enumType.getConsolidatedEnumeration();
            src2dest = new HashMap<String, String>();
            List srcVals = enumType.getValues();
            List destVals = destEnumType.getValues();
            for (int i = 0; i < srcVals.size(); ++i) {
                src2dest.put((String)srcVals.get(i), (String)destVals.get(i));
            }
            this.src2destEles.put((Type)enumType, src2dest);
        }
        return src2dest;
    }

    @Override
    public void close() {
        this.loggingHandler = null;
    }

    @Override
    public IoxLogging getLoggingHandler() {
        return this.loggingHandler;
    }

    @Override
    public void setLoggingHandler(IoxLogging errs) {
        this.loggingHandler = errs;
    }

    @Override
    public IoxValidationDataPool getDataPool() {
        return null;
    }
}

