/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize;

import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.geom.StraightSegment;
import ch.interlis.iom_j.itf.impl.jtsext.operation.polygonize.PolygonizeEdge;
import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateArrays;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.planargraph.DirectedEdge;
import java.util.ArrayList;
import java.util.List;

class EdgeRing {
    private GeometryFactory factory;
    private List<DirectedEdge> deList = new ArrayList<DirectedEdge>();
    private LinearRing ring = null;
    private CompoundCurve ringPts = null;
    private List holes;

    public static EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        LinearRing testRing = testEr.getRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        EdgeRing minShell = null;
        Envelope minShellEnv = null;
        for (EdgeRing tryShell : shellList) {
            LinearRing tryShellRing = tryShell.getRing();
            Envelope tryShellEnv = tryShellRing.getEnvelopeInternal();
            if (EdgeRing.isSameRing(tryShell, testEr) || tryShellEnv.equals((Object)testEnv) || !tryShellEnv.contains(testEnv) || (testPt = CoordinateArrays.ptNotInList((Coordinate[])testRing.getCoordinates(), (Coordinate[])tryShellRing.getCoordinates())) == null) continue;
            boolean isContained = false;
            if (CGAlgorithms.isPointInRing((Coordinate)testPt, (Coordinate[])tryShellRing.getCoordinates())) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minShellEnv.contains(tryShellEnv)) continue;
            minShell = tryShell;
            minShellEnv = minShell.getRing().getEnvelopeInternal();
        }
        return minShell;
    }

    private static boolean isSameRing(EdgeRing tryShell, EdgeRing testEr) {
        List edge1 = DirectedEdge.toEdges(tryShell.deList);
        List edge2 = DirectedEdge.toEdges(testEr.deList);
        int trySize = edge1.size();
        if (trySize != edge2.size()) {
            return false;
        }
        if (edge1.get(0) == edge2.get(0)) {
            for (int i = 0; i < trySize; ++i) {
                if (edge1.get(i) == edge2.get(i)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < trySize; ++i) {
                if (edge1.get(i) == edge2.get(trySize - i - 1)) continue;
                return false;
            }
        }
        return true;
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i = 0; i < testPts.length; ++i) {
            Coordinate testPt = testPts[i];
            if (EdgeRing.isInList(testPt, pts)) continue;
            return testPt;
        }
        return null;
    }

    public static boolean isInList(Coordinate pt, Coordinate[] pts) {
        for (int i = 0; i < pts.length; ++i) {
            if (!pt.equals((Object)pts[i])) continue;
            return true;
        }
        return false;
    }

    public EdgeRing(GeometryFactory factory) {
        this.factory = factory;
    }

    public void add(DirectedEdge de) {
        this.deList.add(de);
    }

    public boolean isHole() {
        LinearRing ring = this.getRing();
        return CompoundCurveRing.isCCW(ring);
    }

    public void addHole(LinearRing hole) {
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(hole);
    }

    public Polygon getPolygon() {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = (LinearRing)this.holes.get(i);
            }
        }
        Polygon poly = this.factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public boolean isValid() {
        this.getCoordinates();
        if (this.ringPts.getCoordinates().length <= 3) {
            return false;
        }
        try {
            this.getRing();
        }
        catch (Exception e) {
            return false;
        }
        return this.ring != null && this.ring.isValid();
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            ArrayList<CurveSegment> coordList = new ArrayList<CurveSegment>();
            for (DirectedEdge de : this.deList) {
                PolygonizeEdge edge = (PolygonizeEdge)de.getEdge();
                EdgeRing.addEdge(edge.getLine(), de.getEdgeDirection(), coordList);
            }
            this.ringPts = ((JtsextGeometryFactory)this.factory).createCompoundCurve(coordList);
        }
        return this.ringPts.getCoordinates();
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.ringPts;
    }

    public LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        if (this.ringPts.getCoordinates().length < 3) {
            throw new IllegalStateException("not a ring " + (Object)((Object)this.ringPts));
        }
        this.ring = ((JtsextGeometryFactory)this.factory).createCompoundCurveRing(this.ringPts);
        return this.ring;
    }

    private static void addEdge(LineString lineString, boolean isForward, ArrayList<CurveSegment> newSegs) {
        if (lineString instanceof CompoundCurve) {
            if (isForward) {
                int segi = 0;
                for (CurveSegment seg : ((CompoundCurve)lineString).getSegments()) {
                    if (segi == 0 && newSegs.size() > 0 && !newSegs.get(newSegs.size() - 1).getEndPoint().equals2D(seg.getStartPoint())) {
                        throw new IllegalStateException("Start!=Last");
                    }
                    newSegs.add(seg);
                    ++segi;
                }
            } else {
                ArrayList<CurveSegment> segv = ((CompoundCurve)lineString).getSegments();
                for (int segi = segv.size() - 1; segi >= 0; --segi) {
                    CurveSegment newSeg;
                    CurveSegment seg = segv.get(segi);
                    if (segi == 0 && newSegs.size() > 0 && !newSegs.get(newSegs.size() - 1).getEndPoint().equals2D(seg.getEndPoint())) {
                        throw new IllegalStateException("Start!=Last");
                    }
                    if (seg instanceof ArcSegment) {
                        newSeg = new ArcSegment(seg.getEndPoint(), ((ArcSegment)seg).getMidPoint(), seg.getStartPoint());
                        newSeg.setUserData(seg.getUserData());
                        newSegs.add(newSeg);
                        continue;
                    }
                    newSeg = new StraightSegment(seg.getEndPoint(), seg.getStartPoint());
                    newSeg.setUserData(seg.getUserData());
                    newSegs.add(newSeg);
                }
            }
        } else {
            if (lineString instanceof CompoundCurveRing) {
                throw new IllegalArgumentException("lineString instanceof CompoundCurveRing");
            }
            Coordinate[] coords = lineString.getCoordinates();
            if (isForward) {
                for (int i = 0; i < coords.length - 1; ++i) {
                    if (newSegs.size() > 0 && i == 0 && !newSegs.get(newSegs.size() - 1).getEndPoint().equals2D(coords[i])) {
                        throw new IllegalStateException("Start!=Last");
                    }
                    newSegs.add(new StraightSegment(coords[i], coords[i + 1]));
                }
            } else {
                for (int i = coords.length - 1; i > 0; --i) {
                    if (i == 1 && !newSegs.get(newSegs.size() - 1).getEndPoint().equals2D(coords[i - 1])) {
                        throw new IllegalStateException("Start!=Last");
                    }
                    newSegs.add(new StraightSegment(coords[i], coords[i - 1]));
                }
            }
        }
    }

    public List<? extends DirectedEdge> getEdges() {
        return this.deList;
    }
}

