/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.noding;

import ch.interlis.iom_j.itf.impl.ItfSurfaceLinetable2Polygon;
import ch.interlis.iom_j.itf.impl.jtsext.algorithm.CurveSegmentIntersector;
import ch.interlis.iom_j.itf.impl.jtsext.geom.ArcSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurveRing;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iom_j.itf.impl.jtsext.geom.JtsextGeometryFactory;
import ch.interlis.iom_j.itf.impl.jtsext.noding.Intersection;
import ch.interlis.iox_j.IoxIntersectionException;
import ch.interlis.iox_j.IoxInvalidDataException;
import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AreaValidator {
    private static final byte NOT_SET = -1;
    private static final byte UNKNOWN = 0;
    private static final byte INVALID = 1;
    private static final byte MATCHED = 2;
    private static final byte VALID = 3;
    private final CurveSegmentIntersector intersector = new CurveSegmentIntersector();
    private final JtsextGeometryFactory factory;
    private final double maxOverlap;
    private final List<Face> faces = new ArrayList<Face>();
    private final List<EdgeRing> rings = new ArrayList<EdgeRing>();
    private final List<Intersection> intersections = new ArrayList<Intersection>();
    private final Map<String, Set<String>> overlaps = new HashMap<String, Set<String>>();

    public AreaValidator(JtsextGeometryFactory factory, double maxOverlap) {
        this.factory = factory;
        this.maxOverlap = maxOverlap;
    }

    public static List<IoxInvalidDataException> validateArea(Collection<Polygon> polygons, double maxOverlap, String iliQualifiedName) {
        if (polygons.isEmpty()) {
            return Collections.emptyList();
        }
        JtsextGeometryFactory factory = (JtsextGeometryFactory)polygons.iterator().next().getFactory();
        AreaValidator areaValidator = new AreaValidator(factory, maxOverlap);
        areaValidator.addPolygons(polygons);
        areaValidator.validateAll();
        return areaValidator.createIntersectionExceptions(iliQualifiedName);
    }

    public void addPolygons(Collection<Polygon> polygons) {
        HashMap<Edge, CurveSegment> segmentsMap = new HashMap<Edge, CurveSegment>();
        HashMap<Coordinate, List<Edge>> nodes = new HashMap<Coordinate, List<Edge>>();
        for (Polygon polygon : polygons) {
            this.addPolygon(polygon, segmentsMap, nodes);
        }
        this.mergeLines(nodes);
    }

    private void addPolygon(Polygon polygon, Map<Edge, CurveSegment> segmentsMap, Map<Coordinate, List<Edge>> nodes) {
        Face face = new Face();
        this.faces.add(face);
        face.polygon = polygon;
        CompoundCurveRing shell = (CompoundCurveRing)polygon.getExteriorRing();
        face.shell = this.addRing(shell, true, polygon.getUserData(), segmentsMap, nodes);
        face.holes = new EdgeRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            CompoundCurveRing hole = (CompoundCurveRing)polygon.getInteriorRingN(i);
            face.holes[i] = this.addRing(hole, false, polygon.getUserData(), segmentsMap, nodes);
        }
    }

    private EdgeRing addRing(CompoundCurveRing linearRing, boolean isShell, Object userData, Map<Edge, CurveSegment> segmentsMap, Map<Coordinate, List<Edge>> nodes) {
        CompoundCurve ring;
        EdgeRing edgeRing = new EdgeRing();
        edgeRing.userData = userData;
        this.rings.add(edgeRing);
        if (linearRing.getLines().size() == 1) {
            ring = linearRing.getLines().get(0);
        } else {
            ArrayList<CurveSegment> segments = new ArrayList<CurveSegment>();
            for (CompoundCurve line : linearRing.getLines()) {
                segments.addAll(line.getSegments());
            }
            ring = this.factory.createCompoundCurve(segments);
        }
        ring.setUserData(userData);
        edgeRing.lines = ring;
        edgeRing.isRightInside = isShell ^ this.isCCW(ring);
        this.addLine(ring, edgeRing, segmentsMap, nodes);
        return edgeRing;
    }

    private boolean isCCW(CompoundCurve ring) {
        CompoundCurve fixedCurve = this.factory.createCompoundCurve(ring);
        ItfSurfaceLinetable2Polygon.removeValidSelfIntersections(fixedCurve, this.maxOverlap, 0.1);
        return CompoundCurveRing.isCCW(this.factory.createCompoundCurveRing(fixedCurve));
    }

    private void addLine(CompoundCurve compoundCurve, EdgeRing edgeRing, Map<Edge, CurveSegment> segmentsMap, Map<Coordinate, List<Edge>> nodes) {
        ArrayList<CurveSegment> segments = compoundCurve.getSegments();
        for (int i = 0; i < compoundCurve.getNumSegments(); ++i) {
            List<Edge> endNode;
            CurveSegment segment = segments.get(i);
            List<Edge> startNode = nodes.get(segment.getStartPoint());
            if (startNode == null) {
                startNode = new ArrayList<Edge>();
                nodes.put(segment.getStartPoint(), startNode);
            }
            if ((endNode = nodes.get(segment.getEndPoint())) == null) {
                endNode = new ArrayList<Edge>();
                nodes.put(segment.getEndPoint(), endNode);
            }
            Edge areaEdge = null;
            for (Edge edge : endNode) {
                if (!AreaValidator.isControlPoint(edge.fromNode, segment) && !AreaValidator.isControlPoint(edge.toNode, segment) || !segment.equals(segmentsMap.get(edge))) continue;
                areaEdge = edge;
                break;
            }
            if (areaEdge == null) {
                areaEdge = new Edge(segment);
                segmentsMap.put(areaEdge, segment);
                startNode.add(areaEdge);
                endNode.add(areaEdge);
            }
            if (areaEdge.fromNode.equals2D(segment.getStartPoint())) {
                areaEdge.edgeRings.add(edgeRing);
            } else {
                areaEdge.reversedEdgeRings.add(edgeRing);
            }
            edgeRing.edges.add(areaEdge);
        }
    }

    private void mergeLines(Map<Coordinate, List<Edge>> nodes) {
        for (Map.Entry<Coordinate, List<Edge>> node : nodes.entrySet()) {
            List<Edge> adjNode;
            Edge edgeB;
            Edge edgeA;
            Coordinate point = node.getKey();
            List<Edge> edges = node.getValue();
            if (edges.size() != 2 || (edgeA = edges.get(0)) == (edgeB = edges.get(1))) continue;
            for (EdgeRing edgeRing : edgeB.edgeRings) {
                edgeRing.edges.remove(edgeB);
            }
            for (EdgeRing edgeRing : edgeB.reversedEdgeRings) {
                edgeRing.edges.remove(edgeB);
            }
            if (edgeB.fromNode.equals2D(point)) {
                adjNode = nodes.get(edgeB.toNode);
                adjNode.remove(edgeB);
                adjNode.add(edgeA);
                edgeA.toNode = edgeB.toNode;
                continue;
            }
            adjNode = nodes.get(edgeB.fromNode);
            adjNode.remove(edgeB);
            adjNode.add(edgeA);
            edgeA.fromNode = edgeB.fromNode;
        }
    }

    public List<IoxInvalidDataException> createIntersectionExceptions(String iliQualifiedName) {
        ArrayList<IoxInvalidDataException> invalidDataExceptions = new ArrayList<IoxInvalidDataException>();
        for (Intersection intersection : this.intersections) {
            invalidDataExceptions.add(new IoxIntersectionException(iliQualifiedName, intersection.getCurve1().getUserData().toString(), intersection));
        }
        if (this.intersections.isEmpty()) {
            for (Map.Entry entry : this.overlaps.entrySet()) {
                String tid1 = (String)entry.getKey();
                for (String tid2 : (Set)entry.getValue()) {
                    invalidDataExceptions.add(new IoxInvalidDataException("polygons overlay tid1 " + tid1 + ", tid2 " + tid2));
                }
            }
        }
        return invalidDataExceptions;
    }

    public List<MultiLineString> gatherInvalidGeometry() {
        ArrayList<MultiLineString> invalidMultiLines = new ArrayList<MultiLineString>();
        for (Face face : this.faces) {
            ArrayList<CompoundCurve> invalidLines = new ArrayList<CompoundCurve>(this.gatherInvalidGeometry(face.shell));
            for (EdgeRing edgeRing : face.holes) {
                invalidLines.addAll(this.gatherInvalidGeometry(edgeRing));
            }
            if (invalidLines.isEmpty()) continue;
            MultiLineString invalidMultiLine = this.factory.createMultiLineString(invalidLines.toArray(new CompoundCurve[0]));
            invalidMultiLine.setUserData(face.polygon.getUserData());
            invalidMultiLines.add(invalidMultiLine);
        }
        return invalidMultiLines;
    }

    private List<CompoundCurve> gatherInvalidGeometry(EdgeRing edgeRing) {
        ArrayList<CompoundCurve> invalidLines = new ArrayList<CompoundCurve>();
        ArrayList<CurveSegment> invalidSegments = new ArrayList<CurveSegment>();
        boolean lastSegmentValid = true;
        for (int i = 0; i < edgeRing.getNumSegments(); ++i) {
            if (edgeRing.state[i] == 1) {
                invalidSegments.add(edgeRing.getSegment(i));
                lastSegmentValid = false;
                continue;
            }
            if (!lastSegmentValid) {
                CompoundCurve invalidLine = this.factory.createCompoundCurve(invalidSegments);
                invalidLines.add(invalidLine);
                invalidSegments.clear();
            }
            lastSegmentValid = true;
        }
        if (!invalidSegments.isEmpty()) {
            CompoundCurve invalidLine = this.factory.createCompoundCurve(invalidSegments);
            invalidLines.add(invalidLine);
        }
        return invalidLines;
    }

    public void validateAll() {
        this.initializeEdgeState();
        STRtree index = new STRtree();
        for (Face face : this.faces) {
            index.insert(face.polygon.getEnvelopeInternal(), (Object)face);
        }
        for (Face face : this.faces) {
            List adjacentFaces = index.query(face.polygon.getEnvelopeInternal());
            adjacentFaces.remove(face);
            this.validateFace(face, adjacentFaces);
        }
    }

    private void initializeEdgeState() {
        for (EdgeRing ring : this.rings) {
            ring.state = new byte[ring.getNumSegments()];
            int segmentIndex = 0;
            for (Edge edge : ring.edges) {
                int toIndex;
                if (edge.edgeRings.size() + edge.reversedEdgeRings.size() < 2) continue;
                boolean reversed = edge.reversedEdgeRings.contains(ring);
                boolean ringOnRight = ring.isRightInside ^ reversed;
                byte state = 2;
                for (EdgeRing edgeRing : edge.edgeRings) {
                    if (edgeRing == ring || edgeRing.isRightInside != ringOnRight) continue;
                    this.recordOverlap(ring.userData.toString(), edgeRing.userData.toString());
                    state = 1;
                    break;
                }
                if (state != 1) {
                    for (EdgeRing edgeRing : edge.reversedEdgeRings) {
                        if (edgeRing == ring || edgeRing.isRightInside == ringOnRight) continue;
                        this.recordOverlap(ring.userData.toString(), edgeRing.userData.toString());
                        state = 1;
                        break;
                    }
                }
                Coordinate firstNode = reversed ? edge.toNode : edge.fromNode;
                Coordinate lastNode = reversed ? edge.fromNode : edge.toNode;
                int fromIndex = ring.indexOfNextSegment(firstNode, segmentIndex);
                segmentIndex = toIndex = ring.indexOfNextSegment(lastNode, fromIndex);
                if (fromIndex < toIndex) {
                    Arrays.fill(ring.state, fromIndex, toIndex, state);
                    continue;
                }
                Arrays.fill(ring.state, fromIndex, ring.getNumSegments(), state);
                Arrays.fill(ring.state, 0, toIndex, state);
            }
        }
    }

    private void validateFace(Face currentFace, List<Face> adjacentFaces) {
        this.validateEdgeRing(currentFace.shell, adjacentFaces);
        for (EdgeRing edgeRing : currentFace.holes) {
            this.validateEdgeRing(edgeRing, adjacentFaces);
        }
    }

    private void validateEdgeRing(EdgeRing edgeRing, List<Face> adjacentFaces) {
        if (edgeRing.isAllKnown()) {
            return;
        }
        block0: for (int i = 0; i < edgeRing.getNumSegments(); ++i) {
            if (edgeRing.isKnown(i)) continue;
            int allValid = -1;
            for (Face adjacentFace : adjacentFaces) {
                EdgeRing shell = adjacentFace.shell;
                byte segmentInsideShell = this.validateSegmentAgainstRing(edgeRing, i, shell);
                int segmentInsideHole = 0;
                for (EdgeRing hole : adjacentFace.holes) {
                    byte holeState = this.validateSegmentAgainstRing(edgeRing, i, hole);
                    if (holeState == 3) {
                        segmentInsideHole = 3;
                        continue;
                    }
                    if (holeState != 1 || segmentInsideHole != 0) continue;
                    segmentInsideHole = 1;
                }
                if (segmentInsideShell == 3 || segmentInsideHole == 3) {
                    if (allValid != -1) continue;
                    allValid = 3;
                    continue;
                }
                if (segmentInsideShell == 1 || segmentInsideHole == 1) {
                    allValid = 1;
                    edgeRing.setState(i, (byte)1);
                    this.recordOverlap(edgeRing.userData.toString(), shell.userData.toString());
                    continue;
                }
                if (allValid == 1) continue;
                allValid = 0;
            }
            if (allValid == 3) {
                edgeRing.setState(i, (byte)3);
            }
            if (edgeRing.isKnown(i)) continue;
            CurveSegment thisSegment = edgeRing.getSegment(i);
            for (Face adjacentFace : adjacentFaces) {
                if (!this.isPointInsideFace(thisSegment.getEndPoint(), adjacentFace)) continue;
                this.recordOverlap(edgeRing.userData.toString(), adjacentFace.polygon.getUserData().toString());
                edgeRing.setState(i, (byte)1);
                edgeRing.setState(edgeRing.next(i), (byte)1);
                continue block0;
            }
        }
    }

    private byte validateSegmentAgainstRing(EdgeRing testRing, int testSegmentIndex, EdgeRing otherRing) {
        CurveSegment testSegment = testRing.getSegment(testSegmentIndex);
        STRtree index = otherRing.getIndex();
        HashMap pointsToCheck = new HashMap();
        List otherSegments = index.query(testSegment.computeEnvelopeInternal());
        Iterator iterator = otherSegments.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            CurveSegment otherSegment = otherRing.getSegment(i);
            this.intersector.computeIntersection(testSegment, otherSegment);
            if (!this.intersector.hasIntersection()) continue;
            if (AreaValidator.isInvalidProperIntersection(this.intersector, testSegment, otherSegment, this.maxOverlap)) {
                testRing.setState(testSegmentIndex, (byte)1);
                otherRing.setState(i, (byte)1);
                this.recordIntersection(this.intersector, testRing.lines, otherRing.lines, testSegment, otherSegment);
                continue;
            }
            if (this.intersector.getIntersectionNum() == 2) {
                if (this.intersector.isIntersection(otherSegment.getStartPoint())) {
                    if (this.intersector.isIntersection(otherSegment.getEndPoint())) {
                        this.mergeMax(pointsToCheck, i, 0.0);
                        this.mergeMax(pointsToCheck, otherRing.next(i), 0.0);
                        continue;
                    }
                    this.mergeMax(pointsToCheck, i, this.intersector.getIntersection(0).distance(this.intersector.getIntersection(1)));
                    continue;
                }
                this.mergeMax(pointsToCheck, otherRing.next(i), this.intersector.getIntersection(0).distance(this.intersector.getIntersection(1)));
                continue;
            }
            if (this.intersector.getIntersectionNum() != 1) continue;
            if (this.intersector.isIntersection(otherSegment.getStartPoint())) {
                this.mergeMax(pointsToCheck, i, 0.0);
                continue;
            }
            this.mergeMax(pointsToCheck, otherRing.next(i), 0.0);
        }
        int state = 0;
        for (Map.Entry point : pointsToCheck.entrySet()) {
            boolean onInside;
            int i = (Integer)point.getKey();
            double distance = (Double)point.getValue();
            CurveSegment next = otherRing.getSegment(i);
            CurveSegment previous = otherRing.getSegment(otherRing.previous(i));
            this.intersector.computeIntersection(previous, next);
            if (!(this.intersector.getIntersectionNum() != 2 || this.intersector.isIntersection(next.getStartPoint()) && this.intersector.isIntersection(next.getEndPoint()))) {
                distance = Math.max(distance, this.intersector.getIntersection(0).distance(this.intersector.getIntersection(1)));
            }
            if (onInside = AreaValidator.isOnInside(next.getStartPoint(), testSegment, previous, next, distance) ^ otherRing.isRightInside) {
                return 1;
            }
            state = 3;
        }
        return (byte)state;
    }

    private <K> void mergeMax(Map<K, Double> map, K key, double value) {
        Double previous = map.get(key);
        if (previous == null) {
            map.put(key, value);
        } else {
            map.put(key, Math.max(previous, value));
        }
    }

    private boolean isPointInsideFace(Coordinate point, Face face) {
        if (face.indexedPointInAreaLocator == null) {
            face.indexedPointInAreaLocator = new IndexedPointInAreaLocator((Geometry)face.polygon);
        }
        return face.indexedPointInAreaLocator.locate(point) == 0;
    }

    private void recordIntersection(CurveSegmentIntersector intersector, CompoundCurve curveA, CompoundCurve curveB, CurveSegment segmentA, CurveSegment segmentB) {
        if (intersector.getIntersectionNum() == 1) {
            this.intersections.add(new Intersection(intersector.getIntersection(0), curveA, curveB, segmentA, segmentB, intersector.getOverlap()));
        } else if (intersector.getIntersectionNum() == 2) {
            this.intersections.add(new Intersection(intersector.getIntersection(0), intersector.getIntersection(1), curveA, curveB, segmentA, segmentB, intersector.getOverlap(), intersector.isOverlay()));
        }
    }

    private void recordOverlap(String tid1, String tid2) {
        Set<String> overlapings;
        if (tid1.compareTo(tid2) > 0) {
            String temp = tid1;
            tid1 = tid2;
            tid2 = temp;
        }
        if ((overlapings = this.overlaps.get(tid1)) == null) {
            overlapings = new HashSet<String>();
        }
        overlapings.add(tid2);
        this.overlaps.put(tid1, overlapings);
    }

    private static boolean isInvalidProperIntersection(CurveSegmentIntersector intersector, CurveSegment segmentA, CurveSegment segmentB, double maxOverlap) {
        if (intersector.isOverlay()) {
            return true;
        }
        if (intersector.getIntersectionNum() == 2) {
            boolean p1AtControlPoints;
            Coordinate p0 = intersector.getIntersection(0);
            Coordinate p1 = intersector.getIntersection(1);
            boolean p0AtControlPoints = AreaValidator.isControlPoint(p0, segmentA) && AreaValidator.isControlPoint(p0, segmentB);
            boolean bl = p1AtControlPoints = AreaValidator.isControlPoint(p1, segmentA) && AreaValidator.isControlPoint(p1, segmentB);
            if (!p0AtControlPoints && !p1AtControlPoints) {
                return true;
            }
            if (p0AtControlPoints && p1AtControlPoints) {
                return false;
            }
            return intersector.getOverlap() != null && intersector.getOverlap() > maxOverlap;
        }
        if (intersector.getIntersectionNum() == 1) {
            Coordinate p = intersector.getIntersection(0);
            return !AreaValidator.isControlPoint(p, segmentA) || !AreaValidator.isControlPoint(p, segmentB);
        }
        return false;
    }

    private static boolean isControlPoint(Coordinate point, CurveSegment segment) {
        return point.equals2D(segment.getStartPoint()) || point.equals2D(segment.getEndPoint());
    }

    private static boolean isOnInside(Coordinate point, CurveSegment testSegment, CurveSegment firstSegment, CurveSegment secondSegment, double minDirectionPointDistance) {
        Coordinate first = AreaValidator.getDirectionPoint(point, firstSegment, minDirectionPointDistance);
        Coordinate second = AreaValidator.getDirectionPoint(point, secondSegment, minDirectionPointDistance);
        Coordinate test = AreaValidator.getDirectionPoint(point, testSegment, minDirectionPointDistance);
        return AreaValidator.isOnInside(point, first, second, test);
    }

    private static boolean isOnInside(Coordinate origin, Coordinate p0, Coordinate p1, Coordinate testPoint) {
        double first = AreaValidator.getAngle(origin, p0);
        double second = AreaValidator.getAngle(origin, p1);
        double test = AreaValidator.getAngle(origin, testPoint);
        if (first < second) {
            return second < test || test < first;
        }
        return second < test && test < first;
    }

    private static Coordinate getDirectionPoint(Coordinate origin, CurveSegment segment, double minDirectionPointDistance) {
        boolean originAtStart = segment.getStartPoint().equals2D(origin);
        if (segment instanceof ArcSegment) {
            return ((ArcSegment)segment).getDirectionPt(originAtStart, minDirectionPointDistance + 0.1);
        }
        return originAtStart ? segment.getEndPoint() : segment.getStartPoint();
    }

    private static double getAngle(Coordinate origin, Coordinate point) {
        return Math.atan2(point.y - origin.y, point.x - origin.x);
    }

    private static class Face {
        public EdgeRing shell;
        public EdgeRing[] holes;
        public Polygon polygon;
        public IndexedPointInAreaLocator indexedPointInAreaLocator;

        private Face() {
        }
    }

    private static class EdgeRing {
        public final List<Edge> edges = new ArrayList<Edge>();
        public CompoundCurve lines;
        public boolean isRightInside;
        public Object userData;
        public byte[] state;
        private STRtree index;

        private EdgeRing() {
        }

        public STRtree getIndex() {
            if (this.index == null) {
                this.index = new STRtree();
                for (int i = 0; i < this.lines.getSegments().size(); ++i) {
                    this.index.insert(this.lines.getSegments().get(i).computeEnvelopeInternal(), (Object)i);
                }
                this.index.build();
            }
            return this.index;
        }

        public int getNumSegments() {
            return this.lines.getNumSegments();
        }

        public CurveSegment getSegment(int index) {
            return this.lines.getSegments().get(index);
        }

        public int next(int index) {
            return index == this.getNumSegments() - 1 ? 0 : index + 1;
        }

        public int previous(int index) {
            return index == 0 ? this.getNumSegments() - 1 : index - 1;
        }

        public void setState(int index, byte newState) {
            if (this.state[index] == 0) {
                this.state[index] = newState;
            }
        }

        public boolean isAllKnown() {
            for (int i = 0; i < this.lines.getNumSegments(); ++i) {
                if (this.isKnown(i)) continue;
                return false;
            }
            return true;
        }

        public boolean isKnown(int index) {
            return this.state[index] != 0;
        }

        public int indexOfNextSegment(Coordinate point, int startIndex) {
            int index;
            ArrayList<CurveSegment> segments = this.lines.getSegments();
            for (index = startIndex; index < this.getNumSegments(); ++index) {
                if (!segments.get(index).getStartPoint().equals2D(point)) continue;
                return index;
            }
            for (index = 0; index < startIndex; ++index) {
                if (!segments.get(index).getStartPoint().equals2D(point)) continue;
                return index;
            }
            throw new IllegalArgumentException(String.format("point %s is not the start point of any segment of %s", new Object[]{point, this.lines}));
        }
    }

    private static class Edge {
        Coordinate fromNode;
        Coordinate toNode;
        final List<EdgeRing> edgeRings = new ArrayList<EdgeRing>();
        final List<EdgeRing> reversedEdgeRings = new ArrayList<EdgeRing>();

        public Edge(CurveSegment segment) {
            this.fromNode = segment.getStartPoint();
            this.toNode = segment.getEndPoint();
        }
    }
}

