/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j;

import ch.interlis.iom.IomObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class Iom_jObject
implements IomObject,
Serializable {
    public static final String COORD_C1 = "C1";
    public static final String COORD_C2 = "C2";
    public static final String COORD_C3 = "C3";
    public static final String ARC_A1 = "A1";
    public static final String ARC_A2 = "A2";
    public static final String ARC_R = "R";
    public static final String MULTICOORD = "MULTICOORD";
    public static final String MULTICOORD_COORD = "coord";
    public static final String MULTIPOLYLINE = "MULTIPOLYLINE";
    public static final String MULTIPOLYLINE_POLYLINE = "polyline";
    public static final String POLYLINE = "POLYLINE";
    public static final String POLYLINE_SEQUENCE = "sequence";
    public static final String POLYLINE_LINEATTR = "lineattr";
    public static final String SEGMENTS = "SEGMENTS";
    public static final String SEGMENTS_SEGMENT = "segment";
    public static final String COORD = "COORD";
    public static final String ARC = "ARC";
    public static final String MULTISURFACE = "MULTISURFACE";
    public static final String MULTISURFACE_SURFACE = "surface";
    public static final String SURFACE = "SURFACE";
    public static final String SURFACE_BOUNDARY = "boundary";
    public static final String BOUNDARY = "BOUNDARY";
    public static final String BOUNDARY_POLYLINE = "polyline";
    public static final String INTERNAL_T_ID = "_t_id";
    public static final String REF = "REF";
    private final HashMap<String, ArrayList> attrv = new HashMap();
    private int col = 0;
    private int line = 0;
    private int consistency;
    private String oid;
    private int op;
    private String refbid;
    private String refoid;
    private long orderpos;
    private String tag;

    public Iom_jObject(String tag1, String oid1) {
        this.tag = tag1;
        this.oid = oid1;
    }

    public Iom_jObject(IomObject src) {
        this(src.getobjecttag(), src.getobjectoid());
        this.col = src.getobjectcol();
        this.consistency = src.getobjectconsistency();
        this.line = src.getobjectline();
        this.op = src.getobjectoperation();
        this.orderpos = src.getobjectreforderpos();
        this.refbid = src.getobjectrefbid();
        this.refoid = src.getobjectrefoid();
        int attrc = src.getattrcount();
        for (int attri = 0; attri < attrc; ++attri) {
            String attrName = src.getattrname(attri);
            int valuec = src.getattrvaluecount(attrName);
            for (int valuei = 0; valuei < valuec; ++valuei) {
                String valueStr = src.getattrprim(attrName, valuei);
                if (valueStr != null) {
                    this.addattrvalue(attrName, valueStr);
                    continue;
                }
                IomObject valueObj = src.getattrobj(attrName, valuei);
                this.addattrobj(attrName, new Iom_jObject(valueObj));
            }
        }
    }

    @Deprecated
    public IomObject addattrobj(String attrName, String type) {
        Iom_jObject ret = null;
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            ret = new Iom_jObject(type, null);
            valuev.add(ret);
        } else {
            ArrayList<Iom_jObject> valuev = new ArrayList<Iom_jObject>();
            ret = new Iom_jObject(type, null);
            valuev.add(ret);
            this.attrv.put(attrName, valuev);
        }
        return ret;
    }

    public void addattrobj(String attrName, IomObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("illegal argument obj (=null)");
        }
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            valuev.add(obj);
        } else {
            ArrayList<IomObject> valuev = new ArrayList<IomObject>();
            valuev.add(obj);
            this.attrv.put(attrName, valuev);
        }
    }

    public void addattrvalue(String attrName, String attrValue) {
        if (attrValue == null) {
            throw new IllegalArgumentException("illegal argument obj (=null)");
        }
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            valuev.add(attrValue);
        } else {
            ArrayList<String> valuev = new ArrayList<String>();
            valuev.add(attrValue);
            this.attrv.put(attrName, valuev);
        }
    }

    @Deprecated
    public IomObject changeattrobj(String attrName, int index, String type) {
        Iom_jObject ret = null;
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            ret = new Iom_jObject(type, null);
            valuev.set(index, ret);
        } else {
            ArrayList<Iom_jObject> valuev = new ArrayList<Iom_jObject>();
            ret = new Iom_jObject(type, null);
            valuev.set(index, ret);
            this.attrv.put(attrName, valuev);
        }
        return ret;
    }

    public void changeattrobj(String attrName, int index, IomObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("illegal argument obj (=null)");
        }
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            valuev.set(index, obj);
        } else {
            ArrayList<IomObject> valuev = new ArrayList<IomObject>();
            valuev.set(index, obj);
            this.attrv.put(attrName, valuev);
        }
    }

    public void delete() {
    }

    public void deleteattrobj(String attrName, int index) {
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            if (index >= 0 && index < valuev.size()) {
                valuev.remove(index);
                if (valuev.size() == 0) {
                    this.attrv.remove(attrName);
                }
            }
        }
    }

    public int getattrcount() {
        return this.attrv.size();
    }

    public String getattrname(int index) {
        int i = 0;
        for (String attr : this.attrv.keySet()) {
            if (i == index) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public IomObject getattrobj(String attrName, int index) {
        ArrayList valuev;
        Object val;
        if (this.attrv.containsKey(attrName) && (val = (valuev = this.attrv.get(attrName)).get(index)) instanceof Iom_jObject) {
            return (Iom_jObject)val;
        }
        return null;
    }

    public String getattrprim(String attrName, int index) {
        ArrayList valuev;
        Object val;
        if (this.attrv.containsKey(attrName) && (val = (valuev = this.attrv.get(attrName)).get(index)) instanceof String) {
            return (String)val;
        }
        return null;
    }

    public String getattrvalue(String attrName) {
        return this.getattrprim(attrName, 0);
    }

    public int getattrvaluecount(String attrName) {
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            return valuev.size();
        }
        return 0;
    }

    public int getobjectcol() {
        return this.col;
    }

    public int getobjectline() {
        return this.line;
    }

    public void setobjectcol(int col) {
        this.col = col;
    }

    public void setobjectline(int line) {
        this.line = line;
    }

    public String getxmleleattrname(int index) {
        return null;
    }

    public int getxmlelecount() {
        return 0;
    }

    public IomObject getxmleleobj(int index) {
        return null;
    }

    public String getxmleleprim(int index) {
        return null;
    }

    public int getxmlelevalueidx(int index) {
        return 0;
    }

    @Deprecated
    public IomObject insertattrobj(String attrName, int index, String type) {
        Iom_jObject ret = null;
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            ret = new Iom_jObject(type, null);
            valuev.add(index, ret);
        } else {
            ArrayList<Iom_jObject> valuev = new ArrayList<Iom_jObject>();
            ret = new Iom_jObject(type, null);
            valuev.add(index, ret);
            this.attrv.put(attrName, valuev);
        }
        return ret;
    }

    public void insertattrobj(String attrName, int index, IomObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException("illegal argument obj (=null)");
        }
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            valuev.add(index, obj);
        } else {
            ArrayList<IomObject> valuev = new ArrayList<IomObject>();
            valuev.add(index, obj);
            this.attrv.put(attrName, valuev);
        }
    }

    public void setattrundefined(String attrName) {
        this.attrv.remove(attrName);
    }

    public void setattrvalue(String attrName, String value) {
        if (value == null) {
            throw new IllegalArgumentException("illegal value null for " + attrName);
        }
        if (this.attrv.containsKey(attrName)) {
            ArrayList valuev = this.attrv.get(attrName);
            valuev.clear();
            valuev.add(value);
        } else {
            ArrayList<String> valuev = new ArrayList<String>();
            valuev.add(value);
            this.attrv.put(attrName, valuev);
        }
    }

    public void setattrvalue(String attrName, int index, String value) {
        if (value == null) {
            throw new IllegalArgumentException("Illegal value null for " + attrName);
        }
        if (!this.attrv.containsKey(attrName)) {
            throw new IllegalArgumentException("Could not find attribute with name " + attrName);
        }
        ArrayList arrayList = this.attrv.get(attrName);
        arrayList.set(index, value);
    }

    public int getobjectconsistency() {
        return this.consistency;
    }

    public void setobjectconsistency(int consistency1) {
        this.consistency = consistency1;
    }

    public String getobjectoid() {
        return this.oid;
    }

    public void setobjectoid(String oid1) {
        this.oid = oid1;
    }

    public int getobjectoperation() {
        return this.op;
    }

    public void setobjectoperation(int operation) {
        this.op = operation;
    }

    public String getobjectrefbid() {
        return this.refbid;
    }

    public void setobjectrefbid(String refbid1) {
        this.refbid = refbid1;
    }

    public String getobjectrefoid() {
        return this.refoid;
    }

    public void setobjectrefoid(String refoid1) {
        this.refoid = refoid1;
    }

    public long getobjectreforderpos() {
        return this.orderpos;
    }

    public void setobjectreforderpos(long orderpos1) {
        this.orderpos = orderpos1;
    }

    public String getobjecttag() {
        return this.tag;
    }

    public void setobjecttag(String tag1) {
        this.tag = tag1;
    }

    public String toString() {
        return Iom_jObject.dumpObject(this);
    }

    public static String dumpObject(IomObject obj) {
        int i;
        StringBuffer ret = new StringBuffer();
        String className = obj.getobjecttag();
        String oid = obj.getobjectoid();
        ret.append(className);
        if (oid != null) {
            ret.append(" oid " + oid);
        }
        ret.append(" {");
        String sep = "";
        int attrc = obj.getattrcount();
        Object[] propNames = new String[attrc];
        for (i = 0; i < attrc; ++i) {
            propNames[i] = obj.getattrname(i);
        }
        Arrays.sort(propNames);
        for (i = 0; i < attrc; ++i) {
            Object propName = propNames[i];
            int propc = obj.getattrvaluecount((String)propName);
            if (propc <= 0) continue;
            ret.append(sep + (String)propName);
            String sep2 = " ";
            if (propc > 1) {
                ret.append(" [");
                sep2 = "";
            }
            for (int propi = 0; propi < propc; ++propi) {
                String value = obj.getattrprim((String)propName, propi);
                if (value != null) {
                    ret.append(sep2 + value);
                } else {
                    IomObject structvalue = obj.getattrobj((String)propName, propi);
                    String refoid = structvalue.getobjectrefoid();
                    if (refoid != null) {
                        long orderPos = structvalue.getobjectreforderpos();
                        sep2 = orderPos != 0L ? sep2 + "-> " + refoid + ", ORDER_POS " + orderPos + " " : sep2 + "-> " + refoid + " ";
                    }
                    ret.append(sep2 + Iom_jObject.dumpObject(structvalue));
                }
                sep2 = ", ";
            }
            if (propc > 1) {
                ret.append("]");
            }
            sep = ", ";
        }
        ret.append("}");
        return ret.toString();
    }
}

