/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.logging;

import ch.ehi.basics.logging.AbstractFilteringListener;
import ch.ehi.basics.logging.LogEvent;
import ch.interlis.iox.IoxLogEvent;
import java.util.ArrayList;

public class StdLogger
extends AbstractFilteringListener {
    private int ioxErrc = 0;
    private String logfile = null;
    private static final String INFO = "Info";

    public StdLogger(String logfileName) {
        this.logfile = logfileName;
    }

    public void setLogfileName(String fileName) {
        this.logfile = fileName;
    }

    public void outputEvent(LogEvent event, ArrayList msgv) {
        String msgTag = this.getMessageTag(event);
        msgTag = msgTag == null ? "" : msgTag + ": ";
        String msgTimestamp = null;
        msgTimestamp = this.getTimestamp();
        msgTimestamp = msgTimestamp == null ? "" : msgTimestamp + ": ";
        String objRef = null;
        if (event instanceof IoxLogEvent) {
            if (this.isError(event.getEventKind())) {
                ++this.ioxErrc;
            }
            objRef = "";
            IoxLogEvent ioxEvent = (IoxLogEvent)event;
            if (ioxEvent.getSourceLineNr() != null) {
                objRef = objRef + "line " + ioxEvent.getSourceLineNr() + ": ";
            }
            if (ioxEvent.getSourceObjectTag() != null) {
                objRef = objRef + ioxEvent.getSourceObjectTag() + ": ";
            }
            if (ioxEvent.getSourceObjectTechId() != null) {
                objRef = objRef + ioxEvent.getSourceObjectTechId() + ": ";
            }
            if (ioxEvent.getSourceObjectXtfId() != null) {
                objRef = objRef + "tid " + ioxEvent.getSourceObjectXtfId() + ": ";
            }
            if (ioxEvent.getSourceObjectUsrId() != null) {
                objRef = objRef + ioxEvent.getSourceObjectUsrId() + ": ";
            }
        } else {
            objRef = "";
        }
        for (String msg : msgv) {
            this.outputMsgLine(event.getEventKind(), event.getCustomLevel(), msgTimestamp + msgTag + objRef + msg);
        }
        if (event instanceof IoxLogEvent && this.logfile != null && this.ioxErrc == 1 && this.isError(event.getEventKind())) {
            this.outputMsgLine(6, 0, msgTimestamp + INFO + ": see <" + this.logfile + "> for more validation results");
        }
    }

    public void outputMsgLine(int arg0, int arg1, String msg) {
        if (msg.endsWith("\n")) {
            System.err.print(msg);
        } else {
            System.err.println(msg);
        }
        System.err.flush();
    }

    public String getMessageTag(LogEvent event) {
        switch (event.getEventKind()) {
            case 7: {
                return "Error";
            }
            case 6: {
                return "Warning";
            }
        }
        return INFO;
    }

    private boolean isError(int kind) {
        return kind == 7 || kind == 6;
    }

    public boolean skipEvent(LogEvent event) {
        if (event instanceof IoxLogEvent && this.ioxErrc > 0 && this.logfile != null && this.isError(event.getEventKind())) {
            return true;
        }
        return super.skipEvent(event);
    }
}

