/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.ili2db.gui;

import ch.ehi.basics.logging.EhiLogger;
import ch.ehi.basics.logging.LogListener;
import ch.ehi.basics.logging.TextAreaListener;
import ch.ehi.basics.swing.SwingWorker;
import ch.ehi.ili2db.base.DbUrlConverter;
import ch.ehi.ili2db.base.Ili2db;
import ch.ehi.ili2db.gui.Config;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class WorkPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton workButton = null;
    private TextAreaListener errlog = null;
    private String appHome = null;
    private Config config = null;
    private JScrollPane jScrollPane = null;
    private JTextArea logUi = null;
    private DbUrlConverter dbUrlConverter;
    private JButton clearlogButton = null;

    public WorkPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridy = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridx = 1;
        gridBagConstraints11.anchor = 18;
        gridBagConstraints11.gridy = 1;
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        gridBagConstraints1.gridheight = 2;
        gridBagConstraints1.gridx = 0;
        this.setSize(300, 200);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJScrollPane(), gridBagConstraints1);
        this.add((Component)this.getWorkButton(), gridBagConstraints11);
        this.add((Component)this.getClearlogButton(), gridBagConstraints2);
        if (this.errlog == null) {
            this.errlog = new TextAreaListener();
            this.errlog.setOutputArea(this.getLogUi());
            EhiLogger.getInstance().addListener((LogListener)this.errlog);
        }
    }

    private JButton getWorkButton() {
        if (this.workButton == null) {
            this.workButton = new JButton();
            this.workButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SwingWorker worker = new SwingWorker(){

                        public Object construct() {
                            try {
                                WorkPanel.this.config.setDburl(WorkPanel.this.getDbUrlConverter().makeUrl(WorkPanel.this.config));
                                if (WorkPanel.this.config.getXtffile() != null && Ili2db.isItfFilename(WorkPanel.this.config.getXtffile())) {
                                    WorkPanel.this.config.setItfTransferfile(true);
                                }
                                Ili2db.run(WorkPanel.this.config, WorkPanel.this.getAppHome());
                            }
                            catch (Exception ex) {
                                EhiLogger.logError((String)"failed", (Throwable)ex);
                            }
                            return null;
                        }
                    };
                    worker.start();
                }
            });
        }
        return this.workButton;
    }

    public void setWorkBtn(String text) {
        this.getWorkButton().setText(text);
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getLogUi());
        }
        return this.jScrollPane;
    }

    private JTextArea getLogUi() {
        if (this.logUi == null) {
            this.logUi = new JTextArea();
            this.logUi.setEditable(false);
        }
        return this.logUi;
    }

    public String getAppHome() {
        return this.appHome;
    }

    public void setAppHome(String appHome) {
        this.appHome = appHome;
    }

    public DbUrlConverter getDbUrlConverter() {
        return this.dbUrlConverter;
    }

    public void setDbUrlConverter(DbUrlConverter dbUrlConverter) {
        this.dbUrlConverter = dbUrlConverter;
    }

    private JButton getClearlogButton() {
        if (this.clearlogButton == null) {
            this.clearlogButton = new JButton();
            this.clearlogButton.setText("clear log");
            this.clearlogButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WorkPanel.this.getLogUi().setText("");
                }
            });
        }
        return this.clearlogButton;
    }
}

