/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iox_j.plugins;

import ch.ehi.basics.logging.EhiLogger;
import ch.interlis.iox_j.plugins.IoxPlugin;
import ch.interlis.iox_j.plugins.PluginLoader;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

class JARClassLoader
extends URLClassLoader {
    private String path;
    private JAR jar;
    private ArrayList<String> pluginClasses = new ArrayList();

    public JARClassLoader(String path, PluginLoader pluginLoader) throws IOException {
        super(new URL[]{new URL("file", "", path)});
        URL u = new URL("jar", "", new URL("file", "", path) + "!/");
        JarURLConnection uc = (JarURLConnection)u.openConnection();
        JarFile zipFile = uc.getJarFile();
        this.jar = new JAR(path, this);
        Enumeration<JarEntry> entires = zipFile.entries();
        while (entires.hasMoreElements()) {
            ZipEntry entry = entires.nextElement();
            String name = entry.getName();
            if (!name.endsWith("IoxPlugin.class")) continue;
            this.pluginClasses.add(name);
        }
        pluginLoader.addPluginJAR(this.jar);
    }

    void loadAllPlugins() {
        boolean ok = true;
        for (int i = 0; i < this.pluginClasses.size(); ++i) {
            String name = this.pluginClasses.get(i);
            name = JARClassLoader.fileToClass(name);
            try {
                Class<?> clazz = this.loadClass(name);
                IoxPlugin plugin = (IoxPlugin)clazz.newInstance();
                this.jar.addPlugin(plugin);
                continue;
            }
            catch (Throwable t) {
                EhiLogger.logError((String)("Error while starting plugin " + name), (Throwable)t);
            }
        }
    }

    public static String fileToClass(String name) {
        char[] clsName = name.toCharArray();
        for (int i = clsName.length - 6; i >= 0; --i) {
            if (clsName[i] != '/') continue;
            clsName[i] = 46;
        }
        return new String(clsName, 0, clsName.length - 6);
    }

    public static class JAR {
        private String path;
        private JARClassLoader classLoader;
        private Vector<IoxPlugin> plugins;

        public JARClassLoader getClassLoader() {
            return this.classLoader;
        }

        private void addPlugin(IoxPlugin plugin) {
            this.plugins.addElement(plugin);
        }

        public IoxPlugin[] getPlugins() {
            Object[] array = new IoxPlugin[this.plugins.size()];
            this.plugins.copyInto(array);
            return array;
        }

        public JAR(String path, JARClassLoader classLoader) {
            this.path = path;
            this.classLoader = classLoader;
            this.plugins = new Vector();
        }
    }
}

