/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.itf.impl.jtsext.noding;

import ch.interlis.iom_j.itf.impl.jtsext.geom.CompoundCurve;
import ch.interlis.iom_j.itf.impl.jtsext.geom.CurveSegment;
import ch.interlis.iox_j.IoxInvalidDataException;
import com.vividsolutions.jts.geom.Coordinate;
import java.util.Formatter;

public class Intersection {
    Coordinate[] pt;
    CompoundCurve curve1;
    CompoundCurve curve2;
    CurveSegment seg1;
    CurveSegment seg2;
    Double overlap;
    boolean overlay = false;

    public Intersection(Coordinate pt1, CompoundCurve g1, CompoundCurve g2, CurveSegment s1, CurveSegment s2, Double overlap) {
        this.pt = new Coordinate[1];
        this.pt[0] = new Coordinate(pt1);
        this.curve1 = g1;
        this.curve2 = g2;
        this.seg1 = s1;
        this.seg2 = s2;
        this.overlap = overlap;
    }

    public Intersection(Coordinate pt1, Coordinate pt2, CompoundCurve g1, CompoundCurve g2, CurveSegment s1, CurveSegment s2, Double overlap, boolean isOverlay) {
        this.pt = new Coordinate[2];
        this.pt[0] = new Coordinate(pt1);
        this.pt[1] = new Coordinate(pt2);
        this.curve1 = g1;
        this.curve2 = g2;
        this.seg1 = s1;
        this.seg2 = s2;
        this.overlap = overlap;
        this.overlay = isOverlay;
    }

    public Coordinate[] getPt() {
        return this.pt;
    }

    public CompoundCurve getCurve1() {
        return this.curve1;
    }

    public CompoundCurve getCurve2() {
        return this.curve2;
    }

    public CurveSegment getSegment1() {
        return this.seg1;
    }

    public CurveSegment getSegment2() {
        return this.seg2;
    }

    public Double getOverlap() {
        return this.overlap;
    }

    public boolean isIntersection(Coordinate p00) {
        for (Coordinate p : this.pt) {
            if (!p.equals2D(p00)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        Object seg1UserData = this.seg1.getUserData();
        Object seg2UserData = this.seg2.getUserData();
        if (this.isOverlay()) {
            return "Overlay coord1 " + this.pt[0].toString() + ", coord2 " + this.pt[1].toString() + ", tid1 " + (seg1UserData != null ? seg1UserData : this.curve1.getUserData()) + ", tid2 " + (seg2UserData != null ? seg2UserData : this.curve2.getUserData()) + ", idx1 " + this.curve1.getSegments().indexOf(this.seg1) + ", idx2 " + this.curve2.getSegments().indexOf(this.seg2) + ", seg1 " + this.seg1 + ", seg2 " + this.seg2;
        }
        return "Intersection" + (this.pt.length == 2 ? " overlap " + this.overlap + "," : "") + " coord1 " + this.pt[0].toString() + (this.pt.length == 2 ? ", coord2 " + this.pt[1].toString() : "") + ", tid1 " + (seg1UserData != null ? seg1UserData : this.curve1.getUserData()) + ", tid2 " + (seg2UserData != null ? seg2UserData : this.curve2.getUserData()) + ", idx1 " + this.curve1.getSegments().indexOf(this.seg1) + ", idx2 " + this.curve2.getSegments().indexOf(this.seg2) + ", seg1 " + this.seg1 + ", seg2 " + this.seg2;
    }

    public String toShortString() {
        Object seg1UserData = this.seg1.getUserData();
        Object seg2UserData = this.seg2.getUserData();
        String[] tids = new String[]{(String)(seg1UserData != null ? seg1UserData : this.curve1.getUserData()), (String)(seg2UserData != null ? seg2UserData : this.curve2.getUserData())};
        if (this.isOverlay()) {
            Coordinate coord0 = this.pt[0];
            Coordinate coord1 = this.pt[1];
            if (coord0.compareTo((Object)coord1) > 0) {
                coord0 = this.pt[1];
                coord1 = this.pt[0];
            }
            return "Overlay coord1 " + this.toString(coord0) + ", coord2 " + this.toString(coord1) + ", " + IoxInvalidDataException.formatTids(tids);
        }
        return "Intersection" + (this.pt.length == 2 ? " overlap " + this.overlap + "," : "") + " coord1 " + this.toString(this.pt[0]) + (this.pt.length == 2 ? ", coord2 " + this.toString(this.pt[1]) : "") + ", " + IoxInvalidDataException.formatTids(tids);
    }

    public String toString(Coordinate coord) {
        Formatter txt = new Formatter();
        return txt.format("(%.3f, %.3f)", coord.x, coord.y).toString();
    }

    public boolean isOverlay() {
        return this.overlay;
    }
}

