/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.ili2c.metamodel;

import ch.interlis.ili2c.metamodel.BaseType;
import ch.interlis.ili2c.metamodel.Domain;
import ch.interlis.ili2c.metamodel.Element;
import ch.interlis.ili2c.metamodel.Enumeration;
import ch.interlis.ili2c.metamodel.EnumerationType;
import ch.interlis.ili2c.metamodel.Ili2cSemanticException;
import ch.interlis.ili2c.metamodel.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class EnumTreeValueType
extends BaseType {
    private Domain enumType = null;
    private ArrayList<String> cachedValues = null;

    public Set<Type> getDirectExtensions() {
        return this.extendedBy;
    }

    @Override
    public boolean checkStructuralEquivalence(Element with) {
        return super.checkStructuralEquivalence(with);
    }

    @Override
    void checkTypeExtension(Type wantToExtend) {
        if (wantToExtend == null || (wantToExtend = wantToExtend.resolveAliases()) == null) {
            return;
        }
        if (!wantToExtend.getClass().equals(this.getClass())) {
            throw new Ili2cSemanticException(rsrc.getString("err_type_ExtOther"));
        }
        this.checkCardinalityExtension(wantToExtend);
    }

    public Domain getEnumType() {
        return this.enumType;
    }

    public void setEnumType(Domain domain) {
        this.enumType = domain;
    }

    @Override
    public EnumTreeValueType clone() {
        return (EnumTreeValueType)super.clone();
    }

    public Enumeration getConsolidatedEnumeration() {
        Enumeration ret = ((EnumerationType)this.enumType.getType()).getConsolidatedEnumeration();
        return ret;
    }

    @Override
    protected void checkTranslationOf(List<Ili2cSemanticException> errs, String name, String baseName) {
        super.checkTranslationOf(errs, name, baseName);
        EnumTreeValueType baseElement = (EnumTreeValueType)this.getTranslationOf();
        if (baseElement == null) {
            return;
        }
        Ili2cSemanticException err = null;
        err = EnumTreeValueType.checkElementRef(this.enumType, baseElement.enumType, this.getSourceLine(), "err_diff_baseDomainMismatch");
        if (err != null) {
            errs.add(err);
        }
    }

    public List<String> getValues() {
        if (this.cachedValues == null) {
            this.cachedValues = new ArrayList();
            EnumTreeValueType.buildEnumList(this.cachedValues, "", this.getConsolidatedEnumeration());
        }
        return this.cachedValues;
    }

    public static void buildEnumList(List<String> accu, String prefix1, Enumeration enumer) {
        Iterator<Enumeration.Element> iter = enumer.getElements();
        String prefix = "";
        if (prefix1.length() > 0) {
            prefix = prefix1 + ".";
        }
        while (iter.hasNext()) {
            Enumeration.Element ee = iter.next();
            Enumeration subEnum = ee.getSubEnumeration();
            accu.add(prefix + ee.getName());
            if (subEnum == null) continue;
            EnumTreeValueType.buildEnumList(accu, prefix + ee.getName(), subEnum);
        }
    }
}

