/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.basics.view;

import java.io.IOException;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void displayURL(String url) {
        block8: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process process = Runtime.getRuntime().exec(cmd);
                    break block8;
                }
                try {
                    Runtime.getRuntime().exec("mozilla " + url);
                }
                catch (IOException e) {
                    System.out.println("tried Mozilla (failed): " + e.getLocalizedMessage());
                    cmd = "netscape -remote openURL(" + url + ")";
                    Process p = Runtime.getRuntime().exec(cmd);
                    try {
                        int exitCode = p.waitFor();
                        if (exitCode != 0) {
                            cmd = "netscape " + url;
                            p = Runtime.getRuntime().exec(cmd);
                        }
                    }
                    catch (InterruptedException x) {
                        System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                        System.err.println("Caught: " + x);
                    }
                }
            }
            catch (IOException x) {
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }

    public static void main(String[] args) {
        BrowserControl.displayURL("http://www.javaworld.com");
        if (BrowserControl.isWindowsPlatform()) {
            BrowserControl.displayURL("C:/WINDOWS/win.ini");
        }
    }
}

