/*
 * Decompiled with CFR 0.152.
 */
package ch.interlis.iom_j.xtf.impl;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.DTD;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLStreamWriterAdapter {
    private XMLStreamWriterAdapter() {
    }

    public static void add(XMLStreamWriter streamWriter, XMLEvent event) throws XMLStreamException {
        int type = event.getEventType();
        switch (type) {
            case 11: {
                DTD dtd = (DTD)event;
                streamWriter.writeDTD(dtd.getDocumentTypeDeclaration());
                break;
            }
            case 7: {
                StartDocument startDocument = (StartDocument)event;
                streamWriter.writeStartDocument(startDocument.getCharacterEncodingScheme(), startDocument.getVersion());
                break;
            }
            case 1: {
                StartElement startElement = event.asStartElement();
                QName qname = startElement.getName();
                streamWriter.writeStartElement(qname.getPrefix(), qname.getLocalPart(), qname.getNamespaceURI());
                Iterator<Namespace> iterator = startElement.getNamespaces();
                while (iterator.hasNext()) {
                    Namespace namespace = iterator.next();
                    streamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                }
                Iterator<Attribute> attributes = startElement.getAttributes();
                while (attributes.hasNext()) {
                    Attribute attribute = attributes.next();
                    QName name = attribute.getName();
                    streamWriter.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), attribute.getValue());
                }
                break;
            }
            case 13: {
                Namespace namespace = (Namespace)event;
                streamWriter.writeNamespace(namespace.getPrefix(), namespace.getNamespaceURI());
                break;
            }
            case 5: {
                Comment comment = (Comment)event;
                streamWriter.writeComment(comment.getText());
                break;
            }
            case 3: {
                ProcessingInstruction processingInstruction = (ProcessingInstruction)event;
                streamWriter.writeProcessingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
                break;
            }
            case 4: {
                Characters characters = event.asCharacters();
                if (characters.isCData()) {
                    streamWriter.writeCData(characters.getData());
                    break;
                }
                streamWriter.writeCharacters(characters.getData());
                break;
            }
            case 9: {
                EntityReference entityReference = (EntityReference)event;
                streamWriter.writeEntityRef(entityReference.getName());
                break;
            }
            case 10: {
                Attribute attribute = (Attribute)event;
                QName qname = attribute.getName();
                streamWriter.writeAttribute(qname.getPrefix(), qname.getNamespaceURI(), qname.getLocalPart(), attribute.getValue());
                break;
            }
            case 12: {
                Characters characters = (Characters)event;
                if (!characters.isCData()) break;
                streamWriter.writeCData(characters.getData());
                break;
            }
            case 2: {
                streamWriter.writeEndElement();
                break;
            }
            case 8: {
                streamWriter.writeEndDocument();
                break;
            }
            default: {
                throw new XMLStreamException("Unknown Event type = " + type);
            }
        }
    }
}

